/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.google.gson.JsonObject;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceInitialState;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.PrettierBundle;
import com.intellij.prettierjs.PrettierConfig;
import com.intellij.prettierjs.PrettierLanguageService;
import com.intellij.prettierjs.PrettierLanguageServiceManager;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0003 !\"B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJF\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010\u0016\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/prettierjs/PrettierLanguageServiceImpl;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceBase;", "Lcom/intellij/prettierjs/PrettierLanguageService;", "project", "Lcom/intellij/openapi/project/Project;", "workDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "format", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/prettierjs/PrettierLanguageService$FormatResult;", "filePath", "", "ignoreFilePath", "text", "prettierPackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "range", "Lcom/intellij/openapi/util/TextRange;", "cursorOffset", "", "resolveConfig", "Lcom/intellij/prettierjs/PrettierLanguageService$ResolveConfigResult;", "parseReformatResponse", "response", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceAnswer;", "forceLineBreakAtEof", "", "parseResolveConfigResponse", "createLanguageServiceQueueBlocking", "Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue;", "Protocol", "ReformatFileCommand", "ResolveConfigCommand", "intellij.prettierJS"})
@SourceDebugExtension(value={"SMAP\nPrettierLanguageServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrettierLanguageServiceImpl.kt\ncom/intellij/prettierjs/PrettierLanguageServiceImpl\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,198:1\n31#2,2:199\n31#2,2:201\n*S KotlinDebug\n*F\n+ 1 PrettierLanguageServiceImpl.kt\ncom/intellij/prettierjs/PrettierLanguageServiceImpl\n*L\n47#1:199,2\n66#1:201,2\n*E\n"})
public final class PrettierLanguageServiceImpl
extends JSLanguageServiceBase
implements PrettierLanguageService {
    @NotNull
    private final VirtualFile workDir;

    public PrettierLanguageServiceImpl(@NotNull Project project, @NotNull VirtualFile workDir) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)workDir, (String)"workDir");
        super(project);
        this.workDir = workDir;
    }

    @Override
    @Nullable
    public CompletableFuture<PrettierLanguageService.FormatResult> format(@NotNull String filePath, @Nullable String ignoreFilePath, @NotNull String text, @NotNull NodePackage prettierPackage, @Nullable TextRange range, int cursorOffset) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)prettierPackage, (String)"prettierPackage");
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null || !process.isValid()) {
            String string = PrettierBundle.message("service.not.started.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return CompletableFuture.completedFuture(PrettierLanguageService.FormatResult.Companion.error(string));
        }
        boolean forceLineBreakAtEof = range != null && range.getEndOffset() < text.length() && StringsKt.endsWith$default((String)text, (String)"\n", (boolean)false, (int)2, null);
        ReformatFileCommand command = new ReformatFileCommand(this.myProject, filePath, prettierPackage, ignoreFilePath, text, range, false, cursorOffset);
        ComponentManager $this$service$iv = (ComponentManager)this.getProject();
        boolean $i$f$service = false;
        Class<PrettierLanguageServiceManager> serviceClass$iv = PrettierLanguageServiceManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return FutureKt.future$default((CoroutineScope)((PrettierLanguageServiceManager)((Object)object)).getCs$intellij_prettierJS(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super PrettierLanguageService.FormatResult>, Object>(process, command, this, forceLineBreakAtEof, null){
            int label;
            final /* synthetic */ JSLanguageServiceQueue $process;
            final /* synthetic */ ReformatFileCommand $command;
            final /* synthetic */ PrettierLanguageServiceImpl this$0;
            final /* synthetic */ boolean $forceLineBreakAtEof;
            {
                this.$process = $process;
                this.$command = $command;
                this.this$0 = $receiver;
                this.$forceLineBreakAtEof = $forceLineBreakAtEof;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = JSLanguageServiceQueue.execute$default((JSLanguageServiceQueue)this.$process, (JSLanguageServiceCommand)((JSLanguageServiceCommand)this.$command), null, (Continuation)((Continuation)this), (int)2, null);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((v1 = (commandResult = (JSLanguageServiceQueue.CommandResult)v0)) == null || (v1 = v1.getAnswer()) == null) {
                            return null;
                        }
                        answer = v1;
                        return PrettierLanguageServiceImpl.access$parseReformatResponse(this.this$0, (JSLanguageServiceAnswer)answer, this.$forceLineBreakAtEof);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super PrettierLanguageService.FormatResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    @Nullable
    public CompletableFuture<PrettierLanguageService.ResolveConfigResult> resolveConfig(@NotNull String filePath, @NotNull NodePackage prettierPackage) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)prettierPackage, (String)"prettierPackage");
        String filePath2 = JSLanguageServiceUtil.normalizeNameAndPath((String)filePath);
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null || !process.isValid()) {
            String string = PrettierBundle.message("service.not.started.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return CompletableFuture.completedFuture(PrettierLanguageService.ResolveConfigResult.Companion.error(string));
        }
        Intrinsics.checkNotNull((Object)filePath2);
        ResolveConfigCommand command = new ResolveConfigCommand(this.myProject, filePath2, prettierPackage, false);
        ComponentManager $this$service$iv = (ComponentManager)this.getProject();
        boolean $i$f$service = false;
        Class<PrettierLanguageServiceManager> serviceClass$iv = PrettierLanguageServiceManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return FutureKt.future$default((CoroutineScope)((PrettierLanguageServiceManager)((Object)object)).getCs$intellij_prettierJS(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super PrettierLanguageService.ResolveConfigResult>, Object>(process, command, this, null){
            int label;
            final /* synthetic */ JSLanguageServiceQueue $process;
            final /* synthetic */ ResolveConfigCommand $command;
            final /* synthetic */ PrettierLanguageServiceImpl this$0;
            {
                this.$process = $process;
                this.$command = $command;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = JSLanguageServiceQueue.execute$default((JSLanguageServiceQueue)this.$process, (JSLanguageServiceCommand)((JSLanguageServiceCommand)this.$command), null, (Continuation)((Continuation)this), (int)2, null);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((v1 = (JSLanguageServiceQueue.CommandResult)v0) == null || (v1 = v1.getAnswer()) == null) {
                            return null;
                        }
                        response = v1;
                        return PrettierLanguageServiceImpl.access$parseResolveConfigResponse(this.this$0, (JSLanguageServiceAnswer)response);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super PrettierLanguageService.ResolveConfigResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final PrettierLanguageService.FormatResult parseReformatResponse(JSLanguageServiceAnswer response, boolean forceLineBreakAtEof) {
        String error;
        JsonObject jsonObject = response.getElement();
        String string = error = JsonUtil.getChildAsString((JsonObject)jsonObject, (String)"error");
        boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
        if (bl) {
            return PrettierLanguageService.FormatResult.Companion.error(error);
        }
        if (JsonUtil.getChildAsBoolean((JsonObject)jsonObject, (String)"ignored", (boolean)false)) {
            return PrettierLanguageService.FormatResult.Companion.getIGNORED();
        }
        if (JsonUtil.getChildAsBoolean((JsonObject)jsonObject, (String)"unsupported", (boolean)false)) {
            return PrettierLanguageService.FormatResult.UNSUPPORTED;
        }
        String string2 = JsonUtil.getChildAsString((JsonObject)jsonObject, (String)"formatted");
        Intrinsics.checkNotNull((Object)string2);
        Object formattedResult = string2;
        int cursorOffset = JsonUtil.getChildAsInteger((JsonObject)jsonObject, (String)"cursorOffset", (int)-1);
        if (forceLineBreakAtEof && !StringsKt.endsWith$default((String)formattedResult, (String)"\n", (boolean)false, (int)2, null)) {
            formattedResult = (String)formattedResult + "\n";
        }
        return PrettierLanguageService.FormatResult.Companion.formatted((String)formattedResult, cursorOffset);
    }

    private final PrettierLanguageService.ResolveConfigResult parseResolveConfigResponse(JSLanguageServiceAnswer response) {
        String error;
        JsonObject jsonObject = response.getElement();
        String string = error = JsonUtil.getChildAsString((JsonObject)jsonObject, (String)"error");
        boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
        if (bl) {
            return PrettierLanguageService.ResolveConfigResult.Companion.error(error);
        }
        JsonObject config = JsonUtil.getChildAsObject((JsonObject)jsonObject, (String)"config");
        PrettierConfig prettierConfig2 = PrettierConfig.createFromJson(config);
        Intrinsics.checkNotNull((Object)prettierConfig2);
        return PrettierLanguageService.ResolveConfigResult.Companion.config(prettierConfig2);
    }

    @NotNull
    protected JSLanguageServiceQueue createLanguageServiceQueueBlocking() {
        return (JSLanguageServiceQueue)new JSLanguageServiceQueueImpl(this.myProject, (JSLanguageServiceProtocol)new Protocol(this.myProject, PrettierLanguageServiceImpl::createLanguageServiceQueueBlocking$lambda$0), null, (JSLanguageServiceQueue.ServiceInfoReporter)this.myDefaultReporter, (JSLanguageServiceCacheData)new JSLanguageServiceDefaultCacheData());
    }

    private static final void createLanguageServiceQueueBlocking$lambda$0(Object o) {
    }

    public static final /* synthetic */ PrettierLanguageService.FormatResult access$parseReformatResponse(PrettierLanguageServiceImpl $this, JSLanguageServiceAnswer response, boolean forceLineBreakAtEof) {
        return $this.parseReformatResponse(response, forceLineBreakAtEof);
    }

    public static final /* synthetic */ PrettierLanguageService.ResolveConfigResult access$parseResolveConfigResponse(PrettierLanguageServiceImpl $this, JSLanguageServiceAnswer response) {
        return $this.parseResolveConfigResponse(response);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0014R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/prettierjs/PrettierLanguageServiceImpl$Protocol;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase;", "project", "Lcom/intellij/openapi/project/Project;", "readyConsumer", "Ljava/util/function/Consumer;", "<init>", "(Lcom/intellij/prettierjs/PrettierLanguageServiceImpl;Lcom/intellij/openapi/project/Project;Ljava/util/function/Consumer;)V", "addNodeProcessAdditionalArguments", "", "targetRun", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "workingDirectory", "", "getWorkingDirectory", "()Ljava/lang/String;", "needReadActionToCreateState", "", "createState", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceInitialState;", "getNodeCommandLineConfiguratorOptions", "Lcom/intellij/javascript/nodejs/interpreter/NodeCommandLineConfigurator$Options;", "intellij.prettierJS"})
    @SourceDebugExtension(value={"SMAP\nPrettierLanguageServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrettierLanguageServiceImpl.kt\ncom/intellij/prettierjs/PrettierLanguageServiceImpl$Protocol\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,198:1\n1#2:199\n25#3:200\n*S KotlinDebug\n*F\n+ 1 PrettierLanguageServiceImpl.kt\ncom/intellij/prettierjs/PrettierLanguageServiceImpl$Protocol\n*L\n140#1:200\n*E\n"})
    private final class Protocol
    extends JSLanguageServiceNodeStdProtocolBase {
        public Protocol(@NotNull Project project, Consumer<?> readyConsumer) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(readyConsumer, (String)"readyConsumer");
            super("prettier", project, readyConsumer);
        }

        protected void addNodeProcessAdditionalArguments(@NotNull NodeTargetRun targetRun) {
            Intrinsics.checkNotNullParameter((Object)targetRun, (String)"targetRun");
            super.addNodeProcessAdditionalArguments(targetRun);
            File file = JSLanguageServiceUtil.getPluginDirectory(((Object)((Object)this)).getClass(), (String)"prettierLanguageService");
            Intrinsics.checkNotNull((Object)file);
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            targetRun.path(string);
        }

        @Nullable
        protected String getWorkingDirectory() {
            VirtualFile virtualFile;
            Application application = ApplicationManager.getApplication();
            boolean bl = application != null ? application.isUnitTestMode() : false;
            if (bl && (virtualFile = ProjectUtil.guessProjectDir((Project)this.myProject)) != null) {
                VirtualFile it = virtualFile;
                boolean bl2 = false;
                return it.getPath();
            }
            return FileUtil.toSystemDependentName((String)PrettierLanguageServiceImpl.this.workDir.getPath());
        }

        protected boolean needReadActionToCreateState() {
            return false;
        }

        @NotNull
        protected JSLanguageServiceInitialState createState() {
            JSLanguageServiceInitialState jSLanguageServiceInitialState;
            File service = new File(JSLanguageServiceUtil.getPluginDirectory(((Object)((Object)this)).getClass(), (String)"prettierLanguageService"), "prettier-plugin-provider.js");
            if (!service.exists()) {
                Protocol $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(Protocol.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("prettier language service plugin not found");
            }
            JSLanguageServiceInitialState it = jSLanguageServiceInitialState = new JSLanguageServiceInitialState();
            boolean bl = false;
            it.pluginName = "prettier";
            String string = service.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            it.pluginPath = LocalFilePath.Companion.createNotNull(string);
            return jSLanguageServiceInitialState;
        }

        @NotNull
        protected NodeCommandLineConfigurator.Options getNodeCommandLineConfiguratorOptions(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            NodeCommandLineConfigurator.Options options = NodeCommandLineConfigurator.defaultOptions((Project)this.myProject);
            Intrinsics.checkNotNullExpressionValue((Object)options, (String)"defaultOptions(...)");
            return options;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002BK\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010(\u001a\u00020\u0001H\u0016J\u0010\u0010+\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0016R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0013\u0010\u001f\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0013\u0010\t\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001cR\u0015\u0010\"\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\n\n\u0002\u0010%\u001a\u0004\b#\u0010$R\u0015\u0010&\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\n\n\u0002\u0010%\u001a\u0004\b'\u0010$R\u0014\u0010)\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0014\u00a8\u0006,"}, d2={"Lcom/intellij/prettierjs/PrettierLanguageServiceImpl$ReformatFileCommand;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceObject;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceSimpleCommand;", "project", "Lcom/intellij/openapi/project/Project;", "filePath", "", "prettierPackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "ignoreFilePath", "content", "range", "Lcom/intellij/openapi/util/TextRange;", "flushConfigCache", "", "cursorOffset", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/javascript/nodejs/util/NodePackage;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;ZI)V", "getContent", "()Ljava/lang/String;", "getFlushConfigCache", "()Z", "getCursorOffset", "()I", "path", "Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "getPath", "()Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "prettierPath", "getPrettierPath", "packageJsonPath", "getPackageJsonPath", "getIgnoreFilePath", "start", "getStart", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "end", "getEnd", "toSerializableObject", "command", "getCommand", "getPresentableText", "intellij.prettierJS"})
    @SourceDebugExtension(value={"SMAP\nPrettierLanguageServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrettierLanguageServiceImpl.kt\ncom/intellij/prettierjs/PrettierLanguageServiceImpl$ReformatFileCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n1#2:199\n*E\n"})
    private static final class ReformatFileCommand
    implements JSLanguageServiceObject,
    JSLanguageServiceSimpleCommand {
        @NotNull
        private final String content;
        private final boolean flushConfigCache;
        private final int cursorOffset;
        @NotNull
        private final LocalFilePath path;
        @NotNull
        private final LocalFilePath prettierPath;
        @Nullable
        private final LocalFilePath packageJsonPath;
        @Nullable
        private final LocalFilePath ignoreFilePath;
        @Nullable
        private final Integer start;
        @Nullable
        private final Integer end;
        @NotNull
        private final String command;

        /*
         * WARNING - void declaration
         */
        public ReformatFileCommand(@NotNull Project project, @NotNull String filePath, @NotNull NodePackage prettierPackage, @Nullable String ignoreFilePath, @NotNull String content, @Nullable TextRange range, boolean flushConfigCache, int cursorOffset) {
            LocalFilePath localFilePath;
            String string;
            ReformatFileCommand reformatFileCommand;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)prettierPackage, (String)"prettierPackage");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.content = content;
            this.flushConfigCache = flushConfigCache;
            this.cursorOffset = cursorOffset;
            String string2 = FileUtil.toSystemDependentName((String)filePath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
            this.path = LocalFilePath.Companion.createNotNull(string2);
            Object object = prettierPackage instanceof YarnPnpNodePackage ? (YarnPnpNodePackage)prettierPackage : null;
            if (object == null || (object = object.getName()) == null) {
                object = prettierPackage.getSystemDependentPath();
            }
            this.prettierPath = LocalFilePath.Companion.createNotNull((String)object);
            ReformatFileCommand reformatFileCommand2 = this;
            LocalFilePath.Companion companion = LocalFilePath.Companion;
            YarnPnpNodePackage yarnPnpNodePackage = prettierPackage instanceof YarnPnpNodePackage ? (YarnPnpNodePackage)prettierPackage : null;
            if (yarnPnpNodePackage != null) {
                void it;
                YarnPnpNodePackage yarnPnpNodePackage2 = yarnPnpNodePackage;
                LocalFilePath.Companion companion2 = companion;
                reformatFileCommand = reformatFileCommand2;
                boolean bl = false;
                String string3 = it.getPackageJsonPath(project);
                Intrinsics.checkNotNull((Object)string3);
                String string4 = FileUtil.toSystemDependentName((String)string3);
                reformatFileCommand2 = reformatFileCommand;
                companion = companion2;
                string = string4;
            } else {
                string = null;
            }
            reformatFileCommand2.packageJsonPath = companion.create(string);
            ReformatFileCommand reformatFileCommand3 = this;
            String string5 = ignoreFilePath;
            if (string5 != null) {
                void it;
                String string6 = string5;
                reformatFileCommand = reformatFileCommand3;
                boolean bl = false;
                String string7 = FileUtil.toSystemDependentName((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toSystemDependentName(...)");
                localFilePath = LocalFilePath.Companion.createNotNull(string7);
                reformatFileCommand3 = reformatFileCommand;
            } else {
                localFilePath = null;
            }
            reformatFileCommand3.ignoreFilePath = localFilePath;
            TextRange textRange = range;
            this.start = textRange != null ? Integer.valueOf(textRange.getStartOffset()) : null;
            TextRange textRange2 = range;
            this.end = textRange2 != null ? Integer.valueOf(textRange2.getEndOffset()) : null;
            this.command = "reformat";
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        public final boolean getFlushConfigCache() {
            return this.flushConfigCache;
        }

        public final int getCursorOffset() {
            return this.cursorOffset;
        }

        @NotNull
        public final LocalFilePath getPath() {
            return this.path;
        }

        @NotNull
        public final LocalFilePath getPrettierPath() {
            return this.prettierPath;
        }

        @Nullable
        public final LocalFilePath getPackageJsonPath() {
            return this.packageJsonPath;
        }

        @Nullable
        public final LocalFilePath getIgnoreFilePath() {
            return this.ignoreFilePath;
        }

        @Nullable
        public final Integer getStart() {
            return this.start;
        }

        @Nullable
        public final Integer getEnd() {
            return this.end;
        }

        @NotNull
        public JSLanguageServiceObject toSerializableObject() {
            return this;
        }

        @NotNull
        public String getCommand() {
            return this.command;
        }

        @NotNull
        public String getPresentableText(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String string = PrettierBundle.message("progress.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0017\u001a\u00020\u0001H\u0016J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0018\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lcom/intellij/prettierjs/PrettierLanguageServiceImpl$ResolveConfigCommand;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceObject;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceSimpleCommand;", "project", "Lcom/intellij/openapi/project/Project;", "filePath", "", "prettierPackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "flushConfigCache", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/javascript/nodejs/util/NodePackage;Z)V", "getFlushConfigCache", "()Z", "path", "Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "getPath", "()Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "prettierPath", "getPrettierPath", "packageJsonPath", "getPackageJsonPath", "toSerializableObject", "command", "getCommand", "()Ljava/lang/String;", "getPresentableText", "intellij.prettierJS"})
    private static final class ResolveConfigCommand
    implements JSLanguageServiceObject,
    JSLanguageServiceSimpleCommand {
        private final boolean flushConfigCache;
        @NotNull
        private final LocalFilePath path;
        @NotNull
        private final LocalFilePath prettierPath;
        @Nullable
        private final LocalFilePath packageJsonPath;
        @NotNull
        private final String command;

        /*
         * WARNING - void declaration
         */
        public ResolveConfigCommand(@NotNull Project project, @NotNull String filePath, @NotNull NodePackage prettierPackage, boolean flushConfigCache) {
            String string;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)prettierPackage, (String)"prettierPackage");
            this.flushConfigCache = flushConfigCache;
            String string2 = FileUtil.toSystemDependentName((String)filePath);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
            this.path = LocalFilePath.Companion.createNotNull(string2);
            Object object = prettierPackage instanceof YarnPnpNodePackage ? (YarnPnpNodePackage)prettierPackage : null;
            if (object == null || (object = object.getName()) == null) {
                object = prettierPackage.getSystemDependentPath();
            }
            this.prettierPath = LocalFilePath.Companion.createNotNull((String)object);
            ResolveConfigCommand resolveConfigCommand = this;
            LocalFilePath.Companion companion = LocalFilePath.Companion;
            YarnPnpNodePackage yarnPnpNodePackage = prettierPackage instanceof YarnPnpNodePackage ? (YarnPnpNodePackage)prettierPackage : null;
            if (yarnPnpNodePackage != null) {
                void it;
                YarnPnpNodePackage yarnPnpNodePackage2 = yarnPnpNodePackage;
                LocalFilePath.Companion companion2 = companion;
                ResolveConfigCommand resolveConfigCommand2 = resolveConfigCommand;
                boolean bl = false;
                String string3 = it.getPackageJsonPath(project);
                Intrinsics.checkNotNull((Object)string3);
                String string4 = FileUtil.toSystemDependentName((String)string3);
                resolveConfigCommand = resolveConfigCommand2;
                companion = companion2;
                string = string4;
            } else {
                string = null;
            }
            resolveConfigCommand.packageJsonPath = companion.create(string);
            this.command = "resolveConfig";
        }

        public final boolean getFlushConfigCache() {
            return this.flushConfigCache;
        }

        @NotNull
        public final LocalFilePath getPath() {
            return this.path;
        }

        @NotNull
        public final LocalFilePath getPrettierPath() {
            return this.prettierPath;
        }

        @Nullable
        public final LocalFilePath getPackageJsonPath() {
            return this.packageJsonPath;
        }

        @NotNull
        public JSLanguageServiceObject toSerializableObject() {
            return this;
        }

        @NotNull
        public String getCommand() {
            return this.command;
        }

        @NotNull
        public String getPresentableText(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String string = PrettierBundle.message("progress.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }
}

