/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlQualificationIntentionBase;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class SqlUnqualifyIdentifierIntention
extends SqlQualificationIntentionBase
implements PriorityAction {
    @NotNull
    public PriorityAction.Priority getPriority() {
        PriorityAction.Priority priority = PriorityAction.Priority.TOP;
        if (priority == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(0);
        }
        return priority;
    }

    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.unqualify.identifier", (Object[])new Object[0]);
        if (string == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static JBIterable<SqlReferenceExpression> getTopmostQualifiedRefs(@NotNull PsiFile file, @NotNull Caret caret) {
        if (file == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(2);
        }
        if (caret == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(3);
        }
        JBIterable jBIterable = SqlUnqualifyIdentifierIntention.getTopmostIdentifiers(file, caret).filterMap(identifier -> {
            SqlReferenceExpression ref2 = (SqlReferenceExpression)ObjectUtils.tryCast((Object)identifier.getParent(), SqlReferenceExpression.class);
            if (ref2 == null) {
                return null;
            }
            return ref2.getParent() instanceof SqlReferenceExpression ? ref2 : null;
        });
        if (jBIterable == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (project == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(5);
        }
        if (!(file instanceof SqlFile)) {
            return false;
        }
        return !JBIterable.from((Iterable)editor2.getCaretModel().getAllCarets()).flatten(c2 -> SqlUnqualifyIdentifierIntention.getTopmostQualifiedRefs(file, c2)).isEmpty();
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(6);
        }
        SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        int depth = 999;
        LinkedHashSet<SqlReferenceExpression> refs = new LinkedHashSet<SqlReferenceExpression>();
        for (SqlReferenceExpression ref2 : JBIterable.from((Iterable)editor2.getCaretModel().getAllCarets()).flatten(c2 -> SqlUnqualifyIdentifierIntention.getTopmostQualifiedRefs(file, c2))) {
            int d = SqlUnqualifyIdentifierIntention.getDepth(language, SqlUnqualifyIdentifierIntention.getKind(ref2.resolve()));
            if (depth < d) continue;
            if (depth > d) {
                depth = d;
                refs.clear();
            }
            refs.add(ref2);
        }
        if (!refs.isEmpty()) {
            SqlUnqualifyIdentifierIntention.performUnqualification(editor2.getDocument(), refs);
        }
    }

    private static void performUnqualification(@NotNull Document document, @NotNull Set<SqlReferenceExpression> refs) {
        if (document == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(7);
        }
        if (refs == null) {
            SqlUnqualifyIdentifierIntention.$$$reportNull$$$0(8);
        }
        ArrayList<RangeMarker> markers = new ArrayList<RangeMarker>();
        for (SqlReferenceExpression ref2 : refs) {
            SqlIdentifier identifier;
            SqlReferenceExpression parent = (SqlReferenceExpression)ObjectUtils.tryCast((Object)ref2.getParent(), SqlReferenceExpression.class);
            if (parent == null || (identifier = parent.getIdentifier()) == null) continue;
            TextRange ir = identifier.getTextRange();
            TextRange pr = parent.getTextRange();
            if (!pr.contains(ir)) continue;
            if (ir.getStartOffset() != pr.getStartOffset()) {
                markers.add(document.createRangeMarker(pr.getStartOffset(), ir.getStartOffset()));
            }
            if (ir.getEndOffset() == pr.getEndOffset()) continue;
            markers.add(document.createRangeMarker(ir.getEndOffset(), pr.getEndOffset()));
        }
        for (RangeMarker marker : markers) {
            document.deleteString(marker.getStartOffset(), marker.getEndOffset());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/intentions/SqlUnqualifyIdentifierIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/intentions/SqlUnqualifyIdentifierIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopmostQualifiedRefs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostQualifiedRefs";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performUnqualification";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

