/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.ElementTypeSetContinuePattern;
import com.intellij.sql.formatter.model.FirstAndContinuePattern;
import com.intellij.sql.formatter.model.FlowContinuePatternKt;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.NodeMatcher;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.RowPattern;
import com.intellij.sql.formatter.model.SimplePattern;
import com.intellij.sql.formatter.model.SingletonExpandPattern;
import com.intellij.sql.formatter.model.SingletonPattern;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockStatementBlock;
import com.intellij.sql.formatter.model.SqlDeclarationDefinitions;
import com.intellij.sql.formatter.model.SqlDeclarationSectionBlock;
import com.intellij.sql.formatter.model.SqlDefinitionsSubsectionBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlKeyword;
import com.intellij.sql.formatter.model.SqlLanguageClauseBlock;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlParametersBlock;
import com.intellij.sql.formatter.model.SqlPostfixClauseBlock;
import com.intellij.sql.formatter.model.SqlPrefixClauseBlock;
import com.intellij.sql.formatter.model.SqlQueryBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlReturnBlock;
import com.intellij.sql.formatter.model.SqlRoutineBlock;
import com.intellij.sql.formatter.model.SqlUnsortedBlock;
import com.intellij.sql.formatter.model.SqlUnsortedClauseBlock;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlLazyElementType;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.stubs.SqlTypedDefinitionElementType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/sql/formatter/model/SqlRoutineBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "<init>", "()V", "flowPatterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "makeBlock", "Lcom/intellij/sql/formatter/model/SqlBlock;", "node", "Lcom/intellij/lang/ASTNode;", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "configureFormattingAttributes", "", "userRequiresExpand", "", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "Companion", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlRoutineBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlRoutineBlock.kt\ncom/intellij/sql/formatter/model/SqlRoutineBlock\n+ 2 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlBlockKt\n+ 3 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlBlock\n*L\n1#1,415:1\n945#2,2:416\n831#2,2:418\n111#3,5:420\n111#3,5:425\n111#3,5:430\n111#3,5:435\n111#3,5:440\n111#3,5:445\n111#3,5:450\n111#3,5:455\n111#3,5:460\n111#3,5:465\n111#3,5:470\n*S KotlinDebug\n*F\n+ 1 SqlRoutineBlock.kt\ncom/intellij/sql/formatter/model/SqlRoutineBlock\n*L\n67#1:416,2\n68#1:418,2\n80#1:420,5\n81#1:425,5\n82#1:430,5\n83#1:435,5\n85#1:440,5\n86#1:445,5\n90#1:450,5\n94#1:455,5\n99#1:460,5\n103#1:465,5\n107#1:470,5\n*E\n"})
public final class SqlRoutineBlock
extends SqlNodeBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<SqlTokenType> regularCaseFirstKeywords;
    @NotNull
    private static final Set<SqlTokenType> regularCaseNextKeywords;
    @NotNull
    private static final Set<SqlTokenType> shortCaseKeywords;
    @NotNull
    private static final List<FlowPattern> patterns;

    @Override
    @NotNull
    protected List<FlowPattern> flowPatterns() {
        return patterns;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node) {
        SqlBlock sqlBlock;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_COMMENT_CLAUSE)) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_CLAUSE) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_LANGUAGE_CLAUSE)) {
            SqlFlowBlock sqlFlowBlock;
            if (SqlFormattingModelFun.find((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.BODY) != null) {
                SqlRangeBlock $this$withSetup$iv = new SqlPostfixClauseBlock();
                boolean $i$f$withSetup = false;
                SqlBlock sqlBlock2 = this;
                TextRange textRange = node.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                $this$withSetup$iv.setup$intellij_database_sql_core_impl(sqlBlock2, textRange, SqlFormattingModelFun.listChildren(node));
                sqlFlowBlock = $this$withSetup$iv;
            } else {
                void var3_4;
                SqlNodeBlock $this$withSetup$iv = new SqlPrefixClauseBlock();
                boolean $i$f$withSetup = false;
                $this$withSetup$iv.setup$intellij_database_sql_core_impl(this, node);
                sqlFlowBlock = (SqlFlowBlock)var3_4;
            }
            sqlBlock = sqlFlowBlock;
        } else {
            sqlBlock = super.makeBlock(node);
        }
        return sqlBlock;
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return block.getRole() == BlockRole.PREFIX ? SqlFormattingFunKt.getNONE_INDENT() : super.defaultChildIndent(block);
    }

    @Override
    protected void configureFormattingAttributes() {
        Wrap mainWrap = SqlFlowBlock.makeWrap$default(this, WrapType.ALWAYS, false, 2, null);
        Wrap prefixOptionsWrap = null;
        Wrap postfixOptionsWrap = null;
        for (SqlBlock b : this.getNestedBlocks()) {
            IElementType wrap$iv;
            Indent indent$iv;
            Alignment align$iv;
            Indent indent$iv2;
            SqlBlock sqlBlock = b;
            if (sqlBlock instanceof SqlDeclarationSectionBlock) {
                indent$iv2 = SqlFormattingFunKt.getNONE_INDENT();
                align$iv = b.getMyAlign();
                boolean $i$f$setAttributes = false;
                b.setMyWrap(mainWrap);
                b.setMyIndent(indent$iv2);
                b.setMyAlign(align$iv);
                continue;
            }
            if (sqlBlock instanceof SqlDefinitionsSubsectionBlock) {
                indent$iv2 = SqlFormattingFunKt.getNORMAL_INDENT();
                align$iv = b.getMyAlign();
                boolean $i$f$setAttributes = false;
                b.setMyWrap(mainWrap);
                b.setMyIndent(indent$iv2);
                b.setMyAlign(align$iv);
                continue;
            }
            if (sqlBlock instanceof SqlBlockStatementBlock || sqlBlock instanceof SqlQueryBlock) {
                indent$iv2 = SqlFormattingFunKt.getNONE_INDENT();
                align$iv = b.getMyAlign();
                boolean $i$f$setAttributes = false;
                b.setMyWrap(mainWrap);
                b.setMyIndent(indent$iv2);
                b.setMyAlign(align$iv);
                continue;
            }
            if (sqlBlock instanceof SqlReturnBlock) {
                indent$iv2 = b.getShape() == BlockShape.DECIDED_TO_MULTI_ROWS ? mainWrap : null;
                indent$iv = SqlFormattingFunKt.getNORMAL_INDENT();
                Alignment align$iv2 = b.getMyAlign();
                boolean $i$f$setAttributes = false;
                b.setMyWrap((Wrap)wrap$iv);
                b.setMyIndent(indent$iv);
                b.setMyAlign(align$iv2);
                continue;
            }
            if (sqlBlock instanceof SqlKeyword) {
                wrap$iv = ((SqlKeyword)b).getElementType();
                if (Intrinsics.areEqual((Object)wrap$iv, (Object)SqlTokens.SQL_CREATE) || Intrinsics.areEqual((Object)wrap$iv, (Object)SqlTokens.SQL_ALTER)) {
                    indent$iv = SqlFormattingFunKt.getNONE_INDENT();
                    Alignment align$iv3 = b.getMyAlign();
                    boolean $i$f$setAttributes = false;
                    b.setMyWrap(mainWrap);
                    b.setMyIndent(indent$iv);
                    b.setMyAlign(align$iv3);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)wrap$iv, (Object)SqlTokens.SQL_AS)) continue;
                Indent indent$iv3 = SqlFormattingFunKt.getNONE_INDENT();
                Wrap wrap$iv2 = b.getMyWrap();
                Alignment align$iv4 = b.getMyAlign();
                boolean $i$f$setAttributes = false;
                b.setMyWrap(wrap$iv2);
                b.setMyIndent(indent$iv3);
                b.setMyAlign(align$iv4);
                continue;
            }
            if (sqlBlock instanceof SqlPrefixClauseBlock) {
                if (prefixOptionsWrap == null) {
                    indent$iv2 = b.getMyIndent();
                    align$iv = b.getMyAlign();
                    boolean $i$f$setAttributes = false;
                    b.setMyWrap(mainWrap);
                    b.setMyIndent(indent$iv2);
                    b.setMyAlign(align$iv);
                    prefixOptionsWrap = SqlFlowBlock.makeWrap$intellij_database_sql_core_impl$default((SqlFlowBlock)this, mainWrap, WrapType.CHOP_DOWN_IF_LONG, false, 4, null);
                    continue;
                }
                indent$iv2 = b.getMyIndent();
                align$iv = b.getMyAlign();
                boolean $i$f$setAttributes = false;
                b.setMyWrap(prefixOptionsWrap);
                b.setMyIndent(indent$iv2);
                b.setMyAlign(align$iv);
                continue;
            }
            if (sqlBlock instanceof SqlPostfixClauseBlock) {
                if (postfixOptionsWrap == null) {
                    indent$iv2 = b.getMyIndent();
                    align$iv = b.getMyAlign();
                    boolean $i$f$setAttributes = false;
                    b.setMyWrap(mainWrap);
                    b.setMyIndent(indent$iv2);
                    b.setMyAlign(align$iv);
                    postfixOptionsWrap = SqlFlowBlock.makeWrap$intellij_database_sql_core_impl$default((SqlFlowBlock)this, mainWrap, WrapType.CHOP_DOWN_IF_LONG, false, 4, null);
                    continue;
                }
                indent$iv2 = b.getMyIndent();
                align$iv = b.getMyAlign();
                boolean $i$f$setAttributes = false;
                b.setMyWrap(postfixOptionsWrap);
                b.setMyIndent(indent$iv2);
                b.setMyAlign(align$iv);
                continue;
            }
            if (!(sqlBlock instanceof SqlLanguageClauseBlock) && !(sqlBlock instanceof SqlUnsortedClauseBlock)) {
                if (!(sqlBlock instanceof SqlUnsortedBlock)) continue;
            }
            indent$iv2 = b.getMyIndent();
            align$iv = b.getMyAlign();
            boolean $i$f$setAttributes = false;
            b.setMyWrap(mainWrap);
            b.setMyIndent(indent$iv2);
            b.setMyAlign(align$iv);
        }
    }

    @Override
    protected boolean userRequiresExpand() {
        return true;
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        SqlBlock sqlBlock = block2;
        if (sqlBlock instanceof SqlParametersBlock) {
            switch (this.getContext().getSql().ROUTINE_ARG_OPENING) {
                case 1: {
                    spacing = this.getContext().makeSpace(this.getContext().getCom().SPACE_BEFORE_METHOD_PARENTHESES || ((SqlParametersBlock)block2).getOpeningBlock() == null, false);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null);
                    break;
                }
                default: {
                    spacing = SqlFormattingContext.makeSafeSpacing$default(this.getContext(), false, 1, null);
                    break;
                }
            }
        } else {
            spacing = sqlBlock instanceof SqlPrefixClauseBlock ? this.getContext().makeAutoSpacing(true) : (sqlBlock instanceof SqlPostfixClauseBlock ? this.getContext().makeAutoSpacing(true) : super.decideSpacing(block1, block2));
        }
        return spacing;
    }

    static {
        Object object = new SqlTokenType[]{SqlTokens.SQL_CREATE, SqlTokens.SQL_ALTER};
        regularCaseFirstKeywords = SetsKt.setOf((Object[])object);
        object = new SqlTokenType[]{SqlTokens.SQL_OR, SqlTokens.SQL_REPLACE, SqlTokens.SQL_ALTER, SqlTokens.SQL_PROCEDURE, SqlTokens.SQL_FUNCTION};
        regularCaseNextKeywords = SetsKt.setOf((Object[])object);
        object = new SqlTokenType[]{SqlTokens.SQL_PROCEDURE, SqlTokens.SQL_FUNCTION};
        shortCaseKeywords = SetsKt.setOf((Object[])object);
        object = new FlowPattern[9];
        object[0] = new SimplePattern((byte)0, (byte)1, NodeMatcherKt.matchType(regularCaseFirstKeywords), NodeMatcherKt.matchType(regularCaseNextKeywords), false, BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.1.INSTANCE));
        object[1] = new SingletonPattern((byte)0, (byte)1, NodeMatcherKt.matchType(shortCaseKeywords), BlockRole.PREFIX, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.2.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_PARAMETER_LIST;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SQL_PARAMETER_LIST");
        object[2] = new SingletonExpandPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.3.INSTANCE));
        SqlTypedDefinitionElementType sqlTypedDefinitionElementType = SqlCompositeElementTypes.SQL_RETURNS_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlTypedDefinitionElementType), (String)"SQL_RETURNS_CLAUSE");
        object[3] = new SingletonExpandPattern(NodeMatcherKt.matchType((IElementType)sqlTypedDefinitionElementType), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.4.INSTANCE));
        Object[] objectArray = new NodeMatcher[2];
        SqlTokenType sqlTokenType = SqlTokens.SQL_RETURN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_RETURN");
        objectArray[0] = NodeMatcherKt.matchType((IElementType)sqlTokenType);
        SqlTokenType sqlTokenType2 = SqlTokens.SQL_SELF;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_SELF");
        objectArray[1] = NodeMatcherKt.matchType((IElementType)sqlTokenType2);
        object[4] = new RowPattern(null, null, CollectionsKt.listOf((Object[])objectArray), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.5.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType2 = SqlCompositeElementTypes.SQL_LANGUAGE_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType2, (String)"SQL_LANGUAGE_CLAUSE");
        object[5] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType2), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.6.INSTANCE));
        SqlCompositeElementType sqlCompositeElementType3 = SqlCompositeElementTypes.SQL_DECLARE_STATEMENT;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType3, (String)"SQL_DECLARE_STATEMENT");
        object[6] = new SingletonExpandPattern(NodeMatcherKt.matchType((IElementType)sqlCompositeElementType3), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.7.INSTANCE));
        SqlTokenType sqlTokenType3 = SqlTokens.SQL_DECLARE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"SQL_DECLARE");
        objectArray = new IElementType[]{SqlCompositeElementTypes.SQL_VARIABLE_DEFINITION, SqlCommonTokens.SQL_SEMICOLON};
        object[7] = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType((IElementType)sqlTokenType3), new ElementTypeSetContinuePattern(SetsKt.setOf((Object[])objectArray), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.8.INSTANCE)));
        SqlLazyElementType sqlLazyElementType = SqlCompositeElementTypes.SQL_BLOCK_STATEMENT;
        Intrinsics.checkNotNullExpressionValue((Object)sqlLazyElementType, (String)"SQL_BLOCK_STATEMENT");
        object[8] = new SingletonPattern(NodeMatcherKt.matchType((IElementType)sqlLazyElementType), BlockRole.NOTHING, (Function0<? extends SqlBlock>)((Function0)Companion.patterns.9.INSTANCE));
        patterns = CollectionsKt.mutableListOf((Object[])object);
        for (IElementType dt : SqlDeclarationDefinitions.INSTANCE.getDEFINITION_TYPES$intellij_database_sql_core_impl()) {
            FirstAndContinuePattern p2 = FlowContinuePatternKt.followedBy(NodeMatcherKt.matchType(dt), new ElementTypeSetContinuePattern(SqlDeclarationDefinitions.INSTANCE.getDEFINITION_AND_DELIMITER_TYPES$intellij_database_sql_core_impl(), (Function0<? extends SqlRangeBlock>)((Function0)Companion.p.1.INSTANCE)));
            ((Collection)patterns).add(p2);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/formatter/model/SqlRoutineBlock$Companion;", "", "<init>", "()V", "regularCaseFirstKeywords", "", "Lcom/intellij/sql/psi/SqlTokenType;", "kotlin.jvm.PlatformType", "regularCaseNextKeywords", "shortCaseKeywords", "patterns", "", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/List;", "intellij.database.sql.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<FlowPattern> getPatterns() {
            return patterns;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

