/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.BasicModelRegistry;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelExternalData;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.VmElement;
import com.intellij.database.model.basic.VmModelContextFactory;
import com.intellij.database.model.families.FamilyWithId;
import com.intellij.database.model.families.ObjectsFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.structure.DvExtraNode;
import com.intellij.database.view.structure.DvFamilyId;
import com.intellij.database.view.structure.DvTreeIconItem;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.database.view.structure.DvTreeStoreyLayer;
import com.intellij.database.view.structure.DvTreeStructure;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.WeakInterner;
import java.util.Arrays;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001:\u000589:;<B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0018\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u00132\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u001a\u0010\u0014\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000e\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u001c\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u00132\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0002J(\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0013\"\b\b\u0000\u0010\u001b*\u00020\u001c2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001dH\u0002J@\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0013\"\b\b\u0000\u0010\u001b*\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001d2\b\u0010 \u001a\u0004\u0018\u00010\u001c2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001b0\"H\u0002JP\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0013\"\b\b\u0000\u0010\u001b*\u00020\u001c\"\b\b\u0001\u0010$*\u00020%2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001d2\b\u0010 \u001a\u0004\u0018\u00010\u001c2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H$0'H\u0002J;\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u0019\"\b\b\u0000\u0010\u001b*\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001d2\u0006\u0010)\u001a\u0002H\u001b2\u0006\u0010*\u001a\u00020+H\u0002\u00a2\u0006\u0002\u0010,J\u0018\u0010-\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u000eH\u0002JC\u0010.\u001a5\u0012,\u0012*\u0012\u000e\b\u0001\u0012\n /*\u0004\u0018\u00010\u001c0\u001c /*\u0014\u0012\u000e\b\u0001\u0012\n /*\u0004\u0018\u00010\u001c0\u001c\u0018\u00010\u001d0\u001d0\u0013\u00a2\u0006\u0002\b02\u0006\u0010\u000f\u001a\u00020\u001cH\u0002J\u0010\u00101\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u00102\u001a\u0002032\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u001f\u00104\u001a\u0002H5\"\b\b\u0000\u00105*\u00020\n2\u0006\u00106\u001a\u0002H5H\u0002\u00a2\u0006\u0002\u00107R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/intellij/database/view/structure/DvTreeImplantingLayer;", "Lcom/intellij/database/view/structure/DvTreeStoreyLayer;", "<init>", "()V", "level", "", "getLevel", "()B", "interner", "Lcom/intellij/util/containers/WeakInterner;", "Lcom/intellij/database/view/structure/DvTreeImplantingLayer$ImplantedNode;", "clearAll", "", "parentOf", "Lcom/intellij/database/model/basic/BasicNode;", "node", "isValid", "", "childrenOf", "Lcom/intellij/util/containers/JBIterable;", "childrenOfImpl", "countAllChildrenOf", "", "countRealChildrenOf", "childrenOfImplantedVirtualObject", "Lcom/intellij/database/view/structure/DvTreeImplantingLayer$ImplantedVirtualObject;", "childrenOfImplantedVirtualFamily", "E", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/view/structure/DvTreeImplantingLayer$ImplantedVirtualFamily;", "virtualObjects", "parent", "e", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "extractImplanted", "D", "Lcom/intellij/database/model/ModelExternalData$ObjDesc;", "extractor", "Lcom/intellij/database/model/basic/VmModelContextFactory$VmExtractor;", "implantedVirtualObject", "delegate", "data", "", "(Lcom/intellij/database/view/structure/DvTreeImplantingLayer$ImplantedVirtualFamily;Lcom/intellij/database/model/basic/BasicElement;Ljava/lang/Object;)Lcom/intellij/database/view/structure/DvTreeImplantingLayer$ImplantedVirtualObject;", "implantChildren", "implantedVirtualFamilies", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "isAlwaysLeaf", "presentableNameOf", "", "intern", "T", "x", "(Lcom/intellij/database/view/structure/DvTreeImplantingLayer$ImplantedNode;)Lcom/intellij/database/view/structure/DvTreeImplantingLayer$ImplantedNode;", "ImplantedNode", "ImplantedFamily", "ImplantedVirtualFamily", "ImplantedObject", "ImplantedVirtualObject", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDvTreeImplantingLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeImplantingLayer.kt\ncom/intellij/database/view/structure/DvTreeImplantingLayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n1#2:208\n*E\n"})
public final class DvTreeImplantingLayer
extends DvTreeStoreyLayer {
    @NotNull
    private final WeakInterner<ImplantedNode> interner = new WeakInterner(HashingStrategy.canonical());

    @Override
    public byte getLevel() {
        return 3;
    }

    @Override
    public void clearAll() {
        this.interner.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public BasicNode parentOf(@NotNull BasicNode node) {
        BasicNode basicNode;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof ImplantedNode) {
            BasicNode it = ((ImplantedNode)node).getParent();
            boolean bl = false;
            if (it instanceof BasicRoot) {
                DataSourceNode dataSourceNode = this.getContext().modelRegistry.getDataSourceNode((BasicElement)it);
                basicNode = dataSourceNode != null ? (BasicNode)dataSourceNode : it;
            } else {
                void var2_2;
                basicNode = var2_2;
            }
        } else {
            basicNode = this.getBase().parentOf(node);
        }
        return basicNode;
    }

    @Override
    public boolean isValid(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof ImplantedNode ? this.isValid((ImplantedNode)node) : super.isValid(node);
    }

    private final boolean isValid(ImplantedNode node) {
        return this.isValid(node.getParent()) && this.childrenOf(node.getParent()).contains((Object)node);
    }

    @Override
    @NotNull
    public JBIterable<? extends BasicNode> childrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        JBIterable<? extends BasicNode> jBIterable = this.childrenOfImpl(node);
        if (jBIterable == null) {
            jBIterable = this.getBase().childrenOf(node);
        }
        return jBIterable;
    }

    private final JBIterable<? extends BasicNode> childrenOfImpl(BasicNode node) {
        BasicNode basicNode = node;
        return basicNode instanceof ImplantedVirtualObject ? this.childrenOfImplantedVirtualObject((ImplantedVirtualObject)node) : (basicNode instanceof ImplantedVirtualFamily ? this.childrenOfImplantedVirtualFamily((ImplantedVirtualFamily)node) : this.implantChildren(node));
    }

    @Override
    public int countAllChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        JBIterable<? extends BasicNode> jBIterable = this.childrenOfImpl(node);
        return jBIterable != null ? jBIterable.size() : super.countAllChildrenOf(node);
    }

    @Override
    public int countRealChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        JBIterable<? extends BasicNode> jBIterable = this.childrenOfImpl(node);
        return jBIterable != null ? jBIterable.size() : super.countRealChildrenOf(node);
    }

    private final JBIterable<? extends BasicNode> childrenOfImplantedVirtualObject(ImplantedVirtualObject<?> node) {
        BasicMetaObject<?>[] basicMetaObjectArray = ((BasicObjectNode)node.getDelegate()).getMetaObject().children;
        JBIterable jBIterable = JBIterable.of((Object[])Arrays.copyOf(basicMetaObjectArray, basicMetaObjectArray.length)).map(arg_0 -> DvTreeImplantingLayer.childrenOfImplantedVirtualObject$lambda$2(arg_0 -> DvTreeImplantingLayer.childrenOfImplantedVirtualObject$lambda$1(node, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"map(...)");
        return jBIterable;
    }

    private final <E extends BasicElement> JBIterable<? extends BasicNode> childrenOfImplantedVirtualFamily(ImplantedVirtualFamily<E> node) {
        JBIterable<BasicNode> jBIterable;
        if (node.getMetaObject().kindOf(VmElement.class)) {
            Intrinsics.checkNotNull(node, (String)"null cannot be cast to non-null type com.intellij.database.view.structure.DvTreeImplantingLayer.ImplantedVirtualFamily<com.intellij.database.model.basic.VmForeignKey>");
            BasicNode basicNode = node.getParent();
            jBIterable = this.virtualObjects(node, basicNode instanceof BasicElement ? (BasicElement)basicNode : null, node.getMetaObject());
        } else {
            JBIterable<BasicNode> jBIterable2 = JBIterable.empty();
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"empty(...)");
        }
        return jBIterable;
    }

    private final <E extends BasicElement> JBIterable<? extends BasicNode> virtualObjects(ImplantedVirtualFamily<E> parent, BasicElement e, BasicMetaObject<E> meta) {
        VmModelContextFactory.VmExtractor<E, ?> vmExtractor = VmModelContextFactory.createVirtualObjectsExtractor(meta);
        if (vmExtractor == null) {
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return jBIterable;
        }
        VmModelContextFactory.VmExtractor<E, ?> extractor = vmExtractor;
        return this.extractImplanted(parent, e, extractor);
    }

    private final <E extends BasicElement, D extends ModelExternalData.ObjDesc> JBIterable<? extends BasicNode> extractImplanted(ImplantedVirtualFamily<E> parent, BasicElement e, VmModelContextFactory.VmExtractor<E, D> extractor) {
        Object object;
        block3: {
            block2: {
                object = e;
                if (object == null) break block2;
                BasicElement basicElement = object;
                BasicModelRegistry basicModelRegistry = this.getContext().modelRegistry;
                BasicElement p0 = basicElement;
                boolean bl = false;
                LocalDataSource localDataSource = basicModelRegistry.getLocalDataSource(p0);
                object = localDataSource;
                if (localDataSource != null) break block3;
            }
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return jBIterable;
        }
        Object ds = object;
        JBIterable jBIterable = extractor.extractData((LocalDataSource)ds, e).filterMap(arg_0 -> DvTreeImplantingLayer.extractImplanted$lambda$5(arg_0 -> DvTreeImplantingLayer.extractImplanted$lambda$4(extractor, this, parent, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
        return jBIterable;
    }

    private final <E extends BasicElement> ImplantedVirtualObject<E> implantedVirtualObject(ImplantedVirtualFamily<E> parent, E delegate, Object data) {
        return (ImplantedVirtualObject)this.intern((ImplantedNode)new ImplantedVirtualObject<E>(parent, delegate, data));
    }

    private final JBIterable<BasicNode> implantChildren(BasicNode node) {
        if (!this.getVo().getShowVirtualObjects() || !(node instanceof BasicElement)) {
            return null;
        }
        JBIterable jBIterable = this.implantedVirtualFamilies((BasicElement)node).collect();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"collect(...)");
        JBIterable implanted = jBIterable;
        if (implanted.isEmpty()) {
            return null;
        }
        JBIterable<? extends BasicNode> jBIterable2 = this.getBase().childrenOf(node);
        Intrinsics.checkNotNull(jBIterable2, (String)"null cannot be cast to non-null type com.intellij.util.containers.JBIterable<com.intellij.database.model.basic.BasicNode>");
        JBIterable<? extends BasicNode> children2 = jBIterable2;
        return children2.append((Iterable)implanted);
    }

    private final JBIterable<ImplantedVirtualFamily<? extends BasicElement>> implantedVirtualFamilies(BasicElement node) {
        JBIterable jBIterable = JBIterable.from((Iterable)VmModelContextFactory.createContextVmMetaObjects(node.getMetaObject())).map(arg_0 -> DvTreeImplantingLayer.implantedVirtualFamilies$lambda$7(arg_0 -> DvTreeImplantingLayer.implantedVirtualFamilies$lambda$6(node, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"map(...)");
        return jBIterable;
    }

    @Override
    public boolean isAlwaysLeaf(@NotNull BasicNode node) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof ImplantedVirtualObject) {
            Intrinsics.checkNotNullExpressionValue(((BasicObjectNode)((ImplantedVirtualObject)node).getDelegate()).getMetaObject().children, (String)"children");
            bl = ((Object[])((BasicObjectNode)((ImplantedVirtualObject)node).getDelegate()).getMetaObject().children).length == 0;
        } else {
            bl = this.getBase().isAlwaysLeaf(node);
        }
        return bl;
    }

    @Override
    @NotNull
    public String presentableNameOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getBase().presentableNameOf(node);
    }

    private final <T extends ImplantedNode> T intern(T x) {
        Object object = this.interner.intern(x);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of com.intellij.database.view.structure.DvTreeImplantingLayer.intern");
        return (T)((ImplantedNode)object);
    }

    private static final ImplantedVirtualFamily childrenOfImplantedVirtualObject$lambda$1(ImplantedVirtualObject $node, BasicMetaObject it) {
        BasicNode basicNode = $node;
        Intrinsics.checkNotNull((Object)it);
        return new ImplantedVirtualFamily(basicNode, it);
    }

    private static final ImplantedVirtualFamily childrenOfImplantedVirtualObject$lambda$2(Function1 $tmp0, Object p0) {
        return (ImplantedVirtualFamily)$tmp0.invoke(p0);
    }

    private static final ImplantedVirtualObject extractImplanted$lambda$4(VmModelContextFactory.VmExtractor $extractor, DvTreeImplantingLayer this$0, ImplantedVirtualFamily $parent, ModelExternalData.ObjDesc d) {
        ImplantedVirtualObject implantedVirtualObject;
        Object e = $extractor.create(d);
        if (e != null) {
            Object it = e;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)d);
            implantedVirtualObject = this$0.implantedVirtualObject($parent, it, d);
        } else {
            implantedVirtualObject = null;
        }
        return implantedVirtualObject;
    }

    private static final ImplantedVirtualObject extractImplanted$lambda$5(Function1 $tmp0, Object p0) {
        return (ImplantedVirtualObject)$tmp0.invoke(p0);
    }

    private static final ImplantedVirtualFamily implantedVirtualFamilies$lambda$6(BasicElement $node, BasicMetaObject it) {
        BasicNode basicNode = $node;
        Intrinsics.checkNotNull((Object)it);
        return new ImplantedVirtualFamily(basicNode, it);
    }

    private static final ImplantedVirtualFamily implantedVirtualFamilies$lambda$7(Function1 $tmp0, Object p0) {
        return (ImplantedVirtualFamily)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0006H\u0016J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/view/structure/DvTreeImplantingLayer$ImplantedFamily;", "Lcom/intellij/database/view/structure/DvTreeImplantingLayer$ImplantedNode;", "Lcom/intellij/database/model/families/FamilyWithId;", "parent", "Lcom/intellij/database/model/basic/BasicNode;", "familyId", "Lcom/intellij/database/view/structure/DvFamilyId;", "<init>", "(Lcom/intellij/database/model/basic/BasicNode;Lcom/intellij/database/view/structure/DvFamilyId;)V", "hostKind", "Lcom/intellij/database/model/ObjectKind;", "getHostKind", "()Lcom/intellij/database/model/ObjectKind;", "getDisplayName", "", "getFamilyId", "equals", "", "other", "", "hashCode", "", "treeNodeRank", "Lcom/intellij/database/view/structure/DvTreeNodeRank;", "getTreeNodeRank", "()Lcom/intellij/database/view/structure/DvTreeNodeRank;", "iconItem", "Lcom/intellij/database/view/structure/DvTreeIconItem;", "getIconItem", "()Lcom/intellij/database/view/structure/DvTreeIconItem;", "intellij.database.core.impl"})
    public static class ImplantedFamily
    extends ImplantedNode
    implements FamilyWithId {
        @NotNull
        private final DvFamilyId familyId;

        public ImplantedFamily(@NotNull BasicNode parent, @NotNull DvFamilyId familyId) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)familyId, (String)"familyId");
            super(parent);
            this.familyId = familyId;
        }

        @Override
        @Nullable
        public ObjectKind getHostKind() {
            return this.getParent() instanceof BasicElement ? ((BasicElement)this.getParent()).getKind() : null;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = this.familyId.getFakeKind().getPluralPresentableName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPluralPresentableName(...)");
            return string;
        }

        @Override
        @NotNull
        public DvFamilyId getFamilyId() {
            return this.familyId;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ImplantedFamily && super.equals(other) && Intrinsics.areEqual((Object)this.familyId, (Object)((ImplantedFamily)other).familyId);
        }

        @Override
        public int hashCode() {
            Object[] objectArray = new Object[]{super.hashCode(), this.familyId};
            return Objects.hash(objectArray);
        }

        @Override
        @NotNull
        public DvTreeNodeRank getTreeNodeRank() {
            return DvTreeNodeRank.TL_FAMILY;
        }

        @Override
        @NotNull
        public DvTreeIconItem getIconItem() {
            return DvTreeIconItem.VIRTUAL_FOLDER_ICON;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/view/structure/DvTreeImplantingLayer$ImplantedNode;", "Lcom/intellij/database/view/structure/DvExtraNode;", "parent", "Lcom/intellij/database/model/basic/BasicNode;", "<init>", "(Lcom/intellij/database/model/basic/BasicNode;)V", "getParent", "()Lcom/intellij/database/model/basic/BasicNode;", "getModel", "Lcom/intellij/database/model/basic/BasicModel;", "equals", "", "other", "", "hashCode", "", "updatePresentation", "", "project", "Lcom/intellij/openapi/project/Project;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "treeStructure", "Lcom/intellij/database/view/structure/DvTreeStructure;", "viewOptions", "Lcom/intellij/database/view/structure/DvViewOptions;", "toString", "", "intellij.database.core.impl"})
    public static abstract class ImplantedNode
    implements DvExtraNode {
        @NotNull
        private final BasicNode parent;

        public ImplantedNode(@NotNull BasicNode parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            this.parent = parent;
        }

        @NotNull
        public final BasicNode getParent() {
            return this.parent;
        }

        @Override
        @Nullable
        public BasicModel getModel() {
            return this.parent.getModel();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ImplantedNode && Intrinsics.areEqual((Object)this.parent, (Object)((ImplantedNode)other).parent);
        }

        public int hashCode() {
            return this.parent.hashCode();
        }

        public void updatePresentation(@NotNull Project project, @NotNull PresentationData presentation, @NotNull DvTreeStructure treeStructure, @NotNull DvViewOptions viewOptions) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)treeStructure, (String)"treeStructure");
            Intrinsics.checkNotNullParameter((Object)viewOptions, (String)"viewOptions");
        }

        @NotNull
        public String toString() {
            String string = this.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            return string;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/view/structure/DvTreeImplantingLayer$ImplantedObject;", "Lcom/intellij/database/view/structure/DvTreeImplantingLayer$ImplantedNode;", "parent", "Lcom/intellij/database/model/basic/BasicNode;", "data", "", "<init>", "(Lcom/intellij/database/model/basic/BasicNode;Ljava/lang/Object;)V", "getData", "()Ljava/lang/Object;", "equals", "", "other", "hashCode", "", "treeNodeRank", "Lcom/intellij/database/view/structure/DvTreeNodeRank;", "getTreeNodeRank", "()Lcom/intellij/database/view/structure/DvTreeNodeRank;", "isItselfMeaningful", "()Z", "intellij.database.core.impl"})
    public static abstract class ImplantedObject
    extends ImplantedNode {
        @NotNull
        private final Object data;

        public ImplantedObject(@NotNull BasicNode parent, @NotNull Object data) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            super(parent);
            this.data = data;
        }

        @NotNull
        public final Object getData() {
            return this.data;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ImplantedObject && super.equals(other) && Intrinsics.areEqual((Object)this.data, (Object)((ImplantedObject)other).data);
        }

        @Override
        public int hashCode() {
            Object[] objectArray = new Object[]{super.hashCode(), this.data};
            return Objects.hash(objectArray);
        }

        @Override
        @NotNull
        public DvTreeNodeRank getTreeNodeRank() {
            return DvTreeNodeRank.TL_ELEMENT;
        }

        @Override
        public boolean isItselfMeaningful() {
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0016J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/view/structure/DvTreeImplantingLayer$ImplantedVirtualFamily;", "E", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/view/structure/DvTreeImplantingLayer$ImplantedFamily;", "Lcom/intellij/database/model/families/ObjectsFamily;", "parent", "Lcom/intellij/database/model/basic/BasicNode;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "<init>", "(Lcom/intellij/database/model/basic/BasicNode;Lcom/intellij/database/model/meta/BasicMetaObject;)V", "getMetaObject", "equals", "", "other", "", "hashCode", "", "intellij.database.core.impl"})
    public static final class ImplantedVirtualFamily<E extends BasicElement>
    extends ImplantedFamily
    implements ObjectsFamily {
        @NotNull
        private final BasicMetaObject<E> meta;

        public ImplantedVirtualFamily(@NotNull BasicNode parent, @NotNull BasicMetaObject<E> meta) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter(meta, (String)"meta");
            ObjectKind objectKind = meta.kind;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"kind");
            super(parent, DvFamilyId.Companion.wrap(objectKind));
            this.meta = meta;
        }

        @NotNull
        public BasicMetaObject<E> getMetaObject() {
            return this.meta;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ImplantedVirtualFamily && super.equals(other) && Intrinsics.areEqual(this.meta, ((ImplantedVirtualFamily)other).meta);
        }

        @Override
        public int hashCode() {
            Object[] objectArray = new Object[]{super.hashCode(), this.meta};
            return Objects.hash(objectArray);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B%\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014H\u0016J\r\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u0016J(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016R\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006&"}, d2={"Lcom/intellij/database/view/structure/DvTreeImplantingLayer$ImplantedVirtualObject;", "E", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/view/structure/DvTreeImplantingLayer$ImplantedObject;", "Lcom/intellij/database/model/basic/BasicObjectNode;", "Lcom/intellij/database/model/DasObject;", "parent", "Lcom/intellij/database/view/structure/DvTreeImplantingLayer$ImplantedVirtualFamily;", "delegate", "data", "", "<init>", "(Lcom/intellij/database/view/structure/DvTreeImplantingLayer$ImplantedVirtualFamily;Lcom/intellij/database/model/basic/BasicElement;Ljava/lang/Object;)V", "getDelegate", "()Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/model/basic/BasicElement;", "getParent", "getDisplayName", "", "getMetaObject", "Lcom/intellij/database/model/meta/BasicMetaObject;", "extractObject", "getName", "getKind", "Lcom/intellij/database/model/ObjectKind;", "isQuoted", "", "getDasParent", "updatePresentation", "", "project", "Lcom/intellij/openapi/project/Project;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "treeStructure", "Lcom/intellij/database/view/structure/DvTreeStructure;", "viewOptions", "Lcom/intellij/database/view/structure/DvViewOptions;", "intellij.database.core.impl"})
    public static final class ImplantedVirtualObject<E extends BasicElement>
    extends ImplantedObject
    implements BasicObjectNode,
    DasObject {
        @NotNull
        private final E delegate;

        public ImplantedVirtualObject(@NotNull ImplantedVirtualFamily<E> parent, @NotNull E delegate, @NotNull Object data) {
            Intrinsics.checkNotNullParameter(parent, (String)"parent");
            Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            super(parent, data);
            this.delegate = delegate;
        }

        @NotNull
        public final E getDelegate() {
            return this.delegate;
        }

        @Override
        @Nullable
        public BasicObjectNode getParent() {
            BasicNode basicNode = this.getParent();
            Intrinsics.checkNotNull((Object)basicNode, (String)"null cannot be cast to non-null type com.intellij.database.view.structure.DvTreeImplantingLayer.ImplantedVirtualFamily<*>");
            BasicNode basicNode2 = ((ImplantedVirtualFamily)basicNode).getParent();
            return basicNode2 instanceof BasicObjectNode ? (BasicObjectNode)basicNode2 : null;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = ((DasNamed)this.delegate).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }

        @NotNull
        public BasicMetaObject<E> getMetaObject() {
            BasicMetaObject<E> basicMetaObject = BasicMetaUtils.getMetaObject(this.delegate);
            Intrinsics.checkNotNullExpressionValue(basicMetaObject, (String)"getMetaObject(...)");
            return basicMetaObject;
        }

        @NotNull
        public E extractObject() {
            return this.delegate;
        }

        @Override
        @NotNull
        public String getName() {
            String string = ((DasNamed)this.delegate).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ((DasNamed)this.delegate).getKind();
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"getKind(...)");
            return objectKind;
        }

        @Override
        public boolean isQuoted() {
            return ((BasicMixinElement)this.delegate).isQuoted();
        }

        @Override
        @Nullable
        public DasObject getDasParent() {
            BasicNode tmp = this.getParent();
            while (tmp != null) {
                if (tmp instanceof DasObject) {
                    return (DasObject)((Object)tmp);
                }
                BasicNode basicNode = tmp;
                ImplantedNode implantedNode = basicNode instanceof ImplantedNode ? (ImplantedNode)basicNode : null;
                tmp = implantedNode != null ? implantedNode.getParent() : null;
            }
            return null;
        }

        @Override
        public void updatePresentation(@NotNull Project project, @NotNull PresentationData presentation, @NotNull DvTreeStructure treeStructure, @NotNull DvViewOptions viewOptions) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)treeStructure, (String)"treeStructure");
            Intrinsics.checkNotNullParameter((Object)viewOptions, (String)"viewOptions");
            if (((CharSequence)this.getDisplayName()).length() == 0) {
                presentation.setPresentableText("");
                presentation.getColoredText().clear();
            }
            if ((object = this.getModel()) == null || (object = object.getDbms()) == null) {
                object = Dbms.UNKNOWN;
            }
            Object dbms = object;
            presentation.setIcon(DbPresentationCore.getIcon((DasObject)this.delegate));
            ModelFacade.forDbms((Dbms)dbms).getDescriptionService().updatePresentation(project, (DasObject)this.delegate, viewOptions, presentation);
        }
    }
}

