/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.actions.ColumnHeaderActionBase;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.database.run.ui.grid.editors.UuidEditorFactory;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J(\u0010\u000f\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/run/actions/InsertRandomUUIDAction;", "Lcom/intellij/database/run/actions/ColumnHeaderActionBase;", "<init>", "()V", "findSuitableFactory", "Lcom/intellij/database/run/ui/grid/editors/GridCellEditorFactory;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "columnIdxs", "Lcom/intellij/database/datagrid/ModelIndexSet;", "Lcom/intellij/database/datagrid/GridColumn;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nInsertRandomUUIDAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsertRandomUUIDAction.kt\ncom/intellij/database/run/actions/InsertRandomUUIDAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1863#2,2:55\n*S KotlinDebug\n*F\n+ 1 InsertRandomUUIDAction.kt\ncom/intellij/database/run/actions/InsertRandomUUIDAction\n*L\n46#1:55,2\n*E\n"})
public final class InsertRandomUUIDAction
extends ColumnHeaderActionBase {
    public InsertRandomUUIDAction() {
        super(true);
    }

    private final GridCellEditorFactory findSuitableFactory(DataGrid grid, ModelIndexSet<GridColumn> columnIdxs) {
        if (columnIdxs.size() != 1) {
            return null;
        }
        Index index = columnIdxs.first();
        Intrinsics.checkNotNullExpressionValue((Object)index, (String)"first(...)");
        ModelIndex columnIdx = (ModelIndex)index;
        ModelIndexSet modelIndexSet = grid.getSelectionModel().getSelectedRows();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndexSet, (String)"getSelectedRows(...)");
        ModelIndexSet selectedRows = modelIndexSet;
        if (selectedRows.size() < 1) {
            return null;
        }
        Index index2 = selectedRows.first();
        Intrinsics.checkNotNullExpressionValue((Object)index2, (String)"first(...)");
        ModelIndex rowIdx = (ModelIndex)index2;
        GridCellEditorFactoryProvider gridCellEditorFactoryProvider = GridCellEditorFactoryProvider.get((DataGrid)grid);
        GridCellEditorFactory gridCellEditorFactory = gridCellEditorFactoryProvider != null ? gridCellEditorFactoryProvider.getEditorFactory(grid, rowIdx, columnIdx) : null;
        UuidEditorFactory factory = gridCellEditorFactory instanceof UuidEditorFactory ? (UuidEditorFactory)gridCellEditorFactory : null;
        return factory;
    }

    protected void update(@NotNull AnActionEvent e, @NotNull DataGrid grid, @NotNull ModelIndexSet<GridColumn> columnIdxs) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter(columnIdxs, (String)"columnIdxs");
        GridCellEditorFactory factory = this.findSuitableFactory(grid, columnIdxs);
        e.getPresentation().setEnabledAndVisible(columnIdxs.size() == 1 && factory != null);
    }

    protected void actionPerformed(@Nullable AnActionEvent e, @NotNull DataGrid grid, @NotNull ModelIndexSet<GridColumn> columnIdxs) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter(columnIdxs, (String)"columnIdxs");
        GridCellEditorFactory gridCellEditorFactory = this.findSuitableFactory(grid, columnIdxs);
        if (gridCellEditorFactory == null) {
            return;
        }
        GridCellEditorFactory factory = gridCellEditorFactory;
        if (columnIdxs.size() != 1) {
            return;
        }
        Index index = columnIdxs.first();
        Intrinsics.checkNotNullExpressionValue((Object)index, (String)"first(...)");
        ModelIndex columnIdx = (ModelIndex)index;
        List list = GridUtil.getSelectedGridRows((DataGrid)grid);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedGridRows(...)");
        List rows = list;
        GridModel gridModel = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
        GridModel model = gridModel;
        grid.cancelEditing();
        Iterable $this$forEach$iv = rows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object value;
            GridCellEditorFactory.ValueParser valueParser;
            GridRow row = (GridRow)element$iv;
            boolean bl = false;
            ModelIndex rowIdx = ModelIndex.forRow((CoreGrid)((CoreGrid)grid), (int)GridRow.toRealIdx((GridRow)row));
            Intrinsics.checkNotNullExpressionValue((Object)factory.getValueParser(grid, rowIdx, columnIdx), (String)"getValueParser(...)");
            Intrinsics.checkNotNullExpressionValue((Object)valueParser.parse(UUID.randomUUID().toString(), null), (String)"parse(...)");
            ModelIndex[] modelIndexArray = new ModelIndex[]{rowIdx};
            ModelIndexSet modelIndexSet = ModelIndexSet.forRows((GridModel)model, (ModelIndex[])modelIndexArray);
            modelIndexArray = new ModelIndex[]{columnIdx};
            grid.setCells(modelIndexSet, ModelIndexSet.forColumns((GridModel)model, (ModelIndex[])modelIndexArray), value);
        }
    }
}

