/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.DataGridBundle;
import com.intellij.database.Dbms;
import com.intellij.database.data.types.GeoHelper;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.remote.jdbc.GeoWrapper;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.FormatterImpl;
import java.text.ParsePosition;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0016J\r\u0010\u001d\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001eH\u0014R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/extractors/GeoWrapperFormatter;", "Lcom/intellij/database/run/ui/grid/editors/FormatterImpl;", "myDbms", "Lcom/intellij/database/Dbms;", "column", "Lcom/intellij/database/datagrid/GridColumn;", "objectFormatter", "Lcom/intellij/database/extractors/ObjectFormatter;", "<init>", "(Lcom/intellij/database/Dbms;Lcom/intellij/database/datagrid/GridColumn;Lcom/intellij/database/extractors/ObjectFormatter;)V", "getMyDbms", "()Lcom/intellij/database/Dbms;", "setMyDbms", "(Lcom/intellij/database/Dbms;)V", "getColumn", "()Lcom/intellij/database/datagrid/GridColumn;", "setColumn", "(Lcom/intellij/database/datagrid/GridColumn;)V", "getObjectFormatter", "()Lcom/intellij/database/extractors/ObjectFormatter;", "setObjectFormatter", "(Lcom/intellij/database/extractors/ObjectFormatter;)V", "parse", "", "value", "", "position", "Ljava/text/ParsePosition;", "format", "getErrorMessage", "Lorg/jetbrains/annotations/Nls;", "intellij.database.core.impl"})
public final class GeoWrapperFormatter
extends FormatterImpl {
    @NotNull
    private Dbms myDbms;
    @NotNull
    private GridColumn column;
    @NotNull
    private ObjectFormatter objectFormatter;

    public GeoWrapperFormatter(@NotNull Dbms myDbms, @NotNull GridColumn column2, @NotNull ObjectFormatter objectFormatter) {
        Intrinsics.checkNotNullParameter((Object)myDbms, (String)"myDbms");
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        Intrinsics.checkNotNullParameter((Object)objectFormatter, (String)"objectFormatter");
        this.myDbms = myDbms;
        this.column = column2;
        this.objectFormatter = objectFormatter;
    }

    @NotNull
    public final Dbms getMyDbms() {
        return this.myDbms;
    }

    public final void setMyDbms(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"<set-?>");
        this.myDbms = dbms;
    }

    @NotNull
    public final GridColumn getColumn() {
        return this.column;
    }

    public final void setColumn(@NotNull GridColumn gridColumn) {
        Intrinsics.checkNotNullParameter((Object)gridColumn, (String)"<set-?>");
        this.column = gridColumn;
    }

    @NotNull
    public final ObjectFormatter getObjectFormatter() {
        return this.objectFormatter;
    }

    public final void setObjectFormatter(@NotNull ObjectFormatter objectFormatter) {
        Intrinsics.checkNotNullParameter((Object)objectFormatter, (String)"<set-?>");
        this.objectFormatter = objectFormatter;
    }

    @NotNull
    public Object parse(@NotNull String value, @NotNull ParsePosition position) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        GeoHelper geoHelper = GeoHelper.EP.forDbms(this.myDbms);
        byte[] binary = geoHelper.extractBinaryFromWkt(value, position.getIndex());
        position.setIndex(value.length());
        return new GeoWrapper(binary, value);
    }

    @Nullable
    public String format(@Nullable Object value) {
        if (value instanceof GeoWrapper) {
            return this.objectFormatter.objectToString(value, this.column, (ObjectFormatterConfig)new DatabaseObjectFormatterConfig(ObjectFormatterMode.DISPLAY));
        }
        return value instanceof ReservedCellValue ? "" : String.valueOf(value);
    }

    @NotNull
    protected String getErrorMessage() {
        String string = DataGridBundle.message((String)"unexpected.data.format", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

