/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis;

import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.HookUpHelper;
import com.intellij.database.dialects.redis.delegates.RedisDelegateFactory;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCodeFragmentImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u000e\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\b\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0014\u001a\u00020\u00132\b\u0010\b\u001a\u0004\u0018\u00010\u000fH\u0016J6\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u001b\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u001b\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u001c\u001a\u00020\u00132\b\u0010\b\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u001d\u001a\u00020\u00132\b\u0010\b\u001a\u0004\u0018\u00010\u000fH\u0016J6\u0010\u001e\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\u000fH\u0016J@\u0010 \u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\u000f2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/database/dialects/redis/RedisHookUpHelper;", "Lcom/intellij/database/datagrid/HookUpHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "needToObtainTableKind", "", "table", "Lcom/intellij/database/psi/DbElement;", "getFilterSortLanguage", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "dataSource", "Lcom/intellij/database/psi/DbDataSource;", "isFilterApplicable", "Lcom/intellij/database/model/DasObject;", "kind", "Lcom/intellij/database/model/ObjectKind;", "getFilterPrefix", "", "getFilterEmptyText", "createFilterCodeFragment", "Lcom/intellij/psi/PsiCodeFragment;", "project", "Lcom/intellij/openapi/project/Project;", "filterText", "queryText", "isSortingApplicable", "getSortingPrefix", "getSortingEmptyText", "createSortingCodeFragment", "sortingText", "createCodeFragment", "text", "elementType", "Lcom/intellij/psi/tree/IElementType;", "intellij.database.dialects.redis"})
final class RedisHookUpHelper
implements HookUpHelper {
    @NotNull
    private final Dbms dbms;

    public RedisHookUpHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.dbms = dbms;
    }

    @Override
    public boolean needToObtainTableKind(@NotNull DbElement table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        return Intrinsics.areEqual((Object)table.getKind(), (Object)ObjectKind.COLLECTION);
    }

    @NotNull
    public SqlLanguageDialect getFilterSortLanguage(@NotNull DbDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect(dataSource);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"getSqlDialect(...)");
        return sqlLanguageDialect;
    }

    @Override
    public boolean isFilterApplicable(@Nullable DasObject table) {
        return RedisDelegateFactory.INSTANCE.getHookUpHelperDelegate(table).isFilterApplicable();
    }

    @Override
    public boolean isFilterApplicable(@Nullable ObjectKind kind) {
        return RedisDelegateFactory.INSTANCE.getHookUpHelperDelegate(kind).isFilterApplicable();
    }

    @Override
    @NotNull
    public String getFilterPrefix(@Nullable DasObject table) {
        return RedisDelegateFactory.INSTANCE.getHookUpHelperDelegate(table).getFilterPrefix(table);
    }

    @Override
    @NotNull
    public String getFilterEmptyText(@Nullable DasObject table) {
        return RedisDelegateFactory.INSTANCE.getHookUpHelperDelegate(table).getFilterEmptyText(table);
    }

    @Override
    @Nullable
    public PsiCodeFragment createFilterCodeFragment(@NotNull Project project, @NotNull String filterText, @Nullable String queryText, @NotNull DbDataSource dataSource, @Nullable DasObject table) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filterText, (String)"filterText");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return this.createCodeFragment(project, filterText, queryText, dataSource, table, RedisDelegateFactory.INSTANCE.getHookUpHelperDelegate(table).getFilterElementType());
    }

    @Override
    public boolean isSortingApplicable(@Nullable DasObject table) {
        return RedisDelegateFactory.INSTANCE.getHookUpHelperDelegate(table).isSortingApplicable();
    }

    @Override
    public boolean isSortingApplicable(@Nullable ObjectKind kind) {
        return RedisDelegateFactory.INSTANCE.getHookUpHelperDelegate(kind).isSortingApplicable();
    }

    @Override
    @NotNull
    public String getSortingPrefix(@Nullable DasObject table) {
        return RedisDelegateFactory.INSTANCE.getHookUpHelperDelegate(table).getSortingPrefix(table);
    }

    @Override
    @NotNull
    public String getSortingEmptyText(@Nullable DasObject table) {
        return RedisDelegateFactory.INSTANCE.getHookUpHelperDelegate(table).getSortingEmptyText(table);
    }

    @Override
    @Nullable
    public PsiCodeFragment createSortingCodeFragment(@NotNull Project project, @NotNull String sortingText, @Nullable String queryText, @NotNull DbDataSource dataSource, @Nullable DasObject table) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sortingText, (String)"sortingText");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return this.createCodeFragment(project, sortingText, queryText, dataSource, table, RedisDelegateFactory.INSTANCE.getHookUpHelperDelegate(table).getSortingElementType());
    }

    private final PsiCodeFragment createCodeFragment(Project project, String text2, String queryText, DbDataSource dataSource, DasObject table, IElementType elementType) {
        if (queryText == null || elementType == null) {
            return null;
        }
        SqlCodeFragmentImpl codeFragment = new SqlCodeFragmentImpl(project, this.getFilterSortLanguage(dataSource), elementType, "dummy.sql", text2, true);
        codeFragment.putUserData(DatabaseDataKeysCore.DATA_SOURCE_KEY, dataSource);
        SearchPath searchPath = DbImplUtilCore.getSearchPath(dataSource, table);
        codeFragment.putUserData(DatabaseDataKeysCore.SEARCH_PATH_KEY, searchPath);
        return (PsiCodeFragment)codeFragment;
    }
}

