/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbConflictChange;
import com.intellij.database.dataSource.srcStorage.DbContentRevision;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTrackerBase;
import com.intellij.database.dataSource.srcStorage.DbSrcFileStatus;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.UrlFilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcChangeList
implements ChangeList {
    private final String myDataSourceId;
    private final Project myProject;
    private volatile Map<VirtualFile, Change> myChanges;
    private String myName;

    public DbSrcChangeList(@Nullable Project project, @NotNull String dataSourceId) {
        if (dataSourceId == null) {
            DbSrcChangeList.$$$reportNull$$$0(0);
        }
        this.myChanges = Collections.emptyMap();
        this.myProject = project;
        this.myDataSourceId = dataSourceId;
        this.updateName();
    }

    public Collection<Change> getChanges() {
        return this.myChanges == null ? Collections.emptyList() : this.myChanges.values();
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            DbSrcChangeList.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String getComment() {
        return null;
    }

    private void updateName() {
        LocalDataSource source = this.getDataSource();
        this.myName = source == null ? "invalid" : source.getName();
    }

    @Nullable
    public LocalDataSource getDataSource() {
        return DbSrcUtils.findDataSource(this.myProject, this.myDataSourceId);
    }

    public void updateChanges(@NotNull Iterable<VirtualFile> files2) {
        if (files2 == null) {
            DbSrcChangeList.$$$reportNull$$$0(2);
        }
        final DbSrcFileStatus fileStatus = DbSrcChangesTracker.getInstance(null).getFileStatus();
        Map<VirtualFile, Change> old2 = this.myChanges;
        final HashMap<VirtualFile, Change> newChanges = new HashMap<VirtualFile, Change>();
        for (Map.Entry<VirtualFile, Change> entry : old2.entrySet()) {
            if (fileStatus.getStatus(entry.getKey()).getStatus() == null) continue;
            newChanges.put(entry.getKey(), entry.getValue());
        }
        for (VirtualFile file : files2) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (file.isDirectory()) {
                        return true;
                    }
                    DbSrcFileStatus.StatusEntry status = fileStatus.getStatus(file);
                    if (status.getStatus() != null) {
                        UrlFilePath path = new UrlFilePath(file);
                        ContentRevision originalRevision = 1.getContentRevision(path, status.getOriginalFileUrl(), DbSrcChangesTrackerBase.REMOTE);
                        ContentRevision baseRevision = Objects.equals(status.getBaseFileUrl(), status.getOriginalFileUrl()) ? null : 1.getContentRevision(path, status.getBaseFileUrl(), DbSrcChangesTrackerBase.BEFORE);
                        DbContentRevision modifiedRevision = new DbContentRevision(file, path, DbSrcChangesTrackerBase.LOCAL);
                        Change change = baseRevision == null ? new Change(originalRevision, (ContentRevision)modifiedRevision, status.getStatus()) : new DbConflictChange(baseRevision, (ContentRevision)modifiedRevision, originalRevision, status.getStatus());
                        newChanges.put(file, change);
                    }
                    return true;
                }

                @Nullable
                private static ContentRevision getContentRevision(@NotNull UrlFilePath path, @Nullable String url, @NotNull VcsRevisionNumber revision) {
                    if (path == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (revision == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    VirtualFile file = url == null ? null : VirtualFileManager.getInstance().findFileByUrl(url);
                    return file == null ? null : new DbContentRevision(file, path, revision);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "path";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "revision";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangeList$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitFile";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getContentRevision";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        this.updateName();
        this.myChanges = Map.copyOf(newChanges);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/DbSrcChangeList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcChangeList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateChanges";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

