/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0005J\n\u0010\b\u001a\u00020\t*\u00020\u0005J\n\u0010\n\u001a\u00020\u0005*\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/packageChecker/util/GzipUtils;", "", "<init>", "()V", "GZIP_MAGIC_NUMBER", "", "isCompressedWithGzip", "", "decompressFromGzipOrGetString", "", "compressToGzip", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nGzipUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GzipUtils.kt\ncom/intellij/packageChecker/util/GzipUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,27:1\n1#2:28\n*E\n"})
public final class GzipUtils {
    @NotNull
    public static final GzipUtils INSTANCE = new GzipUtils();
    @NotNull
    private static final byte[] GZIP_MAGIC_NUMBER;

    private GzipUtils() {
    }

    public final boolean isCompressedWithGzip(@NotNull byte[] $this$isCompressedWithGzip) {
        Intrinsics.checkNotNullParameter((Object)$this$isCompressedWithGzip, (String)"<this>");
        return $this$isCompressedWithGzip.length >= 2 && $this$isCompressedWithGzip[0] == GZIP_MAGIC_NUMBER[0] && $this$isCompressedWithGzip[1] == GZIP_MAGIC_NUMBER[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String decompressFromGzipOrGetString(@NotNull byte[] $this$decompressFromGzipOrGetString) {
        Intrinsics.checkNotNullParameter((Object)$this$decompressFromGzipOrGetString, (String)"<this>");
        if (!this.isCompressedWithGzip($this$decompressFromGzipOrGetString)) {
            return new String($this$decompressFromGzipOrGetString, Charsets.UTF_8);
        }
        Object object = new InputStreamReader((InputStream)new GZIPInputStream(new ByteArrayInputStream($this$decompressFromGzipOrGetString)), Charsets.UTF_8);
        int n = 8192;
        Closeable closeable = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] compressToGzip(@NotNull byte[] $this$compressToGzip) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$compressToGzip, (String)"<this>");
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new GZIPOutputStream(baos);
            Throwable throwable2 = null;
            try {
                GZIPOutputStream gzos = (GZIPOutputStream)closeable2;
                boolean bl2 = false;
                gzos.write($this$compressToGzip);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
        return byArray;
    }

    static {
        byte[] byArray = new byte[]{31, -117};
        GZIP_MAGIC_NUMBER = byArray;
    }
}

