/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.javascript.utils;

import com.intellij.json.psi.JsonFile;
import com.intellij.packageChecker.RegistryKeys;
import com.intellij.packageChecker.javascript.model.SimplifiedNpmPackageLockModel;
import com.intellij.packageChecker.javascript.model.SimplifiedPackageInfoLockModel;
import com.intellij.packageChecker.model.Dependency;
import com.intellij.packageChecker.util.SerializationUtils;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.package.PackageType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u0005J8\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f2\b\b\u0002\u0010\u0014\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/packageChecker/javascript/utils/NpmPackageLockParser;", "", "<init>", "()V", "NPM_PACKAGE_LOCK_FILENAME", "", "DEPTH_LIMIT", "", "findAndReadLockFile", "packageJsonFile", "Lcom/intellij/psi/PsiFile;", "readPackages", "", "Lcom/intellij/packageChecker/javascript/utils/NpmPackageLockParser$PackageToLockModel;", "lockFileContent", "dependencyWithTransitives", "Lcom/intellij/packageChecker/model/Dependency;", "internalPackageSearchPath", "packageName", "packagesNodes", "currentDepth", "PackageToLockModel", "intellij.packageChecker.javascript"})
@SourceDebugExtension(value={"SMAP\nNpmPackageLockParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NpmPackageLockParser.kt\ncom/intellij/packageChecker/javascript/utils/NpmPackageLockParser\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n216#2,2:95\n1863#3,2:97\n*S KotlinDebug\n*F\n+ 1 NpmPackageLockParser.kt\ncom/intellij/packageChecker/javascript/utils/NpmPackageLockParser\n*L\n43#1:95,2\n79#1:97,2\n*E\n"})
public final class NpmPackageLockParser {
    @NotNull
    public static final NpmPackageLockParser INSTANCE = new NpmPackageLockParser();
    @NotNull
    public static final String NPM_PACKAGE_LOCK_FILENAME = "package-lock.json";
    private static final int DEPTH_LIMIT = RegistryKeys.INSTANCE.getDepthLimitOfTransitiveDependencies();

    private NpmPackageLockParser() {
    }

    @Nullable
    public final String findAndReadLockFile(@NotNull PsiFile packageJsonFile) {
        Intrinsics.checkNotNullParameter((Object)packageJsonFile, (String)"packageJsonFile");
        if (!(packageJsonFile instanceof JsonFile) || !Intrinsics.areEqual((Object)((JsonFile)packageJsonFile).getName(), (Object)"package.json")) {
            return null;
        }
        PsiDirectory psiDirectory = ((JsonFile)packageJsonFile).getContainingDirectory();
        if (psiDirectory == null) {
            return null;
        }
        PsiDirectory directory = psiDirectory;
        PsiFile psiFile = directory.findFile(NPM_PACKAGE_LOCK_FILENAME);
        JsonFile jsonFile = psiFile instanceof JsonFile ? (JsonFile)psiFile : null;
        if (jsonFile == null) {
            return null;
        }
        JsonFile npmLockFile = jsonFile;
        return npmLockFile.getText();
    }

    @Nullable
    public final Map<String, PackageToLockModel> readPackages(@NotNull String lockFileContent) {
        Object object;
        block5: {
            Intrinsics.checkNotNullParameter((Object)lockFileContent, (String)"lockFileContent");
            try {
                object = (SimplifiedNpmPackageLockModel)SerializationUtils.INSTANCE.getOm().readValue(lockFileContent, SimplifiedNpmPackageLockModel.class);
            }
            catch (Exception exception) {
                return MapsKt.emptyMap();
            }
            SimplifiedNpmPackageLockModel packageLock = object;
            Object $this$readPackages_u24lambda_u241 = object = MapsKt.createMapBuilder();
            boolean bl = false;
            Map<String, SimplifiedPackageInfoLockModel> map2 = packageLock.getPackages();
            if (map2 == null) break block5;
            Map<String, SimplifiedPackageInfoLockModel> $this$forEach$iv = map2;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, SimplifiedPackageInfoLockModel>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                String version;
                Map map3;
                Map.Entry<String, SimplifiedPackageInfoLockModel> element$iv;
                Map.Entry<String, SimplifiedPackageInfoLockModel> entry = element$iv = iterator.next();
                boolean bl2 = false;
                String coordinates = entry.getKey();
                SimplifiedPackageInfoLockModel infoLockModel = entry.getValue();
                if (infoLockModel == null) continue;
                String packageName = StringsKt.substringAfterLast$default((String)coordinates, (String)"/", null, (int)2, null);
                if (infoLockModel.getVersion() == null) continue;
                Map map4 = infoLockModel.getDependencies();
                if (map4 == null) {
                    map4 = MapsKt.emptyMap();
                }
                if ((map3 = infoLockModel.getOptionalDependencies()) == null) {
                    map3 = MapsKt.emptyMap();
                }
                Map childrenOfPackage = MapsKt.plus((Map)map4, map3);
                PackageToLockModel packageToLockModel = new PackageToLockModel(new Package(PackageType.npm, null, packageName, version, null, null, null, 114, null), childrenOfPackage);
                $this$readPackages_u24lambda_u241.put(coordinates, packageToLockModel);
            }
        }
        return MapsKt.build((Map)object);
    }

    @Nullable
    public final Dependency dependencyWithTransitives(@NotNull String internalPackageSearchPath, @NotNull String packageName, @NotNull Map<String, PackageToLockModel> packagesNodes, int currentDepth) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)internalPackageSearchPath, (String)"internalPackageSearchPath");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(packagesNodes, (String)"packagesNodes");
        if (currentDepth > DEPTH_LIMIT) {
            return null;
        }
        String topLevelSearchPath = "node_modules/" + packageName;
        Object packageScopePackagePath = StringsKt.isBlank((CharSequence)internalPackageSearchPath) ? topLevelSearchPath : internalPackageSearchPath;
        PackageToLockModel packageScopeDependency = packagesNodes.get(packageScopePackagePath);
        Object resolvedPackagePath = packageScopeDependency != null ? packageScopePackagePath : topLevelSearchPath;
        PackageToLockModel packageToLockModel = packagesNodes.get(resolvedPackagePath);
        if (packageToLockModel == null) {
            return null;
        }
        PackageToLockModel packageToLockModel2 = packageToLockModel;
        Package pkg = packageToLockModel2.component1();
        Map<String, String> childrenOfPackage = packageToLockModel2.component2();
        Set $this$dependencyWithTransitives_u24lambda_u244 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = childrenOfPackage.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Dependency it;
            String pkgName = (String)element$iv;
            boolean bl2 = false;
            String internalPackageName = (String)resolvedPackagePath + "/node_modules/" + pkgName;
            if (INSTANCE.dependencyWithTransitives(internalPackageName, pkgName, packagesNodes, currentDepth + 1) == null) continue;
            boolean bl3 = false;
            $this$dependencyWithTransitives_u24lambda_u244.add(it);
        }
        Set transitiveDependencies = SetsKt.build((Set)set);
        return new Dependency(pkg, transitiveDependencies, null, 4, null);
    }

    public static /* synthetic */ Dependency dependencyWithTransitives$default(NpmPackageLockParser npmPackageLockParser, String string, String string2, Map map2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = "";
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        return npmPackageLockParser.dependencyWithTransitives(string, string2, map2, n);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0017\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u00c6\u0003J+\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/packageChecker/javascript/utils/NpmPackageLockParser$PackageToLockModel;", "", "pkg", "Lorg/jetbrains/security/package/Package;", "childrenOfPackage", "", "", "<init>", "(Lorg/jetbrains/security/package/Package;Ljava/util/Map;)V", "getPkg", "()Lorg/jetbrains/security/package/Package;", "getChildrenOfPackage", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.packageChecker.javascript"})
    public static final class PackageToLockModel {
        @NotNull
        private final Package pkg;
        @NotNull
        private final Map<String, String> childrenOfPackage;

        public PackageToLockModel(@NotNull Package pkg, @NotNull Map<String, String> childrenOfPackage) {
            Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
            Intrinsics.checkNotNullParameter(childrenOfPackage, (String)"childrenOfPackage");
            this.pkg = pkg;
            this.childrenOfPackage = childrenOfPackage;
        }

        @NotNull
        public final Package getPkg() {
            return this.pkg;
        }

        @NotNull
        public final Map<String, String> getChildrenOfPackage() {
            return this.childrenOfPackage;
        }

        @NotNull
        public final Package component1() {
            return this.pkg;
        }

        @NotNull
        public final Map<String, String> component2() {
            return this.childrenOfPackage;
        }

        @NotNull
        public final PackageToLockModel copy(@NotNull Package pkg, @NotNull Map<String, String> childrenOfPackage) {
            Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
            Intrinsics.checkNotNullParameter(childrenOfPackage, (String)"childrenOfPackage");
            return new PackageToLockModel(pkg, childrenOfPackage);
        }

        public static /* synthetic */ PackageToLockModel copy$default(PackageToLockModel packageToLockModel, Package package_, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                package_ = packageToLockModel.pkg;
            }
            if ((n & 2) != 0) {
                map2 = packageToLockModel.childrenOfPackage;
            }
            return packageToLockModel.copy(package_, map2);
        }

        @NotNull
        public String toString() {
            return "PackageToLockModel(pkg=" + this.pkg + ", childrenOfPackage=" + this.childrenOfPackage + ")";
        }

        public int hashCode() {
            int result = this.pkg.hashCode();
            result = result * 31 + ((Object)this.childrenOfPackage).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PackageToLockModel)) {
                return false;
            }
            PackageToLockModel packageToLockModel = (PackageToLockModel)other;
            if (!Intrinsics.areEqual((Object)this.pkg, (Object)packageToLockModel.pkg)) {
                return false;
            }
            return Intrinsics.areEqual(this.childrenOfPackage, packageToLockModel.childrenOfPackage);
        }
    }
}

