/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractByteCollection;
import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.ByteContainer;
import com.carrotsearch.hppc.IntByteAssociativeContainer;
import com.carrotsearch.hppc.IntByteHashMap;
import com.carrotsearch.hppc.IntByteMap;
import com.carrotsearch.hppc.IntCollection;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.comparators.IntByteComparator;
import com.carrotsearch.hppc.comparators.IntComparator;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.cursors.IntByteCursor;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.predicates.BytePredicate;
import com.carrotsearch.hppc.predicates.IntBytePredicate;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.ByteProcedure;
import com.carrotsearch.hppc.procedures.IntByteProcedure;
import com.carrotsearch.hppc.procedures.IntProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationIntByteHashMap
implements IntByteMap {
    public final IntByteHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationIntByteHashMap(IntByteHashMap delegate2, IntComparator comparator) {
        this.delegate = delegate2;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationIntByteHashMap(IntByteHashMap delegate2, IntByteComparator comparator) {
        this.delegate = delegate2;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        int[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry2 = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry2++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry2 < size) {
            if (keys[keyIndex] != 0) {
                entryIndexes[entry2++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, IntComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            int[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final IntByteComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final int[] keys;
            final byte[] values;
            {
                this.keys = SortedIterationIntByteHashMap.this.delegate.keys;
                this.values = SortedIterationIntByteHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<IntByteCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(int key2) {
        return this.delegate.containsKey(key2);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(IntContainer container) {
        throw SortedIterationIntByteHashMap.readOnlyException();
    }

    @Override
    public int removeAll(IntPredicate predicate) {
        throw SortedIterationIntByteHashMap.readOnlyException();
    }

    @Override
    public int removeAll(IntBytePredicate predicate) {
        throw SortedIterationIntByteHashMap.readOnlyException();
    }

    @Override
    public <T extends IntByteProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        int[] keys = this.delegate.keys;
        byte[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends IntBytePredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        int[] keys = this.delegate.keys;
        byte[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public IntCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public ByteContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public byte get(int key2) {
        return this.delegate.get(key2);
    }

    @Override
    public byte getOrDefault(int key2, byte defaultValue) {
        return this.delegate.getOrDefault(key2, defaultValue);
    }

    @Override
    public byte put(int key2, byte value) {
        throw SortedIterationIntByteHashMap.readOnlyException();
    }

    @Override
    public int putAll(IntByteAssociativeContainer container) {
        throw SortedIterationIntByteHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends IntByteCursor> iterable) {
        throw SortedIterationIntByteHashMap.readOnlyException();
    }

    @Override
    public byte putOrAdd(int key2, byte putValue, byte incrementValue) {
        throw SortedIterationIntByteHashMap.readOnlyException();
    }

    @Override
    public byte addTo(int key2, byte additionValue) {
        throw SortedIterationIntByteHashMap.readOnlyException();
    }

    @Override
    public byte remove(int key2) {
        throw SortedIterationIntByteHashMap.readOnlyException();
    }

    @Override
    public int indexOf(int key2) {
        return this.delegate.indexOf(key2);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public byte indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public byte indexReplace(int index, byte newValue) {
        throw SortedIterationIntByteHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, int key2, byte value) {
        throw SortedIterationIntByteHashMap.readOnlyException();
    }

    @Override
    public byte indexRemove(int index) {
        throw SortedIterationIntByteHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationIntByteHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationIntByteHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<IntByteCursor> {
        private final IntByteCursor cursor = new IntByteCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected IntByteCursor fetch() {
            if (this.index < SortedIterationIntByteHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntByteHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationIntByteHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationIntByteHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (IntByteCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final SortedIterationIntByteHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationIntByteHashMap.this;
        }

        @Override
        public boolean contains(int e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            this.owner.forEach((key2, value) -> predicate.apply(key2));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationIntByteHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationIntByteHashMap.readOnlyException();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            throw SortedIterationIntByteHashMap.readOnlyException();
        }

        @Override
        public int removeAll(int e) {
            throw SortedIterationIntByteHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractByteCollection {
        private final SortedIterationIntByteHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationIntByteHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(byte value) {
            for (IntByteCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<ByteCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(byte e) {
            throw SortedIterationIntByteHashMap.readOnlyException();
        }

        @Override
        public int removeAll(BytePredicate predicate) {
            throw SortedIterationIntByteHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationIntByteHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationIntByteHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor = new ByteCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected ByteCursor fetch() {
            if (this.index < SortedIterationIntByteHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntByteHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationIntByteHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ByteCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected IntCursor fetch() {
            if (this.index < SortedIterationIntByteHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntByteHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationIntByteHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }
}

