/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptRedundantGenericTypeInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            TypeScriptRedundantGenericTypeInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            TypeScriptRedundantGenericTypeInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitReferenceListMember(@NotNull JSReferenceListMember member) {
                JSExpression referenceExpression;
                if (member == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!((referenceExpression = member.getExpression()) instanceof JSReferenceExpression)) {
                    return;
                }
                PsiElement resolve2 = ((JSReferenceExpression)referenceExpression).resolve();
                if (!(resolve2 instanceof TypeScriptTypeParameterListOwner)) {
                    return;
                }
                JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)member, () -> this.checkTypesForRedundancy(member, (TypeScriptTypeParameterListOwner)resolve2));
            }

            @Override
            public void visitTypeScriptSingleType(@NotNull TypeScriptSingleType singleType) {
                JSReferenceExpression referenceExpression;
                if (singleType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((referenceExpression = singleType.getReferenceExpression()) == null) {
                    return;
                }
                PsiElement resolve2 = referenceExpression.resolve();
                if (!(resolve2 instanceof TypeScriptTypeParameterListOwner)) {
                    return;
                }
                JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)singleType, () -> this.checkTypesForRedundancy(singleType, (TypeScriptTypeParameterListOwner)resolve2));
            }

            private void checkTypesForRedundancy(@NotNull JSElement jsElement, @NotNull TypeScriptTypeParameterListOwner referenceExpression) {
                if (jsElement == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (referenceExpression == null) {
                    1.$$$reportNull$$$0(3);
                }
                TypeScriptTypeParameter[] expectedList = referenceExpression.getTypeParameters();
                TypeScriptTypeArgumentList arguments = (TypeScriptTypeArgumentList)PsiTreeUtil.getStubChildOfType((PsiElement)jsElement, TypeScriptTypeArgumentList.class);
                if (arguments == null) {
                    return;
                }
                Object[] declarationParameters = arguments.getTypeArguments();
                int declarationListLength = declarationParameters.length;
                int expectedListLength = expectedList.length;
                int expectedDefaultTypes = (int)Arrays.stream(expectedList).filter(element -> element.getDefault() != null).count();
                if (expectedListLength < declarationListLength) {
                    return;
                }
                ArrayList<JSTypeDeclaration> removedParams = new ArrayList<JSTypeDeclaration>();
                ArrayList<JSTypeDeclaration> remainingParams = new ArrayList<JSTypeDeclaration>();
                boolean shouldStop = false;
                for (int i = declarationListLength - 1; i >= 0; --i) {
                    TypeScriptType expectedDefaultType = expectedList[i].getDefault();
                    JSTypeDeclaration declarationParameter = declarationParameters[i];
                    if (expectedDefaultType != null && expectedDefaultType.getJSType().isEquivalentTo(declarationParameter.getJSType(), null) && !shouldStop) {
                        removedParams.add(declarationParameter);
                        continue;
                    }
                    shouldStop = true;
                    remainingParams.add(0, declarationParameters[i]);
                }
                if (removedParams.isEmpty()) {
                    return;
                }
                PsiElement firstItem = (PsiElement)ContainerUtil.getLastItem(removedParams);
                PsiElement lastItem = (PsiElement)ContainerUtil.getFirstItem(removedParams);
                if (firstItem == null || lastItem == null) {
                    return;
                }
                boolean shouldRemoveArguments = expectedListLength == expectedDefaultTypes && expectedDefaultTypes == removedParams.size();
                LocalQuickFix fix = this.getFix(arguments, shouldRemoveArguments, firstItem, lastItem);
                List expectedListElements = ContainerUtil.map((Object[])declarationParameters, element -> element.getText());
                String expectedListText = StringUtil.join((Collection)expectedListElements, (String)", ");
                List fixListElements = ContainerUtil.map(remainingParams, element -> element.getText());
                String fixListText = StringUtil.join((Collection)fixListElements, (String)", ");
                String fixText = shouldRemoveArguments ? JavaScriptBundle.message("javascript.validation.message.redundant.type.remove", expectedListText) : JavaScriptBundle.message("javascript.validation.message.redundant.type", expectedListText, fixListText);
                TextRange range = new TextRange(shouldRemoveArguments ? 0 : firstItem.getStartOffsetInParent(), arguments.getTextLength() - (shouldRemoveArguments ? 0 : 1));
                holder.registerProblem((PsiElement)arguments, fixText, ProblemHighlightType.LIKE_UNUSED_SYMBOL, range, new LocalQuickFix[]{fix});
            }

            @Contract(value="!null, true, _, _ -> !null")
            @Nullable
            private LocalQuickFix getFix(@Nullable TypeScriptTypeArgumentList arguments, boolean shouldRemoveArguments, @NotNull PsiElement firstItem, @NotNull PsiElement lastItem) {
                if (firstItem == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (lastItem == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (shouldRemoveArguments && arguments != null) {
                    return JSFixFactory.getInstance().removeGenericArgumentFix(arguments);
                }
                PsiElement comma = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)firstItem);
                if (comma == null) {
                    return null;
                }
                String key = "javascript.validation.message.duplicate.declaration.fix.remove";
                return JSFixFactory.getInstance().removeASTNodeFix(key, false, comma, lastItem);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "member";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "singleType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "jsElement";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceExpression";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "firstItem";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lastItem";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/typescript/inspections/TypeScriptRedundantGenericTypeInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceListMember";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeScriptSingleType";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkTypesForRedundancy";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getFix";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/typescript/inspections/TypeScriptRedundantGenericTypeInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

