/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.recordImpl.CallSignatureImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureCommonImpl;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSCompositeFunctionPropertySignatureImpl
implements PropertySignatureCommonImpl {
    private final boolean myIsOptional;
    private final boolean myIsReadonly;
    @NotNull
    private final String myName;
    private final boolean privateName;
    private final int privateNameDepth;
    @NotNull
    private final List<JSRecordType.PropertySignature> myFunctionSignatures;
    @NotNull
    private final JSTypeSource myTypeSource;
    @NotNull
    private final NotNullLazyValue<JSType> myType;
    private final NotNullLazyValue<JSRecordType.MemberSource> myMemberSourceLazy;

    public JSCompositeFunctionPropertySignatureImpl(@NotNull String name, boolean privateName, int privateNameDepth, @NotNull List<JSRecordType.PropertySignature> functionSignatures, boolean isOptional, boolean isReadonly, @NotNull JSTypeSource typeSource) {
        if (name == null) {
            JSCompositeFunctionPropertySignatureImpl.$$$reportNull$$$0(0);
        }
        if (functionSignatures == null) {
            JSCompositeFunctionPropertySignatureImpl.$$$reportNull$$$0(1);
        }
        if (typeSource == null) {
            JSCompositeFunctionPropertySignatureImpl.$$$reportNull$$$0(2);
        }
        this.myType = NotNullLazyValue.createValue(() -> {
            List<JSRecordType.PropertySignature> members = this.getMembers();
            ArrayList<CallSignatureImpl> toMerge = new ArrayList<CallSignatureImpl>(members.size());
            for (JSRecordType.PropertySignature signature : members) {
                JSType type2 = signature.getJSType();
                if (!(type2 instanceof JSFunctionTypeImpl)) continue;
                toMerge.add(new CallSignatureImpl(false, (JSFunctionTypeImpl)type2));
            }
            return new JSRecordTypeImpl(this.getTypeSource(), toMerge);
        });
        this.myName = name;
        this.privateName = privateName;
        this.privateNameDepth = privateNameDepth;
        this.myIsOptional = isOptional;
        this.myIsReadonly = isReadonly;
        this.myFunctionSignatures = functionSignatures;
        this.myTypeSource = typeSource;
        this.myMemberSourceLazy = NotNullLazyValue.createValue(this::computeMemberSource);
    }

    @Override
    public boolean isEquivalentTo(@Nullable JSRecordType.TypeMember other, @Nullable ProcessingContext context2, boolean allowResolve) {
        if (this.isFastEquivalentTo(other)) {
            return true;
        }
        return PropertySignatureCommonImpl.arePropertySignaturesEqual(this, other, context2, allowResolve);
    }

    boolean isFastEquivalentTo(@Nullable JSRecordType.TypeMember other) {
        if (!(other instanceof JSCompositeFunctionPropertySignatureImpl)) {
            return false;
        }
        JSCompositeFunctionPropertySignatureImpl otherFPSignature = (JSCompositeFunctionPropertySignatureImpl)other;
        List<JSRecordType.PropertySignature> members = this.getMembers();
        List<JSRecordType.PropertySignature> otherMembers = otherFPSignature.getMembers();
        return ContainerUtil.equalsIdentity(members, otherMembers);
    }

    @Override
    @NotNull
    public JSRecordType.MemberSource getMemberSource() {
        JSRecordType.MemberSource memberSource = (JSRecordType.MemberSource)this.myMemberSourceLazy.getValue();
        if (memberSource == null) {
            JSCompositeFunctionPropertySignatureImpl.$$$reportNull$$$0(3);
        }
        return memberSource;
    }

    @NotNull
    private JSRecordType.MemberSource computeMemberSource() {
        ArrayList<PsiElement> allSourceElements = new ArrayList<PsiElement>();
        for (JSRecordType.PropertySignature signature : this.myFunctionSignatures) {
            allSourceElements.addAll(signature.getMemberSource().getAllSourceElements());
        }
        JSRecordType.MemberSource memberSource = JSRecordMemberSourceFactory.createSource(allSourceElements, JSRecordType.MemberSourceKind.CompositeSignature, true);
        if (memberSource == null) {
            JSCompositeFunctionPropertySignatureImpl.$$$reportNull$$$0(4);
        }
        return memberSource;
    }

    @Override
    @NotNull
    public JSRecordType.PropertySignature copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform) {
        if (childTransform == null) {
            JSCompositeFunctionPropertySignatureImpl.$$$reportNull$$$0(5);
        }
        List<JSRecordType.PropertySignature> members = this.getMembers();
        ArrayList<JSRecordType.PropertySignature> resultMembers = new ArrayList<JSRecordType.PropertySignature>(members.size());
        for (JSRecordType.PropertySignature propertySignature : members) {
            resultMembers.add((JSRecordType.PropertySignature)propertySignature.copyTypeHierarchy((Function)childTransform));
        }
        if (ContainerUtil.equalsIdentity(members, resultMembers)) {
            JSCompositeFunctionPropertySignatureImpl jSCompositeFunctionPropertySignatureImpl = this;
            if (jSCompositeFunctionPropertySignatureImpl == null) {
                JSCompositeFunctionPropertySignatureImpl.$$$reportNull$$$0(6);
            }
            return jSCompositeFunctionPropertySignatureImpl;
        }
        return new JSCompositeFunctionPropertySignatureImpl(this.getMemberName(), this.isPrivateName(), this.getPrivateNameDepth(), resultMembers, this.isOptional(), this.isConst(), this.getTypeSource());
    }

    @Override
    @NotNull
    public String getMemberName() {
        String string = this.myName;
        if (string == null) {
            JSCompositeFunctionPropertySignatureImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public boolean isPrivateName() {
        return this.privateName;
    }

    @Override
    public int getPrivateNameDepth() {
        return this.privateNameDepth;
    }

    @Override
    public boolean isOptional() {
        return this.myIsOptional;
    }

    @Override
    public boolean isConst() {
        return this.myIsReadonly;
    }

    public List<JSRecordType.PropertySignature> getMembers() {
        return this.myFunctionSignatures;
    }

    public JSCompositeFunctionPropertySignatureImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSCompositeFunctionPropertySignatureImpl.$$$reportNull$$$0(8);
        }
        return new JSCompositeFunctionPropertySignatureImpl(this.getMemberName(), this.isPrivateName(), this.getPrivateNameDepth(), this.getMembers(), this.isOptional(), this.isConst(), source);
    }

    @NotNull
    public JSTypeSource getTypeSource() {
        JSTypeSource jSTypeSource = this.myTypeSource;
        if (jSTypeSource == null) {
            JSCompositeFunctionPropertySignatureImpl.$$$reportNull$$$0(9);
        }
        return jSTypeSource;
    }

    @Override
    public JSType getJSType() {
        return (JSType)this.myType.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionSignatures";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSCompositeFunctionPropertySignatureImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSCompositeFunctionPropertySignatureImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberSource";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeMemberSource";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7, 9 -> new IllegalStateException(string);
        };
    }
}

