/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import com.intellij.lang.javascript.linter.eslint.ESLintJsonProblemsParser;
import com.intellij.lang.javascript.linter.eslint.EslintError;
import com.intellij.lang.javascript.linter.eslint.EslintRequestData;
import com.intellij.lang.javascript.linter.eslint.service.EslintLanguageServiceClient;
import com.intellij.lang.javascript.linter.eslint.service.protocol.ESLintLanguageServiceInitialState;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u0000 .*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u00032\u00020\u0004:\u0005*+,-.B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016J4\u0010\u000f\u001a\u001c\u0012\u0016\u0012\u0014\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0018\u00010\u0012\u0018\u00010\u0011\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J,\u0010\u0018\u001a\u0014\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0018\u00010\u0011\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u001a\u0010\u0019\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u001b0\u001aH$J\u001d\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010!J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0014J\u0012\u0010(\u001a\u0004\u0018\u00010\u00172\u0006\u0010)\u001a\u00020\u0017H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006/"}, d2={"Lcom/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService;", "TStoredState", "Lcom/intellij/lang/javascript/linter/JSNpmLinterState;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceBase;", "Lcom/intellij/lang/javascript/linter/eslint/service/EslintLanguageServiceClient;", "project", "Lcom/intellij/openapi/project/Project;", "myNodePackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "myWorkingDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/javascript/nodejs/util/NodePackage;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getNodePackage", "getWorkingDirectory", "highlight", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/lang/javascript/linter/eslint/service/EslintLanguageServiceClient$Response;", "", "Lcom/intellij/lang/javascript/linter/eslint/EslintError;", "requestData", "Lcom/intellij/lang/javascript/linter/eslint/EslintRequestData;", "extraOptions", "", "fixFile", "getConfigurationClass", "Ljava/lang/Class;", "Lcom/intellij/lang/javascript/linter/JSLinterConfiguration;", "fillInitialProtocolState", "", "protocolState", "Lcom/intellij/lang/javascript/linter/eslint/service/protocol/ESLintLanguageServiceInitialState;", "storedState", "(Lcom/intellij/lang/javascript/linter/eslint/service/protocol/ESLintLanguageServiceInitialState;Lcom/intellij/lang/javascript/linter/JSNpmLinterState;)V", "createLanguageServiceQueueBlocking", "Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue;", "extendedState", "Lcom/intellij/lang/javascript/linter/ExtendedLinterState;", "getExtendedState", "()Lcom/intellij/lang/javascript/linter/ExtendedLinterState;", "findUploadRoot", "path", "BaseCommand", "GetErrorsCommand", "FixErrorsCommand", "Protocol", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nESLintBasedLanguageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ESLintBasedLanguageService.kt\ncom/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,325:1\n1#2:326\n*E\n"})
public abstract class ESLintBasedLanguageService<TStoredState extends JSNpmLinterState<TStoredState>>
extends JSLanguageServiceBase
implements EslintLanguageServiceClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NodePackage myNodePackage;
    @NotNull
    private final VirtualFile myWorkingDirectory;

    public ESLintBasedLanguageService(@NotNull Project project, @NotNull NodePackage myNodePackage, @NotNull VirtualFile myWorkingDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)myNodePackage, (String)"myNodePackage");
        Intrinsics.checkNotNullParameter((Object)myWorkingDirectory, (String)"myWorkingDirectory");
        super(project);
        this.myNodePackage = myNodePackage;
        this.myWorkingDirectory = myWorkingDirectory;
    }

    @Override
    @NotNull
    public NodePackage getNodePackage() {
        return this.myNodePackage;
    }

    @Override
    @NotNull
    public VirtualFile getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    @Override
    @Nullable
    public CompletableFuture<EslintLanguageServiceClient.Response<List<EslintError>>> highlight(@NotNull EslintRequestData requestData, @Nullable String extraOptions) {
        Intrinsics.checkNotNullParameter((Object)requestData, (String)"requestData");
        String string = requestData.getFileToLintContent();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileToLintContent(...)");
        if (StringsKt.isBlank((CharSequence)string)) {
            return null;
        }
        VirtualFile virtualFile = requestData.getFileToLint();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFileToLint(...)");
        VirtualFile virtualFile2 = virtualFile;
        String configPath = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(requestData.getSpecifiedConfigFile());
        String path2 = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(virtualFile2);
        String eslintIgnoreFilePath = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(requestData.getEslintIgnoreFile());
        if (path2 == null) {
            return null;
        }
        JSLanguageServiceQueue process2 = this.getProcess();
        if (process2 == null) {
            String string2 = JSLanguageServiceUtil.getLanguageServiceCreationError(this);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLanguageServiceCreationError(...)");
            String error = string2;
            return CompletableFuture.completedFuture(EslintLanguageServiceClient.Response.error(error, false));
        }
        GetErrorsCommand command = new GetErrorsCommand(path2, configPath, requestData.getFileToLintContent(), extraOptions, eslintIgnoreFilePath, requestData.getFileKind().getStringValue(), requestData.isFlatConfigMode());
        return FutureKt.asCompletableFuture((Deferred)BuildersKt.async$default((CoroutineScope)this.getCs(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super EslintLanguageServiceClient.Response<List<EslintError>>>, Object>(process2, command, null){
            int label;
            final /* synthetic */ JSLanguageServiceQueue $process;
            final /* synthetic */ GetErrorsCommand $command;
            {
                this.$process = $process;
                this.$command = $command;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = JSLanguageServiceQueue.execute$default(this.$process, this.$command, null, (Continuation)this, 2, null);
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((v1 = (JSLanguageServiceQueue.CommandResult)v0) == null || (v1 = v1.getAnswer()) == null) {
                            return null;
                        }
                        answer = v1;
                        languageServiceError = JsonUtil.getChildAsString((JsonObject)answer.getElement(), (String)"error");
                        if (languageServiceError != null) {
                            isNoConfigFile = JsonUtil.getChildAsBoolean((JsonObject)answer.getElement(), (String)"isNoConfigFile", (boolean)false);
                            return EslintLanguageServiceClient.Response.error(languageServiceError, isNoConfigFile != false);
                        }
                        parser = ESLintJsonProblemsParser.parse(answer.getElement());
                        return new EslintLanguageServiceClient.Response<List<EslintError>>(parser.getFileLevelError(), parser.getErrors(), false);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super EslintLanguageServiceClient.Response<List<EslintError>>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null));
    }

    @Override
    @Nullable
    public CompletableFuture<EslintLanguageServiceClient.Response<String>> fixFile(@NotNull EslintRequestData requestData, @Nullable String extraOptions) {
        Intrinsics.checkNotNullParameter((Object)requestData, (String)"requestData");
        VirtualFile virtualFile = requestData.getFileToLint();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFileToLint(...)");
        VirtualFile virtualFile2 = virtualFile;
        String configPath = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(requestData.getSpecifiedConfigFile());
        String path2 = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(virtualFile2);
        String ignoreFilePath = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(requestData.getEslintIgnoreFile());
        if (path2 == null) {
            return null;
        }
        JSLanguageServiceQueue process2 = this.getProcess();
        if (process2 == null) {
            return CompletableFuture.completedFuture(EslintLanguageServiceClient.Response.error(JSLanguageServiceUtil.getLanguageServiceCreationError(this), false));
        }
        FixErrorsCommand command = new FixErrorsCommand(path2, configPath, requestData.getFileToLintContent(), extraOptions, ignoreFilePath, requestData.getFileKind().getStringValue(), requestData.isFlatConfigMode());
        return FutureKt.asCompletableFuture((Deferred)BuildersKt.async$default((CoroutineScope)this.getCs(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super EslintLanguageServiceClient.Response<String>>, Object>(process2, command, null){
            int label;
            final /* synthetic */ JSLanguageServiceQueue $process;
            final /* synthetic */ FixErrorsCommand $command;
            {
                this.$process = $process;
                this.$command = $command;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = JSLanguageServiceQueue.execute$default(this.$process, this.$command, null, (Continuation)this, 2, null);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((v1 = (JSLanguageServiceQueue.CommandResult)v0) == null || (v1 = v1.getAnswer()) == null) {
                            return null;
                        }
                        answer = v1;
                        return com.intellij.lang.javascript.linter.eslint.service.ESLintBasedLanguageService$Companion.access$processFixFileResponse(ESLintBasedLanguageService.Companion, (JSLanguageServiceAnswer)answer);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super EslintLanguageServiceClient.Response<String>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null));
    }

    @NotNull
    protected abstract Class<? extends JSLinterConfiguration<TStoredState>> getConfigurationClass();

    protected void fillInitialProtocolState(@NotNull ESLintLanguageServiceInitialState protocolState, @NotNull TStoredState storedState) {
        SemVer version2;
        Intrinsics.checkNotNullParameter((Object)protocolState, (String)"protocolState");
        Intrinsics.checkNotNullParameter(storedState, (String)"storedState");
        String packagePath = null;
        if (this.myNodePackage instanceof YarnPnpNodePackage) {
            packagePath = ((YarnPnpNodePackage)this.myNodePackage).getName();
            String packageJsonPath = ((YarnPnpNodePackage)this.myNodePackage).getPackageJsonPath(this.myProject);
            if (packageJsonPath == null) {
                boolean $i$a$-checkNotNull-ESLintBasedLanguageService$fillInitialProtocolState$22 = false;
                String $i$a$-checkNotNull-ESLintBasedLanguageService$fillInitialProtocolState$22 = "Cannot find package.json path for " + this.myNodePackage;
                throw new IllegalStateException($i$a$-checkNotNull-ESLintBasedLanguageService$fillInitialProtocolState$22.toString());
            }
            String string = FileUtil.toSystemDependentName((String)packageJsonPath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
            protocolState.packageJsonPath = LocalFilePath.Companion.createNotNull(string);
        } else {
            packagePath = this.myNodePackage.getSystemDependentPath();
        }
        LocalFilePath localFilePackagePath = LocalFilePath.Companion.createNotNull(packagePath);
        if (Intrinsics.areEqual((Object)this.myNodePackage.getName(), (Object)"standard")) {
            protocolState.standardPackagePath = localFilePackagePath;
        } else {
            protocolState.eslintPackagePath = localFilePackagePath;
        }
        SemVer semVer = version2 = this.myNodePackage.getVersion(this.myProject);
        protocolState.linterPackageVersion = semVer != null ? semVer.getRawVersion() : "";
    }

    @Override
    @Nullable
    protected JSLanguageServiceQueue createLanguageServiceQueueBlocking() {
        JSLanguageServiceQueue.ProcessConnector processConnector = null;
        if (NodeTargetRun.Companion.shouldEnableRemoteDevelopmentUsingTargetsApi()) {
            processConnector = new JSLanguageServiceQueue.ProcessConnector(){

                public void connectToProcessHandler(ProcessHandler handler) {
                    Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
                }

                public void disconnectFromProcessHandler(boolean closeAssociatedConsoleView) {
                }
            };
        }
        return new JSLanguageServiceQueueImpl(this.myProject, new Protocol(StringUtil.toLowerCase((String)this.getDebugName()), this.myProject, ESLintBasedLanguageService::createLanguageServiceQueueBlocking$lambda$1), processConnector, this.myDefaultReporter, new JSLanguageServiceDefaultCacheData());
    }

    private final ExtendedLinterState<TStoredState> getExtendedState() {
        ExtendedLinterState<TStoredState> extendedLinterState = JSLinterConfiguration.getInstance(this.myProject, this.getConfigurationClass()).getExtendedState();
        Intrinsics.checkNotNullExpressionValue(extendedLinterState, (String)"getExtendedState(...)");
        return extendedLinterState;
    }

    private final String findUploadRoot(String path2) {
        return (String)ReadAction.compute(() -> ESLintBasedLanguageService.findUploadRoot$lambda$2(path2, this));
    }

    private static final void createLanguageServiceQueueBlocking$lambda$1(Object it) {
    }

    private static final String findUploadRoot$lambda$2(String $path, ESLintBasedLanguageService this$0) {
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath($path);
        if (file == null) {
            JSLanguageServiceQueue.Holder.LOGGER.info("Cannot find virtual file by " + $path);
            return null;
        }
        if (!file.isDirectory() && (file = file.getParent()) == null) {
            JSLanguageServiceQueue.Holder.LOGGER.error("file.getParent() is null for " + $path);
            return null;
        }
        VirtualFile root = ProjectFileIndex.getInstance((Project)this$0.myProject).getContentRootForFile(file, false);
        if (root == null) {
            JSLanguageServiceQueue.Holder.LOGGER.info("Cannot find content root for " + file);
            return file.getPath();
        }
        return root.getPath();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\n\b\"\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003BK\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010$\u001a\u00020\u0003H\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0012R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001d\"\u0004\b!\u0010\u001fR\u001c\u0010\t\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001d\"\u0004\b#\u0010\u001f\u00a8\u0006%"}, d2={"Lcom/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService$BaseCommand;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceCommand;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceSimpleCommand;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceObject;", "fileName", "", "configPath", "content", "extraOptions", "ignoreFilePath", "fileKind", "flatConfig", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "getContent", "()Ljava/lang/String;", "setContent", "(Ljava/lang/String;)V", "getExtraOptions", "setExtraOptions", "getFileKind", "setFileKind", "getFlatConfig", "()Z", "setFlatConfig", "(Z)V", "Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "getFileName", "()Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "setFileName", "(Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;)V", "getConfigPath", "setConfigPath", "getIgnoreFilePath", "setIgnoreFilePath", "toSerializableObject", "intellij.javascript.impl"})
    private static abstract class BaseCommand
    implements JSLanguageServiceCommand,
    JSLanguageServiceSimpleCommand,
    JSLanguageServiceObject {
        @Nullable
        private String content;
        @Nullable
        private String extraOptions;
        @Nullable
        private String fileKind;
        private boolean flatConfig;
        @Nullable
        private LocalFilePath fileName;
        @Nullable
        private LocalFilePath configPath;
        @Nullable
        private LocalFilePath ignoreFilePath;

        public BaseCommand(@Nullable String fileName, @Nullable String configPath, @Nullable String content, @Nullable String extraOptions, @Nullable String ignoreFilePath, @Nullable String fileKind, boolean flatConfig) {
            this.content = content;
            this.extraOptions = extraOptions;
            this.fileKind = fileKind;
            this.flatConfig = flatConfig;
            this.fileName = LocalFilePath.Companion.create(fileName);
            this.configPath = LocalFilePath.Companion.create(configPath);
            this.ignoreFilePath = LocalFilePath.Companion.create(ignoreFilePath);
        }

        @Nullable
        public final String getContent() {
            return this.content;
        }

        public final void setContent(@Nullable String string) {
            this.content = string;
        }

        @Nullable
        public final String getExtraOptions() {
            return this.extraOptions;
        }

        public final void setExtraOptions(@Nullable String string) {
            this.extraOptions = string;
        }

        @Nullable
        public final String getFileKind() {
            return this.fileKind;
        }

        public final void setFileKind(@Nullable String string) {
            this.fileKind = string;
        }

        public final boolean getFlatConfig() {
            return this.flatConfig;
        }

        public final void setFlatConfig(boolean bl) {
            this.flatConfig = bl;
        }

        @Nullable
        public final LocalFilePath getFileName() {
            return this.fileName;
        }

        public final void setFileName(@Nullable LocalFilePath localFilePath) {
            this.fileName = localFilePath;
        }

        @Nullable
        public final LocalFilePath getConfigPath() {
            return this.configPath;
        }

        public final void setConfigPath(@Nullable LocalFilePath localFilePath) {
            this.configPath = localFilePath;
        }

        @Nullable
        public final LocalFilePath getIgnoreFilePath() {
            return this.ignoreFilePath;
        }

        public final void setIgnoreFilePath(@Nullable LocalFilePath localFilePath) {
            this.ignoreFilePath = localFilePath;
        }

        @Override
        @NotNull
        public JSLanguageServiceObject toSerializableObject() {
            return this;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService$Companion;", "", "<init>", "()V", "processFixFileResponse", "Lcom/intellij/lang/javascript/linter/eslint/service/EslintLanguageServiceClient$Response;", "", "answer", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceAnswer;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final EslintLanguageServiceClient.Response<String> processFixFileResponse(JSLanguageServiceAnswer answer) {
            JsonObject element;
            JsonObject responseObject = answer.getElement();
            String languageServiceError = JsonUtil.getChildAsString((JsonObject)responseObject, (String)"error");
            if (languageServiceError != null) {
                EslintLanguageServiceClient.Response<String> response = EslintLanguageServiceClient.Response.error(languageServiceError, false);
                Intrinsics.checkNotNullExpressionValue(response, (String)"error(...)");
                return response;
            }
            JsonObject body = JsonUtil.getChildAsObject((JsonObject)responseObject, (String)"body");
            JsonArray response = JsonUtil.getChildAsArray((JsonObject)body, (String)"results");
            if (response == null || response.isEmpty()) {
                EslintLanguageServiceClient.Response<Object> response2 = EslintLanguageServiceClient.Response.ok(null);
                Intrinsics.checkNotNullExpressionValue(response2, (String)"ok(...)");
                return response2;
            }
            JsonObject jsonObject = element = response.get(0).isJsonObject() ? response.get(0).getAsJsonObject() : null;
            if (element == null) {
                Object[] objectArray = new Object[]{responseObject.toString()};
                EslintLanguageServiceClient.Response<String> response3 = EslintLanguageServiceClient.Response.error(JavaScriptBundle.message("eslint.inspections.error.unexpected.language.service.response", objectArray), false);
                Intrinsics.checkNotNullExpressionValue(response3, (String)"error(...)");
                return response3;
            }
            EslintLanguageServiceClient.Response<String> response4 = EslintLanguageServiceClient.Response.ok(JsonUtil.getChildAsString((JsonObject)element, (String)"output"));
            Intrinsics.checkNotNullExpressionValue(response4, (String)"ok(...)");
            return response4;
        }

        public static final /* synthetic */ EslintLanguageServiceClient.Response access$processFixFileResponse(Companion $this, JSLanguageServiceAnswer answer) {
            return $this.processFixFileResponse(answer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001BK\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService$FixErrorsCommand;", "Lcom/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService$BaseCommand;", "fileName", "", "configPath", "content", "extraOptions", "ignoreFilePath", "fileKind", "flatConfig", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "command", "getCommand", "()Ljava/lang/String;", "intellij.javascript.impl"})
    private static final class FixErrorsCommand
    extends BaseCommand {
        public FixErrorsCommand(@Nullable String fileName, @Nullable String configPath, @Nullable String content, @Nullable String extraOptions, @Nullable String ignoreFilePath, @Nullable String fileKind, boolean flatConfig) {
            super(fileName, configPath, content, extraOptions, ignoreFilePath, fileKind, flatConfig);
        }

        @Override
        @NotNull
        public String getCommand() {
            return "FixErrors";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001BK\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService$GetErrorsCommand;", "Lcom/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService$BaseCommand;", "fileName", "", "configPath", "content", "extraOptions", "ignoreFilePath", "fileKind", "flatConfig", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "command", "getCommand", "()Ljava/lang/String;", "intellij.javascript.impl"})
    private static final class GetErrorsCommand
    extends BaseCommand {
        public GetErrorsCommand(@Nullable String fileName, @Nullable String configPath, @Nullable String content, @Nullable String extraOptions, @Nullable String ignoreFilePath, @Nullable String fileKind, boolean flatConfig) {
            super(fileName, configPath, content, extraOptions, ignoreFilePath, fileKind, flatConfig);
        }

        @Override
        @NotNull
        public String getCommand() {
            return "GetErrors";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005H\u0014R\u0016\u0010\n\u001a\u0004\u0018\u00010\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService$Protocol;", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase;", "serviceName", "", "project", "Lcom/intellij/openapi/project/Project;", "readyConsumer", "Ljava/util/function/Consumer;", "<init>", "(Lcom/intellij/lang/javascript/linter/eslint/service/ESLintBasedLanguageService;Ljava/lang/String;Lcom/intellij/openapi/project/Project;Ljava/util/function/Consumer;)V", "workingDirectory", "getWorkingDirectory", "()Ljava/lang/String;", "addNodeProcessAdditionalArguments", "", "targetRun", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "eslintPluginDir", "Ljava/io/File;", "getEslintPluginDir", "()Ljava/io/File;", "createState", "Lcom/intellij/lang/javascript/linter/eslint/service/protocol/ESLintLanguageServiceInitialState;", "getNodeCommandLineConfiguratorOptions", "Lcom/intellij/javascript/nodejs/interpreter/NodeCommandLineConfigurator$Options;", "intellij.javascript.impl"})
    public final class Protocol
    extends JSLanguageServiceNodeStdProtocolBase {
        public Protocol(@NotNull String serviceName, @NotNull Project project, Consumer<?> readyConsumer) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(readyConsumer, (String)"readyConsumer");
            super(serviceName, project, readyConsumer);
        }

        @Override
        @Nullable
        protected String getWorkingDirectory() {
            return JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(ESLintBasedLanguageService.this.myWorkingDirectory);
        }

        @Override
        protected void addNodeProcessAdditionalArguments(@NotNull NodeTargetRun targetRun) {
            Path additionalRootDirectory;
            Intrinsics.checkNotNullParameter((Object)targetRun, (String)"targetRun");
            super.addNodeProcessAdditionalArguments(targetRun);
            if (this.myServiceName != null) {
                JSLanguageServiceUtil.addNodeProcessArgumentsFromRegistry(targetRun.getCommandLineBuilder(), this.myServiceName, Protocol::addNodeProcessAdditionalArguments$lambda$0);
            }
            JSLanguageServiceUtil.addNodePathFromRegistry(targetRun.getCommandLineBuilder(), Protocol::addNodeProcessAdditionalArguments$lambda$1);
            ESLintLanguageServiceInitialState initialState = this.createState();
            String string = PathUtil.getParentPath((String)initialState.pluginPath.getPath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParentPath(...)");
            targetRun.path(string);
            String uploadRootPath = null;
            uploadRootPath = ESLintBasedLanguageService.this.myNodePackage instanceof YarnPnpNodePackage ? ESLintBasedLanguageService.this.findUploadRoot(Objects.requireNonNull(initialState.packageJsonPath).getPath()) : ESLintBasedLanguageService.this.findUploadRoot(ESLintBasedLanguageService.this.myNodePackage.getSystemIndependentPath());
            if (uploadRootPath != null) {
                targetRun.path(uploadRootPath);
            }
            if ((additionalRootDirectory = LocalFilePath.Companion.getNioPath(initialState.additionalRootDirectory)) != null && additionalRootDirectory.isAbsolute() && Files.isDirectory(additionalRootDirectory, new LinkOption[0])) {
                targetRun.path(((Object)additionalRootDirectory).toString());
            }
        }

        private final File getEslintPluginDir() {
            return new File(JSLanguageServiceUtil.getPluginDirectory(this.getClass(), "languageService"), "eslint");
        }

        @Override
        @NotNull
        protected ESLintLanguageServiceInitialState createState() {
            ESLintLanguageServiceInitialState protocolState = new ESLintLanguageServiceInitialState();
            ESLintBasedLanguageService.this.fillInitialProtocolState(protocolState, (JSNpmLinterState)ESLintBasedLanguageService.this.getExtendedState().getState());
            protocolState.pluginName = "ESLint";
            File service = new File(this.getEslintPluginDir(), "bin/eslint-plugin-provider.js");
            if (!service.exists()) {
                JSLanguageServiceQueue.Holder.LOGGER.info("ESLint plugin not found");
            }
            String string = service.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            protocolState.pluginPath = LocalFilePath.Companion.createNotNull(string);
            return protocolState;
        }

        @Override
        @NotNull
        protected NodeCommandLineConfigurator.Options getNodeCommandLineConfiguratorOptions(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            NodeCommandLineConfigurator.Options options = NodeCommandLineConfigurator.defaultOptions(project).withRequiredNodePackage(ESLintBasedLanguageService.this.myNodePackage);
            Intrinsics.checkNotNullExpressionValue((Object)options, (String)"withRequiredNodePackage(...)");
            return options;
        }

        private static final String addNodeProcessAdditionalArguments$lambda$0() {
            return Registry.Companion.stringValue("eslint.service.node.arguments");
        }

        private static final String addNodeProcessAdditionalArguments$lambda$1() {
            return Registry.Companion.stringValue("eslint.service.node.path");
        }
    }
}

