/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index.gist;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import com.intellij.lang.javascript.index.flags.IntFlagsSerializer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

abstract class JSStubElementGistProvider<PsiT extends StubBasedPsiElementBase, V> {
    JSStubElementGistProvider() {
    }

    @NotNull
    abstract V calculate(@NotNull PsiT var1);

    abstract void save(DataOutput var1, V var2) throws IOException;

    @NotNull
    abstract V read(DataInput var1) throws IOException;

    protected static abstract class FlagsOwner {
        private final int myFlags;

        public FlagsOwner(int childFlags) {
            this.myFlags = childFlags;
        }

        public FlagsOwner(DataInput in) throws IOException {
            this.myFlags = DataInputOutputUtil.readINT((DataInput)in);
        }

        protected void save(DataOutput out) throws IOException {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myFlags);
        }

        @NotNull
        protected abstract FlagsStructure getFlagsStructure();

        protected <T> T readFlag(FlagsStructureElement<T> structureElement) {
            return IntFlagsSerializer.INSTANCE.readValue(this.getFlagsStructure(), structureElement, this.myFlags);
        }

        @Contract(pure=true)
        protected static <T> int writeFlag(int flags, @NotNull FlagsStructure flagsStructure, @NotNull FlagsStructureElement<T> structureElement, T value) {
            if (flagsStructure == null) {
                FlagsOwner.$$$reportNull$$$0(0);
            }
            if (structureElement == null) {
                FlagsOwner.$$$reportNull$$$0(1);
            }
            return IntFlagsSerializer.INSTANCE.writeValue(flagsStructure, structureElement, value, flags);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "flagsStructure";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "structureElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/index/gist/JSStubElementGistProvider$FlagsOwner";
            objectArray[2] = "writeFlag";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

