/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigService;
import com.intellij.lang.javascript.flow.lsp.FlowJSLspServerDescriptor;
import com.intellij.lang.javascript.flow.lsp.FlowJSLspService;
import com.intellij.lang.javascript.flow.lsp.FlowJSLspSupportProvider;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerManager;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class FlowJSServerManager {
    @NotNull
    private final Project myProject;

    public FlowJSServerManager(@NotNull Project project) {
        if (project == null) {
            FlowJSServerManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public static FlowJSServerManager getInstance(@NotNull Project project) {
        if (project == null) {
            FlowJSServerManager.$$$reportNull$$$0(1);
        }
        return (FlowJSServerManager)project.getService(FlowJSServerManager.class);
    }

    @Nullable
    public static FlowJSServerService getService(@NotNull PsiFile file) {
        if (file == null) {
            FlowJSServerManager.$$$reportNull$$$0(2);
        }
        return FlowJSServerManager.getInstance(file.getProject()).getServiceImpl(file);
    }

    @Nullable
    private FlowJSServerService getServiceImpl(@NotNull PsiFile file) {
        if (file == null) {
            FlowJSServerManager.$$$reportNull$$$0(3);
        }
        Project project = file.getProject();
        FlowJSConfig config = this.getConfigForService(file.getVirtualFile());
        if (config == null) {
            return null;
        }
        Collection servers = LspServerManager.getInstance((Project)project).getServersForProvider(FlowJSLspSupportProvider.class);
        for (LspServer server : servers) {
            FlowJSLspServerDescriptor descriptor;
            LspServerDescriptor lspServerDescriptor = server.getDescriptor();
            if (!(lspServerDescriptor instanceof FlowJSLspServerDescriptor) || (descriptor = (FlowJSLspServerDescriptor)lspServerDescriptor).getConfig() != config) continue;
            return new FlowJSLspService(server, config, project);
        }
        return null;
    }

    @Nullable
    public FlowJSConfig getConfigForService(@NotNull VirtualFile file) {
        if (file == null) {
            FlowJSServerManager.$$$reportNull$$$0(4);
        }
        if (!this.isFlowAvailable(file)) {
            return null;
        }
        FlowJSConfigService configService = FlowJSConfigService.getService(this.myProject);
        return configService.getNearestConfig(file);
    }

    private boolean isFlowAvailable(@Nullable VirtualFile file) {
        if (this.myProject.isDisposed() || !this.myProject.isOpen()) {
            return false;
        }
        FlowJSSettings.FlowJSExecutable flowExecutable = FlowJSSettingsManager.getFlowExecutable(file, this.myProject);
        if (flowExecutable == null) {
            return false;
        }
        VirtualFile executableFile = LocalFileSystem.getInstance().findFileByPath(flowExecutable.getPackageOrExePath());
        return executableFile != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSServerManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getServiceImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfigForService";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

