/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.findUsages;

import com.intellij.lang.ecmascript6.findUsages.JSFindReferencesResultProcessor;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportAliasReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    protected ES6ImportAliasReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement target2;
        if (queryParameters == null) {
            ES6ImportAliasReferenceSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            ES6ImportAliasReferenceSearcher.$$$reportNull$$$0(1);
        }
        if (!((target2 = queryParameters.getElementToSearch()) instanceof JSElement) || !(target2 instanceof PsiNamedElement)) {
            return;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(target2);
        if (holder == null || !holder.hasFeature(JSLanguageFeature.EXPORT_DECLARATIONS)) {
            return;
        }
        SearchRequestCollector collector = queryParameters.getOptimizer();
        String name = ((PsiNamedElement)target2).getName();
        if (name != null) {
            collector.searchWord(name, queryParameters.getEffectiveSearchScope(), (short)1, true, target2, (RequestResultProcessor)new MyProcessor(target2, queryParameters));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/ecmascript6/findUsages/ES6ImportAliasReferenceSearcher";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyProcessor
    extends JSFindReferencesResultProcessor {
        MyProcessor(PsiElement target2, ReferencesSearch.SearchParameters queryParameters) {
            super(target2, queryParameters);
        }

        @Override
        protected boolean proceedWithReference(@NotNull PsiElement element, SearchRequestCollector collector) {
            JSNamedElement alias;
            if (element == null) {
                MyProcessor.$$$reportNull$$$0(0);
            }
            if ((alias = MyProcessor.getAlias(element)) == null || alias.getName() == null) {
                return false;
            }
            String name = alias.getName();
            LocalSearchScope fileScope = new LocalSearchScope((PsiElement)element.getContainingFile());
            collector.searchWord(name, (SearchScope)fileScope, (short)1, true, (PsiElement)alias);
            return true;
        }

        @Nullable
        private static JSNamedElement getAlias(PsiElement element) {
            TypeScriptImportStatement importStatement;
            if (element instanceof ES6ImportSpecifier) {
                ES6ImportSpecifierAlias alias = ((ES6ImportSpecifier)element).getAlias();
                if (alias != null) {
                    return alias;
                }
            } else if (element instanceof TypeScriptEntityName && !(element.getParent() instanceof TypeScriptEntityName) && (importStatement = (TypeScriptImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, TypeScriptImportStatement.class)) != null) {
                return importStatement;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/findUsages/ES6ImportAliasReferenceSearcher$MyProcessor", "proceedWithReference"));
        }
    }
}

