/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.codeInsight;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.npm.AvailablePackageVersions;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.typings.TypeScriptDefinitionsUtils;
import com.intellij.lang.javascript.modules.InstallNodeModuleQuickFix;
import com.intellij.lang.javascript.modules.PackageInstaller;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.packaging.PackageManagementService;
import java.io.File;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonInstallTypesIntention
extends BaseIntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("package.json.install.types.fix.family.name", new Object[0]);
        if (string == null) {
            PackageJsonInstallTypesIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        VirtualFile packageJson;
        JsonStringLiteral literal;
        if (project == null) {
            PackageJsonInstallTypesIntention.$$$reportNull$$$0(1);
        }
        if ((literal = PackageJsonInstallTypesIntention.getModuleNameLiteral(editor, file)) == null) {
            return false;
        }
        String packageName = literal.getValue();
        if (!TypeScriptDefinitionsUtils.isTypeDefinitionsInstallAvailable(packageName, packageJson = file.getVirtualFile(), project)) {
            return false;
        }
        String typesPackageName = TypeScriptDefinitionsUtils.getTypingsPackageName(packageName);
        this.setText(JavaScriptBundle.message("node.js.quickfix.install.node.module.text", typesPackageName));
        return true;
    }

    @Nullable
    private static JsonStringLiteral getModuleNameLiteral(@Nullable Editor editor, @Nullable PsiFile file) {
        if (file == null || !PackageJsonUtil.isPackageJsonFile(file) || editor == null) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        if (element instanceof LeafPsiElement) {
            element = element.getParent();
        }
        if (!(element instanceof JsonStringLiteral)) {
            return null;
        }
        JsonProperty property = (JsonProperty)ObjectUtils.tryCast((Object)element.getParent(), JsonProperty.class);
        if (property == null) {
            return null;
        }
        if (property.getNameElement() != element) {
            return null;
        }
        if (!PackageJsonUtil.isPackageDependencyProperty(property)) {
            return null;
        }
        return (JsonStringLiteral)element;
    }

    public void invoke(final @NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            PackageJsonInstallTypesIntention.$$$reportNull$$$0(2);
        }
        final JsonStringLiteral literal = PackageJsonInstallTypesIntention.getModuleNameLiteral(editor, file);
        FileDocumentManager.getInstance().saveAllDocuments();
        if (literal == null) {
            return;
        }
        String value = literal.getValue();
        final String packageName = TypeScriptDefinitionsUtils.getTypingsPackageName(value);
        final NodeJsInterpreter interpreter2 = NodeJsInterpreterManager.getInstance(project).getInterpreter();
        if (interpreter2 == null) {
            return;
        }
        final VirtualFile packageJson = file.getVirtualFile();
        final VirtualFile parent = packageJson.getParent();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, JavaScriptBundle.message("progress.title.install", packageName), true){

            public void run(@NotNull ProgressIndicator indicator) {
                AvailablePackageVersions versions;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                CompletableFuture<@NotNull AvailablePackageVersions> future = NpmRegistryService.getInstance(project).getCachedOrFetchPackageVersionsFuture(packageName, packageJson);
                try {
                    versions = (AvailablePackageVersions)ApplicationUtil.runWithCheckCanceled(future, (ProgressIndicator)indicator);
                }
                catch (ExecutionException e) {
                    Logger.getInstance(PackageJsonInstallTypesIntention.class).info("Cannot find versions for " + packageName, (Throwable)e);
                    return;
                }
                List<SemVer> allVersions = versions.getVersions();
                if (allVersions.isEmpty()) {
                    return;
                }
                String expectedVersion = (String)ReadAction.compute(() -> PackageJsonInstallTypesIntention.getVersionUnderReadAction(literal, allVersions));
                String extraOptions = InstallNodeModuleQuickFix.buildExtraOptions(project, true);
                PackageManagementService.Listener listener2 = InstallNodeModuleQuickFix.createListener(project, packageJson, packageName);
                new PackageInstaller(project, interpreter2, packageName, expectedVersion, new File(parent.getPath()), listener2, extraOptions).run(indicator);
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{packageJson});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonInstallTypesIntention$1", "run"));
            }
        });
    }

    @Nullable
    private static String getVersionUnderReadAction(@NotNull JsonStringLiteral literal, @NotNull List<SemVer> allVersions) {
        JsonProperty property;
        if (literal == null) {
            PackageJsonInstallTypesIntention.$$$reportNull$$$0(3);
        }
        if (allVersions == null) {
            PackageJsonInstallTypesIntention.$$$reportNull$$$0(4);
        }
        if ((property = (JsonProperty)ObjectUtils.tryCast((Object)literal.getParent(), JsonProperty.class)) == null) {
            return null;
        }
        JsonStringLiteral value = (JsonStringLiteral)ObjectUtils.tryCast((Object)property.getValue(), JsonStringLiteral.class);
        if (value == null) {
            return null;
        }
        String version2 = value.getValue();
        SemVer matchedVersion = TypeScriptDefinitionsUtils.getMatchedVersion(version2, allVersions);
        return matchedVersion == null ? null : matchedVersion.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonInstallTypesIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allVersions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonInstallTypesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getVersionUnderReadAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

