/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffModel;
import com.intellij.ide.diff.DirDiffModelHolder;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DirDiffManager;
import com.intellij.openapi.diff.impl.dir.DirDiffElementImpl;
import com.intellij.openapi.diff.impl.dir.DirDiffManagerImpl;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DistinctRootsCollections;
import com.jetbrains.plugins.webDeployment.ExecutionContextBase;
import com.jetbrains.plugins.webDeployment.LocalVsRemoteTaskBase;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.LocalVsRemoteActionBase;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.actions.ToggleRemoteExclusionAction;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import com.jetbrains.plugins.webDeployment.diff.BatchDirDiffTableModel;
import com.jetbrains.plugins.webDeployment.ui.CompositeDiffElement;
import com.jetbrains.plugins.webDeployment.ui.DiffRoot;
import com.jetbrains.plugins.webDeployment.ui.LocalMappingDiffRoot;
import com.jetbrains.plugins.webDeployment.ui.RemoteItemDiffElement;
import com.jetbrains.plugins.webDeployment.ui.SyncLoadComponent;
import com.jetbrains.plugins.webDeployment.ui.SyncUtils;
import com.jetbrains.plugins.webDeployment.ui.Util;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncLocalVsRemoteAction
extends LocalVsRemoteActionBase {
    private static final Logger LOG = Logger.getInstance(SyncLocalVsRemoteAction.class);
    @NonNls
    public static final String DIFF_TITLE = "recursive compare window title";
    @NonNls
    public static final String SYNC_LOAD_COMPONENT = "syncLoadComponent";

    public SyncLocalVsRemoteAction() {
        super(WDBundle.messagePointer("sync.with.local.version", new Object[0]));
    }

    @Override
    protected LocalVsRemoteActionBase.LocalData getDataIfEnabledOnProjectView(AnActionEvent e, boolean isFromUpdate) {
        DataContext dataContext = e.getDataContext();
        Project project = SyncLocalVsRemoteAction.getValidProject(dataContext);
        if (project == null) {
            return null;
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        List<WebServerConfig> defaultWrap = publishConfig.findDefaultServers();
        if (defaultWrap.size() != 1 || !defaultWrap.get(0).needsTransfer() || defaultWrap.get(0).validateFast() != null) {
            return null;
        }
        WebServerConfig server = defaultWrap.get(0);
        VirtualFile[] files = PublishActionUtil.getVirtualFiles(e);
        if (files == null || files.length == 0) {
            return null;
        }
        VfsUtilCore.DistinctVFilesRootsCollection distinctFiles = isFromUpdate ? Arrays.asList(files) : new VfsUtilCore.DistinctVFilesRootsCollection(files);
        List<LocalMappingDiffRoot> filesMap = SyncLocalVsRemoteAction.getLocalDiffRoots(publishConfig, server, files, (Collection<VirtualFile>)distinctFiles);
        if (!filesMap.isEmpty()) {
            return new LocalVsRemoteActionBase.LocalData(project, Deployable.create(server, project), filesMap);
        }
        return null;
    }

    @NotNull
    static List<LocalMappingDiffRoot> getLocalDiffRoots(PublishConfig publishConfig, WebServerConfig server, VirtualFile[] files, Collection<VirtualFile> distinctFiles) {
        ArrayList<LocalMappingDiffRoot> filesMap = new ArrayList<LocalMappingDiffRoot>(files.length);
        for (VirtualFile file : distinctFiles) {
            DeploymentPathMapping mapping = (DeploymentPathMapping)publishConfig.getNearestMappingForLocal(file.getPath(), false, true, false, server, true).getFirst();
            if (mapping == null || StringUtil.isEmpty((String)mapping.getDeployPath())) continue;
            filesMap.add(LocalMappingDiffRoot.create(file, mapping));
        }
        ArrayList<LocalMappingDiffRoot> arrayList = filesMap;
        if (arrayList == null) {
            SyncLocalVsRemoteAction.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Override
    protected LocalVsRemoteActionBase.RemoteData getRemoteDataIfEnabledOnRemoteHostView(AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        Project project = SyncLocalVsRemoteAction.getValidProject(dataContext);
        if (project == null) {
            return null;
        }
        Deployable server = (Deployable)event.getData(WebDeploymentDataKeys.DEPLOYABLE);
        if (server == null) {
            return null;
        }
        ServerTreeNode[] serverNodes = (ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(dataContext);
        if (serverNodes == null || serverNodes.length == 0) {
            return null;
        }
        DistinctRootsCollections.ServerTreeNodes distinctServerNodes = new DistinctRootsCollections.ServerTreeNodes(serverNodes, server.isCaseSensitive());
        PublishConfig config = PublishConfig.getInstance(project);
        ArrayList<DiffRoot> files = new ArrayList<DiffRoot>(serverNodes.length);
        Iterator iterator = distinctServerNodes.iterator();
        while (iterator.hasNext()) {
            DeploymentPathMapping mapping;
            ServerTreeNode node = (ServerTreeNode)((Object)iterator.next());
            FileObject fileObject = node.getFileObject();
            if (fileObject == null || (mapping = (DeploymentPathMapping)config.getNearestMappingDeploy2Local(fileObject, false, (Mappable)server, true).getFirst()) == null) continue;
            String localPath = mapping.mapToLocalPath(fileObject.getName(), (Mappable)server);
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(localPath);
            files.add(DiffRoot.create(vFile, fileObject, mapping));
        }
        if (files.isEmpty()) {
            return null;
        }
        RemoteConnection connection = (RemoteConnection)event.getData(WebDeploymentDataKeys.REMOTE_CONNECTION);
        LOG.assertTrue(connection != null);
        return new LocalVsRemoteActionBase.RemoteData(project, server, files, connection);
    }

    @Override
    protected LocalVsRemoteTaskBase<?> createTask(final LocalVsRemoteActionBase.LocalData data) {
        return new SyncTask<LocalMappingDiffRoot>(data.project, data.server, WDBundle.message("sync.with.server.version", new Object[0]), "Project", new ArrayList<LocalMappingDiffRoot>(data.myDiffRoots)){

            @Override
            protected DiffRoot getFullData(ExecutionContextBase context, LocalMappingDiffRoot pair) throws FileSystemException {
                FileObject remote = LocalVsRemoteActionBase.getRemoteItem(context, pair.getMapping(), pair.getLocal(), data.server);
                return DiffRoot.create(pair.getLocal(), remote, pair.getMapping());
            }
        };
    }

    @Nullable
    protected LocalVsRemoteTaskBase createTask(LocalVsRemoteActionBase.RemoteData data) {
        return new SyncTask<DiffRoot>(data.project, data.server, WDBundle.message("sync.with.server.version", new Object[0]), "Remote Host", new ArrayList<DiffRoot>(data.files)){

            @Override
            protected DiffRoot getFullData(ExecutionContextBase context, DiffRoot pair) {
                return pair;
            }
        };
    }

    @Override
    protected Supplier<@NlsActions.ActionText String> getProjectViewTitleSupplier(@NotNull Deployable serverConfig) {
        if (serverConfig == null) {
            SyncLocalVsRemoteAction.$$$reportNull$$$0(1);
        }
        return WDBundle.messagePointer("sync.with.server.0.version", serverConfig.getName());
    }

    public static boolean isExcludedFileHidden(DirDiffSettings settings) {
        Object value = settings.customSettings.get("hide excluded files");
        LOG.assertTrue(value != null);
        return (Boolean)value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/actions/SyncLocalVsRemoteAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalDiffRoots";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/SyncLocalVsRemoteAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProjectViewTitleSupplier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static final class ToggleExcludedPathsAction
    extends ToggleAction
    implements DirDiffModelHolder {
        @NonNls
        private static final String HIDE_EXCLUDED_FILES = "hide excluded files";
        private volatile DirDiffModel myModel;
        private final Boolean myInitialSelected;

        private ToggleExcludedPathsAction(Boolean initialSelected) {
            super(WDBundle.message("hide.excluded.files", new Object[0]), WDBundle.message("remove.excluded.files.from.comparison", new Object[0]), AllIcons.General.Filter);
            this.myInitialSelected = initialSelected;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ToggleExcludedPathsAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void setModel(DirDiffModel model) {
            this.myModel = model;
            this.myModel.getSettings().customSettings.put(HIDE_EXCLUDED_FILES, this.myInitialSelected == null || this.myInitialSelected != false);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleExcludedPathsAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            if (this.myModel instanceof DirDiffTableModel) {
                e.getPresentation().setEnabled(!((DirDiffTableModel)this.myModel).isUpdating());
            }
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleExcludedPathsAction.$$$reportNull$$$0(2);
            }
            return this.isSelected();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ToggleExcludedPathsAction.$$$reportNull$$$0(3);
            }
            this.myModel.getSettings().customSettings.put(HIDE_EXCLUDED_FILES, state);
            this.myModel.reloadModel(false);
        }

        public boolean isSelected() {
            Object value = this.myModel.getSettings().customSettings.get(HIDE_EXCLUDED_FILES);
            return value instanceof Boolean ? (Boolean)value : true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/actions/SyncLocalVsRemoteAction$ToggleExcludedPathsAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/SyncLocalVsRemoteAction$ToggleExcludedPathsAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static abstract class SyncTask<T extends LocalMappingDiffRoot>
    extends LocalVsRemoteTaskBase<T> {
        protected SyncTask(@NotNull Project project, @NotNull Deployable server, @NlsContexts.ProgressTitle String title, String toolWindowId, List<T> localFiles) {
            if (project == null) {
                SyncTask.$$$reportNull$$$0(0);
            }
            if (server == null) {
                SyncTask.$$$reportNull$$$0(1);
            }
            super(project, title, server, toolWindowId, localFiles);
        }

        @Override
        protected boolean execute(List<DiffRoot> roots, ExecutionContextBase context, RemoteConnection remoteConnection) {
            DiffElement localDiffElement;
            DiffElement remoteDiffElement;
            FileDocumentManager mgr = FileDocumentManager.getInstance();
            ArrayList<Document> docsToSave = new ArrayList<Document>();
            block2: for (Document document : mgr.getUnsavedDocuments()) {
                VirtualFile file = mgr.getFile(document);
                if (file == null || !file.isValid()) continue;
                for (DiffRoot pair : roots) {
                    if (pair.getLocal() == null || !VfsUtilCore.isAncestor((VirtualFile)pair.getLocal(), (VirtualFile)file, (boolean)false)) continue;
                    docsToSave.add(document);
                    continue block2;
                }
            }
            if (!docsToSave.isEmpty()) {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    for (Document document : docsToSave) {
                        mgr.saveDocument(document);
                    }
                });
            }
            RemoteConnection connectionForDiff = remoteConnection.clone();
            assert (this.myProject != null);
            final PublishConfig config = PublishConfig.getInstance(this.myProject);
            final Deployable serverConfig = context.getServer();
            DirDiffSettings settings = new DirDiffSettings();
            SyncUtils.initializeExcludedFromProjectFiles(settings, roots, serverConfig, this.myProject);
            try {
                remoteDiffElement = CompositeDiffElement.createRootRemoteDiffElement(roots, serverConfig, settings, this.myProject, connectionForDiff);
                localDiffElement = CompositeDiffElement.createRootLocalDiffElement(roots, config, serverConfig, settings, this.myProject);
            }
            catch (FileSystemException e) {
                connectionForDiff.release();
                LOG.warn((Throwable)e);
                Util.showBalloonError(this.myProject, this.myToolWindowId, PublishUtils.getMessage(e, false));
                return false;
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                DirDiffManagerImpl diffManager = (DirDiffManagerImpl)DirDiffManager.getInstance((Project)this.myProject);
                final BatchDirDiffTableModel model = new BatchDirDiffTableModel(this.myProject, localDiffElement, remoteDiffElement, settings, config, serverConfig);
                if (diffManager.canShow(localDiffElement, remoteDiffElement)) {
                    ToggleExcludedPathsAction toggleExcludedPathsAction = new ToggleExcludedPathsAction(!config.isShowExcludedInSync());
                    settings.addExtraAction((AnAction)toggleExcludedPathsAction);
                    ToggleRemoteExclusionAction exclusionAction = new ToggleRemoteExclusionAction(AllIcons.FileTypes.AddAny){

                        @Override
                        protected FileObject[] getRemoteFiles(AnActionEvent event) {
                            ArrayList<FileObject> fileObjects = new ArrayList<FileObject>();
                            for (DirDiffElementImpl selectedElement : model.getSelectedElements()) {
                                DiffElement target = selectedElement.getTarget();
                                if (!(target instanceof RemoteItemDiffElement)) continue;
                                fileObjects.add(((RemoteItemDiffElement)target).getValue());
                            }
                            return fileObjects.toArray(new FileObject[0]);
                        }

                        @Override
                        @NotNull
                        protected Deployable getServerConfig(AnActionEvent event) {
                            Deployable deployable = serverConfig;
                            if (deployable == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return deployable;
                        }

                        @Override
                        @NotNull
                        protected PublishConfig getPublishConfig(AnActionEvent event) {
                            PublishConfig publishConfig = config;
                            if (publishConfig == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return publishConfig;
                        }

                        @Override
                        public boolean displayTextInToolbar() {
                            return false;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[2];
                            objectArray2[0] = "com/jetbrains/plugins/webDeployment/actions/SyncLocalVsRemoteAction$SyncTask$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getServerConfig";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getPublishConfig";
                                    break;
                                }
                            }
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                        }
                    };
                    settings.addExtraAction((AnAction)exclusionAction);
                    settings.compareTimestampAccuracy = SyncTask.getTimestampAccuracy(roots);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Compare timestamp accuracy is " + settings.compareTimestampAccuracy);
                    }
                    settings.compareMode = config.getCompareModeInSync();
                    settings.showDifferent = config.isShowDifferentInSync();
                    settings.showEqual = config.isShowEqualInSync();
                    settings.showNewOnSource = config.isShowNewOnSourceInSync();
                    settings.showNewOnTarget = config.isShowNewOnTargetInSync();
                    settings.customSourceChooser = new DirDiffSettings.CustomSourceChooser(){

                        public DiffElement chooseSource(@NotNull DiffElement first, @NotNull DiffElement second) {
                            if (first == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            if (second == null) {
                                2.$$$reportNull$$$0(1);
                            }
                            long firstTimestamp = first.getTimeStamp();
                            long secondTimestamp = second.getTimeStamp();
                            if (firstTimestamp < 0L || secondTimestamp < 0L || firstTimestamp == secondTimestamp) {
                                return null;
                            }
                            return firstTimestamp > secondTimestamp ? first : second;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "first";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "second";
                                    break;
                                }
                            }
                            objectArray[1] = "com/jetbrains/plugins/webDeployment/actions/SyncLocalVsRemoteAction$SyncTask$2";
                            objectArray[2] = "chooseSource";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    settings.customSettings.put(SyncLocalVsRemoteAction.SYNC_LOAD_COMPONENT, new SyncLoadComponent(this.myProject, config, serverConfig));
                    settings.customSettings.put(SyncLocalVsRemoteAction.DIFF_TITLE, WDBundle.message("diff.between.0.and.1", localDiffElement.getPresentablePath(), remoteDiffElement.getPresentablePath()));
                    RemoteConnectionManager.getInstance().registerBlockingPluginUnloadElement(settings);
                    Runnable onWindowClosing = () -> {
                        RemoteConnectionManager.getInstance().unregisterBlockingPluginUnloadElement(settings);
                        connectionForDiff.release();
                        DirDiffSettings.CompareMode mode = settings.compareMode;
                        config.setCompareModeInSync(mode);
                        config.setShowDifferentInSync(settings.showDifferent);
                        config.setShowEqualInSync(settings.showEqual);
                        config.setShowNewOnSourceInSync(settings.showNewOnSource);
                        config.setShowNewOnTargetInSync(settings.showNewOnTarget);
                        config.setShowExcludedInSync(!toggleExcludedPathsAction.isSelected());
                    };
                    diffManager.showDiff(settings, (DirDiffTableModel)model, onWindowClosing);
                }
            });
            return true;
        }

        private static double getTimestampAccuracy(List<DiffRoot> files) {
            double result = 0.0;
            FileObject local = null;
            FileObject remote = null;
            for (DiffRoot file : files) {
                if (file.getLocal() != null && (local = DeploymentPathUtils.getLocalFile(file.getLocal().getPath())) != null) {
                    result += local.getFileSystem().getLastModTimeAccuracy();
                }
                if (remote == null) {
                    remote = file.getRemote();
                    result += remote.getFileSystem().getLastModTimeAccuracy();
                }
                if (local == null) continue;
                return result;
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "server";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/plugins/webDeployment/actions/SyncLocalVsRemoteAction$SyncTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

