/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.util;

import com.github.dockerjava.api.exception.DockerException;
import com.intellij.docker.agent.i18n.DockerAgentBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0002\b\u0002\u001a\u000e\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0006H\u0007\u001a\f\u0010\u0007\u001a\u00020\u0005*\u00020\u0006H\u0001\"\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006\b"}, d2={"SERVER_RUNTIME_EXCEPTION_MESSAGE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "extractDockerErrorMessage", "", "", "dockerUserFriendlyMessage", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\ndockerErrorUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 dockerErrorUtil.kt\ncom/intellij/docker/agent/util/DockerErrorUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,33:1\n1#2:34\n*E\n"})
public final class DockerErrorUtilKt {
    private static final Pattern SERVER_RUNTIME_EXCEPTION_MESSAGE_PATTERN = Pattern.compile("(?s).*\\{\"message\":\"(?<body>.*)\"}.*");

    @Nls
    @Nullable
    public static final String extractDockerErrorMessage(@NotNull Throwable $this$extractDockerErrorMessage) {
        String string;
        block4: {
            block3: {
                String string2;
                Intrinsics.checkNotNullParameter((Object)$this$extractDockerErrorMessage, (String)"<this>");
                string = $this$extractDockerErrorMessage.getMessage();
                if (string == null) break block3;
                String it = string2 = string;
                boolean bl = false;
                string = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
                if (string != null) break block4;
            }
            return null;
        }
        String message = string;
        Matcher matcher = SERVER_RUNTIME_EXCEPTION_MESSAGE_PATTERN.matcher(message);
        return matcher.matches() ? matcher.group("body") : null;
    }

    @Nls
    @NotNull
    public static final String dockerUserFriendlyMessage(@NotNull Throwable $this$dockerUserFriendlyMessage) {
        Intrinsics.checkNotNullParameter((Object)$this$dockerUserFriendlyMessage, (String)"<this>");
        String string = DockerErrorUtilKt.extractDockerErrorMessage($this$dockerUserFriendlyMessage);
        if (string == null && (string = $this$dockerUserFriendlyMessage.getMessage()) == null) {
            String string2;
            DockerException dockerException = $this$dockerUserFriendlyMessage instanceof DockerException ? (DockerException)$this$dockerUserFriendlyMessage : null;
            if (dockerException != null) {
                DockerException it = dockerException;
                boolean bl = false;
                Object[] objectArray = new Object[]{((DockerException)$this$dockerUserFriendlyMessage).getHttpStatus()};
                string2 = DockerAgentBundle.Companion.message("UserFriendlyMessage.error.code", objectArray);
            } else {
                string2 = string = null;
            }
            if (string2 == null) {
                String string3 = $this$dockerUserFriendlyMessage.getClass().getName();
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            }
        }
        return string;
    }
}

