/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteDriver;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperDetection;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.remote.jdbc.helpers.RemoteLogHelper;
import com.intellij.database.remote.jdbc.helpers.RemoteLogStdRedirector;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.database.remote.jdbc.impl.SerializableDriverPropertyInfo;
import com.intellij.database.remote.toolkit.RemoteDesktopActionsHandler;
import com.intellij.database.remote.toolkit.RemoteDesktopActionsHandlerImpl;
import com.intellij.execution.rmi.ssl.SslKeyStore;
import com.intellij.execution.rmi.ssl.SslTrustStore;
import com.intellij.openapi.util.Comparing;
import java.io.File;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.nativecerts.NativeTrustedCertificates;

public class RemoteDriverImpl
extends JdbcRemoteObject
implements RemoteDriver {
    private final Driver myDelegate;
    private String myLogConfig;

    protected RemoteDriverImpl(Driver delegate) {
        this.myDelegate = delegate;
    }

    public static RemoteDriverImpl wrap(Driver delegate) {
        return delegate == null ? null : new RemoteDriverImpl(delegate);
    }

    public String getCastToClassName() {
        return Driver.class.getName();
    }

    @Override
    public void logStdOutAndErr() {
        RemoteLogStdRedirector.logStdOutAndErr();
    }

    @Override
    public void setLogConfig(String config) throws Exception {
        if (Comparing.equal((String)this.myLogConfig, (String)config)) {
            return;
        }
        if (this.myLogConfig != null) {
            JdbcNativeUtil.logWarn("log config is already set, trying to reset log manager", null);
        } else {
            JdbcNativeUtil.logInfo("loading log config:\n" + config);
        }
        RemoteLogHelper.loadConfig(config);
        this.myLogConfig = config;
    }

    @NotNull
    private static String certificates(int count) {
        String string = count == 1 ? "certificate" : count + " certificates";
        if (string == null) {
            RemoteDriverImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void loadTrustedCertificate(@NotNull String alias, @NotNull String certPath) throws Exception {
        if (alias == null) {
            RemoteDriverImpl.$$$reportNull$$$0(1);
        }
        if (certPath == null) {
            RemoteDriverImpl.$$$reportNull$$$0(2);
        }
        try {
            int count = SslTrustStore.appendUserCert((String)alias, (String)certPath);
            JdbcNativeUtil.logInfo("Loaded " + RemoteDriverImpl.certificates(count) + ": " + alias + " from " + certPath);
        }
        catch (Exception e) {
            this.rethrowException(e);
        }
    }

    @Override
    public void loadTrustedCertificates(@NotNull String storePath, char[] password) throws Exception {
        if (storePath == null) {
            RemoteDriverImpl.$$$reportNull$$$0(3);
        }
        try {
            int count = SslTrustStore.appendUserTrustStore((String)storePath, (char[])password);
            JdbcNativeUtil.logInfo("Loaded " + RemoteDriverImpl.certificates(count) + " truststore" + (password == null ? "" : "(password protected)") + " from " + storePath);
        }
        catch (Exception e) {
            this.rethrowException(e);
        }
    }

    @Override
    public void loadJavaTrustedCertificates() throws Exception {
        String path = System.getProperty("javax.net.ssl.trustStore");
        if (path == null) {
            JdbcNativeUtil.logInfo("No java truststore passed");
            return;
        }
        if (!new File(path).exists()) {
            JdbcNativeUtil.logInfo("Java truststore does not exist in " + path);
            return;
        }
        String password = System.getProperty("javax.net.ssl.trustStorePassword");
        try {
            int count = SslTrustStore.appendUserTrustStore((String)path, (char[])(password == null ? null : password.toCharArray()));
            JdbcNativeUtil.logInfo("Loaded " + RemoteDriverImpl.certificates(count) + " java truststore" + (password == null ? "" : "(password protected)") + " from " + path);
        }
        catch (Exception e) {
            this.rethrowException(e);
        }
    }

    @Override
    public void loadSystemTrustedCertificates() throws Exception {
        try {
            Collection systemCerts = NativeTrustedCertificates.getCustomOsSpecificTrustedCertificates();
            SslTrustStore.appendCertificates((String)"os-certificate", (Collection)systemCerts);
            JdbcNativeUtil.logInfo("Loaded " + RemoteDriverImpl.certificates(systemCerts.size()) + " system truststore");
        }
        catch (Exception e) {
            this.rethrowException(e);
        }
    }

    @Override
    public void loadUserCertificate(@NotNull String alias, @NotNull String keyPath, @Nullable String certPath, char[] keyPassword) throws Exception {
        if (alias == null) {
            RemoteDriverImpl.$$$reportNull$$$0(4);
        }
        if (keyPath == null) {
            RemoteDriverImpl.$$$reportNull$$$0(5);
        }
        try {
            SslKeyStore.loadKey((String)alias, (String)keyPath, (String)certPath, (char[])keyPassword);
        }
        catch (Exception e) {
            this.rethrowException(e);
        }
    }

    @Override
    public void loadUserCertificates(@NotNull String storePath, char[] password) throws Exception {
        if (storePath == null) {
            RemoteDriverImpl.$$$reportNull$$$0(6);
        }
        try {
            int count = SslKeyStore.appendUserKeyStore((String)storePath, (char[])password);
            JdbcNativeUtil.logInfo("Loaded " + RemoteDriverImpl.certificates(count) + " keystore" + (password == null ? "" : "(password protected)") + " from " + storePath);
        }
        catch (Exception e) {
            this.rethrowException(e);
        }
    }

    @Override
    public void setDesktopActionsHandler(RemoteDesktopActionsHandler handler) throws RemoteException {
        RemoteDesktopActionsHandlerImpl.setHandler(handler);
    }

    @Override
    public RemoteConnection connect(String url, @Nullable Properties properties, @NotNull Map<String, Serializable> extra) throws RemoteException, SQLException {
        if (extra == null) {
            RemoteDriverImpl.$$$reportNull$$$0(7);
        }
        JdbcHelperImpl connectHelper = null;
        try {
            String forced;
            Connection connection;
            if (properties == null) {
                properties = new Properties();
            }
            if ((connection = (connectHelper = JdbcHelperDetection.detect(this.myDelegate, url, forced = JdbcSettings.FORCED_JDBC_HELPER.get(extra))).connect(this.myDelegate, url, properties, extra)) == null) {
                return null;
            }
            if (connection.isClosed()) {
                throw new SQLException("Connection is closed");
            }
            JdbcHelperImpl helper = JdbcHelperDetection.detect(connection, connectHelper, forced);
            return (RemoteConnection)((Object)this.export((Remote)((Object)helper.wrap(connection))));
        }
        catch (Exception e) {
            if (connectHelper != null) {
                connectHelper.createExceptionProcessor().rethrowException(e);
            }
            this.rethrowException(e);
            throw new AssertionError();
        }
    }

    @Override
    @TestOnly
    public String getConnectHelperClass(String url) throws RemoteException {
        return JdbcHelperDetection.detect(this.myDelegate, url).getClass().getName();
    }

    @Override
    public boolean acceptsURL(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.acceptsURL(p1);
        }
        catch (Exception e) {
            this.rethrowException(e);
            throw new AssertionError();
        }
    }

    @Override
    public boolean canChangePassword(String url, Properties properties) throws RemoteException {
        if (properties == null) {
            properties = new Properties();
        }
        JdbcHelperImpl connectHelper = JdbcHelperDetection.detect(this.myDelegate, url);
        return connectHelper.canChangePassword(this.myDelegate, url, properties);
    }

    @Override
    public void changeExpiredPassword(String url, Properties properties, @NotNull Map<String, Serializable> extra, String newPassword) throws RemoteException, SQLException {
        if (extra == null) {
            RemoteDriverImpl.$$$reportNull$$$0(8);
        }
        try {
            if (properties == null) {
                properties = new Properties();
            }
            JdbcHelperImpl connectHelper = JdbcHelperDetection.detect(this.myDelegate, url, JdbcSettings.FORCED_JDBC_HELPER.get(extra));
            connectHelper.changeExpiredPassword(this.myDelegate, url, properties, extra, newPassword);
        }
        catch (Exception e) {
            this.rethrowException(e);
            throw new AssertionError();
        }
    }

    @Override
    public int getMajorVersion() throws RemoteException {
        try {
            return this.myDelegate.getMajorVersion();
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    @Override
    public int getMinorVersion() throws RemoteException {
        try {
            return this.myDelegate.getMinorVersion();
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String p1, Properties p2) throws RemoteException, SQLException {
        try {
            DriverPropertyInfo[] value;
            try {
                value = this.myDelegate.getPropertyInfo(p1, p2);
            }
            catch (RuntimeException e) {
                JdbcNativeUtil.logWarn(null, e);
                value = null;
            }
            DriverPropertyInfo[] result = new DriverPropertyInfo[value == null ? 0 : value.length];
            for (int i = 0; i < result.length; ++i) {
                DriverPropertyInfo p = value[i];
                result[i] = p == null ? new SerializableDriverPropertyInfo() : new SerializableDriverPropertyInfo(p);
            }
            return result;
        }
        catch (Exception e) {
            this.rethrowException(e);
            throw new AssertionError();
        }
    }

    @Override
    public boolean jdbcCompliant() throws RemoteException {
        try {
            return this.myDelegate.jdbcCompliant();
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public void unreferenced() {
        System.exit(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/impl/RemoteDriverImpl";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certPath";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPath";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extra";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "certificates";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/impl/RemoteDriverImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadTrustedCertificate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadTrustedCertificates";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadUserCertificate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadUserCertificates";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "changeExpiredPassword";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

