/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.temporal;

import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.temporal.TemporalInstantFunctionBuiltins;
import com.oracle.truffle.js.builtins.temporal.TemporalInstantPrototypeBuiltins;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public final class JSTemporalInstant
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final JSTemporalInstant INSTANCE = new JSTemporalInstant();
    public static final TruffleString CLASS_NAME = Strings.constant("Instant");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("Instant.prototype");
    public static final TruffleString TO_STRING_TAG = Strings.constant("Temporal.Instant");

    private JSTemporalInstant() {
    }

    public static JSTemporalInstantObject create(JSContext context2, JSRealm realm, BigInt nanoseconds) {
        JSObjectFactory factory = context2.getTemporalInstantFactory();
        return JSTemporalInstant.create(factory, realm, factory.getPrototype(realm), nanoseconds);
    }

    public static JSTemporalInstantObject create(JSContext context2, JSRealm realm, JSDynamicObject proto, BigInt nanoseconds) {
        JSObjectFactory factory = context2.getTemporalInstantFactory();
        return JSTemporalInstant.create(factory, realm, proto, nanoseconds);
    }

    private static JSTemporalInstantObject create(JSObjectFactory factory, JSRealm realm, JSDynamicObject proto, BigInt nanoseconds) {
        Shape shape = factory.getShape(realm, proto);
        JSTemporalInstantObject newObj = factory.initProto(new JSTemporalInstantObject(shape, proto, nanoseconds), realm, proto);
        return factory.trackAllocation(newObj);
    }

    @Override
    public TruffleString getClassName(JSDynamicObject object) {
        return TO_STRING_TAG;
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject constructor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(prototype, constructor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, TemporalInstantPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putAccessorsFromContainer(realm, prototype, TemporalInstantPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, TO_STRING_TAG);
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context2, JSDynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context2);
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getTemporalInstantPrototype();
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, TemporalInstantFunctionBuiltins.BUILTINS);
    }

    public static boolean isJSTemporalInstant(Object obj) {
        return obj instanceof JSTemporalInstantObject;
    }
}

