/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sr extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Средње време по Гриничу",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Акре стандардно време",
               "",
               "Акре летње рачунање времена",
               "",
               "Акре време",
               "",
            };
        final String[] Apia = new String[] {
               "Апија, стандардно време",
               "",
               "Апија, летње време",
               "",
               "Апија време",
               "",
            };
        final String[] Cook = new String[] {
               "Кукова острва, стандардно време",
               "",
               "Кукова острва, полу-летње време",
               "",
               "Кукова острва време",
               "",
            };
        final String[] Cuba = new String[] {
               "Куба, стандардно време",
               "CST",
               "Куба, летње време",
               "CDT",
               "Куба",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Фиџи, стандардно време",
               "",
               "Фиџи, летње време",
               "",
               "Фиџи време",
               "",
            };
        final String[] Gulf = new String[] {
               "Заливско време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Ховд, стандардно време",
               "",
               "Ховд, летње време",
               "",
               "Ховд време",
               "",
            };
        final String[] Iran = new String[] {
               "Иран, стандардно време",
               "",
               "Иран, летње време",
               "",
               "Иран време",
               "",
            };
        final String[] Niue = new String[] {
               "Ниуе време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Омск, стандардно време",
               "",
               "Омск, летње време",
               "",
               "Омск време",
               "",
            };
        final String[] Peru = new String[] {
               "Перу, стандардно време",
               "",
               "Перу, летње време",
               "",
               "Перу време",
               "",
            };
        final String[] Truk = new String[] {
               "Чуук време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Вејк острво време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Чиле, стандардно време",
               "",
               "Чиле, летње време",
               "",
               "Чиле време",
               "",
            };
        final String[] China = new String[] {
               "Кинеско стандардно време",
               "CST",
               "Кина, летње време",
               "CDT",
               "Кина време",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Кокос (Келинг) Острва време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Дејвис време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Индијско стандардно време",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Јапанско стандардно време",
               "JST",
               "Јапанско летње време",
               "JDT",
               "Јапанско време",
               "JT",
            };
        final String[] Korea = new String[] {
               "Корејско стандардно време",
               "KST",
               "Корејско летње време",
               "KST",
               "Корејско време",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Науру време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Непал време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Палау време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Самоа, стандардно време",
               "SST",
               "Самоа, летње време",
               "SST",
               "Самоа време",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Шова време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Тонга, стандардно време",
               "",
               "Тонга, летње време",
               "",
               "Тонга време",
               "",
            };
        final String[] Yukon = new String[] {
               "Јукон",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Аљаска, стандардно време",
               "AKST",
               "Аљаска, летње време",
               "AKDT",
               "Аљаска",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Амазон, стандардно време",
               "",
               "Амазон, летње време",
               "",
               "Амазон време",
               "",
            };
        final String[] Azores = new String[] {
               "Азори, стандардно време",
               "",
               "Азори, летње време",
               "",
               "Азори време",
               "",
            };
        final String[] Bhutan = new String[] {
               "Бутан време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Брунеј Дарусалум време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Ускршња острва, стандардно време",
               "",
               "Ускршња острва, летње време",
               "",
               "Ускршња острва време",
               "",
            };
        final String[] Guyana = new String[] {
               "Гвајана време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "Хавајско-алеутско стандардно време",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "Израелско стандардно време",
               "IST",
               "Израелско летње време",
               "IDT",
               "Израелско време",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Кошре време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Мосон време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Москва, стандардно време",
               "MSK",
               "Москва, летње време",
               "MSK",
               "Москва време",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Понпеј време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Самара стандардно време",
               "",
               "Самара летње рачунање времена",
               "",
               "Самара време",
               "",
            };
        final String[] Tahiti = new String[] {
               "Тахити време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Тајпеј, стандардно време",
               "CST",
               "Тајпеј, летње време",
               "CDT",
               "Тајпеј време",
               "CT",
            };
        final String[] Turkey = new String[] {
               "Турска стандардно време",
               "",
               "Турска летње рачунање времена",
               "",
               "Турска време",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Тувалу време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Восток време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Валис и Футуна Острва време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Арабијско стандардно време",
               "",
               "Арабијско летње време",
               "",
               "Арабијско време",
               "",
            };
        final String[] Armenia = new String[] {
               "Јерменија, стандардно време",
               "",
               "Јерменија, летње време",
               "",
               "Јерменија време",
               "",
            };
        final String[] Bolivia = new String[] {
               "Боливија време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Чатам, стандардно време",
               "",
               "Чатам, летње време",
               "",
               "Чатам време",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Координисано универзално време",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Еквадор време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Гамбије време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Грузија, стандардно време",
               "",
               "Грузија, летње време",
               "",
               "Грузија време",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Иркуцк, стандардно време",
               "",
               "Иркуцк, летње време",
               "",
               "Иркуцк време",
               "",
            };
        final String[] Magadan = new String[] {
               "Магадан, стандардно време",
               "",
               "Магадан, летње време",
               "",
               "Магадан време",
               "",
            };
        final String[] Myanmar = new String[] {
               "Мијанмар време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Норфолк Острво, стандардно време",
               "",
               "Норфолк Острво, летње време",
               "",
               "Норфолк Острво време",
               "",
            };
        final String[] Noronha = new String[] {
               "Фернандо де Нороња, стандардно време",
               "",
               "Фернандо де Нороња, летње време",
               "",
               "Фернандо де Нороња време",
               "",
            };
        final String[] Reunion = new String[] {
               "Реинион време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Ротера време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Соломонска Острва време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Токелау време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Уругвај, стандардно време",
               "",
               "Уругвај, летње време",
               "",
               "Уругвај време",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Вануату, стандардно време",
               "",
               "Вануату, летње време",
               "",
               "Вануату време",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Јакутск, стандардно време",
               "",
               "Јакутск, летње време",
               "",
               "Јакутск време",
               "",
            };
        final String[] Atlantic = new String[] {
               "Атлантско стандардно време",
               "AST",
               "Атлантско летње време",
               "AST",
               "Атлантско време",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Бразилија, стандардно време",
               "",
               "Бразилија, летње време",
               "",
               "Бразилија време",
               "",
            };
        final String[] Chamorro = new String[] {
               "Чаморо време",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Колумбија, стандардно време",
               "",
               "Колумбија, летње време",
               "",
               "Колумбија време",
               "",
            };
        final String[] Falkland = new String[] {
               "Фолкландска Острва, стандардно време",
               "",
               "Фолкландска Острва, летње време",
               "",
               "Фолкландска Острва време",
               "",
            };
        final String[] Malaysia = new String[] {
               "Малезија време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Малдиви време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Улан Батор, стандардно време",
               "",
               "Улан Батор, летње време",
               "",
               "Улан Батор време",
               "",
            };
        final String[] Pakistan = new String[] {
               "Пакистан, стандардно време",
               "PKT",
               "Пакистан, летње време",
               "PKST",
               "Пакистан време",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Парагвај, стандардно време",
               "",
               "Парагвај, летње време",
               "",
               "Парагвај време",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Питкерн време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Суринам време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Аргентина, стандардно време",
               "",
               "Аргентина, летње време",
               "",
               "Аргентина време",
               "",
            };
        final String[] Christmas = new String[] {
               "Божићно острво време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Галапагос време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Хонг Конг, стандардно време",
               "HKT",
               "Хонг Конг, летње време",
               "HKST",
               "Хонг Конг време",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Индокина време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Петропавловско-камчатско стандардно време",
               "",
               "Петропавловско-камчатско летње рачунање времена",
               "",
               "Петропавловско-камчатско време",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Киргистан време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Лорд Хов, стандардно време",
               "",
               "Лорд Хов, летње време",
               "",
               "Лорд Хов време",
               "",
            };
        final String[] Marquesas = new String[] {
               "Маркиз време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Маурицијус, стандардно време",
               "",
               "Маурицијус, летње време",
               "",
               "Маурицијус време",
               "",
            };
        final String[] Singapore = new String[] {
               "Сингапур, стандардно време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Венецуела време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Азербејџан, стандардно време",
               "",
               "Азербејџан, летње време",
               "",
               "Азербејџан време",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Бангладеш, стандардно време",
               "",
               "Бангладеш, летње време",
               "",
               "Бангладеш време",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Зеленортска Острва, стандардно време",
               "",
               "Зеленортска Острва, летње време",
               "",
               "Зеленортска Острва време",
               "",
            };
        final String[] East_Timor = new String[] {
               "Источни тимор време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Казахстанско време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Сејшели време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Таџикистан време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Узбекистан, стандардно време",
               "",
               "Узбекистан, летње време",
               "",
               "Узбекистан време",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Авганистан време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Краснојарск, стандардно време",
               "",
               "Краснојарск, летње време",
               "",
               "Краснојарск време",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Нови Зеланд, стандардно време",
               "NZST",
               "Нови Зеланд, летње време",
               "NZDT",
               "Нови Зеланд време",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "Филипини, стандардно време",
               "PST",
               "Филипини, летње време",
               "PDT",
               "Филипини време",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Владивосток, стандардно време",
               "",
               "Владивосток, летње време",
               "",
               "Владивосток време",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Индијско океанско време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Острва Лајн време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Њуфаундленд, стандардно време",
               "NST",
               "Њуфаундленд, летње време",
               "NDT",
               "Њуфаундленд",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Туркменистан, стандардно време",
               "",
               "Туркменистан, летње време",
               "",
               "Туркменистан време",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Француска Гвајана време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Нова Каледонија, стандардно време",
               "",
               "Нова Каледонија, летње време",
               "",
               "Нова Каледонија време",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Јужна Џорџија време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Јекатеринбург, стандардно време",
               "",
               "Јекатеринбург, летње време",
               "",
               "Јекатеринбург време",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Централно-афричко време",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Источно-афричко време",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Западно-афричко време",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Димон д’Урвил време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Средњеевропско стандардно време",
               "CET",
               "Средњеевропско летње време",
               "CEST",
               "Средњеевропско време",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Источноевропско стандардно време",
               "EET",
               "Источноевропско летње време",
               "EEST",
               "Источноевропско време",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Западноевропско стандардно време",
               "WET",
               "Западноевропско летње време",
               "WEST",
               "Западноевропско време",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Мексички Пацифик, стандардно време",
               "MST",
               "Мексички Пацифик, летње време",
               "MDT",
               "Мексички Пацифик",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Јужно-афричко време",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Северноамеричко централно стандардно време",
               "CST",
               "Северноамеричко централно летње време",
               "CDT",
               "Северноамеричко централно време",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Северноамеричко источно стандардно време",
               "EST",
               "Северноамеричко источно летње време",
               "EST",
               "Северноамеричко источно време",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Северноамеричко пацифичко стандардно време",
               "PST",
               "Северноамеричко пацифичко летње време",
               "PDT",
               "Северноамеричко пацифичко време",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Француско јужно и антарктичко време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Гилберт острва време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Хавајско-алеутско стандардно време",
               "HST",
               "Хавајско-алеутско летње време",
               "HDT",
               "Хавајско-алеутско време",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Феникс острва време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Сен Пјер и Микелон, стандардно време",
               "",
               "Сен Пјер и Микелон, летње време",
               "",
               "Сен Пјер и Микелон",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Северноамеричко планинско стандардно време",
               "MST",
               "Северноамеричко планинско летње време",
               "MST",
               "Северноамеричко планинско време",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Маршалска Острва време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Папуа Нова Гвинеја време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Аустралијско централно стандардно време",
               "ACST",
               "Аустралијско централно летње време",
               "ACDT",
               "Аустралијско централно време",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Аустралијско источно стандардно време",
               "AEST",
               "Аустралијско источно летње време",
               "AEDT",
               "Аустралијско источно време",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Аустралијско западно стандардно време",
               "AWST",
               "Аустралијско западно летње време",
               "AWDT",
               "Аустралијско западно време",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Централно-индонезијско време",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Источно-индонезијско време",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Западно-индонезијско време",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Аустралијско централно западно стандардно време",
               "",
               "Аустралијско централно западно летње време",
               "",
               "Аустралијско централно западно време",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Средње време по Гриничу",
                    "GMT",
                    "Британија, летње време",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Координисано универзално време",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Средње време по Гриничу",
                    "GMT",
                    "Ирска, стандардно време",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Координисано универзално време",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "Turkey", Turkey },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Координисано универзално време",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Средње време по Гриничу",
                    "GMT",
                    "Британија, летње време",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Координисано универзално време",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "Координисано универзално време",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Istanbul", Turkey },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Координисано универзално време",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Средње време по Гриничу",
                    "GMT",
                    "Ирска, стандардно време",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Средње време по Гриничу",
                    "GMT",
                    "Британија, летње време",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Средње време по Гриничу",
                    "GMT",
                    "Британија, летње време",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Средње време по Гриничу",
                    "GMT",
                    "Британија, летње време",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Средње време по Гриничу",
                    "GMT",
                    "Британија, летње време",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Istanbul", Turkey },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Средње време по Гриничу",
                    "GMT",
                    "Британија, летње време",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Аден" },
            { "timezone.excity.Asia/Baku", "Баку" },
            { "timezone.excity.Asia/Dili", "Дили" },
            { "timezone.excity.Asia/Gaza", "Газа" },
            { "timezone.excity.Asia/Hovd", "Ховд" },
            { "timezone.excity.Asia/Omsk", "Омск" },
            { "timezone.excity.Asia/Oral", "Орал" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Аман" },
            { "timezone.excity.Asia/Aqtau", "Актау" },
            { "timezone.excity.Asia/Chita", "Чита" },
            { "timezone.excity.Asia/Dhaka", "Дака" },
            { "timezone.excity.Asia/Dubai", "Дубаи" },
            { "timezone.excity.Asia/Kabul", "Кабул" },
            { "timezone.excity.Asia/Macau", "Макао" },
            { "timezone.excity.Asia/Qatar", "Катар" },
            { "timezone.excity.Asia/Seoul", "Сеул" },
            { "timezone.excity.Asia/Tokyo", "Токио" },
            { "timezone.excity.Asia/Tomsk", "Томск" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Џуба" },
            { "timezone.excity.Africa/Lome", "Ломе" },
            { "timezone.excity.Asia/Almaty", "Алмати" },
            { "timezone.excity.Asia/Anadyr", "Анадир" },
            { "timezone.excity.Asia/Aqtobe", "Акутобе" },
            { "timezone.excity.Asia/Atyrau", "Атирау" },
            { "timezone.excity.Asia/Beirut", "Бејрут" },
            { "timezone.excity.Asia/Brunei", "Брунеј" },
            { "timezone.excity.Asia/Hebron", "Хеброн" },
            { "timezone.excity.Asia/Kuwait", "Кувајт" },
            { "timezone.excity.Asia/Manila", "Манила" },
            { "timezone.excity.Asia/Muscat", "Мускат" },
            { "timezone.excity.Asia/Riyadh", "Ријад" },
            { "timezone.excity.Asia/Saigon", "Хо Ши Мин" },
            { "timezone.excity.Asia/Taipei", "Тајпеј" },
            { "timezone.excity.Asia/Tehran", "Техеран" },
            { "timezone.excity.Asia/Urumqi", "Урумћи" },
            { "timezone.excity.Etc/Unknown", "Непознат град" },
            { "timezone.excity.Europe/Kiev", "Кијев" },
            { "timezone.excity.Europe/Oslo", "Осло" },
            { "timezone.excity.Europe/Riga", "Рига" },
            { "timezone.excity.Europe/Rome", "Рим" },
            { "timezone.excity.Indian/Mahe", "Махе" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Акра" },
            { "timezone.excity.Africa/Cairo", "Каиро" },
            { "timezone.excity.Africa/Ceuta", "Сеута" },
            { "timezone.excity.Africa/Dakar", "Дакар" },
            { "timezone.excity.Africa/Lagos", "Лагос" },
            { "timezone.excity.Africa/Tunis", "Тунис" },
            { "timezone.excity.America/Adak", "Адак" },
            { "timezone.excity.America/Lima", "Лима" },
            { "timezone.excity.America/Nome", "Ном" },
            { "timezone.excity.Asia/Baghdad", "Багдад" },
            { "timezone.excity.Asia/Bahrain", "Бахреин" },
            { "timezone.excity.Asia/Bangkok", "Бангкок" },
            { "timezone.excity.Asia/Barnaul", "Барнаул" },
            { "timezone.excity.Asia/Bishkek", "Бишкек" },
            { "timezone.excity.Asia/Colombo", "Коломбо" },
            { "timezone.excity.Asia/Irkutsk", "Иркуцк" },
            { "timezone.excity.Asia/Jakarta", "Џакарта" },
            { "timezone.excity.Asia/Karachi", "Карачи" },
            { "timezone.excity.Asia/Kuching", "Кучинг" },
            { "timezone.excity.Asia/Magadan", "Магадан" },
            { "timezone.excity.Asia/Nicosia", "Никозија" },
            { "timezone.excity.Asia/Rangoon", "Рангун" },
            { "timezone.excity.Asia/Tbilisi", "Тбилиси" },
            { "timezone.excity.Asia/Thimphu", "Тимпу" },
            { "timezone.excity.Asia/Yakutsk", "Јакутск" },
            { "timezone.excity.Asia/Yerevan", "Јереван" },
            { "timezone.excity.Europe/Kirov", "Киров" },
            { "timezone.excity.Europe/Malta", "Малта" },
            { "timezone.excity.Europe/Minsk", "Минск" },
            { "timezone.excity.Europe/Paris", "Париз" },
            { "timezone.excity.Europe/Sofia", "Софија" },
            { "timezone.excity.Europe/Vaduz", "Вадуз" },
            { "timezone.excity.Indian/Cocos", "Кокос" },
            { "timezone.excity.Pacific/Apia", "Апија" },
            { "timezone.excity.Pacific/Fiji", "Фиџи" },
            { "timezone.excity.Pacific/Guam", "Гуам" },
            { "timezone.excity.Pacific/Niue", "Ниуе" },
            { "timezone.excity.Pacific/Truk", "Трук" },
            { "timezone.excity.Pacific/Wake", "Вејк" },
            { "timezone.excity.Africa/Asmera", "Асмера" },
            { "timezone.excity.Africa/Bamako", "Бамако" },
            { "timezone.excity.Africa/Bangui", "Бангуи" },
            { "timezone.excity.Africa/Banjul", "Банжул" },
            { "timezone.excity.Africa/Bissau", "Бисао" },
            { "timezone.excity.Africa/Douala", "Дуала" },
            { "timezone.excity.Africa/Harare", "Хараре" },
            { "timezone.excity.Africa/Kigali", "Кигали" },
            { "timezone.excity.Africa/Luanda", "Луанда" },
            { "timezone.excity.Africa/Lusaka", "Лусака" },
            { "timezone.excity.Africa/Malabo", "Малабо" },
            { "timezone.excity.Africa/Maputo", "Мапуто" },
            { "timezone.excity.Africa/Maseru", "Масеру" },
            { "timezone.excity.Africa/Niamey", "Нијамеј" },
            { "timezone.excity.America/Aruba", "Аруба" },
            { "timezone.excity.America/Bahia", "Баија" },
            { "timezone.excity.America/Belem", "Белем" },
            { "timezone.excity.America/Boise", "Бојзи" },
            { "timezone.excity.America/Jujuy", "Жужуи" },
            { "timezone.excity.America/Sitka", "Ситка" },
            { "timezone.excity.America/Thule", "Тул" },
            { "timezone.excity.Asia/Ashgabat", "Ашхабад" },
            { "timezone.excity.Asia/Calcutta", "Калкута" },
            { "timezone.excity.Asia/Damascus", "Дамаск" },
            { "timezone.excity.Asia/Dushanbe", "Душанбе" },
            { "timezone.excity.Asia/Jayapura", "Џајапура" },
            { "timezone.excity.Asia/Katmandu", "Катманду" },
            { "timezone.excity.Asia/Khandyga", "Хандига" },
            { "timezone.excity.Asia/Makassar", "Макасар" },
            { "timezone.excity.Asia/Qostanay", "Костанај" },
            { "timezone.excity.Asia/Sakhalin", "Сахалин" },
            { "timezone.excity.Asia/Shanghai", "Шангај" },
            { "timezone.excity.Asia/Tashkent", "Ташкент" },
            { "timezone.excity.Asia/Ust-Nera", "Уст-Нера" },
            { "timezone.excity.Europe/Athens", "Атина" },
            { "timezone.excity.Europe/Berlin", "Берлин" },
            { "timezone.excity.Europe/Dublin", "Даблин" },
            { "timezone.excity.Europe/Jersey", "Џерзи" },
            { "timezone.excity.Europe/Lisbon", "Лисабон" },
            { "timezone.excity.Europe/London", "Лондон" },
            { "timezone.excity.Europe/Madrid", "Мадрид" },
            { "timezone.excity.Europe/Monaco", "Монако" },
            { "timezone.excity.Europe/Moscow", "Москва" },
            { "timezone.excity.Europe/Prague", "Праг" },
            { "timezone.excity.Europe/Samara", "Самара" },
            { "timezone.excity.Europe/Skopje", "Скопље" },
            { "timezone.excity.Europe/Tirane", "Тирана" },
            { "timezone.excity.Europe/Vienna", "Беч" },
            { "timezone.excity.Europe/Warsaw", "Варшава" },
            { "timezone.excity.Europe/Zagreb", "Загреб" },
            { "timezone.excity.Europe/Zurich", "Цирих" },
            { "timezone.excity.Indian/Chagos", "Чагос" },
            { "timezone.excity.Indian/Comoro", "Коморо" },
            { "timezone.excity.Pacific/Efate", "Ефат" },
            { "timezone.excity.Pacific/Nauru", "Науру" },
            { "timezone.excity.Pacific/Palau", "Палау" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Абиџан" },
            { "timezone.excity.Africa/Algiers", "Алжир" },
            { "timezone.excity.Africa/Conakry", "Конакри" },
            { "timezone.excity.Africa/Kampala", "Кампала" },
            { "timezone.excity.Africa/Mbabane", "Мбабане" },
            { "timezone.excity.Africa/Nairobi", "Најроби" },
            { "timezone.excity.Africa/Tripoli", "Триполи" },
            { "timezone.excity.America/Belize", "Белизе" },
            { "timezone.excity.America/Bogota", "Богота" },
            { "timezone.excity.America/Cancun", "Канкун" },
            { "timezone.excity.America/Cayman", "Кајманска Острва" },
            { "timezone.excity.America/Cuiaba", "Куиаба" },
            { "timezone.excity.America/Dawson", "Досон" },
            { "timezone.excity.America/Denver", "Денвер" },
            { "timezone.excity.America/Guyana", "Гвајана" },
            { "timezone.excity.America/Havana", "Хавана" },
            { "timezone.excity.America/Inuvik", "Инувик" },
            { "timezone.excity.America/Juneau", "Жуно" },
            { "timezone.excity.America/La_Paz", "Ла Паз" },
            { "timezone.excity.America/Maceio", "Масејо" },
            { "timezone.excity.America/Manaus", "Манаус" },
            { "timezone.excity.America/Merida", "Мерида" },
            { "timezone.excity.America/Nassau", "Насау" },
            { "timezone.excity.America/Panama", "Панама" },
            { "timezone.excity.America/Recife", "Ресифе" },
            { "timezone.excity.America/Regina", "Регина" },
            { "timezone.excity.Asia/Famagusta", "Фамагуста" },
            { "timezone.excity.Asia/Hong_Kong", "Хонгконг" },
            { "timezone.excity.Asia/Jerusalem", "Јерусалим" },
            { "timezone.excity.Asia/Kamchatka", "Камчатка" },
            { "timezone.excity.Asia/Pontianak", "Понтијанак" },
            { "timezone.excity.Asia/Pyongyang", "Пјонгјанг" },
            { "timezone.excity.Asia/Qyzylorda", "Кизилорда" },
            { "timezone.excity.Asia/Samarkand", "Самарканд" },
            { "timezone.excity.Asia/Singapore", "Сингапур" },
            { "timezone.excity.Asia/Vientiane", "Вијентијан" },
            { "timezone.excity.Europe/Andorra", "Андора" },
            { "timezone.excity.Europe/Saratov", "Саратов" },
            { "timezone.excity.Europe/Tallinn", "Талин" },
            { "timezone.excity.Europe/Vatican", "Ватикан" },
            { "timezone.excity.Europe/Vilnius", "Вилњус" },
            { "timezone.excity.Indian/Mayotte", "Мајот" },
            { "timezone.excity.Indian/Reunion", "Реунион" },
            { "timezone.excity.Pacific/Easter", "Ускршње острво" },
            { "timezone.excity.Pacific/Kosrae", "Кошре" },
            { "timezone.excity.Pacific/Majuro", "Мајуро" },
            { "timezone.excity.Pacific/Midway", "Мидвеј" },
            { "timezone.excity.Pacific/Noumea", "Нумеа" },
            { "timezone.excity.Pacific/Ponape", "Понапе" },
            { "timezone.excity.Pacific/Saipan", "Сајпан" },
            { "timezone.excity.Pacific/Tahiti", "Тахити" },
            { "timezone.excity.Pacific/Tarawa", "Тарава" },
            { "timezone.excity.Pacific/Wallis", "Валис" },
            { "timezone.excity.Africa/Blantyre", "Блантир" },
            { "timezone.excity.Africa/Djibouti", "Џибути" },
            { "timezone.excity.Africa/El_Aaiun", "Ел Ајун" },
            { "timezone.excity.Africa/Freetown", "Фритаун" },
            { "timezone.excity.Africa/Gaborone", "Габорон" },
            { "timezone.excity.Africa/Khartoum", "Картум" },
            { "timezone.excity.Africa/Kinshasa", "Киншаса" },
            { "timezone.excity.Africa/Monrovia", "Монровија" },
            { "timezone.excity.Africa/Ndjamena", "Нџамена" },
            { "timezone.excity.Africa/Sao_Tome", "Сао Томе" },
            { "timezone.excity.Africa/Windhoek", "Виндхук" },
            { "timezone.excity.America/Antigua", "Антигва" },
            { "timezone.excity.America/Caracas", "Каракас" },
            { "timezone.excity.America/Cayenne", "Кајен" },
            { "timezone.excity.America/Chicago", "Чикаго" },
            { "timezone.excity.America/Cordoba", "Кордоба" },
            { "timezone.excity.America/Creston", "Крестон" },
            { "timezone.excity.America/Curacao", "Курасао" },
            { "timezone.excity.America/Detroit", "Детроит" },
            { "timezone.excity.America/Godthab", "Готхаб" },
            { "timezone.excity.America/Grenada", "Гренада" },
            { "timezone.excity.America/Halifax", "Халифакс" },
            { "timezone.excity.America/Iqaluit", "Иквалуит" },
            { "timezone.excity.America/Jamaica", "Јамајка" },
            { "timezone.excity.America/Managua", "Манагва" },
            { "timezone.excity.America/Marigot", "Мариго" },
            { "timezone.excity.America/Mendoza", "Мендоса" },
            { "timezone.excity.America/Moncton", "Монктон" },
            { "timezone.excity.America/Noronha", "Нороња" },
            { "timezone.excity.America/Ojinaga", "Охинага" },
            { "timezone.excity.America/Phoenix", "Финикс" },
            { "timezone.excity.America/Tijuana", "Тихуана" },
            { "timezone.excity.America/Toronto", "Торонто" },
            { "timezone.excity.America/Tortola", "Тортола" },
            { "timezone.excity.America/Yakutat", "Јакутат" },
            { "timezone.excity.Asia/Phnom_Penh", "Пном Пен" },
            { "timezone.excity.Atlantic/Azores", "Азори" },
            { "timezone.excity.Atlantic/Canary", "Канарска острва" },
            { "timezone.excity.Atlantic/Faeroe", "Фарска Острва" },
            { "timezone.excity.Australia/Eucla", "Иукла" },
            { "timezone.excity.Australia/Perth", "Перт" },
            { "timezone.excity.Europe/Belgrade", "Београд" },
            { "timezone.excity.Europe/Brussels", "Брисел" },
            { "timezone.excity.Europe/Budapest", "Будимпешта" },
            { "timezone.excity.Europe/Busingen", "Бисинген" },
            { "timezone.excity.Europe/Chisinau", "Кишињев" },
            { "timezone.excity.Europe/Guernsey", "Гернзи" },
            { "timezone.excity.Europe/Helsinki", "Хелсинки" },
            { "timezone.excity.Europe/Istanbul", "Истанбул" },
            { "timezone.excity.Europe/Sarajevo", "Сарајево" },
            { "timezone.excity.Indian/Maldives", "Малдиви" },
            { "timezone.excity.Pacific/Chatham", "Чатам" },
            { "timezone.excity.Pacific/Fakaofo", "Факаофо" },
            { "timezone.excity.Pacific/Gambier", "Гамбије" },
            { "timezone.excity.Pacific/Norfolk", "Норфолк" },
            { "timezone.excity.Africa/Bujumbura", "Буџумбура" },
            { "timezone.excity.Africa/Mogadishu", "Могадиш" },
            { "timezone.excity.America/Anguilla", "Ангвила" },
            { "timezone.excity.America/Asuncion", "Асунсион" },
            { "timezone.excity.America/Barbados", "Барбадос" },
            { "timezone.excity.America/Dominica", "Доминика" },
            { "timezone.excity.America/Edmonton", "Едмонтон" },
            { "timezone.excity.America/Eirunepe", "Еирунепе" },
            { "timezone.excity.America/Mazatlan", "Мазатлан" },
            { "timezone.excity.America/Miquelon", "Микелон" },
            { "timezone.excity.America/New_York", "Њујорк" },
            { "timezone.excity.America/Resolute", "Ресолут" },
            { "timezone.excity.America/Santarem", "Сантарем" },
            { "timezone.excity.America/Santiago", "Сантјаго" },
            { "timezone.excity.America/St_Johns", "Св. Џон" },
            { "timezone.excity.America/St_Kitts", "Сент Китс" },
            { "timezone.excity.America/St_Lucia", "Св. Луција" },
            { "timezone.excity.America/Winnipeg", "Винипег" },
            { "timezone.excity.Antarctica/Casey", "Кејси" },
            { "timezone.excity.Antarctica/Davis", "Дејвис" },
            { "timezone.excity.Antarctica/Syowa", "Шова" },
            { "timezone.excity.Antarctica/Troll", "Трол" },
            { "timezone.excity.Asia/Krasnoyarsk", "Краснојарск" },
            { "timezone.excity.Asia/Novosibirsk", "Новосибирск" },
            { "timezone.excity.Asia/Ulaanbaatar", "Улан Батор" },
            { "timezone.excity.Asia/Vladivostok", "Владивосток" },
            { "timezone.excity.Atlantic/Bermuda", "Бермуда" },
            { "timezone.excity.Atlantic/Madeira", "Мадеира" },
            { "timezone.excity.Atlantic/Stanley", "Стенли" },
            { "timezone.excity.Australia/Darwin", "Дарвин" },
            { "timezone.excity.Australia/Hobart", "Хобарт" },
            { "timezone.excity.Australia/Sydney", "Сиднеј" },
            { "timezone.excity.Europe/Amsterdam", "Амстердам" },
            { "timezone.excity.Europe/Astrakhan", "Астракан" },
            { "timezone.excity.Europe/Bucharest", "Букурешт" },
            { "timezone.excity.Europe/Gibraltar", "Гибралтар" },
            { "timezone.excity.Europe/Ljubljana", "Љубљана" },
            { "timezone.excity.Europe/Mariehamn", "Марихамн" },
            { "timezone.excity.Europe/Podgorica", "Подгорица" },
            { "timezone.excity.Europe/Stockholm", "Стокхолм" },
            { "timezone.excity.Europe/Ulyanovsk", "Уљановск" },
            { "timezone.excity.Europe/Volgograd", "Волгоград" },
            { "timezone.excity.Indian/Christmas", "Божић" },
            { "timezone.excity.Indian/Kerguelen", "Кергелен" },
            { "timezone.excity.Indian/Mauritius", "Маурицијус" },
            { "timezone.excity.Pacific/Auckland", "Окланд" },
            { "timezone.excity.Pacific/Funafuti", "Фунафути" },
            { "timezone.excity.Pacific/Honolulu", "Хонолулу" },
            { "timezone.excity.Pacific/Pitcairn", "Питкерн" },
            { "timezone.excity.Africa/Casablanca", "Казабланка" },
            { "timezone.excity.Africa/Libreville", "Либревил" },
            { "timezone.excity.Africa/Lubumbashi", "Лубумбаши" },
            { "timezone.excity.Africa/Nouakchott", "Нуакшот" },
            { "timezone.excity.Africa/Porto-Novo", "Порто Ново" },
            { "timezone.excity.America/Anchorage", "Енкориџ" },
            { "timezone.excity.America/Araguaina", "Арагвајана" },
            { "timezone.excity.America/Boa_Vista", "Боа Виста" },
            { "timezone.excity.America/Catamarca", "Катамарка" },
            { "timezone.excity.America/Chihuahua", "Чихуахуа" },
            { "timezone.excity.America/Coyhaique", "Којајке" },
            { "timezone.excity.America/Fortaleza", "Форталеза" },
            { "timezone.excity.America/Glace_Bay", "Глејс Беј" },
            { "timezone.excity.America/Goose_Bay", "Гус Беј" },
            { "timezone.excity.America/Guatemala", "Гватемала" },
            { "timezone.excity.America/Guayaquil", "Гвајакил" },
            { "timezone.excity.America/Matamoros", "Матаморос" },
            { "timezone.excity.America/Menominee", "Меномини" },
            { "timezone.excity.America/Monterrey", "Монтереј" },
            { "timezone.excity.America/Sao_Paulo", "Сао Паоло" },
            { "timezone.excity.America/St_Thomas", "Св. Тома" },
            { "timezone.excity.America/Vancouver", "Ванкувер" },
            { "timezone.excity.Antarctica/Mawson", "Мосон" },
            { "timezone.excity.Antarctica/Palmer", "Палмер" },
            { "timezone.excity.Antarctica/Vostok", "Восток" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Куала Лумпур" },
            { "timezone.excity.Asia/Novokuznetsk", "Новокузњецк" },
            { "timezone.excity.Europe/Bratislava", "Братислава" },
            { "timezone.excity.Europe/Copenhagen", "Копенхаген" },
            { "timezone.excity.Europe/Luxembourg", "Луксембург" },
            { "timezone.excity.Europe/San_Marino", "Сан Марино" },
            { "timezone.excity.Europe/Simferopol", "Симферопољ" },
            { "timezone.excity.Pacific/Enderbury", "Кантон" },
            { "timezone.excity.Pacific/Galapagos", "Галапагос" },
            { "timezone.excity.Pacific/Kwajalein", "Кваџалејин" },
            { "timezone.excity.Pacific/Marquesas", "Маркиз" },
            { "timezone.excity.Pacific/Pago_Pago", "Паго Паго" },
            { "timezone.excity.Pacific/Rarotonga", "Раротонга" },
            { "timezone.excity.Pacific/Tongatapu", "Тонгатапу" },
            { "timezone.excity.Africa/Addis_Ababa", "Адис Абеба" },
            { "timezone.excity.Africa/Brazzaville", "Бразавил" },
            { "timezone.excity.Africa/Ouagadougou", "Уагадугу" },
            { "timezone.excity.America/Costa_Rica", "Костарика" },
            { "timezone.excity.America/Grand_Turk", "Гранд Турк" },
            { "timezone.excity.America/Guadeloupe", "Гвадалупе" },
            { "timezone.excity.America/Hermosillo", "Хермосиљо" },
            { "timezone.excity.America/Kralendijk", "Кралендајк" },
            { "timezone.excity.America/Louisville", "Луивиле" },
            { "timezone.excity.America/Martinique", "Мартиник" },
            { "timezone.excity.America/Metlakatla", "Метлакатла" },
            { "timezone.excity.America/Montevideo", "Монтевидео" },
            { "timezone.excity.America/Montserrat", "Монтсерат" },
            { "timezone.excity.America/Paramaribo", "Парамарибо" },
            { "timezone.excity.America/Rio_Branco", "Рио Бранко" },
            { "timezone.excity.America/St_Vincent", "Сент Винсент" },
            { "timezone.excity.America/Whitehorse", "Вајтхорс" },
            { "timezone.excity.Antarctica/McMurdo", "Макмурдо" },
            { "timezone.excity.Antarctica/Rothera", "Ротера" },
            { "timezone.excity.Asia/Srednekolymsk", "Средњеколимск" },
            { "timezone.excity.Asia/Yekaterinburg", "Јекатеринбург" },
            { "timezone.excity.Atlantic/Reykjavik", "Рејкјавик" },
            { "timezone.excity.Atlantic/St_Helena", "Света Јелена" },
            { "timezone.excity.Australia/Adelaide", "Аделејд" },
            { "timezone.excity.Australia/Brisbane", "Бризбејн" },
            { "timezone.excity.Australia/Lindeman", "Линдеман" },
            { "timezone.excity.Europe/Isle_of_Man", "Острво Ман" },
            { "timezone.excity.Europe/Kaliningrad", "Калињинград" },
            { "timezone.excity.Pacific/Kiritimati", "Киритимати" },
            { "timezone.excity.Africa/Johannesburg", "Јоханесбург" },
            { "timezone.excity.America/El_Salvador", "Салвадор" },
            { "timezone.excity.America/Fort_Nelson", "Форт Нелсон" },
            { "timezone.excity.America/Los_Angeles", "Лос Анђелес" },
            { "timezone.excity.America/Mexico_City", "Мексико Сити" },
            { "timezone.excity.America/Porto_Velho", "Порто Вељо" },
            { "timezone.excity.America/Puerto_Rico", "Порто Рико" },
            { "timezone.excity.America/Tegucigalpa", "Тегусигалпа" },
            { "timezone.excity.Arctic/Longyearbyen", "Лонгјербјен" },
            { "timezone.excity.Atlantic/Cape_Verde", "Зеленортска Острва" },
            { "timezone.excity.Australia/Lord_Howe", "Лорд Хау" },
            { "timezone.excity.Australia/Melbourne", "Мелбурн" },
            { "timezone.excity.Indian/Antananarivo", "Антананариво" },
            { "timezone.excity.Pacific/Guadalcanal", "Гвадалканал" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Дар-ес-Салам" },
            { "timezone.excity.America/Blanc-Sablon", "Бланк-Сејблон" },
            { "timezone.excity.America/Buenos_Aires", "Буенос Ајрес" },
            { "timezone.excity.America/Campo_Grande", "Кампо Гранде" },
            { "timezone.excity.America/Danmarkshavn", "Данмарксхаген" },
            { "timezone.excity.America/Dawson_Creek", "Досон Крик" },
            { "timezone.excity.America/Indiana/Knox", "Нокс, Индијана" },
            { "timezone.excity.America/Indianapolis", "Индианаполис" },
            { "timezone.excity.America/Punta_Arenas", "Пунта Аренас" },
            { "timezone.excity.America/Rankin_Inlet", "Ранкин Инлет" },
            { "timezone.excity.America/Scoresbysund", "Скорезбисунд" },
            { "timezone.excity.Antarctica/Macquarie", "Меквори" },
            { "timezone.excity.Pacific/Bougainville", "Буганвил" },
            { "timezone.excity.Pacific/Port_Moresby", "Порт Морзби" },
            { "timezone.excity.America/Cambridge_Bay", "Кембриџ Беј" },
            { "timezone.excity.America/Ciudad_Juarez", "Сиудад Хуарез" },
            { "timezone.excity.America/Coral_Harbour", "Корал Харбур" },
            { "timezone.excity.America/Indiana/Vevay", "Вевај, Индијана" },
            { "timezone.excity.America/Lower_Princes", "Лоуер Принсиз Квортер" },
            { "timezone.excity.America/Port_of_Spain", "Порт оф Спејн" },
            { "timezone.excity.America/Santo_Domingo", "Санто Доминго" },
            { "timezone.excity.America/St_Barthelemy", "Св. Бартоломeј" },
            { "timezone.excity.America/Swift_Current", "Свифт Курент" },
            { "timezone.excity.Australia/Broken_Hill", "Брокен Хил" },
            { "timezone.excity.America/Bahia_Banderas", "Баија Бандерас" },
            { "timezone.excity.America/Port-au-Prince", "Порт о Пренс" },
            { "timezone.excity.Atlantic/South_Georgia", "Јужна Џорџија" },
            { "timezone.excity.America/Argentina/Salta", "Салта" },
            { "timezone.excity.America/Indiana/Marengo", "Маренго, Индијана" },
            { "timezone.excity.America/Indiana/Winamac", "Винамак, Индијана" },
            { "timezone.excity.America/Argentina/Tucuman", "Тукуман" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ушуаија" },
            { "timezone.excity.America/Indiana/Tell_City", "Тел Сити, Индијана" },
            { "timezone.excity.America/Indiana/Vincennes", "Винценес, Индијана" },
            { "timezone.excity.Antarctica/DumontDUrville", "Димон д’Урвил" },
            { "timezone.excity.America/Argentina/La_Rioja", "Ла Риоха" },
            { "timezone.excity.America/Argentina/San_Juan", "Сан Хуан" },
            { "timezone.excity.America/Argentina/San_Luis", "Сан Луи" },
            { "timezone.excity.America/Indiana/Petersburg", "Питерсбург, Индијана" },
            { "timezone.excity.America/Kentucky/Monticello", "Монтичело, Кентаки" },
            { "timezone.excity.America/North_Dakota/Beulah", "Бијула, Северна Дакота" },
            { "timezone.excity.America/North_Dakota/Center", "Центар, Северна Дакота" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Рио Гаљегос" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Нови Салем, Северна Дакота" },
        };
        return data;
    }
}
