/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sah extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "GMT",
               "GMT",
               "",
               "BST",
               "",
               "GMT",
            };
        final String[] Iran = new String[] {
               "Ираан сүрүн кэмэ",
               "",
               "Ыраан сайыҥҥы кэмэ",
               "",
               "Ираан кэмэ",
               "",
            };
        final String[] Omsk = new String[] {
               "Омскай сүрүн кэмэ",
               "",
               "Омскай сайыҥҥы кэмэ",
               "",
               "Омскай кэмэ",
               "",
            };
        final String[] China = new String[] {
               "Кытай сүрүн кэмэ",
               "CST",
               "Кытай сайыҥҥы кэмэ",
               "CDT",
               "Кытай кэмэ",
               "CT",
            };
        final String[] India = new String[] {
               "Ииндийэ сүрүн кэмэ",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Дьоппуон сүрүн кэмэ",
               "JST",
               "Дьоппуон сайыҥҥы кэмэ",
               "JDT",
               "Дьоппуон кэмэ",
               "JT",
            };
        final String[] Korea = new String[] {
               "Кэриэй сүрүн кэмэ",
               "KST",
               "Кэриэй сайыҥҥы кэмэ",
               "KST",
               "Кэриэй кэмэ",
               "KST",
            };
        final String[] Moscow = new String[] {
               "Москуба сүрүн кэмэ",
               "MSK",
               "Москуба сайыҥҥы кэмэ",
               "MSK",
               "Москуба кэмэ",
               "MSK",
            };
        final String[] Arabian = new String[] {
               "Арааб сүрүн кэмэ",
               "",
               "Арааб сайыҥҥы кэмэ",
               "",
               "Арааб кэмэ",
               "",
            };
        final String[] Armenia = new String[] {
               "Эрмээн сүрүн кэмэ",
               "",
               "Эрмээн сайыҥҥы кэмэ",
               "",
               "Эрмээн кэмэ",
               "",
            };
        final String[] Georgia = new String[] {
               "Курусуун сүрүн кэмэ",
               "",
               "Курусуун сайыҥҥы кэмэ",
               "",
               "Курусуун кэмэ",
               "",
            };
        final String[] Magadan = new String[] {
               "Магадаан сүрүн кэмэ",
               "",
               "Магадаан сайыҥҥы кэмэ",
               "",
               "Магадаан кэмэ",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Дьокуускай сүрүн кэмэ",
               "",
               "Дьокуускай сайыҥҥы кэмэ",
               "",
               "Дьокуускай кэмэ",
               "",
            };
        final String[] Mongolia = new String[] {
               "Улан Баатар сүрүн кэмэ",
               "",
               "Улан Баатар сайыҥҥы кэмэ",
               "",
               "Улан Баатар кэмэ",
               "",
            };
        final String[] Pakistan = new String[] {
               "Пакистаан сүрүн кэмэ",
               "PKT",
               "Пакистаан сайыҥҥы кэмэ",
               "PKST",
               "Пакистаан кэмэ",
               "PKT",
            };
        final String[] Kyrgystan = new String[] {
               "Кыргыстаан кэмэ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Красноярскай сүрүн кэмэ",
               "",
               "Красноярскай сайыҥҥы кэмэ",
               "",
               "Красноярскай кэмэ",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Саҥа Сэйлэнд сүрүн кэмэ",
               "NZST",
               "Саҥа Сэйлэнд сайыҥҥы кэмэ",
               "NZDT",
               "Саҥа Зеландия кэмэ",
               "NZT",
            };
        final String[] Vladivostok = new String[] {
               "Быладьыбастыак сүрүн кэмэ",
               "",
               "Быладьыбастыак сайыҥҥы кэмэ",
               "",
               "Владивосток кэмэ",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Екатеринбуур сүрүн кэмэ",
               "",
               "Екатеринбуур сайыҥҥы кэмэ",
               "",
               "Екатеринбург кэмэ",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Киин Австралия сүрүн кэмэ",
               "ACST",
               "Киин Австралия сайыҥҥы кэмэ",
               "ACDT",
               "Киин Австралия кэмэ",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Илин Австралия сүрүн кэмэ",
               "AEST",
               "Илин Австралия сайыҥҥы кэмэ",
               "AEDT",
               "Илин Австралия кэмэ",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Арҕаа Австралия сүрүн кэмэ",
               "AWST",
               "Арҕаа Австралия сайыҥҥы кэмэ",
               "AWDT",
               "Арҕаа Австралия кэмэ",
               "AWT",
            };
        final Object[][] data = new Object[][] {
            { "GMT", GMT },
            { "Asia/Tokyo", Japan },
            { "Asia/Shanghai", China },
            { "UTC", EMPTY_ZONE },
            { "GB", GMT },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "CTT", China },
            { "IST", India },
            { "JST", Japan },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PRC", China },
            { "ROK", Korea },
            { "Eire", GMT },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Japan", Japan },
            { "Etc/GMT", GMT },
            { "GB-Eire", GMT },
            { "Iceland", GMT },
            { "Etc/GMT0", GMT },
            { "Asia/Aden", Arabian },
            { "Asia/Omsk", Omsk },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Asia/Chita", Yakutsk },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "Africa/Lome", GMT },
            { "Asia/Harbin", China },
            { "Asia/Kuwait", Arabian },
            { "Asia/Riyadh", Arabian },
            { "Asia/Tehran", Iran },
            { "Africa/Accra", GMT },
            { "Africa/Dakar", GMT },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Magadan", Magadan },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Kirov", Moscow },
            { "Europe/Minsk", Moscow },
            { "Africa/Bamako", GMT },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Asia/Calcutta", India },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Europe/Dublin", GMT },
            { "Europe/Jersey", GMT },
            { "Europe/London", GMT },
            { "Europe/Moscow", Moscow },
            { "Africa/Abidjan", GMT },
            { "Africa/Conakry", GMT },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Pyongyang", Korea },
            { "Australia/West", Australia_Western },
            { "Europe/Belfast", GMT },
            { "Africa/Freetown", GMT },
            { "Africa/Monrovia", GMT },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Ulan_Bator", Mongolia },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Europe/Guernsey", GMT },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Volgograd", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "Africa/Nouakchott", GMT },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Simferopol", Moscow },
            { "Africa/Ouagadougou", GMT },
            { "Antarctica/McMurdo", New_Zealand },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Australia/Melbourne", Australia_Eastern },
            { "America/Danmarkshavn", GMT },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "timezone.excity.Asia/Baku", "Бакуу" },
            { "timezone.excity.Asia/Omsk", "Омскай" },
            { "timezone.excity.Asia/Chita", "Читаа" },
            { "timezone.excity.Asia/Dubai", "Дубаай" },
            { "timezone.excity.Asia/Kabul", "Кабуул" },
            { "timezone.excity.Asia/Almaty", "Алматы" },
            { "timezone.excity.Asia/Anadyr", "Анаадыр" },
            { "timezone.excity.Asia/Urumqi", "Урумчу" },
            { "timezone.excity.Etc/Unknown", "Биллибэт" },
            { "timezone.excity.Asia/Baghdad", "Багдаад" },
            { "timezone.excity.Asia/Barnaul", "Барнаул" },
            { "timezone.excity.Asia/Colombo", "Коломбо" },
            { "timezone.excity.Asia/Irkutsk", "Иркутскай" },
            { "timezone.excity.Asia/Magadan", "Магадаан" },
            { "timezone.excity.Asia/Yakutsk", "Дьокуускай" },
            { "timezone.excity.Asia/Ashgabat", "Асхабаат" },
            { "timezone.excity.Asia/Damascus", "Дамаас" },
            { "timezone.excity.Asia/Khandyga", "Хаандыга" },
            { "timezone.excity.Asia/Sakhalin", "Сахалиин" },
            { "timezone.excity.Asia/Ust-Nera", "Уус Ньара" },
            { "timezone.excity.Europe/Moscow", "Москуба" },
            { "timezone.excity.Europe/Samara", "Самаара" },
            { "timezone.excity.Asia/Kamchatka", "Камчаатка" },
            { "timezone.excity.Asia/Samarkand", "Самаркаан" },
            { "timezone.excity.Europe/Istanbul", "Стамбуул" },
            { "timezone.excity.Asia/Krasnoyarsk", "Красноярскай" },
            { "timezone.excity.Asia/Novosibirsk", "Новосибирскай" },
            { "timezone.excity.Asia/Ulaanbaatar", "Улан Баатар" },
            { "timezone.excity.Europe/Astrakhan", "Аастрахан" },
            { "timezone.excity.Europe/Ulyanovsk", "Ульяновскай" },
            { "timezone.excity.Europe/Simferopol", "Симферополь" },
            { "timezone.excity.Asia/Srednekolymsk", "Орто Халыма" },
            { "timezone.excity.Asia/Yekaterinburg", "Екатеринбуур" },
            { "timezone.excity.Europe/Kaliningrad", "Калининград" },
        };
        return data;
    }
}
