from collections.abc import Iterable, Mapping
from re import Pattern

ETAG_MATCH: Pattern[str]
MONTHS: list[str]
RFC1123_DATE: Pattern[str]
RFC850_DATE: Pattern[str]
ASCTIME_DATE: Pattern[str]
RFC3986_GENDELIMS: str
RFC3986_SUBDELIMS: str

def urlencode(
    query: (
        Mapping[str, str | bytes | int | Iterable[str | bytes | int]]
        | Iterable[tuple[str, str | bytes | int | Iterable[str | bytes | int]]]
        | None
    ),
    doseq: bool = False,
) -> str: ...
def http_date(epoch_seconds: float | None = None) -> str: ...
def parse_http_date(date: str) -> int: ...
def parse_http_date_safe(date: str) -> int | None: ...
def base36_to_int(s: str) -> int: ...
def int_to_base36(i: int) -> str: ...
def urlsafe_base64_encode(s: bytes) -> str: ...
def urlsafe_base64_decode(s: str) -> bytes: ...
def parse_etags(etag_str: str) -> list[str]: ...
def quote_etag(etag_str: str) -> str: ...
def is_same_domain(host: str, pattern: str) -> bool: ...
def url_has_allowed_host_and_scheme(
    url: str | None, allowed_hosts: str | Iterable[str] | None, require_https: bool = False
) -> bool: ...
def escape_leading_slashes(url: str) -> str: ...
def content_disposition_header(as_attachment: bool, filename: str) -> str | None: ...
def parse_header_parameters(line: str) -> tuple[str, dict[str, str]]: ...
