from collections.abc import Sequence
from pathlib import Path
from typing import Any

from django.contrib.gis.geos import Point

GEOIP_SETTINGS: dict[str, Any]

class GeoIP2Exception(Exception): ...

class GeoIP2:
    MODE_AUTO: int
    MODE_MMAP_EXT: int
    MODE_MMAP: int
    MODE_FILE: int
    MODE_MEMORY: int
    cache_options: frozenset[int]
    def __init__(
        self, path: Path | str | None = ..., cache: int = ..., country: Any | None = ..., city: Any | None = ...
    ) -> None: ...
    def __del__(self) -> None: ...
    def city(self, query: str) -> dict[str, Any]: ...
    def country_code(self, query: str) -> str: ...
    def country_name(self, query: str) -> str: ...
    def country(self, query: str) -> dict[str, Any]: ...
    def coords(self, query: str, ordering: Sequence[str] = ...) -> tuple[float, float] | tuple[None, None]: ...
    def lon_lat(self, query: str) -> tuple[float, float] | tuple[None, None]: ...
    def lat_lon(self, query: str) -> tuple[float, float] | tuple[None, None]: ...
    def geos(self, query: str) -> Point: ...
    @property
    def info(self) -> str: ...
    @classmethod
    def open(cls, full_path: Path | str | None, cache: int) -> Any: ...
