/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.cache;

import com.intellij.ml.inline.completion.impl.AnalyzedMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.MLCompletionProposal;
import com.intellij.ml.inline.completion.impl.MLCompletionProposalsDetails;
import com.intellij.ml.inline.completion.impl.RawMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.cache.LightweightCacheKey;
import com.intellij.ml.inline.completion.impl.cache.LightweightEditorCache;
import com.intellij.openapi.Disposable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\b&\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0006J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0013\u001a\u00020\fJ\u0016\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\bJ\u0010\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\fJ\u0006\u0010\u0018\u001a\u00020\u0012J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\bH\u0002J\f\u0010\u001e\u001a\u00020\u001a*\u00020\bH\u0002J\b\u0010\u001f\u001a\u00020\u0012H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR#\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/intellij/ml/inline/completion/impl/cache/MLInlineCompletionCache;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "rawCache", "Lcom/intellij/ml/inline/completion/impl/cache/LightweightEditorCache;", "Lcom/intellij/ml/inline/completion/impl/RawMLCompletionProposal;", "analyzedCache", "Lcom/intellij/ml/inline/completion/impl/AnalyzedMLCompletionProposal;", "rawCacheItems", "", "Lkotlin/Pair;", "Lcom/intellij/ml/inline/completion/impl/cache/LightweightCacheKey;", "getRawCacheItems", "()Ljava/util/List;", "analyzedCacheItems", "getAnalyzedCacheItems", "cacheRaw", "", "key", "proposal", "getCachedRaw", "cacheAnalyzed", "getAnalyzed", "invalidate", "canBeUsedForAnalyzedCache", "", "currentKey", "cachedKey", "cachedProposal", "isEmpty", "dispose", "Companion", "intellij.fullLine.core.completion"})
@SourceDebugExtension(value={"SMAP\nMLInlineCompletionCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLInlineCompletionCache.kt\ncom/intellij/ml/inline/completion/impl/cache/MLInlineCompletionCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1611#2,9:94\n1863#2:103\n1864#2:105\n1620#2:106\n774#2:107\n865#2,2:108\n1734#2,3:111\n1#3:104\n1#3:110\n*S KotlinDebug\n*F\n+ 1 MLInlineCompletionCache.kt\ncom/intellij/ml/inline/completion/impl/cache/MLInlineCompletionCache\n*L\n25#1:94,9\n25#1:103\n25#1:105\n25#1:106\n32#1:107\n32#1:108,2\n74#1:111,3\n25#1:104\n*E\n"})
public abstract class MLInlineCompletionCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LightweightEditorCache<RawMLCompletionProposal> rawCache = new LightweightEditorCache(30L, CACHE_TTL, null);
    @NotNull
    private final LightweightEditorCache<AnalyzedMLCompletionProposal> analyzedCache = new LightweightEditorCache(30L, CACHE_TTL, null);
    private static final long CACHE_TTL = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES);
    private static final long CACHE_CAPACITY = 30L;

    @NotNull
    public final List<Pair<LightweightCacheKey, RawMLCompletionProposal>> getRawCacheItems() {
        return this.rawCache.getItems();
    }

    @NotNull
    public final List<Pair<LightweightCacheKey, AnalyzedMLCompletionProposal>> getAnalyzedCacheItems() {
        return this.analyzedCache.getItems();
    }

    public final void cacheRaw(@NotNull LightweightCacheKey key, @NotNull RawMLCompletionProposal proposal) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        this.rawCache.put(key, (RawMLCompletionProposal)((MLCompletionProposal)proposal));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RawMLCompletionProposal> getCachedRaw(@NotNull LightweightCacheKey key) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map<LightweightCacheKey, RawMLCompletionProposal> allMatching = this.rawCache.getMatching(key);
        Iterable $this$mapNotNull$iv = allMatching.entrySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            RawMLCompletionProposal rawMLCompletionProposal;
            String prefixToTrim;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((RawMLCompletionProposal)it.getValue()).getSuggestion().substring(0, key.getOffset() - ((LightweightCacheKey)it.getKey()).getOffset()), (String)"substring(...)");
            if (((RawMLCompletionProposal)it.getValue()).trimPrefix(prefixToTrim) == null) {
                rawMLCompletionProposal = null;
            } else {
                RawMLCompletionProposal source;
                RawMLCompletionProposal rawMLCompletionProposal2;
                RawMLCompletionProposal $this$getCachedRaw_u24lambda_u241_u24lambda_u240 = rawMLCompletionProposal2 = new RawMLCompletionProposal(source.getSuggestion(), source.getScore(), source.getDetails().clone(true));
                boolean bl3 = false;
                $this$getCachedRaw_u24lambda_u241_u24lambda_u240.getDetails().set(MLCompletionProposalsDetails.INSTANCE.getCACHED_TRIMMED_PREFIX_LENGTH(), prefixToTrim.length());
                rawMLCompletionProposal = rawMLCompletionProposal2;
            }
            if (rawMLCompletionProposal == null) continue;
            RawMLCompletionProposal it$iv$iv = rawMLCompletionProposal;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RawMLCompletionProposal it = (RawMLCompletionProposal)element$iv$iv;
            boolean bl = false;
            boolean bl5 = ((CharSequence)it.getSuggestion()).length() > 0;
            if (!bl5) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void cacheAnalyzed(@NotNull LightweightCacheKey key, @NotNull AnalyzedMLCompletionProposal proposal) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        this.analyzedCache.put(key, (AnalyzedMLCompletionProposal)((MLCompletionProposal)proposal));
    }

    @Nullable
    public final AnalyzedMLCompletionProposal getAnalyzed(@NotNull LightweightCacheKey key) {
        Map.Entry<LightweightCacheKey, AnalyzedMLCompletionProposal> entry;
        block6: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            AnalyzedMLCompletionProposal analyzedMLCompletionProposal = this.analyzedCache.getExact(key);
            if (analyzedMLCompletionProposal != null) {
                AnalyzedMLCompletionProposal it = analyzedMLCompletionProposal;
                boolean bl = false;
                return it;
            }
            for (Map.Entry<LightweightCacheKey, AnalyzedMLCompletionProposal> entry2 : this.analyzedCache.getMatching(key).entrySet()) {
                AnalyzedMLCompletionProposal analyzedMLCompletionProposal2;
                AnalyzedMLCompletionProposal proposal;
                boolean bl = false;
                LightweightCacheKey otherKey = entry2.getKey();
                if (this.canBeUsedForAnalyzedCache(key, otherKey, proposal = entry2.getValue())) {
                    String prefixToTrim;
                    Intrinsics.checkNotNullExpressionValue((Object)proposal.getSuggestion().substring(0, key.getOffset() - otherKey.getOffset()), (String)"substring(...)");
                    if (proposal.trimPrefix(prefixToTrim) != null) {
                        AnalyzedMLCompletionProposal analyzedMLCompletionProposal3;
                        AnalyzedMLCompletionProposal it = analyzedMLCompletionProposal3;
                        boolean bl2 = false;
                        analyzedMLCompletionProposal2 = !this.isEmpty(it) ? analyzedMLCompletionProposal3 : null;
                    } else {
                        analyzedMLCompletionProposal2 = null;
                    }
                } else {
                    analyzedMLCompletionProposal2 = null;
                }
                if ((entry2 = analyzedMLCompletionProposal2) == null) continue;
                entry = entry2;
                break block6;
            }
            entry = null;
        }
        return entry;
    }

    public final void invalidate() {
        this.rawCache.clear();
        this.analyzedCache.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canBeUsedForAnalyzedCache(LightweightCacheKey currentKey, LightweightCacheKey cachedKey, AnalyzedMLCompletionProposal cachedProposal) {
        boolean bl;
        if (!Intrinsics.areEqual((Object)currentKey.getLineSuffix(), (Object)cachedKey.getLineSuffix())) {
            return false;
        }
        if (currentKey.getPostfixHash() != cachedKey.getPostfixHash()) {
            return false;
        }
        int prefixDifference = currentKey.getOffset() - cachedKey.getOffset();
        Set<Integer> matchedIndices = cachedProposal.getDetails().get(MLCompletionProposalsDetails.INSTANCE.getMATCHED_SYMBOLS_INDICES());
        if (matchedIndices == null) return true;
        Iterable $this$all$iv = matchedIndices;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            int it = ((Number)element$iv).intValue();
            boolean bl2 = false;
            if (it < prefixDifference) return false;
            bl = true;
        } while (bl);
        return false;
    }

    private final boolean isEmpty(AnalyzedMLCompletionProposal $this$isEmpty) {
        if (((CharSequence)$this$isEmpty.getSuggestion()).length() == 0) {
            return true;
        }
        Set<Integer> set = $this$isEmpty.getDetails().get(MLCompletionProposalsDetails.INSTANCE.getMATCHED_SYMBOLS_INDICES());
        int matchedSymbolsSize = set != null ? set.size() : 0;
        return $this$isEmpty.getSuggestion().length() <= matchedSymbolsSize;
    }

    public void dispose() {
        this.invalidate();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/inline/completion/impl/cache/MLInlineCompletionCache$Companion;", "", "<init>", "()V", "CACHE_TTL", "Lkotlin/time/Duration;", "J", "CACHE_CAPACITY", "", "intellij.fullLine.core.completion"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

