/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.editor;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.RuntimeCompletionKt;
import com.intellij.jupyter.core.jupyter.actions.utils.JupyterDebugger;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterExecutionCallback;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterExecutionCallbackAdapter;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterCompleteRequestMessageBuilder;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterStatusMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.core.jupyter.connections.http.JupyterRestClientErrorResponseException;
import com.intellij.jupyter.core.jupyter.connections.ws.JupyterWebSocketClientClosedException;
import com.intellij.jupyter.py.editor.JupyterPythonRuntimeCompletionContributor;
import com.intellij.jupyter.py.editor.JupyterPythonRuntimeCompletionContributorKt;
import com.intellij.jupyter.py.psi.JupyterPyDialect;
import com.intellij.jupyter.py.variables.PythonJupyterVarsCommandExecutor;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyUtil;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nJF\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020 R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/jupyter/py/editor/JupyterPythonRuntimeCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "nonFinishedRequests", "Ljava/util/concurrent/atomic/AtomicInteger;", "isJediDisabled", "", "getVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "psiFile", "Lcom/intellij/psi/PsiFile;", "disableJediCompletion", "", "project", "Lcom/intellij/openapi/project/Project;", "notebookVirtualFile", "sendCompleteRequestMessage", "session", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "otherResults", "", "Lcom/intellij/codeInsight/completion/CompletionResult;", "code", "", "cursorPos", "", "qualifier", "parent", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterPythonRuntimeCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterPythonRuntimeCompletionContributor.kt\ncom/intellij/jupyter/py/editor/JupyterPythonRuntimeCompletionContributor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1#2:211\n*E\n"})
public class JupyterPythonRuntimeCompletionContributor
extends CompletionContributor
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicInteger nonFinishedRequests = new AtomicInteger(0);
    private boolean isJediDisabled;
    @NotNull
    private static final String JUPYTER_RUNTIME = "Jupyter Runtime";
    @NotNull
    private static final String COMPLETION_LOG_MESSAGE = "Failed to send Jupyter completion message:";

    public JupyterPythonRuntimeCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void addCompletions(CompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                if (!Registry.Companion.is("jupyter.runtime.completion.enabled")) {
                    return;
                }
                PsiFile psiFile2 = parameters.getOriginalFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getOriginalFile(...)");
                PsiFile psiFile3 = psiFile2;
                BackedNotebookVirtualFile backedNotebookVirtualFile = this.getVirtualFile(psiFile3);
                if (backedNotebookVirtualFile == null) {
                    return;
                }
                BackedNotebookVirtualFile notebookVirtualFile = backedNotebookVirtualFile;
                Project project = psiFile3.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                if (JupyterDebugger.INSTANCE.isUnderDebugger(project2, notebookVirtualFile)) {
                    return;
                }
                JupyterNotebookSession jupyterNotebookSession = JupyterRuntimeService.Companion.getInstance(project2).getNotebookSession(notebookVirtualFile);
                if (jupyterNotebookSession == null) {
                    return;
                }
                JupyterNotebookSession session = jupyterNotebookSession;
                try {
                    PyStatement pyStatement;
                    PsiElement psiElement;
                    if (nonFinishedRequests.getAndIncrement() > 0) {
                        return;
                    }
                    LinkedHashSet otherResults = result.runRemainingContributors(parameters, true);
                    ProgressManager.checkCanceled();
                    Editor editor = parameters.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                    Editor editor2 = editor;
                    int caretOffset = editor2.getCaretModel().getOffset();
                    if (PyUtil.findElementAtOffset((PsiFile)psiFile3, (int)caretOffset) == null) {
                        return;
                    }
                    PsiElement caretElement = psiElement;
                    if ((PyStatement)PsiTreeUtil.getParentOfType((PsiElement)caretElement, PyStatement.class) == null) {
                        return;
                    }
                    PyStatement caretStatement = pyStatement;
                    int startOffset = caretStatement.getTextOffset();
                    PyReferenceExpression ref = (PyReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)caretElement, PyReferenceExpression.class);
                    PyReferenceExpression pyReferenceExpression = ref;
                    String qualifier = pyReferenceExpression != null && (pyReferenceExpression = pyReferenceExpression.getQualifier()) != null ? pyReferenceExpression.getText() : null;
                    String statementText = caretStatement.getText();
                    PsiElement parent = caretElement.getParent();
                    Callable<Unit> callable = () -> 1.addCompletions$lambda$0(this, project2, notebookVirtualFile, session, result, otherResults, statementText, caretOffset, startOffset, qualifier, parent, this);
                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getProgressIndicator(...)");
                    Unit cfr_ignored_0 = (Unit)ApplicationUtil.runWithCheckCanceled(callable, (ProgressIndicator)progressIndicator);
                }
                finally {
                    nonFinishedRequests.decrementAndGet();
                }
            }

            private static final Unit addCompletions$lambda$0(JupyterPythonRuntimeCompletionContributor this$0, Project $project, BackedNotebookVirtualFile $notebookVirtualFile, JupyterNotebookSession $session, CompletionResultSet $result, LinkedHashSet $otherResults, String $statementText, int $caretOffset, int $startOffset, String $qualifier, PsiElement $parent, 1 this$1) {
                block3: {
                    try {
                        if (!this$0.isJediDisabled) {
                            this$0.disableJediCompletion($project, $notebookVirtualFile);
                            this$0.isJediDisabled = true;
                        }
                        Intrinsics.checkNotNull((Object)$otherResults);
                        Set set = $otherResults;
                        Intrinsics.checkNotNull((Object)$statementText);
                        Intrinsics.checkNotNull((Object)$parent);
                        this$0.sendCompleteRequestMessage($session, $result, set, $statementText, $caretOffset - $startOffset, $qualifier, $parent);
                    }
                    catch (Throwable e) {
                        Throwable throwable = e;
                        if (throwable instanceof InterruptedException || throwable instanceof JupyterWebSocketClientClosedException || throwable instanceof JupyterRestClientErrorResponseException || throwable instanceof ConnectException) break block3;
                        1 $this$thisLogger$iv = this$1;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(1.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.warn(JupyterPythonRuntimeCompletionContributor.COMPLETION_LOG_MESSAGE, e);
                    }
                }
                return Unit.INSTANCE;
            }
        });
    }

    @Nullable
    public BackedNotebookVirtualFile getVirtualFile(@NotNull PsiFile psiFile2) {
        BackedNotebookVirtualFile backedNotebookVirtualFile;
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        if (!Intrinsics.areEqual((Object)psiFile2.getLanguage(), (Object)JupyterPyDialect.INSTANCE)) {
            return null;
        }
        VirtualFile virtualFile = psiFile2.getVirtualFile();
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            BackedNotebookVirtualFile.Companion companion = BackedNotebookVirtualFile.Companion;
            VirtualFile p0 = virtualFile2;
            boolean bl = false;
            backedNotebookVirtualFile = companion.takeIfBacked(p0);
        } else {
            backedNotebookVirtualFile = null;
        }
        return backedNotebookVirtualFile;
    }

    public final void disableJediCompletion(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile, (String)"notebookVirtualFile");
        String jediCommand = "# pydev_util_command\n\nget_ipython().Completer.use_jedi = False\n";
        PythonJupyterVarsCommandExecutor.executeCommand$default(PythonJupyterVarsCommandExecutor.Companion.getInstance(project), jediCommand, notebookVirtualFile, null, 4, null);
    }

    public final void sendCompleteRequestMessage(@NotNull JupyterNotebookSession session, @NotNull CompletionResultSet result, @NotNull Set<CompletionResult> otherResults, @NotNull String code, int cursorPos, @Nullable String qualifier, @NotNull PsiElement parent) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter(otherResults, (String)"otherResults");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        JupyterMessage message2 = new JupyterCompleteRequestMessageBuilder(code, cursorPos, session.getSessionId-PaPw8_s(), null, 8, null).build();
        CountDownLatch replyNotifier = new CountDownLatch(1);
        session.sendMessage(message2, (JupyterExecutionCallback)new JupyterExecutionCallbackAdapter(otherResults, qualifier, parent, replyNotifier, result){
            private final AtomicInteger responsesRemains;
            final /* synthetic */ Set<CompletionResult> $otherResults;
            final /* synthetic */ String $qualifier;
            final /* synthetic */ PsiElement $parent;
            final /* synthetic */ CountDownLatch $replyNotifier;
            final /* synthetic */ CompletionResultSet $result;
            {
                this.$otherResults = $otherResults;
                this.$qualifier = $qualifier;
                this.$parent = $parent;
                this.$replyNotifier = $replyNotifier;
                this.$result = $result;
                this.responsesRemains = new AtomicInteger(2);
            }

            /*
             * WARNING - void declaration
             */
            public void onCompleteReply(JupyterMessage message2) {
                Iterable it;
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                Iterable $this$map$iv = this.$otherResults;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    CompletionResult completionResult = (CompletionResult)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getLookupElement().getLookupString());
                }
                List otherCompletionStrings = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                List<String> list = JupyterPythonRuntimeCompletionContributorKt.getCompletionMatches(message2, this.$qualifier, this.$parent);
                if (list != null) {
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    String it2;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    List<String> list2 = list;
                    iterable = this.$parent;
                    CompletionResultSet completionResultSet = this.$result;
                    List<String> completionMatches = list2;
                    boolean bl = false;
                    boolean isSubscription = iterable instanceof PySubscriptionExpression || iterable instanceof PyStringLiteralExpression && ((PyStringLiteralExpression)iterable).getParent() instanceof PySubscriptionExpression;
                    it = completionMatches;
                    boolean $i$f$filter = false;
                    void var12_17 = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it2 = (String)element$iv$iv;
                        boolean bl2 = false;
                        if (!(!otherCompletionStrings.contains(it2))) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv2;
                    boolean $i$f$map2 = false;
                    $this$filterTo$iv$iv = $this$map$iv2;
                    destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv2) {
                        LookupElementBuilder lookupElementBuilder;
                        it2 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl3 = false;
                        String typeText = isSubscription && StringsKt.startsWith$default((String)it2, (String)"'", (boolean)false, (int)2, null) ? "dict key" : "Jupyter Runtime";
                        LookupElementBuilder $this$onCompleteReply_u24lambda_u244_u24lambda_u243_u24lambda_u242 = lookupElementBuilder = LookupElementBuilder.create((String)it2).withTypeText(typeText);
                        boolean bl4 = false;
                        $this$onCompleteReply_u24lambda_u244_u24lambda_u243_u24lambda_u242.putUserData(RuntimeCompletionKt.getRUNTIME_COMPLETION(), (Object)true);
                        collection.add(lookupElementBuilder);
                    }
                    List lookupElements = (List)destination$iv$iv2;
                    completionResultSet.addAllElements((Iterable)lookupElements);
                }
                this.$replyNotifier.countDown();
                this.responseReceived();
            }

            public void onStatus(JupyterStatusMessage message2) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                switch (sendCompleteRequestMessage.WhenMappings.$EnumSwitchMapping$0[message2.getExecutionState().ordinal()]) {
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        this.responseReceived();
                        break;
                    }
                    case 4: {
                        this.getFinalizeCallback().invoke();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }

            private final void responseReceived() {
                if (this.responsesRemains.decrementAndGet() == 0) {
                    this.getFinalizeCallback().invoke();
                }
            }
        });
        replyNotifier.await();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/jupyter/py/editor/JupyterPythonRuntimeCompletionContributor$Companion;", "", "<init>", "()V", "JUPYTER_RUNTIME", "", "COMPLETION_LOG_MESSAGE", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

