/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.util.Arrays;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Unused, see VcsLogTableCommitSelectionListener")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\b'\u0018\u0000 #*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u0003:\u0001#B#\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00018\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0015J\b\u0010\u0015\u001a\u00020\u0011H%J\b\u0010\u0016\u001a\u00020\u0011H%J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H%J$\u0010\u001a\u001a\u00020\u00112\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cH\u0015J\u0016\u0010\u001a\u001a\u00020\u00112\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cH\u0015J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H%J\b\u0010\"\u001a\u00020\u0011H%R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00018\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/vcs/log/ui/table/CommitSelectionListener;", "T", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "Ljavax/swing/event/ListSelectionListener;", "graphTable", "Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "commitDetailsGetter", "Lcom/intellij/vcs/log/data/DataGetter;", "<init>", "(Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;Lcom/intellij/vcs/log/data/DataGetter;)V", "getGraphTable", "()Lcom/intellij/vcs/log/ui/table/VcsLogGraphTable;", "lastEvent", "Ljavax/swing/event/ListSelectionEvent;", "lastRequest", "Lcom/intellij/openapi/progress/ProgressIndicator;", "valueChanged", "", "event", "processEvent", "onLoadingScheduled", "onLoadingStarted", "onLoadingStopped", "onError", "error", "", "onDetailsLoaded", "commitsIds", "", "", "detailsList", "onSelection", "", "selection", "onEmptySelection", "Companion", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
public abstract class CommitSelectionListener<T extends VcsCommitMetadata>
implements ListSelectionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsLogGraphTable graphTable;
    @NotNull
    private final DataGetter<? extends T> commitDetailsGetter;
    @Nullable
    private ListSelectionEvent lastEvent;
    @Nullable
    private ProgressIndicator lastRequest;
    @NotNull
    private static final Logger LOG;

    protected CommitSelectionListener(@NotNull VcsLogGraphTable graphTable, @NotNull DataGetter<? extends T> commitDetailsGetter) {
        Intrinsics.checkNotNullParameter((Object)graphTable, (String)"graphTable");
        Intrinsics.checkNotNullParameter(commitDetailsGetter, (String)"commitDetailsGetter");
        this.graphTable = graphTable;
        this.commitDetailsGetter = commitDetailsGetter;
    }

    @NotNull
    protected final VcsLogGraphTable getGraphTable() {
        return this.graphTable;
    }

    @Override
    public void valueChanged(@Nullable ListSelectionEvent event) {
        if (event != null && event.getValueIsAdjusting()) {
            return;
        }
        this.lastEvent = event;
        if (this.lastRequest != null) {
            ProgressIndicator progressIndicator = this.lastRequest;
            Intrinsics.checkNotNull((Object)progressIndicator);
            progressIndicator.cancel();
        }
        this.lastRequest = null;
        ApplicationManager.getApplication().invokeLater(() -> CommitSelectionListener.valueChanged$lambda$0(this), arg_0 -> CommitSelectionListener.valueChanged$lambda$1(this, event, arg_0));
        this.onLoadingScheduled();
    }

    private final void processEvent() {
        int rows = this.graphTable.getSelectedRowCount();
        if (rows < 1) {
            this.onLoadingStopped();
            this.onEmptySelection();
        } else {
            int[] nArray = this.graphTable.getSelectedRows();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedRows(...)");
            int[] toLoad = this.onSelection(nArray);
            this.onLoadingStarted();
            EmptyProgressIndicator indicator = new EmptyProgressIndicator();
            this.lastRequest = (ProgressIndicator)indicator;
            GraphTableModel graphTableModel = this.graphTable.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)graphTableModel, (String)"getModel(...)");
            GraphTableModel model = graphTableModel;
            List commitIds2 = SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((int[])toLoad), (Function1)((Function1)new Function1<Integer, Integer>((Object)model){

                public final Integer invoke(int p0) {
                    return ((GraphTableModel)this.receiver).getId(p0);
                }
            }))));
            this.commitDetailsGetter.loadCommitsData(commitIds2, arg_0 -> CommitSelectionListener.processEvent$lambda$2(this, indicator, toLoad, commitIds2, arg_0), (Consumer<Throwable>)((Consumer)arg_0 -> CommitSelectionListener.processEvent$lambda$3(this, indicator, toLoad, arg_0)), (ProgressIndicator)indicator);
        }
    }

    @RequiresEdt
    protected void onLoadingScheduled() {
    }

    @RequiresEdt
    protected abstract void onLoadingStarted();

    @RequiresEdt
    protected abstract void onLoadingStopped();

    @RequiresEdt
    protected abstract void onError(@NotNull Throwable var1);

    @RequiresEdt
    protected void onDetailsLoaded(@NotNull List<Integer> commitsIds, @NotNull List<? extends T> detailsList) {
        Intrinsics.checkNotNullParameter(commitsIds, (String)"commitsIds");
        Intrinsics.checkNotNullParameter(detailsList, (String)"detailsList");
        this.onDetailsLoaded(detailsList);
    }

    @Deprecated(message="onDetailsLoaded with additional parameter is preferred")
    @RequiresEdt
    protected void onDetailsLoaded(@NotNull List<? extends T> detailsList) {
        Intrinsics.checkNotNullParameter(detailsList, (String)"detailsList");
    }

    @RequiresEdt
    @NotNull
    protected abstract int[] onSelection(@NotNull int[] var1);

    @RequiresEdt
    protected abstract void onEmptySelection();

    private static final void valueChanged$lambda$0(CommitSelectionListener this$0) {
        this$0.processEvent();
    }

    private static final boolean valueChanged$lambda$1(CommitSelectionListener this$0, ListSelectionEvent $event, Object o) {
        return this$0.lastEvent != $event;
    }

    private static final void processEvent$lambda$2(CommitSelectionListener this$0, EmptyProgressIndicator $indicator, int[] $toLoad, List $commitIds, List detailsList) {
        Intrinsics.checkNotNullParameter((Object)detailsList, (String)"detailsList");
        if (this$0.lastRequest == $indicator && !$indicator.isCanceled()) {
            if ($toLoad.length != detailsList.size()) {
                String string = Arrays.toString($toLoad);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                LOG.error("Loaded incorrect number of details " + detailsList + " for selection " + string);
            }
            this$0.lastRequest = null;
            this$0.onDetailsLoaded($commitIds, detailsList);
            this$0.onLoadingStopped();
        }
    }

    private static final void processEvent$lambda$3(CommitSelectionListener this$0, EmptyProgressIndicator $indicator, int[] $toLoad, Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (this$0.lastRequest == $indicator && !$indicator.isCanceled()) {
            this$0.lastRequest = null;
            String string = Arrays.toString($toLoad);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            LOG.error("Error loading details for selection " + string, t);
            this$0.onError(t);
            this$0.onLoadingStopped();
        }
    }

    static {
        Logger logger = Logger.getInstance(CommitSelectionListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/vcs/log/ui/table/CommitSelectionListener$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

