/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.codeWithMe.ClientId;
import com.intellij.featureStatistics.ApplicabilityFilter;
import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipsSortingResult;
import com.intellij.ide.util.TipsUsageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0018\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eH\u0002J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/util/TipOrderUtil;", "", "<init>", "()V", "sort", "Lcom/intellij/ide/util/TipsSortingResult;", "tips", "", "Lcom/intellij/ide/util/TipAndTrickBean;", "project", "Lcom/intellij/openapi/project/Project;", "getComparator", "Ljava/util/Comparator;", "Lcom/intellij/ide/util/TipOrderUtil$TipInfo;", "Lkotlin/Comparator;", "adjustFirstTip", "cycleShift", "value", "", "TipInfo", "Companion", "intellij.platform.tips"})
@SourceDebugExtension(value={"SMAP\nTipOrderUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TipOrderUtil.kt\ncom/intellij/ide/util/TipOrderUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n25#2:118\n1557#3:119\n1628#3,3:120\n1557#3:123\n1628#3,2:124\n774#3:126\n865#3,2:127\n1755#3,2:129\n1757#3:133\n774#3:134\n865#3,2:135\n1630#3:138\n1557#3:139\n1628#3,3:140\n1971#3,14:143\n360#3,7:157\n360#3,7:164\n12567#4,2:131\n1#5:137\n*S KotlinDebug\n*F\n+ 1 TipOrderUtil.kt\ncom/intellij/ide/util/TipOrderUtil\n*L\n26#1:118\n31#1:119\n31#1:120,3\n33#1:123\n33#1:124,2\n34#1:126\n34#1:127,2\n39#1:129,2\n39#1:133\n46#1:134\n46#1:135,2\n33#1:138\n57#1:139\n57#1:140,3\n76#1:143,14\n77#1:157,7\n81#1:164,7\n42#1:131,2\n*E\n"})
public final class TipOrderUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String SHUFFLE_ALGORITHM = "shuffle";
    @NotNull
    public static final String SORTING_ALGORITHM = "usage_and_applicability";
    @NotNull
    private static final String SORTING_ALGORITHM_VERSION = "2";
    private static final long MIN_SUCCESSIVE_SHOW_INTERVAL_MS = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)14, (DurationUnit)DurationUnit.DAYS));

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TipsSortingResult sort(@NotNull List<TipAndTrickBean> tips, @Nullable Project project) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter(tips, (String)"tips");
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        if (registry == null) {
            TipOrderUtil $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(TipOrderUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("ProductivityFeaturesRegistry is not created");
            return TipsSortingResult.Companion.create(CollectionsKt.shuffled((Iterable)tips), SHUFFLE_ALGORITHM, "1");
        }
        FeatureUsageTracker.getInstance();
        Set set = registry.getFeatureIds();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFeatureIds(...)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            Iterator it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(registry.getFeatureDescriptor((String)((Object)it)));
        }
        List allFeatures = (List)destination$iv$iv;
        Random random = RandomKt.Random((long)TipsUsageManager.Companion.getInstance().getTipsOrderSeed());
        Iterable $this$map$iv2 = CollectionsKt.shuffled((Iterable)tips, (Random)random);
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            TipInfo tipInfo;
            void tip;
            void $this$filterTo$iv$iv;
            TipAndTrickBean tipAndTrickBean = (TipAndTrickBean)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Iterable $this$filter$iv = allFeatures;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FeatureDescriptor it = (FeatureDescriptor)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getTipId(), (Object)tip.getId())) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List features = (List)destination$iv$iv3;
            if (!((Collection)features).isEmpty()) {
                int n;
                void $this$filterTo$iv$iv2;
                ApplicabilityFilter[] filters;
                boolean bl3;
                block23: {
                    if (project == null) {
                        bl3 = true;
                    } else {
                        Iterable $this$any$iv = features;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                boolean bl4;
                                block22: {
                                    FeatureDescriptor feature = (FeatureDescriptor)element$iv;
                                    boolean bl5 = false;
                                    Intrinsics.checkNotNullExpressionValue((Object)registry.getMatchingFilters(feature.getId()), (String)"getMatchingFilters(...)");
                                    if (!(filters.length == 0)) {
                                        ApplicabilityFilter[] $this$any$iv2 = filters;
                                        boolean $i$f$any2 = false;
                                        int n2 = $this$any$iv2.length;
                                        for (int i = 0; i < n2; ++i) {
                                            ApplicabilityFilter element$iv2;
                                            ApplicabilityFilter filter = element$iv2 = $this$any$iv2[i];
                                            boolean bl6 = false;
                                            if (!filter.isApplicable(feature.getId(), project)) continue;
                                            bl4 = true;
                                            break block22;
                                        }
                                        bl4 = false;
                                    } else {
                                        bl4 = true;
                                    }
                                }
                                if (!bl4) continue;
                                bl3 = true;
                                break block23;
                            }
                            bl3 = false;
                        }
                    }
                }
                boolean isApplicable = bl3;
                Iterable $this$filter$iv2 = features;
                boolean $i$f$filter2 = false;
                Iterable element$iv = $this$filter$iv2;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                filters = $this$filterTo$iv$iv2.iterator();
                while (filters.hasNext()) {
                    Object element$iv$iv = filters.next();
                    FeatureDescriptor p0 = (FeatureDescriptor)element$iv$iv;
                    boolean bl7 = false;
                    if (!p0.isUnused()) continue;
                    destination$iv$iv4.add(element$iv$iv);
                }
                List unusedFeatures = (List)destination$iv$iv4;
                double unusedScore = (double)unusedFeatures.size() * 1.0 / (double)features.size();
                if (!((Collection)unusedFeatures).isEmpty()) {
                    var22_45 = ((Iterable)unusedFeatures).iterator();
                    if (!var22_45.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    p1 = (FeatureDescriptor)var22_45.next();
                    boolean bl8 = false;
                    int p1 = p1.getUtilityScore();
                    while (var22_45.hasNext()) {
                        FeatureDescriptor p22 = (FeatureDescriptor)var22_45.next();
                        $i$a$-maxOf-TipOrderUtil$sort$tipInfoList$1$utilityScore$1 = false;
                        int p22 = p22.getUtilityScore();
                        if (p1 >= p22) continue;
                        p1 = p22;
                    }
                    n = p1;
                } else {
                    var22_45 = ((Iterable)features).iterator();
                    if (!var22_45.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    p1 = (FeatureDescriptor)var22_45.next();
                    boolean bl9 = false;
                    int n3 = p1.getUtilityScore();
                    while (var22_45.hasNext()) {
                        FeatureDescriptor p0 = (FeatureDescriptor)var22_45.next();
                        $i$a$-maxOf-TipOrderUtil$sort$tipInfoList$1$utilityScore$2 = false;
                        int n4 = p0.getUtilityScore();
                        if (n3 >= n4) continue;
                        n3 = n4;
                    }
                    n = n3;
                }
                int utilityScore = n;
                tipInfo = new TipInfo((TipAndTrickBean)tip, true, isApplicable, unusedScore, utilityScore);
            } else {
                tipInfo = new TipInfo((TipAndTrickBean)tip, false, true, 0.0, 3);
            }
            collection.add(tipInfo);
        }
        List tipInfoList = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = CollectionsKt.sortedWith((Iterable)tipInfoList, this.getComparator());
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TipInfo bl = (TipInfo)item$iv$iv;
            collection = destination$iv$iv5;
            boolean bl10 = false;
            collection.add(it.getTip());
        }
        List sortedTips = (List)destination$iv$iv5;
        List<TipAndTrickBean> adjustedSortedTips = this.adjustFirstTip(sortedTips);
        return TipsSortingResult.Companion.create(adjustedSortedTips, SORTING_ALGORITHM, SORTING_ALGORITHM_VERSION);
    }

    private final Comparator<TipInfo> getComparator() {
        Comparator<Object> comparator = ComparisonsKt.then((Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TipInfo info = (TipInfo)a;
                boolean bl = false;
                boolean bl2 = info.getFeatureFound() && info.isApplicable() && info.getUnusedScore() > 0.1;
                info = (TipInfo)b;
                Comparable comparable = Boolean.valueOf(bl2);
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Boolean.valueOf(info.getFeatureFound() && info.isApplicable() && info.getUnusedScore() > 0.1));
            }
        }, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TipInfo info = (TipInfo)a;
                boolean bl = false;
                boolean bl2 = !info.getFeatureFound();
                info = (TipInfo)b;
                Comparable comparable = Boolean.valueOf(bl2);
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Boolean.valueOf(!info.getFeatureFound()));
            }
        }).thenComparingDouble(arg_0 -> TipOrderUtil.getComparator$lambda$11(TipOrderUtil::getComparator$lambda$10, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"thenComparingDouble(...)");
        Comparator<Object> comparator2 = ComparisonsKt.then(comparator, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TipInfo info = (TipInfo)a;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(info.isApplicable());
                info = (TipInfo)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(info.isApplicable()));
            }
        }).thenComparingInt(arg_0 -> TipOrderUtil.getComparator$lambda$14(TipOrderUtil::getComparator$lambda$13, arg_0)).reversed();
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"reversed(...)");
        return comparator2;
    }

    private final List<TipAndTrickBean> adjustFirstTip(List<TipAndTrickBean> tips) {
        List<TipAndTrickBean> list;
        if (tips.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        TipsUsageManager tipsUsageManager = TipsUsageManager.Companion.getInstance();
        if (tipsUsageManager.wereTipsShownToday()) {
            int n;
            block13: {
                Object object;
                Object v0;
                Iterable $this$maxByOrNull$iv = tips;
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = maxElem$iv;
                    } else {
                        TipAndTrickBean tipAndTrickBean = (TipAndTrickBean)maxElem$iv;
                        boolean bl = false;
                        String string = tipAndTrickBean.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                        long l = tipsUsageManager.getLastTimeShown(string);
                        do {
                            Object e$iv = iterator$iv.next();
                            TipAndTrickBean it2 = (TipAndTrickBean)e$iv;
                            boolean bl2 = false;
                            String string2 = it2.getId();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
                            long v$iv = tipsUsageManager.getLastTimeShown(string2);
                            if (l >= v$iv) continue;
                            maxElem$iv = e$iv;
                            l = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = maxElem$iv;
                    }
                }
                if ((object = (TipAndTrickBean)v0) == null || (object = object.getId()) == null) {
                    object = tips.get(0);
                }
                Object lastShownTipId = object;
                List<TipAndTrickBean> $this$indexOfFirst$iv = tips;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object e : $this$indexOfFirst$iv) {
                    TipAndTrickBean it = (TipAndTrickBean)e;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getId(), (Object)lastShownTipId)) {
                        n = index$iv;
                        break block13;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int lastShownTipIndex = n;
            list = this.cycleShift(tips, lastShownTipIndex);
        } else {
            int n;
            block14: {
                List<TipAndTrickBean> $this$indexOfFirst$iv = tips;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<TipAndTrickBean> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    TipAndTrickBean item$iv;
                    TipAndTrickBean tipAndTrickBean = item$iv = iterator.next();
                    boolean bl = false;
                    long l = System.currentTimeMillis();
                    String string = tipAndTrickBean.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                    if (l - tipsUsageManager.getLastTimeProposed(string) > MIN_SUCCESSIVE_SHOW_INTERVAL_MS) {
                        n = index$iv;
                        break block14;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int indexToShowFirst = n;
            list = indexToShowFirst <= 0 ? tips : this.cycleShift(tips, indexToShowFirst);
        }
        return list;
    }

    private final List<TipAndTrickBean> cycleShift(List<TipAndTrickBean> tips, int value) {
        List<TipAndTrickBean> before = tips.subList(0, value);
        List<TipAndTrickBean> after = tips.subList(value, tips.size());
        return CollectionsKt.plus((Collection)after, (Iterable)before);
    }

    private static final double getComparator$lambda$10(TipInfo info) {
        return info.getUnusedScore();
    }

    private static final double getComparator$lambda$11(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).doubleValue();
    }

    private static final int getComparator$lambda$13(TipInfo info) {
        return info.getUtilityScore();
    }

    private static final int getComparator$lambda$14(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    @JvmStatic
    @NotNull
    public static final TipOrderUtil getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/util/TipOrderUtil$Companion;", "", "<init>", "()V", "SHUFFLE_ALGORITHM", "", "SORTING_ALGORITHM", "SORTING_ALGORITHM_VERSION", "MIN_SUCCESSIVE_SHOW_INTERVAL_MS", "", "getInstance", "Lcom/intellij/ide/util/TipOrderUtil;", "intellij.platform.tips"})
    @SourceDebugExtension(value={"SMAP\nTipOrderUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TipOrderUtil.kt\ncom/intellij/ide/util/TipOrderUtil$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,117:1\n40#2,3:118\n*S KotlinDebug\n*F\n+ 1 TipOrderUtil.kt\ncom/intellij/ide/util/TipOrderUtil$Companion\n*L\n114#1:118,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TipOrderUtil getInstance() {
            boolean $i$f$service = false;
            Class<TipOrderUtil> serviceClass$iv = TipOrderUtil.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (TipOrderUtil)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\nH\u00c6\u0003J;\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lcom/intellij/ide/util/TipOrderUtil$TipInfo;", "", "tip", "Lcom/intellij/ide/util/TipAndTrickBean;", "featureFound", "", "isApplicable", "unusedScore", "", "utilityScore", "", "<init>", "(Lcom/intellij/ide/util/TipAndTrickBean;ZZDI)V", "getTip", "()Lcom/intellij/ide/util/TipAndTrickBean;", "getFeatureFound", "()Z", "getUnusedScore", "()D", "getUtilityScore", "()I", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "", "intellij.platform.tips"})
    private static final class TipInfo {
        @NotNull
        private final TipAndTrickBean tip;
        private final boolean featureFound;
        private final boolean isApplicable;
        private final double unusedScore;
        private final int utilityScore;

        public TipInfo(@NotNull TipAndTrickBean tip, boolean featureFound, boolean isApplicable, double unusedScore, int utilityScore) {
            Intrinsics.checkNotNullParameter((Object)tip, (String)"tip");
            this.tip = tip;
            this.featureFound = featureFound;
            this.isApplicable = isApplicable;
            this.unusedScore = unusedScore;
            this.utilityScore = utilityScore;
        }

        @NotNull
        public final TipAndTrickBean getTip() {
            return this.tip;
        }

        public final boolean getFeatureFound() {
            return this.featureFound;
        }

        public final boolean isApplicable() {
            return this.isApplicable;
        }

        public final double getUnusedScore() {
            return this.unusedScore;
        }

        public final int getUtilityScore() {
            return this.utilityScore;
        }

        @NotNull
        public final TipAndTrickBean component1() {
            return this.tip;
        }

        public final boolean component2() {
            return this.featureFound;
        }

        public final boolean component3() {
            return this.isApplicable;
        }

        public final double component4() {
            return this.unusedScore;
        }

        public final int component5() {
            return this.utilityScore;
        }

        @NotNull
        public final TipInfo copy(@NotNull TipAndTrickBean tip, boolean featureFound, boolean isApplicable, double unusedScore, int utilityScore) {
            Intrinsics.checkNotNullParameter((Object)tip, (String)"tip");
            return new TipInfo(tip, featureFound, isApplicable, unusedScore, utilityScore);
        }

        public static /* synthetic */ TipInfo copy$default(TipInfo tipInfo, TipAndTrickBean tipAndTrickBean, boolean bl, boolean bl2, double d, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                tipAndTrickBean = tipInfo.tip;
            }
            if ((n2 & 2) != 0) {
                bl = tipInfo.featureFound;
            }
            if ((n2 & 4) != 0) {
                bl2 = tipInfo.isApplicable;
            }
            if ((n2 & 8) != 0) {
                d = tipInfo.unusedScore;
            }
            if ((n2 & 0x10) != 0) {
                n = tipInfo.utilityScore;
            }
            return tipInfo.copy(tipAndTrickBean, bl, bl2, d, n);
        }

        @NotNull
        public String toString() {
            return "TipInfo(tip=" + this.tip + ", featureFound=" + this.featureFound + ", isApplicable=" + this.isApplicable + ", unusedScore=" + this.unusedScore + ", utilityScore=" + this.utilityScore + ")";
        }

        public int hashCode() {
            int result = this.tip.hashCode();
            result = result * 31 + Boolean.hashCode(this.featureFound);
            result = result * 31 + Boolean.hashCode(this.isApplicable);
            result = result * 31 + Double.hashCode(this.unusedScore);
            result = result * 31 + Integer.hashCode(this.utilityScore);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TipInfo)) {
                return false;
            }
            TipInfo tipInfo = (TipInfo)other;
            if (!Intrinsics.areEqual((Object)this.tip, (Object)tipInfo.tip)) {
                return false;
            }
            if (this.featureFound != tipInfo.featureFound) {
                return false;
            }
            if (this.isApplicable != tipInfo.isApplicable) {
                return false;
            }
            if (Double.compare(this.unusedScore, tipInfo.unusedScore) != 0) {
                return false;
            }
            return this.utilityScore == tipInfo.utilityScore;
        }
    }
}

