/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.handlers.CsvDropUtilKt;
import com.intellij.jupyter.core.editor.handlers.TableDataFileDropHandler;
import com.intellij.jupyter.core.jupyter.data.input.DndToolBarPanelUI;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellToolbarInlayControllerKt;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputFileName;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputSelectPopupAction;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputTableInfo;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputVariableName;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputVariablePopup;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.notebooks.ui.SteadyUIPanel;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.plaf.PanelUI;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDnDToolbarPanel;", "Lcom/intellij/notebooks/ui/SteadyUIPanel;", "Lcom/intellij/ide/dnd/DnDNativeTarget;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/notebooks/visualization/ui/EditorCell;)V", "cellFileName", "Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputFileName;", "cellTableInfo", "Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputTableInfo;", "variableName", "Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputVariableName;", "drop", "", "event", "Lcom/intellij/ide/dnd/DnDEvent;", "getDndFilePathOrNull", "", "file", "Ljava/io/File;", "update", "", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterDataInputCellToolbarInlayController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDataInputCellToolbarInlayController.kt\ncom/intellij/jupyter/core/jupyter/data/input/JupyterDnDToolbarPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
final class JupyterDnDToolbarPanel
extends SteadyUIPanel
implements DnDNativeTarget {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final JupyterDataInputFileName cellFileName;
    @NotNull
    private final JupyterDataInputTableInfo cellTableInfo;
    @NotNull
    private final JupyterDataInputVariableName variableName;

    public JupyterDnDToolbarPanel(@NotNull EditorImpl editor, @NotNull EditorCell cell) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        super((PanelUI)new DndToolBarPanelUI(editor));
        this.editor = editor;
        JupyterNotebook notebook = JupyterEditorExtensionsKt.getNotebookFile((Editor)this.editor).getNotebook();
        JupyterCell notebookCell = notebook.getCell(cell.getInterval().getOrdinal());
        this.cellFileName = new JupyterDataInputFileName(notebookCell);
        this.cellTableInfo = new JupyterDataInputTableInfo(notebookCell);
        this.variableName = new JupyterDataInputVariableName(notebookCell, notebook.getLanguage());
        AnAction[] anActionArray = new AnAction[]{new JupyterDataInputSelectPopupAction((Editor)this.editor, this.cellFileName, this.cellTableInfo), new JupyterDataInputVariablePopup((Editor)this.editor, this.variableName, JupyterDataInputVariableName.Companion.getNameGenerator())};
        DefaultActionGroup actionGroup = new DefaultActionGroup(anActionArray);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("EditorTab", (ActionGroup)actionGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        this.setOpaque(false);
        this.setLayout(new FlowLayout(0, 0, 0));
        toolbar.getComponent().setOpaque(false);
        toolbar.getComponent().setCursor(Cursor.getPredefinedCursor(0));
        toolbar.getComponent().setBorder(null);
        toolbar.setTargetComponent((JComponent)this.editor.getContentComponent());
        this.add(toolbar.getComponent());
    }

    public void drop(@NotNull DnDEvent event) {
        String string;
        block2: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            List fileListData = JupyterDataInputCellToolbarInlayControllerKt.access$extractFilesFromDnDEvent(event);
            for (File it : (Iterable)fileListData) {
                boolean bl = false;
                String string2 = this.getDndFilePathOrNull(it);
                if (string2 == null) continue;
                string = string2;
                break block2;
            }
            string = null;
        }
        if (string == null) {
            return;
        }
        String fileName = string;
        this.cellFileName.set(fileName);
        this.revalidate();
    }

    private final String getDndFilePathOrNull(File file) {
        TableDataFileDropHandler tableDataFileDropHandler;
        if (!file.isFile()) {
            return null;
        }
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)this.editor);
        if (backedNotebookVirtualFile != null) {
            BackedNotebookVirtualFile it = backedNotebookVirtualFile;
            boolean bl = false;
            tableDataFileDropHandler = TableDataFileDropHandler.Companion.findApplicable(it.getNotebook(), FilesKt.getExtension((File)file));
        } else {
            tableDataFileDropHandler = null;
        }
        if (tableDataFileDropHandler == null) {
            return null;
        }
        Project project = this.editor.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        VirtualFile virtualFile2 = this.editor.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        return CsvDropUtilKt.createFilePath(file, virtualFile2, project2);
    }

    public boolean update(@NotNull DnDEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        List fileList = JupyterDataInputCellToolbarInlayControllerKt.access$extractFilesFromDnDEvent(event);
        if (fileList.isEmpty()) {
            return false;
        }
        event.setHighlighting((Component)((Object)this), 1);
        event.setDropPossible(true);
        return true;
    }
}

