/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.html;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.DigestUtil;
import java.io.File;
import java.math.BigInteger;
import java.net.URI;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.parser.LinkMap;
import org.intellij.markdown.parser.MarkdownParser;
import org.intellij.plugins.markdown.extensions.CodeFenceGeneratingProvider;
import org.intellij.plugins.markdown.extensions.MarkdownCodeFenceCacheableProvider;
import org.intellij.plugins.markdown.lang.parser.MarkdownParserManager;
import org.intellij.plugins.markdown.ui.preview.html.CodeSpanRunnerGeneratingProvider;
import org.intellij.plugins.markdown.ui.preview.html.DefaultCodeFenceGeneratingProvider;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownCodeFenceHtmlCache;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownCodeFencePluginCacheCollector;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownUtil$createCodeFenceProvider$;
import org.intellij.plugins.markdown.ui.preview.html.ParagraphGeneratingProvider;
import org.intellij.plugins.markdown.ui.preview.html.links.IntelliJImageGeneratingProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\b\u0001\u0010\u0007\u001a\u00020\u0005H\u0007J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\rJ$\u0010\u000e\u001a\u00020\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/html/MarkdownUtil;", "", "<init>", "()V", "md5", "", "buffer", "key", "generateMarkdownHtml", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "text", "project", "Lcom/intellij/openapi/project/Project;", "createCodeFenceProvider", "Lorg/intellij/markdown/html/GeneratingProvider;", "collector", "Lorg/intellij/plugins/markdown/ui/preview/html/MarkdownCodeFencePluginCacheCollector;", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownUtil.kt\norg/intellij/plugins/markdown/ui/preview/html/MarkdownUtil\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,68:1\n477#2:69\n37#3:70\n36#3,3:71\n*S KotlinDebug\n*F\n+ 1 MarkdownUtil.kt\norg/intellij/plugins/markdown/ui/preview/html/MarkdownUtil\n*L\n62#1:69\n65#1:70\n65#1:71,3\n*E\n"})
public final class MarkdownUtil {
    @NotNull
    public static final MarkdownUtil INSTANCE = new MarkdownUtil();

    private MarkdownUtil() {
    }

    @ApiStatus.Internal
    @NotNull
    public final String md5(@Nullable String buffer, @NonNls @NotNull String key) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        MessageDigest md5 = DigestUtil.md5();
        String string = buffer;
        if (string != null) {
            byte[] byArray2 = string.getBytes(Charsets.UTF_8);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        } else {
            byArray = null;
        }
        Objects.requireNonNull(md5).update(byArray);
        byte[] byArray3 = key.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
        byte[] code = md5.digest(byArray3);
        BigInteger bi = new BigInteger(code).abs();
        String string2 = bi.abs().toString(16);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public final String generateMarkdownHtml(@NotNull VirtualFile file, @NotNull String text2, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        VirtualFile parent = file.getParent();
        URI baseUri = parent != null ? new File(parent.getPath()).toURI() : null;
        ASTNode parsedTree = new MarkdownParser(MarkdownParserManager.FLAVOUR).buildMarkdownTreeFromString(text2);
        MarkdownCodeFencePluginCacheCollector cacheCollector = new MarkdownCodeFencePluginCacheCollector(file);
        LinkMap linkMap = LinkMap.Builder.buildLinkMap(parsedTree, (CharSequence)text2);
        Map map = MapsKt.toMutableMap((Map)MarkdownParserManager.FLAVOUR.createHtmlGeneratingProviders(linkMap, baseUri));
        map.put(MarkdownElementTypes.CODE_FENCE, this.createCodeFenceProvider(project, file, cacheCollector));
        if (project != null) {
            map.put(MarkdownElementTypes.IMAGE, new IntelliJImageGeneratingProvider(linkMap));
            map.put(MarkdownElementTypes.PARAGRAPH, new ParagraphGeneratingProvider());
            map.put(MarkdownElementTypes.CODE_SPAN, new CodeSpanRunnerGeneratingProvider(project, file));
        }
        String html2 = HtmlGenerator.generateHtml$default((HtmlGenerator)new HtmlGenerator(text2, parsedTree, map, true), null, (int)1, null);
        MarkdownCodeFenceHtmlCache.getInstance().registerCacheProvider(cacheCollector);
        return html2;
    }

    @ApiStatus.Internal
    @NotNull
    public final GeneratingProvider createCodeFenceProvider(@Nullable Project project, @Nullable VirtualFile file, @NotNull MarkdownCodeFencePluginCacheCollector collector) {
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        Collection<CodeFenceGeneratingProvider> providers = CodeFenceGeneratingProvider.Companion.collectProviders();
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)providers);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)createCodeFenceProvider$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        for (MarkdownCodeFenceCacheableProvider provider : sequence) {
            provider.setCollector(collector);
        }
        Collection<CodeFenceGeneratingProvider> $this$toTypedArray$iv = providers;
        boolean $i$f$toTypedArray = false;
        Collection<CodeFenceGeneratingProvider> thisCollection$iv = $this$toTypedArray$iv;
        return new DefaultCodeFenceGeneratingProvider(thisCollection$iv.toArray(new CodeFenceGeneratingProvider[0]), project, file);
    }
}

