/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.nativecerts.mac;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.platform.mac.CoreFoundation;
import com.sun.jna.ptr.PointerByReference;
import org.jetbrains.annotations.Nullable;

public interface CoreFoundationExt
extends Library {
    public static final CoreFoundationExt INSTANCE = (CoreFoundationExt)Native.load((String)"CoreFoundation", CoreFoundationExt.class);
    public static final CoreFoundation.CFBooleanRef kCFBooleanFalse = CoreFoundationExt.resolveBoolean("kCFBooleanFalse", false);
    public static final CoreFoundation.CFBooleanRef kCFBooleanTrue = CoreFoundationExt.resolveBoolean("kCFBooleanTrue", true);

    public CoreFoundation.CFIndex CFDictionaryGetCount(CoreFoundation.CFDictionaryRef var1);

    public CoreFoundation.CFDictionaryRef CFDictionaryCreate(CoreFoundation.CFAllocatorRef var1, CoreFoundation.CFTypeRef[] var2, CoreFoundation.CFTypeRef[] var3, CoreFoundation.CFIndex var4, Pointer var5, Pointer var6);

    public CoreFoundation.CFArrayRef CFArrayCreate(CoreFoundation.CFAllocatorRef var1, CoreFoundation.CFTypeRef[] var2, CoreFoundation.CFIndex var3, Pointer var4);

    public boolean CFEqual(CoreFoundation.CFTypeRef var1, CoreFoundation.CFTypeRef var2);

    private static CoreFoundation.CFBooleanRef resolveBoolean(String name, boolean expectedValue) {
        Pointer pointer = NativeLibrary.getInstance((String)"CoreFoundation").getGlobalVariableAddress(name);
        CoreFoundation.CFBooleanRef cfBoolean = new CoreFoundation.CFBooleanRef(pointer.getPointer(0L));
        if (cfBoolean.booleanValue() != expectedValue) {
            throw new IllegalStateException("Expected " + name + " to be " + expectedValue + ", but got " + cfBoolean.booleanValue());
        }
        return cfBoolean;
    }

    public static class CFStringRefByReference
    extends PointerByReference {
        public CFStringRefByReference() {
        }

        public CFStringRefByReference(CoreFoundation.CFStringRef value) {
            super(value.getPointer());
        }

        @Nullable
        public CoreFoundation.CFStringRef getStringRef() {
            Pointer value = super.getValue();
            if (value == null) {
                return null;
            }
            return new CoreFoundation.CFStringRef(value);
        }
    }

    public static class CFArrayRefByReference
    extends PointerByReference {
        public CFArrayRefByReference() {
        }

        public CFArrayRefByReference(CoreFoundation.CFArrayRef value) {
            super(value.getPointer());
        }

        @Nullable
        public CoreFoundation.CFArrayRef getArray() {
            Pointer value = super.getValue();
            if (value == null) {
                return null;
            }
            return new CoreFoundation.CFArrayRef(value);
        }
    }
}

