/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout.fontstore;

import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.outputdevice.helper.FontResolverHelper;
import java.io.Closeable;
import java.io.IOException;

public class FontUtil {
    public static String normalizeFontFamily(String fontFamily) {
        String result2 = fontFamily;
        if (result2.startsWith("\"")) {
            result2 = result2.substring(1);
        }
        if (result2.endsWith("\"")) {
            result2 = result2.substring(0, result2.length() - 1);
        }
        if (result2.equalsIgnoreCase("serif")) {
            result2 = "Serif";
        } else if (result2.equalsIgnoreCase("sans-serif")) {
            result2 = "SansSerif";
        } else if (result2.equalsIgnoreCase("monospace")) {
            result2 = "Monospaced";
        }
        return result2;
    }

    public static int normalizeFontWeight(Integer fontWeight) {
        return fontWeight != null ? fontWeight : 400;
    }

    public static IdentValue normalizeFontStyle(IdentValue fontStyle) {
        return fontStyle != null ? fontStyle : IdentValue.NORMAL;
    }

    public static int normalizeFontWeight(IdentValue fontWeight) {
        return fontWeight != null ? FontResolverHelper.convertWeightToInt(fontWeight) : 400;
    }

    public static void tryClose(Closeable obj) {
        try {
            obj.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

