/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.util;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.ide.model.highlighterRegistration.HighlighterProperties;
import com.jetbrains.rd.ide.editor.markup.UtilKt;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.daemon.SuggestionSeveritiesProvider;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FoldingInfoKt;
import com.jetbrains.rdclient.daemon.highlighters.gutterMarks.FrontendGutterIconRenderer;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendHintInlayModelSupportKt;
import com.jetbrains.rdclient.util.idea.RangeUtilKt;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000x\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010)\u001a\u00020\u0004*\u00020\u0007\u001a\n\u0010)\u001a\u00020\u0004*\u00020\u0002\u001a\u0014\u0010.\u001a\u0004\u0018\u00010/*\u0002002\u0006\u00101\u001a\u000202\u001a\u0018\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u0002002\u0006\u00101\u001a\u000202\u001a\u001e\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=\u001a\u0010\u0010>\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020@H\u0002\"\u001f\u0010\u0003\u001a\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0015\u0010\n\u001a\u00020\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\"\u0015\u0010\r\u001a\u00020\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\f\"\u0015\u0010\u000e\u001a\u00020\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\"\u0015\u0010\u000f\u001a\u00020\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\"\u0015\u0010\u0010\u001a\u00020\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\"\u0015\u0010\u0010\u001a\u00020\u000b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0015\u0010\u0012\u001a\u00020\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\f\"\u0015\u0010\u0013\u001a\u00020\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\f\"\u0015\u0010\u0014\u001a\u00020\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\f\"\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u0004*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\t\"\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u0004*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\t\"\u001b\u0010\u0019\u001a\u00020\u0004*\u00020\u00078F\u00a2\u0006\f\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\t\"\u0015\u0010\u001d\u001a\u00020\u0004*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\t\"\u0015\u0010\u001f\u001a\u00020\u0004*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b \u0010\t\"\u0017\u0010!\u001a\u0004\u0018\u00010\"*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\"\u0017\u0010%\u001a\u0004\u0018\u00010&*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\"\u0017\u0010*\u001a\u0004\u0018\u00010+*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006A"}, d2={"toIdeaTargetArea", "Lcom/intellij/openapi/editor/markup/HighlighterTargetArea;", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "text", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getText", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)Ljava/lang/String;", "isBackendHighlighter", "", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)Z", "isBackendLineMarker", "isBackendInlay", "isBackendFolding", "isBackendBulb", "(Lcom/jetbrains/rd/ide/model/HighlighterModel;)Z", "isBackendGutterMark", "isBackendMethodSeparator", "isFromBackend", "backendAttributeId", "getBackendAttributeId", "backendDemoTextTag", "getBackendDemoTextTag", "backendAttributeIdOrThrow", "getBackendAttributeIdOrThrow$annotations", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)V", "getBackendAttributeIdOrThrow", "backendDemoTextTagOrThrow", "getBackendDemoTextTagOrThrow", "attributeKeyName", "getAttributeKeyName", "attributeKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getAttributeKey", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "highlightInfoType", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "getHighlightInfoType", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "prettyPrint", "severity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "getSeverity", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)Lcom/intellij/lang/annotation/HighlightSeverity;", "getErrorStripeColor", "Ljava/awt/Color;", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "colorsScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "attributesFromSeverity", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "info", "vanishHighlighters", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "range", "Lcom/intellij/openapi/util/TextRange;", "editor", "Lcom/intellij/openapi/editor/Editor;", "shouldBeVanished", "h", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "intellij.rd.client"})
public final class HighlightersUtilKt {
    @NotNull
    public static final HighlighterTargetArea toIdeaTargetArea(@NotNull HighlighterModel $this$toIdeaTargetArea) {
        Intrinsics.checkNotNullParameter((Object)$this$toIdeaTargetArea, (String)"<this>");
        return $this$toIdeaTargetArea.isExactRange() ? HighlighterTargetArea.EXACT_RANGE : HighlighterTargetArea.LINES_IN_RANGE;
    }

    @NotNull
    public static final String getText(@NotNull RangeHighlighter $this$text) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"<this>");
        String string = $this$text.getDocument().getText(new TextRange($this$text.getStartOffset(), $this$text.getEndOffset()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public static final boolean isBackendHighlighter(@NotNull RangeHighlighter $this$isBackendHighlighter) {
        Intrinsics.checkNotNullParameter((Object)$this$isBackendHighlighter, (String)"<this>");
        return HighlightersUtilKt.getBackendAttributeId($this$isBackendHighlighter) != null && !HighlightersUtilKt.isBackendBulb($this$isBackendHighlighter);
    }

    public static final boolean isBackendLineMarker(@NotNull RangeHighlighter $this$isBackendLineMarker) {
        Intrinsics.checkNotNullParameter((Object)$this$isBackendLineMarker, (String)"<this>");
        return HighlightersUtilKt.isBackendHighlighter($this$isBackendLineMarker) && $this$isBackendLineMarker.getLineMarkerRenderer() != null;
    }

    public static final boolean isBackendInlay(@NotNull RangeHighlighter $this$isBackendInlay) {
        Intrinsics.checkNotNullParameter((Object)$this$isBackendInlay, (String)"<this>");
        return HighlightersUtilKt.isBackendHighlighter($this$isBackendInlay) && FrontendHintInlayModelSupportKt.getInlayInfo($this$isBackendInlay) != null;
    }

    public static final boolean isBackendFolding(@NotNull RangeHighlighter $this$isBackendFolding) {
        Intrinsics.checkNotNullParameter((Object)$this$isBackendFolding, (String)"<this>");
        return HighlightersUtilKt.isBackendHighlighter($this$isBackendFolding) && FoldingInfoKt.getFoldingInfo($this$isBackendFolding) != null;
    }

    public static final boolean isBackendBulb(@NotNull RangeHighlighter $this$isBackendBulb) {
        Intrinsics.checkNotNullParameter((Object)$this$isBackendBulb, (String)"<this>");
        return Intrinsics.areEqual((Object)HighlightersUtilKt.getBackendAttributeId($this$isBackendBulb), (Object)"CaretDependentBulb");
    }

    public static final boolean isBackendBulb(@NotNull HighlighterModel $this$isBackendBulb) {
        Intrinsics.checkNotNullParameter((Object)$this$isBackendBulb, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isBackendBulb.getProperties().getAttributeId(), (Object)"CaretDependentBulb");
    }

    public static final boolean isBackendGutterMark(@NotNull RangeHighlighter $this$isBackendGutterMark) {
        Intrinsics.checkNotNullParameter((Object)$this$isBackendGutterMark, (String)"<this>");
        return HighlightersUtilKt.isBackendHighlighter($this$isBackendGutterMark) && !HighlightersUtilKt.isBackendBulb($this$isBackendGutterMark) && $this$isBackendGutterMark.getGutterIconRenderer() instanceof FrontendGutterIconRenderer;
    }

    public static final boolean isBackendMethodSeparator(@NotNull RangeHighlighter $this$isBackendMethodSeparator) {
        Intrinsics.checkNotNullParameter((Object)$this$isBackendMethodSeparator, (String)"<this>");
        return HighlightersUtilKt.isBackendHighlighter($this$isBackendMethodSeparator) && $this$isBackendMethodSeparator.getLineSeparatorColor() != null && $this$isBackendMethodSeparator.getLineSeparatorPlacement() != null;
    }

    public static final boolean isFromBackend(@NotNull RangeHighlighter $this$isFromBackend) {
        Intrinsics.checkNotNullParameter((Object)$this$isFromBackend, (String)"<this>");
        return UtilKt.getBackendProperties((RangeHighlighter)$this$isFromBackend) != null;
    }

    @Nullable
    public static final String getBackendAttributeId(@NotNull RangeHighlighter $this$backendAttributeId) {
        Intrinsics.checkNotNullParameter((Object)$this$backendAttributeId, (String)"<this>");
        HighlighterProperties highlighterProperties = UtilKt.getBackendProperties((RangeHighlighter)$this$backendAttributeId);
        return highlighterProperties != null ? highlighterProperties.getAttributeId() : null;
    }

    @Nullable
    public static final String getBackendDemoTextTag(@NotNull RangeHighlighter $this$backendDemoTextTag) {
        Intrinsics.checkNotNullParameter((Object)$this$backendDemoTextTag, (String)"<this>");
        HighlighterProperties highlighterProperties = UtilKt.getBackendProperties((RangeHighlighter)$this$backendDemoTextTag);
        return highlighterProperties != null ? highlighterProperties.getDemoTextTag() : null;
    }

    @NotNull
    public static final String getBackendAttributeIdOrThrow(@NotNull RangeHighlighter $this$backendAttributeIdOrThrow) {
        Intrinsics.checkNotNullParameter((Object)$this$backendAttributeIdOrThrow, (String)"<this>");
        String string = HighlightersUtilKt.getBackendAttributeId($this$backendAttributeIdOrThrow);
        if (string == null) {
            throw new InvalidDataException("this isn't a backend highlighter");
        }
        return string;
    }

    public static /* synthetic */ void getBackendAttributeIdOrThrow$annotations(RangeHighlighter rangeHighlighter) {
    }

    @NotNull
    public static final String getBackendDemoTextTagOrThrow(@NotNull RangeHighlighter $this$backendDemoTextTagOrThrow) {
        Intrinsics.checkNotNullParameter((Object)$this$backendDemoTextTagOrThrow, (String)"<this>");
        String string = HighlightersUtilKt.getBackendDemoTextTag($this$backendDemoTextTagOrThrow);
        if (string == null) {
            throw new InvalidDataException("this isn't a backend highlighter");
        }
        return string;
    }

    @NotNull
    public static final String getAttributeKeyName(@NotNull RangeHighlighter $this$attributeKeyName) {
        Intrinsics.checkNotNullParameter((Object)$this$attributeKeyName, (String)"<this>");
        Object object = HighlightersUtilKt.getAttributeKey($this$attributeKeyName);
        if (object == null || (object = object.getExternalName()) == null) {
            object = "attributeId=" + HighlightersUtilKt.getBackendAttributeId($this$attributeKeyName);
        }
        return object;
    }

    @Nullable
    public static final TextAttributesKey getAttributeKey(@NotNull RangeHighlighter $this$attributeKey) {
        Intrinsics.checkNotNullParameter((Object)$this$attributeKey, (String)"<this>");
        HighlightInfoType highlightInfoType = HighlightersUtilKt.getHighlightInfoType($this$attributeKey);
        return highlightInfoType != null ? highlightInfoType.getAttributesKey() : null;
    }

    @Nullable
    public static final HighlightInfoType getHighlightInfoType(@NotNull RangeHighlighter $this$highlightInfoType) {
        Intrinsics.checkNotNullParameter((Object)$this$highlightInfoType, (String)"<this>");
        HighlightInfo highlightInfo = HighlightInfo.fromRangeHighlighter((RangeHighlighter)$this$highlightInfoType);
        return highlightInfo != null ? highlightInfo.type : null;
    }

    @NotNull
    public static final String prettyPrint(@NotNull RangeHighlighter $this$prettyPrint) {
        Intrinsics.checkNotNullParameter((Object)$this$prettyPrint, (String)"<this>");
        return "{\"" + HighlightersUtilKt.getAttributeKeyName($this$prettyPrint) + "\"; (" + $this$prettyPrint.getStartOffset() + ", " + $this$prettyPrint.getEndOffset() + ")}";
    }

    @NotNull
    public static final String prettyPrint(@NotNull HighlighterModel $this$prettyPrint) {
        Intrinsics.checkNotNullParameter((Object)$this$prettyPrint, (String)"<this>");
        return "{id=" + $this$prettyPrint.getId() + "; attributeId=" + $this$prettyPrint.getProperties().getAttributeId() + "; (" + $this$prettyPrint.getStart() + ", " + $this$prettyPrint.getEnd() + ")}";
    }

    @Nullable
    public static final HighlightSeverity getSeverity(@NotNull RangeHighlighter $this$severity) {
        Intrinsics.checkNotNullParameter((Object)$this$severity, (String)"<this>");
        HighlightInfoType highlightInfoType = HighlightersUtilKt.getHighlightInfoType($this$severity);
        HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = highlightInfoType instanceof HighlightInfoType.HighlightInfoTypeImpl ? (HighlightInfoType.HighlightInfoTypeImpl)highlightInfoType : null;
        return highlightInfoTypeImpl != null ? highlightInfoTypeImpl.getSeverity(null) : null;
    }

    @Nullable
    public static final Color getErrorStripeColor(@NotNull HighlightInfo $this$getErrorStripeColor, @NotNull EditorColorsScheme colorsScheme) {
        Color colorFromKey;
        Color colorFromAtt;
        Intrinsics.checkNotNullParameter((Object)$this$getErrorStripeColor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)colorsScheme, (String)"colorsScheme");
        TextAttributes textAttributes = $this$getErrorStripeColor.forcedTextAttributes;
        Color color = colorFromAtt = textAttributes != null ? textAttributes.getErrorStripeColor() : null;
        if (colorFromAtt != null) {
            return colorFromAtt;
        }
        TextAttributes textAttributes2 = colorsScheme.getAttributes($this$getErrorStripeColor.forcedTextAttributesKey);
        Color color2 = colorFromKey = textAttributes2 != null ? textAttributes2.getErrorStripeColor() : null;
        if (colorFromKey != null) {
            return colorFromKey;
        }
        TextAttributes textAttributes3 = HighlightersUtilKt.attributesFromSeverity($this$getErrorStripeColor, colorsScheme);
        return textAttributes3 != null ? textAttributes3.getErrorStripeColor() : null;
    }

    @Nullable
    public static final TextAttributes attributesFromSeverity(@NotNull HighlightInfo info2, @NotNull EditorColorsScheme colorsScheme) {
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        Intrinsics.checkNotNullParameter((Object)colorsScheme, (String)"colorsScheme");
        HighlightSeverity highlightSeverity = info2.getSeverity();
        TextAttributesKey key = Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.ERROR) ? CodeInsightColors.ERRORS_ATTRIBUTES : (Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.WARNING) ? CodeInsightColors.WARNINGS_ATTRIBUTES : (Intrinsics.areEqual((Object)highlightSeverity, (Object)SuggestionSeveritiesProvider.Companion.getSUGGESTION_SEVERITY()) ? SuggestionSeveritiesProvider.Companion.getSUGGESTION() : (Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.WEAK_WARNING) ? CodeInsightColors.WEAK_WARNING_ATTRIBUTES : (Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.INFORMATION) ? CodeInsightColors.INFORMATION_ATTRIBUTES : (Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING) ? CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING : null)))));
        return colorsScheme.getAttributes(key);
    }

    public static final void vanishHighlighters(@NotNull Lifetime lifetime, @NotNull TextRange range, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!RLifetimeKt.isAlive((Lifetime)lifetime)) {
            return;
        }
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)editor.getDocument(), (Project)editor.getProject(), (boolean)true);
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        MarkupModelEx markupModel2 = (MarkupModelEx)markupModel;
        if (!(!editor.getDocument().isInBulkUpdate())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        TextRange textRange = SelectWordUtil.getWordOrLexemeSelectionRange((Editor)editor, (int)range.getStartOffset(), (SelectWordUtil.CharCondition)SelectWordUtil.JAVA_IDENTIFIER_PART_CONDITION);
        if (textRange == null) {
            textRange = range;
        }
        TextRange textRange2 = textRange;
        int start = RangeUtilKt.component1(textRange2);
        int end = RangeUtilKt.component2(textRange2);
        markupModel2.processRangeHighlightersOverlappingWith(start, end, arg_0 -> HighlightersUtilKt.vanishHighlighters$lambda$2(arg_0 -> HighlightersUtilKt.vanishHighlighters$lambda$1(lifetime, arg_0), arg_0));
    }

    private static final boolean shouldBeVanished(RangeHighlighterEx h) {
        HighlighterProperties highlighterProperties = UtilKt.getBackendProperties((RangeHighlighter)((RangeHighlighter)h));
        if (highlighterProperties == null) {
            return false;
        }
        HighlighterProperties properties = highlighterProperties;
        if (!properties.isVerifiable()) {
            return false;
        }
        for (TextAttributesKey attributesKey = HighlightersUtilKt.getAttributeKey((RangeHighlighter)h); attributesKey != null; attributesKey = attributesKey.getFallbackAttributeKey()) {
            String string = attributesKey.getExternalName();
            if (!Intrinsics.areEqual((Object)string, (Object)"HTML_TAG") && !Intrinsics.areEqual((Object)string, (Object)CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES.getExternalName()) && !Intrinsics.areEqual((Object)string, (Object)EditorColors.INJECTED_LANGUAGE_FRAGMENT.getExternalName())) continue;
            return false;
        }
        return true;
    }

    private static final Unit vanishHighlighters$lambda$1$lambda$0(RangeHighlighterEx $it, TextAttributes $textAttributes) {
        if ($it.isValid()) {
            $it.setTextAttributes($textAttributes);
        }
        return Unit.INSTANCE;
    }

    private static final boolean vanishHighlighters$lambda$1(Lifetime $lifetime, RangeHighlighterEx it) {
        Intrinsics.checkNotNull((Object)it);
        if (!HighlightersUtilKt.shouldBeVanished(it)) {
            return true;
        }
        TextAttributes textAttributes = it.getTextAttributes(null);
        if (textAttributes == null) {
            return true;
        }
        TextAttributes textAttributes2 = textAttributes;
        if (Intrinsics.areEqual((Object)textAttributes2, (Object)TextAttributes.ERASE_MARKER)) {
            return true;
        }
        it.setTextAttributes(TextAttributes.ERASE_MARKER);
        RLifetimeKt.plusAssign((Lifetime)$lifetime, () -> HighlightersUtilKt.vanishHighlighters$lambda$1$lambda$0(it, textAttributes2));
        return true;
    }

    private static final boolean vanishHighlighters$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

