/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.impl.backend.shelf;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.shelf.ShelvedWrapper;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.util.PathUtil;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0003B!\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u0011\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000H\u0096\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/intellij/platform/vcs/impl/backend/shelf/ShelvedChangeNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "Lcom/intellij/openapi/vcs/changes/shelf/ShelvedWrapper;", "", "shelvedChange", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "additionalText", "", "<init>", "(Lcom/intellij/openapi/vcs/changes/shelf/ShelvedWrapper;Lcom/intellij/openapi/vcs/FilePath;Ljava/lang/String;)V", "getShelvedChange", "()Lcom/intellij/openapi/vcs/changes/shelf/ShelvedWrapper;", "getFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "getAdditionalText", "()Ljava/lang/String;", "getTextPresentation", "isFile", "", "compareTo", "", "o", "getBackgroundColor", "Ljava/awt/Color;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl.backend"})
public final class ShelvedChangeNode
extends ChangesBrowserNode<ShelvedWrapper>
implements Comparable<ShelvedChangeNode> {
    @NotNull
    private final ShelvedWrapper shelvedChange;
    @NotNull
    private final FilePath filePath;
    @Nullable
    private final String additionalText;

    public ShelvedChangeNode(@NotNull ShelvedWrapper shelvedChange, @NotNull FilePath filePath, @Nullable String additionalText) {
        Intrinsics.checkNotNullParameter((Object)shelvedChange, (String)"shelvedChange");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        super((Object)shelvedChange);
        this.shelvedChange = shelvedChange;
        this.filePath = filePath;
        this.additionalText = additionalText;
    }

    @NotNull
    public final ShelvedWrapper getShelvedChange() {
        return this.shelvedChange;
    }

    @NotNull
    public final FilePath getFilePath() {
        return this.filePath;
    }

    @Nullable
    public final String getAdditionalText() {
        return this.additionalText;
    }

    @NotNull
    public String getTextPresentation() {
        String string = PathUtil.getFileName((String)this.shelvedChange.getRequestName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        return string;
    }

    protected boolean isFile() {
        return true;
    }

    @Override
    public int compareTo(@NotNull ShelvedChangeNode o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        return ChangesBrowserNode.compareFilePaths((FilePath)this.filePath, (FilePath)o.filePath);
    }

    @Nullable
    public Color getBackgroundColor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ChangesBrowserNode.getBackgroundColorFor((Project)project, (Object)this.filePath);
    }
}

