/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.edt;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import javax.swing.SwingUtilities;
import org.assertj.core.util.Throwables;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.dependency.jsr305.concurrent.GuardedBy;
import org.assertj.swing.dependency.jsr305.concurrent.ThreadSafe;
import org.assertj.swing.edt.GuiAction;
import org.assertj.swing.edt.GuiActionRunnable;
import org.assertj.swing.edt.GuiQuery;
import org.assertj.swing.edt.GuiTask;
import org.assertj.swing.exception.UnexpectedException;

@ThreadSafe
public class GuiActionRunner {
    @GuardedBy(value="this")
    private static boolean executeInEDT = true;

    public static synchronized void executeInEDT(boolean b) {
        executeInEDT = b;
    }

    public static synchronized boolean executeInEDT() {
        return executeInEDT;
    }

    @Nullable
    public static <T> T execute(final @Nonnull Callable<T> query) {
        return GuiActionRunner.execute(new GuiQuery<T>(){

            @Override
            protected T executeInEDT() throws Throwable {
                return query.call();
            }
        });
    }

    @Nullable
    public static <T> T execute(@Nonnull GuiQuery<T> query) {
        if (!executeInEDT) {
            return GuiActionRunner.executeInCurrentThread(query);
        }
        GuiActionRunner.run(query);
        return GuiActionRunner.resultOf(query);
    }

    @Nullable
    private static <T> T executeInCurrentThread(@Nonnull GuiQuery<T> query) {
        try {
            return query.executeInEDT();
        }
        catch (Throwable e) {
            throw UnexpectedException.unexpected(e);
        }
    }

    public static void execute(final @Nonnull GuiActionRunnable task2) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                task2.run();
            }
        });
    }

    public static void execute(@Nonnull GuiTask task2) {
        if (!executeInEDT) {
            GuiActionRunner.executeInCurrentThread(task2);
            return;
        }
        GuiActionRunner.run(task2);
        GuiActionRunner.rethrowCaughtExceptionIn(task2);
    }

    private static void executeInCurrentThread(@Nonnull GuiTask task2) {
        try {
            task2.executeInEDT();
        }
        catch (Throwable e) {
            throw UnexpectedException.unexpected(e);
        }
    }

    private static void run(@Nonnull GuiAction action) {
        if (SwingUtilities.isEventDispatchThread()) {
            action.run();
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        action.executionNotification(latch);
        SwingUtilities.invokeLater(action);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Nullable
    private static <T> T resultOf(@Nonnull GuiQuery<T> query) {
        T result = query.result();
        query.clearResult();
        GuiActionRunner.rethrowCaughtExceptionIn(query);
        return result;
    }

    private static void rethrowCaughtExceptionIn(@Nonnull GuiAction action) {
        Throwable caughtException = action.catchedException();
        action.clearCaughtException();
        if (caughtException == null) {
            return;
        }
        if (caughtException instanceof RuntimeException) {
            Throwables.appendStackTraceInCurrentThreadToThrowable((Throwable)caughtException, (String)"execute");
            throw (RuntimeException)caughtException;
        }
        if (caughtException instanceof Error) {
            caughtException.fillInStackTrace();
            throw (Error)caughtException;
        }
        throw UnexpectedException.unexpected(caughtException);
    }
}

