/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.IndentInfo;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateLanguage;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtils;
import org.jetbrains.plugins.textmate.editor.Utils;
import org.jetbrains.plugins.textmate.language.preferences.IndentAction;
import org.jetbrains.plugins.textmate.language.preferences.IndentationRules;
import org.jetbrains.plugins.textmate.language.preferences.OnEnterRule;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistry;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J-\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/textmate/editor/TextMateLineIndentProvider;", "Lcom/intellij/psi/codeStyle/lineIndent/LineIndentProvider;", "<init>", "()V", "getLineIndent", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "language", "Lcom/intellij/lang/Language;", "offset", "", "isSuitableFor", "", "getIndentChange", "prevLineText", "indentationRules", "Lorg/jetbrains/plugins/textmate/language/preferences/IndentationRules;", "onEnterRules", "", "Lorg/jetbrains/plugins/textmate/language/preferences/OnEnterRule;", "(Ljava/lang/String;Lorg/jetbrains/plugins/textmate/language/preferences/IndentationRules;Ljava/util/List;)Ljava/lang/Integer;", "intellij.textmate"})
@SourceDebugExtension(value={"SMAP\nTextMateLineIndentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateLineIndentProvider.kt\norg/jetbrains/plugins/textmate/editor/TextMateLineIndentProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,107:1\n1797#2,3:108\n1611#2,9:111\n1863#2:120\n1864#2:122\n1620#2:123\n1#3:121\n25#4:124\n25#4:125\n25#4:126\n*S KotlinDebug\n*F\n+ 1 TextMateLineIndentProvider.kt\norg/jetbrains/plugins/textmate/editor/TextMateLineIndentProvider\n*L\n30#1:108,3\n31#1:111,9\n31#1:120\n31#1:122\n31#1:123\n31#1:121\n80#1:124\n91#1:125\n102#1:126\n*E\n"})
public final class TextMateLineIndentProvider
implements LineIndentProvider {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public String getLineIndent(@NotNull Project project, @NotNull Editor editor, @Nullable Language language, int offset) {
        void $this$mapNotNullTo$iv$iv;
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!(language instanceof TextMateLanguage)) {
            return null;
        }
        TextMateScope textMateScope = TextMateEditorUtils.getCurrentScopeSelector((EditorEx)editor);
        if (textMateScope == null) {
            return null;
        }
        TextMateScope actualScope = textMateScope;
        PreferencesRegistry preferencesRegistry = TextMateService.getInstance().getPreferenceRegistry();
        Intrinsics.checkNotNullExpressionValue((Object)preferencesRegistry, (String)"getPreferenceRegistry(...)");
        PreferencesRegistry registry = preferencesRegistry;
        List<Preferences> preferencesList = registry.getPreferences(actualScope);
        Iterable iterable = preferencesList;
        IndentationRules initial$iv = IndentationRules.Companion.empty();
        boolean $i$f$fold = false;
        Object accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void r;
            Preferences preferences = (Preferences)element$iv;
            IndentationRules x = accumulator$iv;
            boolean bl = false;
            accumulator$iv = x.updateWith(r.getIndentationRules());
        }
        IndentationRules indentationRules = accumulator$iv;
        Iterable $this$mapNotNull$iv = preferencesList;
        boolean $i$f$mapNotNull = false;
        accumulator$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Set<OnEnterRule> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Preferences it = (Preferences)element$iv$iv;
            boolean bl2 = false;
            if (it.getOnEnterRules() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List onEnterRules = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        DocumentEx documentEx = ((EditorEx)editor).getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        int lineNumber = document.getLineNumber(offset);
        if ((long)lineNumber <= 0L) {
            return null;
        }
        int lineOffset = document.getLineStartOffset(lineNumber);
        if ((long)lineOffset <= 0L) {
            return null;
        }
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String prevLineText = (String)StringsKt.lines((CharSequence)string).get(lineNumber - 1);
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getSettings((Project)project, (VirtualFile)((EditorEx)editor).getVirtualFile()).getIndentOptionsByFile(project, ((EditorEx)editor).getVirtualFile(), null);
        Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"getIndentOptionsByFile(...)");
        CommonCodeStyleSettings.IndentOptions options = indentOptions;
        Integer indentChange = this.getIndentChange(prevLineText, indentationRules, onEnterRules);
        if (indentChange != null) {
            int baseLineIndent = Utils.Companion.indentOfLine(prevLineText, options);
            return new IndentInfo(0, baseLineIndent + indentChange * options.TAB_SIZE, 0).generateNewWhiteSpace(options);
        }
        return null;
    }

    public boolean isSuitableFor(@Nullable Language language) {
        return language != null && language instanceof TextMateLanguage;
    }

    private final Integer getIndentChange(String prevLineText, IndentationRules indentationRules, List<OnEnterRule> onEnterRules) {
        Object $this$thisLogger$iv;
        for (OnEnterRule onEnterRule : onEnterRules) {
            String beforeTextPatter = onEnterRule.getBeforeText().getText();
            try {
                CharSequence charSequence = prevLineText;
                if (!new Regex(beforeTextPatter).containsMatchIn(charSequence)) continue;
                switch (WhenMappings.$EnumSwitchMapping$0[onEnterRule.getAction().getIndent().ordinal()]) {
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return null;
                    }
                }
            }
            catch (Exception e) {
                TextMateLineIndentProvider $this$thisLogger$iv2 = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(TextMateLineIndentProvider.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Using regex onEnterRule.beforeText failed", (Throwable)e);
            }
        }
        String increasePattern = indentationRules.getIncreaseIndentPattern();
        try {
            CharSequence charSequence;
            if (increasePattern != null && new Regex(increasePattern).matches(charSequence = (CharSequence)prevLineText)) {
                return 1;
            }
        }
        catch (Exception exception) {
            $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(TextMateLineIndentProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Using regex indentationRules.increaseIndentPattern failed", (Throwable)exception);
        }
        String string = indentationRules.getDecreaseIndentPattern();
        try {
            if (string != null && new Regex(string).matches((CharSequence)($this$thisLogger$iv = (CharSequence)prevLineText))) {
                return -1;
            }
        }
        catch (Exception e) {
            TextMateLineIndentProvider $this$thisLogger$iv3 = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(TextMateLineIndentProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Using regex indentationRules.decreaseIndentPattern failed", (Throwable)e);
        }
        return null;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IndentAction.values().length];
            try {
                nArray[IndentAction.INDENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IndentAction.NONE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

