/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.feedback;

import com.intellij.openapi.project.Project;
import com.intellij.platform.feedback.dialog.BaseFeedbackSystemInfoDialogKt;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialog;
import com.intellij.platform.feedback.dialog.CommonFeedbackSystemData;
import com.intellij.platform.feedback.dialog.uiBlocks.CheckBoxGroupBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.CheckBoxItemData;
import com.intellij.platform.feedback.dialog.uiBlocks.DescriptionBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.FeedbackBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.RatingBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.TextAreaBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.TopLabelBlock;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;
import org.jetbrains.plugins.terminal.block.feedback.ReworkedTerminalFeedbackSurveyKt;
import org.jetbrains.plugins.terminal.block.feedback.ReworkedTerminalUsageData;
import org.jetbrains.plugins.terminal.fus.TerminalShellInfoStatistics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001cH\u0002R\u0014\u0010\t\u001a\u00020\nX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00028TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0094\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/terminal/block/feedback/ReworkedTerminalFeedbackDialog;", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialog;", "Lorg/jetbrains/plugins/terminal/block/feedback/ReworkedTerminalUsageData;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "myFeedbackReportId", "", "getMyFeedbackReportId", "()Ljava/lang/String;", "myTitle", "getMyTitle", "mySystemInfoData", "getMySystemInfoData", "()Lorg/jetbrains/plugins/terminal/block/feedback/ReworkedTerminalUsageData;", "mySystemInfoData$delegate", "Lkotlin/Lazy;", "myShowFeedbackSystemInfoDialog", "Lkotlin/Function0;", "", "getMyShowFeedbackSystemInfoDialog$annotations", "()V", "getMyShowFeedbackSystemInfoDialog", "()Lkotlin/jvm/functions/Function0;", "myBlocks", "", "Lcom/intellij/platform/feedback/dialog/uiBlocks/FeedbackBlock;", "getMyBlocks", "()Ljava/util/List;", "improvementItems", "Lcom/intellij/platform/feedback/dialog/uiBlocks/CheckBoxItemData;", "intellij.terminal"})
public final class ReworkedTerminalFeedbackDialog
extends BlockBasedFeedbackDialog<ReworkedTerminalUsageData> {
    @NotNull
    private final String myFeedbackReportId;
    @NotNull
    private final String myTitle;
    @NotNull
    private final Lazy mySystemInfoData$delegate;
    @NotNull
    private final Function0<Unit> myShowFeedbackSystemInfoDialog;
    @NotNull
    private final List<FeedbackBlock> myBlocks;

    public ReworkedTerminalFeedbackDialog(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, forTest);
        this.myFeedbackReportId = "reworked_terminal";
        String string = TerminalBundle.message("feedback.dialog.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.myTitle = string;
        this.mySystemInfoData$delegate = LazyKt.lazy(() -> ReworkedTerminalFeedbackDialog.mySystemInfoData_delegate$lambda$0(project));
        this.myShowFeedbackSystemInfoDialog = () -> ReworkedTerminalFeedbackDialog.myShowFeedbackSystemInfoDialog$lambda$4(this);
        Object[] objectArray = new FeedbackBlock[6];
        String string2 = TerminalBundle.message("feedback.dialog.header", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        objectArray[0] = new TopLabelBlock(string2);
        String string3 = TerminalBundle.message("feedback.dialog.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        objectArray[1] = new DescriptionBlock(string3);
        String string4 = TerminalBundle.message("feedback.dialog.rating.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        objectArray[2] = new RatingBlock(string4, "overall_rating");
        String string5 = TerminalBundle.message("feedback.dialog.issues", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        objectArray[3] = new TextAreaBlock(string5, "issues");
        String string6 = TerminalBundle.message("feedback.dialog.improvement", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        objectArray[4] = CheckBoxGroupBlock.addOtherTextField$default((CheckBoxGroupBlock)new CheckBoxGroupBlock(string6, CollectionsKt.shuffled((Iterable)this.improvementItems()), "important_improvement"), null, (int)1, null);
        String string7 = TerminalBundle.message("feedback.dialog.other", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
        TextAreaBlock textAreaBlock = new TextAreaBlock(string7, "extra");
        String string8 = TerminalBundle.message("feedback.dialog.other.placeholder", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(...)");
        objectArray[5] = textAreaBlock.setPlaceholder(string8);
        this.myBlocks = CollectionsKt.listOf((Object[])objectArray);
        this.init();
    }

    @NotNull
    protected String getMyFeedbackReportId() {
        return this.myFeedbackReportId;
    }

    @NotNull
    protected String getMyTitle() {
        return this.myTitle;
    }

    @NotNull
    protected ReworkedTerminalUsageData getMySystemInfoData() {
        Lazy lazy = this.mySystemInfoData$delegate;
        return (ReworkedTerminalUsageData)lazy.getValue();
    }

    @NotNull
    protected Function0<Unit> getMyShowFeedbackSystemInfoDialog() {
        return this.myShowFeedbackSystemInfoDialog;
    }

    protected static /* synthetic */ void getMyShowFeedbackSystemInfoDialog$annotations() {
    }

    @NotNull
    protected List<FeedbackBlock> getMyBlocks() {
        return this.myBlocks;
    }

    private final List<CheckBoxItemData> improvementItems() {
        Object[] objectArray = new CheckBoxItemData[5];
        String string = TerminalBundle.message("feedback.dialog.improvement.compatibility", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray[0] = new CheckBoxItemData(string, "app_compatibility");
        String string2 = TerminalBundle.message("feedback.dialog.improvement.performance", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        objectArray[1] = new CheckBoxItemData(string2, "performance");
        String string3 = TerminalBundle.message("feedback.dialog.improvement.shell.support", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        objectArray[2] = new CheckBoxItemData(string3, "shell_support");
        String string4 = TerminalBundle.message("feedback.dialog.improvement.ai.integration", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        objectArray[3] = new CheckBoxItemData(string4, "ai_integration");
        String string5 = TerminalBundle.message("feedback.dialog.improvement.ide.integration", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        objectArray[4] = new CheckBoxItemData(string5, "ide_integration");
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final ReworkedTerminalUsageData mySystemInfoData_delegate$lambda$0(Project $project) {
        return new ReworkedTerminalUsageData(TerminalShellInfoStatistics.INSTANCE.getShellNameForStat(TerminalProjectOptionsProvider.Companion.getInstance($project).getShellPath()), ReworkedTerminalFeedbackSurveyKt.getFeedbackMoment($project), CommonFeedbackSystemData.Companion.getCurrentData());
    }

    private static final Unit myShowFeedbackSystemInfoDialog$lambda$4$lambda$3$lambda$1(ReworkedTerminalFeedbackDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(this$0.getMySystemInfoData().getSelectedShell());
        return Unit.INSTANCE;
    }

    private static final Unit myShowFeedbackSystemInfoDialog$lambda$4$lambda$3$lambda$2(ReworkedTerminalFeedbackDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(this$0.getMySystemInfoData().getFeedbackMoment().toString());
        return Unit.INSTANCE;
    }

    private static final Unit myShowFeedbackSystemInfoDialog$lambda$4$lambda$3(ReworkedTerminalFeedbackDialog this$0, Panel $this$showFeedbackSystemInfoDialog) {
        Intrinsics.checkNotNullParameter((Object)$this$showFeedbackSystemInfoDialog, (String)"$this$showFeedbackSystemInfoDialog");
        String string = TerminalBundle.message("feedback.system.info.shell", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$showFeedbackSystemInfoDialog.row(string, arg_0 -> ReworkedTerminalFeedbackDialog.myShowFeedbackSystemInfoDialog$lambda$4$lambda$3$lambda$1(this$0, arg_0));
        String string2 = TerminalBundle.message("feedback.system.info.moment", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$showFeedbackSystemInfoDialog.row(string2, arg_0 -> ReworkedTerminalFeedbackDialog.myShowFeedbackSystemInfoDialog$lambda$4$lambda$3$lambda$2(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit myShowFeedbackSystemInfoDialog$lambda$4(ReworkedTerminalFeedbackDialog this$0) {
        BaseFeedbackSystemInfoDialogKt.showFeedbackSystemInfoDialog((Project)this$0.getMyProject(), (CommonFeedbackSystemData)this$0.getMySystemInfoData().getSystemInfo(), arg_0 -> ReworkedTerminalFeedbackDialog.myShowFeedbackSystemInfoDialog$lambda$4$lambda$3(this$0, arg_0));
        return Unit.INSTANCE;
    }
}

