/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalStartupMoment;
import org.jetbrains.plugins.terminal.block.BlockTerminalStartupResponsivenessReporterKt;
import org.jetbrains.plugins.terminal.block.session.ShellCommandListener;
import org.jetbrains.plugins.terminal.fus.TerminalUsageTriggerCollector;
import org.jetbrains.plugins.terminal.fus.TimeSpanType;
import org.jetbrains.plugins.terminal.util.ShellType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u00070\t\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/terminal/block/BlockTerminalStartupResponsivenessReporter;", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandListener;", "project", "Lcom/intellij/openapi/project/Project;", "startupMoment", "Lorg/jetbrains/plugins/terminal/TerminalStartupMoment;", "shellType", "Lorg/jetbrains/plugins/terminal/util/ShellType;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/TerminalStartupMoment;Lorg/jetbrains/plugins/terminal/util/ShellType;Lcom/intellij/openapi/Disposable;)V", "disposable", "Lorg/jetbrains/annotations/NotNull;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "durationToCursorShownInInitializationBlock", "Ljava/time/Duration;", "initialized", "", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nBlockTerminalStartupResponsivenessReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockTerminalStartupResponsivenessReporter.kt\norg/jetbrains/plugins/terminal/block/BlockTerminalStartupResponsivenessReporter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n25#2:52\n1863#3,2:53\n*S KotlinDebug\n*F\n+ 1 BlockTerminalStartupResponsivenessReporter.kt\norg/jetbrains/plugins/terminal/block/BlockTerminalStartupResponsivenessReporter\n*L\n35#1:52\n36#1:53,2\n*E\n"})
final class BlockTerminalStartupResponsivenessReporter
implements ShellCommandListener {
    @NotNull
    private final Project project;
    @NotNull
    private final TerminalStartupMoment startupMoment;
    @NotNull
    private final ShellType shellType;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final java.time.Duration durationToCursorShownInInitializationBlock;

    public BlockTerminalStartupResponsivenessReporter(@NotNull Project project, @NotNull TerminalStartupMoment startupMoment, @NotNull ShellType shellType, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)startupMoment, (String)"startupMoment");
        Intrinsics.checkNotNullParameter((Object)((Object)shellType), (String)"shellType");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.startupMoment = startupMoment;
        this.shellType = shellType;
        Disposable disposable = Disposer.newDisposable((Disposable)parentDisposable);
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        this.durationToCursorShownInInitializationBlock = this.startupMoment.elapsedNow();
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.disposable;
    }

    @Override
    public void initialized() {
        java.time.Duration durationToReadyPrompt = this.startupMoment.elapsedNow();
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)((Object)TimeSpanType.FROM_STARTUP_TO_SHOWN_CURSOR), (Object)this.durationToCursorShownInInitializationBlock), TuplesKt.to((Object)((Object)TimeSpanType.FROM_STARTUP_TO_READY_PROMPT), (Object)durationToReadyPrompt)};
        List metrics = CollectionsKt.listOf((Object[])objectArray);
        BlockTerminalStartupResponsivenessReporter $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(BlockTerminalStartupResponsivenessReporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info(this.shellType + " block terminal started fully (" + CollectionsKt.joinToString$default((Iterable)metrics, null, null, null, (int)0, null, BlockTerminalStartupResponsivenessReporter::initialized$lambda$0, (int)31, null) + ")");
        Iterable $this$forEach$iv = metrics;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            java.time.Duration duration = (java.time.Duration)it.getSecond();
            TerminalUsageTriggerCollector.logBlockTerminalTimeSpanFinished-Wn2Vu4Y$intellij_terminal(this.project, this.shellType, (TimeSpanType)((Object)it.getFirst()), Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration.getNano(), (DurationUnit)DurationUnit.NANOSECONDS)));
        }
        Disposer.dispose((Disposable)this.disposable);
    }

    private static final CharSequence initialized$lambda$0(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return BlockTerminalStartupResponsivenessReporterKt.access$formatMessage((TimeSpanType)((Object)it.getFirst()), (java.time.Duration)it.getSecond());
    }
}

