/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.action;

import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.ApplicationKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalEngine;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.block.feedback.ReworkedTerminalFeedbackSurveyKt;
import org.jetbrains.plugins.terminal.fus.TerminalOpeningWay;
import org.jetbrains.plugins.terminal.fus.TerminalStartupFusInfo;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/terminal/frontend/action/TerminalChangeEngineAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "engine", "Lorg/jetbrains/plugins/terminal/TerminalEngine;", "<init>", "(Lorg/jetbrains/plugins/terminal/TerminalEngine;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Lcom/intellij/terminal/frontend/action/TerminalClassicEngineAction;", "Lcom/intellij/terminal/frontend/action/TerminalNewTerminalEngineAction;", "Lcom/intellij/terminal/frontend/action/TerminalReworkedEngineAction;", "intellij.terminal.frontend"})
public abstract class TerminalChangeEngineAction
extends DumbAwareToggleAction {
    @NotNull
    private final TerminalEngine engine;

    private TerminalChangeEngineAction(TerminalEngine engine) {
        this.engine = engine;
        this.getTemplatePresentation().setText(this.engine.getPresentableName());
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return TerminalOptionsProvider.Companion.getInstance().getTerminalEngine() == this.engine;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (state) {
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            ReworkedTerminalFeedbackSurveyKt.askForFeedbackIfReworkedTerminalDisabled(project2, TerminalOptionsProvider.Companion.getInstance().getTerminalEngine(), this.engine);
            TerminalOptionsProvider.Companion.getInstance().setTerminalEngine(this.engine);
            StoreUtilKt.saveSettingsForRemoteDevelopment((ComponentManager)((ComponentManager)ApplicationKt.getApplication()));
            TerminalStartupFusInfo startupFusInfo = new TerminalStartupFusInfo(TerminalOpeningWay.SWITCH_ENGINE, null, 2, null);
            TerminalToolWindowManager.getInstance(project2).createNewSession(startupFusInfo);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && ExperimentalUI.Companion.isNewUI() && (this.engine != TerminalEngine.NEW_TERMINAL || TerminalUtil.isGenOneTerminalOptionVisible() || TerminalOptionsProvider.Companion.getInstance().getTerminalEngine() == TerminalEngine.NEW_TERMINAL));
        e.getPresentation().setKeepPopupOnPerform(KeepPopupOnPerform.IfRequested);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public /* synthetic */ TerminalChangeEngineAction(TerminalEngine engine, DefaultConstructorMarker $constructor_marker) {
        this(engine);
    }
}

