/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n25#3:393\n25#3:394\n25#3:395\n25#3:396\n25#3:397\n25#3:398\n25#3:399\n25#3:400\n25#3:401\n25#3:402\n25#3:403\n25#3:404\n25#3:405\n25#3:406\n25#3:407\n25#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 72069300233127L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-250999050 - -26870, 250999050 - 13969, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-250999050 - -26871, -250999050 - -24027, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 107622299983002L;
                thread = Thread.currentThread();
                int[] nArray = SshAgentIpcService.l();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (nArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-990495990 + -((char)-19913), -990495990 + -((char)-17697), (int)l2) + string + WindowsNamedPipeAgentIpc.b(-990495990 + -((char)-19912), -990495990 + -((char)-27765), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-990495990 + -((char)-19915), 990495990 + (char)-28442, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                int[] nArray;
                l2 = 15740410927521L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    nArray = SshAgentIpcService.l();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-644209050 - -10121, 644209050 - 3912, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-644209050 - -10118, 644209050 - 20888, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        windowsNamedPipeAgentIpc = this;
                        if (nArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-644209050 - -10119, 644209050 - 17702, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-644209050 - -10108, 644209050 - 11236, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-644209050 - -10109, -644209050 - -4798, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-644209050 - -10119, 644209050 - 17702, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-644209050 - -10106, -644209050 - -18639, (int)l2));
            if (ActionTimestamp.l() == null) {
                SshAgentIpcService.l(new int[1]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int[] nArray;
                block6: {
                    long l2 = 130402280786949L;
                    nArray = SshAgentIpcService.l();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (nArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (nArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int[] nArray;
        long l2;
        block27: {
            block28: {
                l2 = 11302218484016L;
                int[] nArray2 = SshAgentIpcService.l();
                this.assertConnectionThread();
                Object object3 = this.lock;
                nArray = nArray2;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (nArray == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2135392440 + -((char)-7720), -2135392440 + -((char)-12401), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-2135392440 + -((char)-7732), 2135392440 + (char)-15315, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2135392440 + -((char)-7727), 2135392440 + (char)-21725, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-2135392440 + -((char)-7732), 2135392440 + (char)-15315, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2135392440 + -((char)-7726), 2135392440 + (char)-6509, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2135392440 + -((char)-7720), -2135392440 + -((char)-12401), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-2135392440 + -((char)-7732), 2135392440 + (char)-15315, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2135392440 + -((char)-7725), 2135392440 + (char)-17915, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (nArray == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2135392440 + -((char)-7720), -2135392440 + -((char)-12401), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-2135392440 + -((char)-7732), 2135392440 + (char)-15315, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2135392440 + -((char)-7724), 2135392440 + (char)-20777, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-2135392440 + -((char)-7732), 2135392440 + (char)-15315, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2135392440 + -((char)-7715), -2135392440 + -((char)-23253), (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (nArray == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-2135392440 + -((char)-7732), 2135392440 + (char)-15315, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2135392440 + -((char)-7726), 2135392440 + (char)-6509, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2135392440 + -((char)-7720), -2135392440 + -((char)-12401), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-2135392440 + -((char)-7732), 2135392440 + (char)-15315, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2135392440 + -((char)-7714), 2135392440 + (char)-10567, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 99287413084214L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-654170370 - -((char)-9221), -654039300 + -((char)-21966), (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 80921531896975L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-53083350 - -791, 53083350 - 10575, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "q\u00f9\u00b7\u0090\u00c4\u00a3\u0012\u00de\u00b2\u00182Y\u00ba\u00d3\u0092\u00ec\u001cw\u0084\u0014\u00cc\u0095\u0000\u001b)\u0010\u00d2-(`\u00a4\u0082\u00aaQQ7\u0089\u00ca1:";
                        var4_3 = "q\u00f9\u00b7\u0090\u00c4\u00a3\u0012\u00de\u00b2\u00182Y\u00ba\u00d3\u0092\u00ec\u001cw\u0084\u0014\u00cc\u0095\u0000\u001b)\u0010\u00d2-(`\u00a4\u0082\u00aaQQ7\u0089\u00ca1:".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 113;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 112;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 35;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 28;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 20;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 25;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 124;
                                        break;
                                    }
                                    default: {
                                        v11 = 32;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFD2CF) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 175;
                            case 1 -> 106;
                            case 2 -> 250;
                            case 3 -> 116;
                            case 4 -> 92;
                            case 5 -> 246;
                            case 6 -> 249;
                            case 7 -> 77;
                            case 8 -> 225;
                            case 9 -> 216;
                            case 10 -> 45;
                            case 11 -> 79;
                            case 12 -> 180;
                            case 13 -> 212;
                            case 14 -> 140;
                            case 15 -> 159;
                            case 16 -> 181;
                            case 17 -> 150;
                            case 18 -> 36;
                            case 19 -> 23;
                            case 20 -> 50;
                            case 21 -> 4;
                            case 22 -> 60;
                            case 23 -> 232;
                            case 24 -> 221;
                            case 25 -> 69;
                            case 26 -> 62;
                            case 27 -> 170;
                            case 28 -> 53;
                            case 29 -> 141;
                            case 30 -> 44;
                            case 31 -> 17;
                            case 32 -> 104;
                            case 33 -> 72;
                            case 34 -> 168;
                            case 35 -> 163;
                            case 36 -> 209;
                            case 37 -> 210;
                            case 38 -> 97;
                            case 39 -> 38;
                            case 40 -> 18;
                            case 41 -> 157;
                            case 42 -> 126;
                            case 43 -> 215;
                            case 44 -> 43;
                            case 45 -> 11;
                            case 46 -> 196;
                            case 47 -> 40;
                            case 48 -> 49;
                            case 49 -> 167;
                            case 50 -> 19;
                            case 51 -> 13;
                            case 52 -> 185;
                            case 53 -> 164;
                            case 54 -> 28;
                            case 55 -> 182;
                            case 56 -> 84;
                            case 57 -> 119;
                            case 58 -> 253;
                            case 59 -> 22;
                            case 60 -> 128;
                            case 61 -> 247;
                            case 62 -> 152;
                            case 63 -> 26;
                            case 64 -> 122;
                            case 65 -> 161;
                            case 66 -> 39;
                            case 67 -> 255;
                            case 68 -> 227;
                            case 69 -> 214;
                            case 70 -> 3;
                            case 71 -> 14;
                            case 72 -> 123;
                            case 73 -> 166;
                            case 74 -> 202;
                            case 75 -> 136;
                            case 76 -> 117;
                            case 77 -> 105;
                            case 78 -> 31;
                            case 79 -> 239;
                            case 80 -> 129;
                            case 81 -> 125;
                            case 82 -> 207;
                            case 83 -> 7;
                            case 84 -> 199;
                            case 85 -> 226;
                            case 86 -> 153;
                            case 87 -> 231;
                            case 88 -> 213;
                            case 89 -> 186;
                            case 90 -> 115;
                            case 91 -> 192;
                            case 92 -> 30;
                            case 93 -> 54;
                            case 94 -> 87;
                            case 95 -> 206;
                            case 96 -> 189;
                            case 97 -> 254;
                            case 98 -> 58;
                            case 99 -> 236;
                            case 100 -> 51;
                            case 101 -> 112;
                            case 102 -> 165;
                            case 103 -> 80;
                            case 104 -> 223;
                            case 105 -> 144;
                            case 106 -> 90;
                            case 107 -> 6;
                            case 108 -> 81;
                            case 109 -> 241;
                            case 110 -> 5;
                            case 111 -> 21;
                            case 112 -> 222;
                            case 113 -> 147;
                            case 114 -> 148;
                            case 115 -> 127;
                            case 116 -> 194;
                            case 117 -> 76;
                            case 118 -> 29;
                            case 119 -> 191;
                            case 120 -> 244;
                            case 121 -> 25;
                            case 122 -> 78;
                            case 123 -> 98;
                            case 124 -> 252;
                            case 125 -> 86;
                            case 126 -> 143;
                            case 127 -> 107;
                            case 128 -> 24;
                            case 129 -> 171;
                            case 130 -> 20;
                            case 131 -> 193;
                            case 132 -> 130;
                            case 133 -> 160;
                            case 134 -> 200;
                            case 135 -> 230;
                            case 136 -> 114;
                            case 137 -> 251;
                            case 138 -> 224;
                            case 139 -> 93;
                            case 140 -> 82;
                            case 141 -> 64;
                            case 142 -> 211;
                            case 143 -> 83;
                            case 144 -> 99;
                            case 145 -> 15;
                            case 146 -> 27;
                            case 147 -> 37;
                            case 148 -> 110;
                            case 149 -> 75;
                            case 150 -> 47;
                            case 151 -> 205;
                            case 152 -> 52;
                            case 153 -> 65;
                            case 154 -> 228;
                            case 155 -> 149;
                            case 156 -> 169;
                            case 157 -> 184;
                            case 158 -> 240;
                            case 159 -> 158;
                            case 160 -> 177;
                            case 161 -> 70;
                            case 162 -> 195;
                            case 163 -> 73;
                            case 164 -> 63;
                            case 165 -> 12;
                            case 166 -> 237;
                            case 167 -> 151;
                            case 168 -> 146;
                            case 169 -> 118;
                            case 170 -> 41;
                            case 171 -> 217;
                            case 172 -> 33;
                            case 173 -> 111;
                            case 174 -> 124;
                            case 175 -> 132;
                            case 176 -> 95;
                            case 177 -> 91;
                            case 178 -> 203;
                            case 179 -> 190;
                            case 180 -> 218;
                            case 181 -> 42;
                            case 182 -> 56;
                            case 183 -> 139;
                            case 184 -> 88;
                            case 185 -> 142;
                            case 186 -> 235;
                            case 187 -> 109;
                            case 188 -> 74;
                            case 189 -> 145;
                            case 190 -> 201;
                            case 191 -> 138;
                            case 192 -> 67;
                            case 193 -> 229;
                            case 194 -> 131;
                            case 195 -> 108;
                            case 196 -> 96;
                            case 197 -> 155;
                            case 198 -> 133;
                            case 199 -> 61;
                            case 200 -> 2;
                            case 201 -> 89;
                            case 202 -> 197;
                            case 203 -> 234;
                            case 204 -> 48;
                            case 205 -> 101;
                            case 206 -> 248;
                            case 207 -> 245;
                            case 208 -> 32;
                            case 209 -> 208;
                            case 210 -> 187;
                            case 211 -> 59;
                            case 212 -> 46;
                            case 213 -> 176;
                            case 214 -> 233;
                            case 215 -> 204;
                            case 216 -> 16;
                            case 217 -> 35;
                            case 218 -> 120;
                            case 219 -> 94;
                            case 220 -> 102;
                            case 221 -> 66;
                            case 222 -> 183;
                            case 223 -> 173;
                            case 224 -> 55;
                            case 225 -> 100;
                            case 226 -> 1;
                            case 227 -> 242;
                            case 228 -> 103;
                            case 229 -> 57;
                            case 230 -> 135;
                            case 231 -> 68;
                            case 232 -> 9;
                            case 233 -> 8;
                            case 234 -> 0;
                            case 235 -> 220;
                            case 236 -> 219;
                            case 237 -> 238;
                            case 238 -> 113;
                            case 239 -> 85;
                            case 240 -> 188;
                            case 241 -> 243;
                            case 242 -> 71;
                            case 243 -> 162;
                            case 244 -> 174;
                            case 245 -> 134;
                            case 246 -> 198;
                            case 247 -> 172;
                            case 248 -> 121;
                            case 249 -> 10;
                            case 250 -> 154;
                            case 251 -> 156;
                            case 252 -> 178;
                            case 253 -> 137;
                            case 254 -> 179;
                            default -> 34;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (nArray == null) {
                ActionTimestamp.l(new ActionTimestamp[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 94512217875488L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int[] nArray = SshAgentIpcService.l();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (nArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1462479060 + (char)-30836, 1462479060 + 22997, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1462479060 + (char)-30824, -1462479060 + -27959, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1462479060 + (char)-30811, 1462479060 + (char)-19981, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1462479060 + (char)-30836, 1462479060 + 22997, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1462479060 + (char)-30824, -1462479060 + -27959, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1462479060 + (char)-30812, 1462479060 + (char)-10668, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int[] nArray;
                    block13: {
                        long l2 = 109162931093845L;
                        int[] nArray2 = SshAgentIpcService.l();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(2042332740 - 12602, -2042332740 - -9203, (int)l2));
                        nArray = nArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (nArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (nArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(2042332740 - 12601, -2042332740 - -2003, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (nArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int[] nArray;
        long l2;
        block25: {
            block26: {
                l2 = 78160223285902L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                nArray = SshAgentIpcService.l();
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (nArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (nArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(408414120 + 32550, 408414120 + 27743, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(408414120 + 32538, -408414120 + -22781, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(408414120 + 32555, -408414120 + -25965, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(408414120 + 32538, -408414120 + -22781, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(408414120 + 32544, -408414120 + -31587, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(408414120 + 32550, 408414120 + 27743, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(408414120 + 32538, -408414120 + -22781, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(408414120 + 32554, -408414120 + -14910, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (nArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(408414120 + 32550, 408414120 + 27743, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(408414120 + 32538, -408414120 + -22781, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(408414120 + 32565, 408414120 + 7256, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (nArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(408414120 + 32550, 408414120 + 27743, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(408414120 + 32538, -408414120 + -22781, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(408414120 + 32564, -408414120 + -18938, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int[] nArray;
                block16: {
                    l2 = 131150478705703L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                nArray = SshAgentIpcService.l();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (nArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-642636210 - -10777, -642636210 - -15456, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-642636210 - -10781, 642636210 - 20416, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-642636210 - -10792, 642636210 - 5389, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-642636210 - -10793, 642636210 - 5445, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-642636210 - -10777, -642636210 - -15456, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-642636210 - -10781, 642636210 - 20416, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-642636210 - -10786, 642636210 - 16666, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (nArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (nArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-642636210 - -10777, -642636210 - -15456, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-642636210 - -10781, 642636210 - 20416, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-642636210 - -10787, 642636210 + 6583, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-642636210 - -10777, -642636210 - -15456, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-642636210 - -10781, 642636210 - 20416, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-642636210 - -10788, 642636210 + 9176, (int)l2));
                    if (nArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-642636210 - -10777, -642636210 - -15456, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-642636210 - -10781, 642636210 - 20416, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-642636210 - -10789, -642636210 - -14198, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = ";\u0004z\u00da2wm\u001c\u0014B\u00c5m\u0005.\u0004Ah\b\u00ebu\u0003\u00e1\u00ecq\u0082\u00c8\u00fbv{\u0006E\u00d2\u00b5\u0000\u00a1m\u0018U\u0013\u00ef\u00ef\u00fc\u009c\u0019\u00bb\u00cb\u00ec\u0002\u0093i\u00012\u00bd\tu`7\u00b4[\u00ac\u008c\tv\u00c2\u0015d\u00c8r\u0087.$\u0005\u001aX^Q\u00c6\b\u00d6\u00a5\u00c7\u009f\u00d7\u00f9\u00d7/\u0005\u00bd\u0087\u00aa\u00aaX\u001e>\u00fa\u00cfai\u0089\tcl\u00e3\u00bd\u00f5\u00d2\u00ed\u00e7DR\u00db\u00d9\u0016/P\u00d3 Y\u00df0\u00ad\u009f\u00ae\u0010n\u00aa!\u00ae\u00e3B\u00ae\u00e3\u00e5A\u0001\\C\u008dz\u00d7\t_ \u00e6)\u00e5\u00fc\u0004`\u00ba\u0010[\u0007\u0087\u001b7\u00f445\u00b6\u009bk\u0007\u000e\u00e6\u00d3\u00ba?}\u0015\u00af\u009ch?\u00ac\u00d9\u00a9e@\u00de\u00d2~\u00da\u000f0\u00d7\u00e8R\u0087\u008a\u00bd\u001d\u0084\u0090\u0086\u00f0~S[G\u009a3\u001e\u00d1\u00f5\u00c2\u00b6(\u00dd\u00ab\u00a6\u0094\u00a6\u00caK\n\u00ce\r:\u009cV\u00bf\u00f3\u00a2sh-\nx\u00ed\u00cd\b\u0081\u0095-\u0099\u008a9|7\f\u00cf\u0014\u00f4\u00b2\u00ac>V\u00d0\u00d3o\u0095\u009dF\u00fdE\u00b2\u0098d{Ox\u00f0v\u00fbz3\u00e2\u00f9\u00ba\u00a8\u0006\u00fb\u00c7\u00f7j\u00b03\u0013~\u0087&\u00e1\u00a0\u0092\u0005\u009f\u00cd|/cP\u00cf\u00beal\u00ba\u0097\u00fb/\u00b4\u00cb\u00d6\u00cd_.\u0015\u007f\u008d\u00a1#|\u00b14\u00d8C\u0085U<\u001deq\u0002\n\u001f\u00a7,\u00fc\u00bb\u000f\u00d2\u00c5\b\u00f5\u008e\u008eX\u00b4E \u00e0\u00d1\u00a7\u00d4SExI\u008ek\u00daa\u00c1\u00a8\u00d2\u00b9\u000b\u00d4\u0010\u00972\u00c0.\u00db\u00d2b#\u00a9\u0015$\u001a\u0089p\u0004\u000e\u00af\u00ab\u00d2\u00ecw\u00df5\u0019\r=\u008f\u0088\u00c2\u00cf\u00b1)\u00c3\u00b7p\u00c8\u009e\u00bc\u00f7\u00c5\u00b37Fo\u00a9\u00a9\u001dx)<\u0010\u0087-\u009a\u0082\u00ca}\u001bt\u0081%.\u008a\u00eab\u0095\u00a5\u00a9F\u009d\u00e0\u00ae'\u0007\b\u0017\u0003\u00c6\u00d4 %\u0007\u00c6G\u00be\u00a0\u0084\u00039(\u00fc\u00e9\u00db\"[\u008b\u00b9\u0004\n\u00d8[\u00a4)QO\u00e4d\u0002\u0017\u0003\u00ac4\u00dd\u00d4\u0006d\u00ad\u0015)\u00dc\u00d0\u00ad\u00d2\u0016-t\u00ed[\u0006\u0085\u000f\u00e3Zv}\u0006\f\u00b77\u00be3l\u0088o\u0080\u0019\"u\u00bc\u00a6\u00a9D\u0090\u00ac@\u00d8\u0087+y\u0007g\u00aco\u00f4\u00f7!\u00bc\u00e1\u00fd\u00bbv\u00c9\u00d8/'j\u00c8\u00c11%\u001d\u000e<\t\u008d\u0017yAX\u009eC\u0006\u00d3.\u0094^\u001b\u00cbht>\u00bd\u00d1U\u00d0\u00b5H\u0080\u00e6\u00aeq\u00bf\u00bb>\u00c7\u00c5&F\u009a<<r\u00fc\r\n\u001f\u00de*\u00efb\u000f}!\u001b\u0014\u0018tp\u00830B\u00ac\u008b!p\u00bf\u00fa\u0087X\u000e\u009du\r\u001ftD\b\u009d\u00ae\u008f)|D\u0087\u00b6`s(<H\b9\u0088B\\\u00ff\u00bd\u000b\u00f1\u008b\u00fbd\u0005\u00e25\u0004v\u00c6\u00c0 Z\u0091\u00f5$\u00a8\u00b8\u009a;\u00dfO\u00e6\u00d2";
                var4_3 = ";\u0004z\u00da2wm\u001c\u0014B\u00c5m\u0005.\u0004Ah\b\u00ebu\u0003\u00e1\u00ecq\u0082\u00c8\u00fbv{\u0006E\u00d2\u00b5\u0000\u00a1m\u0018U\u0013\u00ef\u00ef\u00fc\u009c\u0019\u00bb\u00cb\u00ec\u0002\u0093i\u00012\u00bd\tu`7\u00b4[\u00ac\u008c\tv\u00c2\u0015d\u00c8r\u0087.$\u0005\u001aX^Q\u00c6\b\u00d6\u00a5\u00c7\u009f\u00d7\u00f9\u00d7/\u0005\u00bd\u0087\u00aa\u00aaX\u001e>\u00fa\u00cfai\u0089\tcl\u00e3\u00bd\u00f5\u00d2\u00ed\u00e7DR\u00db\u00d9\u0016/P\u00d3 Y\u00df0\u00ad\u009f\u00ae\u0010n\u00aa!\u00ae\u00e3B\u00ae\u00e3\u00e5A\u0001\\C\u008dz\u00d7\t_ \u00e6)\u00e5\u00fc\u0004`\u00ba\u0010[\u0007\u0087\u001b7\u00f445\u00b6\u009bk\u0007\u000e\u00e6\u00d3\u00ba?}\u0015\u00af\u009ch?\u00ac\u00d9\u00a9e@\u00de\u00d2~\u00da\u000f0\u00d7\u00e8R\u0087\u008a\u00bd\u001d\u0084\u0090\u0086\u00f0~S[G\u009a3\u001e\u00d1\u00f5\u00c2\u00b6(\u00dd\u00ab\u00a6\u0094\u00a6\u00caK\n\u00ce\r:\u009cV\u00bf\u00f3\u00a2sh-\nx\u00ed\u00cd\b\u0081\u0095-\u0099\u008a9|7\f\u00cf\u0014\u00f4\u00b2\u00ac>V\u00d0\u00d3o\u0095\u009dF\u00fdE\u00b2\u0098d{Ox\u00f0v\u00fbz3\u00e2\u00f9\u00ba\u00a8\u0006\u00fb\u00c7\u00f7j\u00b03\u0013~\u0087&\u00e1\u00a0\u0092\u0005\u009f\u00cd|/cP\u00cf\u00beal\u00ba\u0097\u00fb/\u00b4\u00cb\u00d6\u00cd_.\u0015\u007f\u008d\u00a1#|\u00b14\u00d8C\u0085U<\u001deq\u0002\n\u001f\u00a7,\u00fc\u00bb\u000f\u00d2\u00c5\b\u00f5\u008e\u008eX\u00b4E \u00e0\u00d1\u00a7\u00d4SExI\u008ek\u00daa\u00c1\u00a8\u00d2\u00b9\u000b\u00d4\u0010\u00972\u00c0.\u00db\u00d2b#\u00a9\u0015$\u001a\u0089p\u0004\u000e\u00af\u00ab\u00d2\u00ecw\u00df5\u0019\r=\u008f\u0088\u00c2\u00cf\u00b1)\u00c3\u00b7p\u00c8\u009e\u00bc\u00f7\u00c5\u00b37Fo\u00a9\u00a9\u001dx)<\u0010\u0087-\u009a\u0082\u00ca}\u001bt\u0081%.\u008a\u00eab\u0095\u00a5\u00a9F\u009d\u00e0\u00ae'\u0007\b\u0017\u0003\u00c6\u00d4 %\u0007\u00c6G\u00be\u00a0\u0084\u00039(\u00fc\u00e9\u00db\"[\u008b\u00b9\u0004\n\u00d8[\u00a4)QO\u00e4d\u0002\u0017\u0003\u00ac4\u00dd\u00d4\u0006d\u00ad\u0015)\u00dc\u00d0\u00ad\u00d2\u0016-t\u00ed[\u0006\u0085\u000f\u00e3Zv}\u0006\f\u00b77\u00be3l\u0088o\u0080\u0019\"u\u00bc\u00a6\u00a9D\u0090\u00ac@\u00d8\u0087+y\u0007g\u00aco\u00f4\u00f7!\u00bc\u00e1\u00fd\u00bbv\u00c9\u00d8/'j\u00c8\u00c11%\u001d\u000e<\t\u008d\u0017yAX\u009eC\u0006\u00d3.\u0094^\u001b\u00cbht>\u00bd\u00d1U\u00d0\u00b5H\u0080\u00e6\u00aeq\u00bf\u00bb>\u00c7\u00c5&F\u009a<<r\u00fc\r\n\u001f\u00de*\u00efb\u000f}!\u001b\u0014\u0018tp\u00830B\u00ac\u008b!p\u00bf\u00fa\u0087X\u000e\u009du\r\u001ftD\b\u009d\u00ae\u008f)|D\u0087\u00b6`s(<H\b9\u0088B\\\u00ff\u00bd\u000b\u00f1\u008b\u00fbd\u0005\u00e25\u0004v\u00c6\u00c0 Z\u0091\u00f5$\u00a8\u00b8\u009a;\u00dfO\u00e6\u00d2".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 33;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00bf\n\u0088\u0000Pd\u0096Z'\u001d\u00ee\u0015\u00a7\u00ee\u0016\n\u0094a\u00ad\u00d1\u00f7\u00c1\u00e9\u0007\u00f8\u00a4\u0099\u00ac\u00fb\u00a6M\u00e3FEI\u0016\u008c\u00fb\u008b";
                    var4_3 = "\u00bf\n\u0088\u0000Pd\u0096Z'\u001d\u00ee\u0015\u00a7\u00ee\u0016\n\u0094a\u00ad\u00d1\u00f7\u00c1\u00e9\u0007\u00f8\u00a4\u0099\u00ac\u00fb\u00a6M\u00e3FEI\u0016\u008c\u00fb\u008b".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 120;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 59;
                            break;
                        }
                        case 1: {
                            v15 = 64;
                            break;
                        }
                        case 2: {
                            v15 = 113;
                            break;
                        }
                        case 3: {
                            v15 = 118;
                            break;
                        }
                        case 4: {
                            v15 = 120;
                            break;
                        }
                        case 5: {
                            v15 = 79;
                            break;
                        }
                        default: {
                            v15 = 15;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x544B) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 131;
                case 1 -> 194;
                case 2 -> 219;
                case 3 -> 89;
                case 4 -> 171;
                case 5 -> 33;
                case 6 -> 108;
                case 7 -> 138;
                case 8 -> 32;
                case 9 -> 127;
                case 10 -> 80;
                case 11 -> 113;
                case 12 -> 186;
                case 13 -> 50;
                case 14 -> 111;
                case 15 -> 62;
                case 16 -> 22;
                case 17 -> 143;
                case 18 -> 152;
                case 19 -> 18;
                case 20 -> 49;
                case 21 -> 38;
                case 22 -> 74;
                case 23 -> 117;
                case 24 -> 93;
                case 25 -> 44;
                case 26 -> 243;
                case 27 -> 36;
                case 28 -> 45;
                case 29 -> 198;
                case 30 -> 206;
                case 31 -> 196;
                case 32 -> 84;
                case 33 -> 141;
                case 34 -> 31;
                case 35 -> 182;
                case 36 -> 249;
                case 37 -> 154;
                case 38 -> 180;
                case 39 -> 167;
                case 40 -> 157;
                case 41 -> 15;
                case 42 -> 224;
                case 43 -> 238;
                case 44 -> 87;
                case 45 -> 217;
                case 46 -> 60;
                case 47 -> 126;
                case 48 -> 147;
                case 49 -> 55;
                case 50 -> 202;
                case 51 -> 213;
                case 52 -> 233;
                case 53 -> 170;
                case 54 -> 195;
                case 55 -> 240;
                case 56 -> 185;
                case 57 -> 201;
                case 58 -> 53;
                case 59 -> 245;
                case 60 -> 72;
                case 61 -> 241;
                case 62 -> 227;
                case 63 -> 40;
                case 64 -> 234;
                case 65 -> 99;
                case 66 -> 199;
                case 67 -> 39;
                case 68 -> 228;
                case 69 -> 21;
                case 70 -> 172;
                case 71 -> 225;
                case 72 -> 10;
                case 73 -> 244;
                case 74 -> 181;
                case 75 -> 160;
                case 76 -> 34;
                case 77 -> 232;
                case 78 -> 168;
                case 79 -> 118;
                case 80 -> 193;
                case 81 -> 115;
                case 82 -> 71;
                case 83 -> 212;
                case 84 -> 253;
                case 85 -> 236;
                case 86 -> 105;
                case 87 -> 148;
                case 88 -> 101;
                case 89 -> 205;
                case 90 -> 81;
                case 91 -> 75;
                case 92 -> 174;
                case 93 -> 137;
                case 94 -> 121;
                case 95 -> 130;
                case 96 -> 184;
                case 97 -> 135;
                case 98 -> 123;
                case 99 -> 109;
                case 100 -> 124;
                case 101 -> 128;
                case 102 -> 242;
                case 103 -> 142;
                case 104 -> 140;
                case 105 -> 82;
                case 106 -> 235;
                case 107 -> 190;
                case 108 -> 6;
                case 109 -> 14;
                case 110 -> 107;
                case 111 -> 57;
                case 112 -> 156;
                case 113 -> 29;
                case 114 -> 120;
                case 115 -> 54;
                case 116 -> 114;
                case 117 -> 52;
                case 118 -> 27;
                case 119 -> 47;
                case 120 -> 252;
                case 121 -> 250;
                case 122 -> 3;
                case 123 -> 255;
                case 124 -> 211;
                case 125 -> 247;
                case 126 -> 42;
                case 127 -> 122;
                case 128 -> 13;
                case 129 -> 28;
                case 130 -> 163;
                case 131 -> 132;
                case 132 -> 189;
                case 133 -> 150;
                case 134 -> 222;
                case 135 -> 177;
                case 136 -> 68;
                case 137 -> 20;
                case 138 -> 207;
                case 139 -> 56;
                case 140 -> 63;
                case 141 -> 220;
                case 142 -> 155;
                case 143 -> 46;
                case 144 -> 248;
                case 145 -> 90;
                case 146 -> 164;
                case 147 -> 98;
                case 148 -> 48;
                case 149 -> 4;
                case 150 -> 197;
                case 151 -> 100;
                case 152 -> 139;
                case 153 -> 191;
                case 154 -> 162;
                case 155 -> 218;
                case 156 -> 251;
                case 157 -> 237;
                case 158 -> 215;
                case 159 -> 2;
                case 160 -> 30;
                case 161 -> 25;
                case 162 -> 178;
                case 163 -> 65;
                case 164 -> 61;
                case 165 -> 67;
                case 166 -> 103;
                case 167 -> 254;
                case 168 -> 208;
                case 169 -> 149;
                case 170 -> 106;
                case 171 -> 24;
                case 172 -> 92;
                case 173 -> 76;
                case 174 -> 221;
                case 175 -> 7;
                case 176 -> 110;
                case 177 -> 204;
                case 178 -> 16;
                case 179 -> 69;
                case 180 -> 23;
                case 181 -> 97;
                case 182 -> 59;
                case 183 -> 125;
                case 184 -> 17;
                case 185 -> 230;
                case 186 -> 112;
                case 187 -> 214;
                case 188 -> 86;
                case 189 -> 166;
                case 190 -> 1;
                case 191 -> 88;
                case 192 -> 9;
                case 193 -> 102;
                case 194 -> 91;
                case 195 -> 85;
                case 196 -> 188;
                case 197 -> 146;
                case 198 -> 136;
                case 199 -> 116;
                case 200 -> 129;
                case 201 -> 145;
                case 202 -> 95;
                case 203 -> 169;
                case 204 -> 173;
                case 205 -> 203;
                case 206 -> 77;
                case 207 -> 144;
                case 208 -> 176;
                case 209 -> 151;
                case 210 -> 83;
                case 211 -> 41;
                case 212 -> 246;
                case 213 -> 158;
                case 214 -> 134;
                case 215 -> 133;
                case 216 -> 161;
                case 217 -> 37;
                case 218 -> 216;
                case 219 -> 165;
                case 220 -> 43;
                case 221 -> 175;
                case 222 -> 153;
                case 223 -> 12;
                case 224 -> 104;
                case 225 -> 8;
                case 226 -> 66;
                case 227 -> 35;
                case 228 -> 192;
                case 229 -> 11;
                case 230 -> 159;
                case 231 -> 226;
                case 232 -> 229;
                case 233 -> 200;
                case 234 -> 96;
                case 235 -> 210;
                case 236 -> 73;
                case 237 -> 94;
                case 238 -> 70;
                case 239 -> 5;
                case 240 -> 58;
                case 241 -> 0;
                case 242 -> 179;
                case 243 -> 223;
                case 244 -> 187;
                case 245 -> 64;
                case 246 -> 239;
                case 247 -> 183;
                case 248 -> 78;
                case 249 -> 209;
                case 250 -> 26;
                case 251 -> 119;
                case 252 -> 231;
                case 253 -> 79;
                case 254 -> 19;
                default -> 51;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 49217247873540L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1217640300 + -8867, 1217640300 + 6013, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int[] nArray;
                        block4: {
                            l2 = 122575030796122L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            nArray = SshAgentIpcService.l();
                            try {
                                hANDLE2 = hANDLE;
                                if (nArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (nArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-959170260 - -22402, 959170260 - 31996, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-959170260 - -22401, 959170260 - (char)-27022, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-959170260 - -22400, 959170260 - (char)-20228, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00fe\u00ef\u00db\u008do\u00a7\u009d\u00f2\u0010|\tz\u00f0\u00e1\u00b3\u00b5)g\u0001{=6\u00fa \u00d8";
                    var4_3 = "\u00fe\u00ef\u00db\u008do\u00a7\u009d\u00f2\u0010|\tz\u00f0\u00e1\u00b3\u00b5)g\u0001{=6\u00fa \u00d8".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 89;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00fa\u00db>n\u00c65\u00ad\u008c\u00c3\u00e8\u00ab\u00ec\u0081\f\u00f3{\u001e\u00d7\b(\u0087m\u00f9\u001dJ\u00c5\u00f1l[\u00e9v\u00ad\u0098C\u00bc\u0091\u00ae\u0017\u00d4\u00da\u00ed<\u00ca)Z2\u00af\u00f9\u00ee\u00b2\u0086\u00aa\u00b1\u00cb\u001bR\u0017.\u00f9";
                        var4_3 = "\u00fa\u00db>n\u00c65\u00ad\u008c\u00c3\u00e8\u00ab\u00ec\u0081\f\u00f3{\u001e\u00d7\b(\u0087m\u00f9\u001dJ\u00c5\u00f1l[\u00e9v\u00ad\u0098C\u00bc\u0091\u00ae\u0017\u00d4\u00da\u00ed<\u00ca)Z2\u00af\u00f9\u00ee\u00b2\u0086\u00aa\u00b1\u00cb\u001bR\u0017.\u00f9".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 49;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 89;
                                break;
                            }
                            case 1: {
                                v15 = 58;
                                break;
                            }
                            case 2: {
                                v15 = 83;
                                break;
                            }
                            case 3: {
                                v15 = 100;
                                break;
                            }
                            case 4: {
                                v15 = 34;
                                break;
                            }
                            case 5: {
                                v15 = 64;
                                break;
                            }
                            default: {
                                v15 = 104;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFAFF5) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 172;
                    case 1 -> 230;
                    case 2 -> 241;
                    case 3 -> 14;
                    case 4 -> 236;
                    case 5 -> 69;
                    case 6 -> 192;
                    case 7 -> 199;
                    case 8 -> 47;
                    case 9 -> 0;
                    case 10 -> 56;
                    case 11 -> 58;
                    case 12 -> 141;
                    case 13 -> 186;
                    case 14 -> 168;
                    case 15 -> 183;
                    case 16 -> 17;
                    case 17 -> 202;
                    case 18 -> 239;
                    case 19 -> 71;
                    case 20 -> 18;
                    case 21 -> 218;
                    case 22 -> 52;
                    case 23 -> 93;
                    case 24 -> 121;
                    case 25 -> 42;
                    case 26 -> 83;
                    case 27 -> 149;
                    case 28 -> 126;
                    case 29 -> 75;
                    case 30 -> 200;
                    case 31 -> 8;
                    case 32 -> 142;
                    case 33 -> 63;
                    case 34 -> 50;
                    case 35 -> 104;
                    case 36 -> 4;
                    case 37 -> 54;
                    case 38 -> 45;
                    case 39 -> 248;
                    case 40 -> 132;
                    case 41 -> 53;
                    case 42 -> 32;
                    case 43 -> 59;
                    case 44 -> 153;
                    case 45 -> 102;
                    case 46 -> 74;
                    case 47 -> 197;
                    case 48 -> 31;
                    case 49 -> 205;
                    case 50 -> 88;
                    case 51 -> 105;
                    case 52 -> 246;
                    case 53 -> 124;
                    case 54 -> 170;
                    case 55 -> 66;
                    case 56 -> 51;
                    case 57 -> 240;
                    case 58 -> 176;
                    case 59 -> 134;
                    case 60 -> 37;
                    case 61 -> 194;
                    case 62 -> 196;
                    case 63 -> 92;
                    case 64 -> 91;
                    case 65 -> 9;
                    case 66 -> 217;
                    case 67 -> 67;
                    case 68 -> 180;
                    case 69 -> 85;
                    case 70 -> 10;
                    case 71 -> 237;
                    case 72 -> 81;
                    case 73 -> 231;
                    case 74 -> 82;
                    case 75 -> 225;
                    case 76 -> 72;
                    case 77 -> 209;
                    case 78 -> 139;
                    case 79 -> 224;
                    case 80 -> 185;
                    case 81 -> 232;
                    case 82 -> 175;
                    case 83 -> 163;
                    case 84 -> 122;
                    case 85 -> 96;
                    case 86 -> 255;
                    case 87 -> 140;
                    case 88 -> 3;
                    case 89 -> 12;
                    case 90 -> 221;
                    case 91 -> 1;
                    case 92 -> 138;
                    case 93 -> 219;
                    case 94 -> 252;
                    case 95 -> 130;
                    case 96 -> 222;
                    case 97 -> 193;
                    case 98 -> 107;
                    case 99 -> 195;
                    case 100 -> 113;
                    case 101 -> 242;
                    case 102 -> 169;
                    case 103 -> 108;
                    case 104 -> 25;
                    case 105 -> 109;
                    case 106 -> 214;
                    case 107 -> 123;
                    case 108 -> 35;
                    case 109 -> 203;
                    case 110 -> 210;
                    case 111 -> 46;
                    case 112 -> 208;
                    case 113 -> 61;
                    case 114 -> 64;
                    case 115 -> 22;
                    case 116 -> 204;
                    case 117 -> 87;
                    case 118 -> 135;
                    case 119 -> 150;
                    case 120 -> 11;
                    case 121 -> 76;
                    case 122 -> 110;
                    case 123 -> 212;
                    case 124 -> 103;
                    case 125 -> 97;
                    case 126 -> 20;
                    case 127 -> 181;
                    case 128 -> 157;
                    case 129 -> 116;
                    case 130 -> 171;
                    case 131 -> 16;
                    case 132 -> 115;
                    case 133 -> 173;
                    case 134 -> 226;
                    case 135 -> 7;
                    case 136 -> 234;
                    case 137 -> 136;
                    case 138 -> 223;
                    case 139 -> 152;
                    case 140 -> 201;
                    case 141 -> 44;
                    case 142 -> 43;
                    case 143 -> 148;
                    case 144 -> 62;
                    case 145 -> 198;
                    case 146 -> 86;
                    case 147 -> 213;
                    case 148 -> 160;
                    case 149 -> 15;
                    case 150 -> 144;
                    case 151 -> 84;
                    case 152 -> 79;
                    case 153 -> 129;
                    case 154 -> 250;
                    case 155 -> 184;
                    case 156 -> 166;
                    case 157 -> 220;
                    case 158 -> 211;
                    case 159 -> 206;
                    case 160 -> 100;
                    case 161 -> 127;
                    case 162 -> 29;
                    case 163 -> 167;
                    case 164 -> 27;
                    case 165 -> 125;
                    case 166 -> 120;
                    case 167 -> 182;
                    case 168 -> 19;
                    case 169 -> 65;
                    case 170 -> 133;
                    case 171 -> 137;
                    case 172 -> 41;
                    case 173 -> 238;
                    case 174 -> 174;
                    case 175 -> 156;
                    case 176 -> 77;
                    case 177 -> 190;
                    case 178 -> 21;
                    case 179 -> 70;
                    case 180 -> 2;
                    case 181 -> 243;
                    case 182 -> 39;
                    case 183 -> 38;
                    case 184 -> 111;
                    case 185 -> 106;
                    case 186 -> 161;
                    case 187 -> 68;
                    case 188 -> 99;
                    case 189 -> 145;
                    case 190 -> 89;
                    case 191 -> 57;
                    case 192 -> 229;
                    case 193 -> 55;
                    case 194 -> 5;
                    case 195 -> 254;
                    case 196 -> 49;
                    case 197 -> 131;
                    case 198 -> 216;
                    case 199 -> 48;
                    case 200 -> 73;
                    case 201 -> 215;
                    case 202 -> 178;
                    case 203 -> 36;
                    case 204 -> 143;
                    case 205 -> 235;
                    case 206 -> 128;
                    case 207 -> 165;
                    case 208 -> 94;
                    case 209 -> 114;
                    case 210 -> 207;
                    case 211 -> 155;
                    case 212 -> 13;
                    case 213 -> 33;
                    case 214 -> 119;
                    case 215 -> 6;
                    case 216 -> 118;
                    case 217 -> 80;
                    case 218 -> 247;
                    case 219 -> 159;
                    case 220 -> 30;
                    case 221 -> 228;
                    case 222 -> 233;
                    case 223 -> 251;
                    case 224 -> 147;
                    case 225 -> 177;
                    case 226 -> 151;
                    case 227 -> 60;
                    case 228 -> 164;
                    case 229 -> 98;
                    case 230 -> 28;
                    case 231 -> 158;
                    case 232 -> 189;
                    case 233 -> 90;
                    case 234 -> 253;
                    case 235 -> 146;
                    case 236 -> 23;
                    case 237 -> 24;
                    case 238 -> 78;
                    case 239 -> 154;
                    case 240 -> 249;
                    case 241 -> 244;
                    case 242 -> 187;
                    case 243 -> 191;
                    case 244 -> 162;
                    case 245 -> 117;
                    case 246 -> 34;
                    case 247 -> 40;
                    case 248 -> 101;
                    case 249 -> 179;
                    case 250 -> 188;
                    case 251 -> 112;
                    case 252 -> 227;
                    case 253 -> 245;
                    case 254 -> 95;
                    default -> 26;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 2706976770074L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "(\u007f#o\u00053Bq\t/u0eHq_m3";
                    var5_4 = "(\u007f#o\u00053Bq\t/u0eHq_m3".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 18;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 81;
                                    break;
                                }
                                case 1: {
                                    v11 = 8;
                                    break;
                                }
                                case 2: {
                                    v11 = 67;
                                    break;
                                }
                                case 3: {
                                    v11 = 19;
                                    break;
                                }
                                case 4: {
                                    v11 = 114;
                                    break;
                                }
                                case 5: {
                                    v11 = 77;
                                    break;
                                }
                                default: {
                                    v11 = 99;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 45406028338320L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "iC52h\u0002m\u0004o]9(\ncB2(d\u0000uIC;\tcB2(d\u0000uEI\rdD/%n\roEN(/o\u0004";
                    var5_4 = "iC52h\u0002m\u0004o]9(\ncB2(d\u0000uIC;\tcB2(d\u0000uEI\rdD/%n\roEN(/o\u0004".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 58;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "Jh\u001a\u001cA$O\u0006Jh\u001a\u001cM.";
                        var5_4 = "Jh\u001a\u001cA$O\u0006Jh\u001a\u001cM.".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 19;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 26;
                                break;
                            }
                            case 1: {
                                v15 = 23;
                                break;
                            }
                            case 2: {
                                v15 = 102;
                                break;
                            }
                            case 3: {
                                v15 = 124;
                                break;
                            }
                            case 4: {
                                v15 = 59;
                                break;
                            }
                            case 5: {
                                v15 = 89;
                                break;
                            }
                            default: {
                                v15 = 59;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n25#2:392\n25#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 103088057249024L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(252178680 + 21986, 252178680 + 6206, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 94275029253215L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "8-R\u00cc\u0011\u00030\u00e1\u00e7\u0005\u0093\u000b\u0001\u00cc\u0098\r%\u00cb\u00e1\u009eqB\u001f\u00d2\u0097\u008d[=}\u0010\u00c8\u00f5\u009b\u00b2\u0001R:\u00ed\u00fa\u00ee\u0015\u001cRMTB\u0005\u00d1\u00b8I\u00ba\u00913\u00ba*5\u009f\u0001\u00b3\n\u00c5\u0081\u0016\u00f1*\b\u00da3\u00afM\u00e6\u0012v\u00ab\u0081\u007f\u00ce\u0081oC\u00bb\u00e43\u0088\u00a6h\u0086lA\t\u00d6*~\u00f0\u00dc\u0089-\t\u0093\u0097\n\u00a0\u00c7\u0099";
                    var4_3 = "8-R\u00cc\u0011\u00030\u00e1\u00e7\u0005\u0093\u000b\u0001\u00cc\u0098\r%\u00cb\u00e1\u009eqB\u001f\u00d2\u0097\u008d[=}\u0010\u00c8\u00f5\u009b\u00b2\u0001R:\u00ed\u00fa\u00ee\u0015\u001cRMTB\u0005\u00d1\u00b8I\u00ba\u00913\u00ba*5\u009f\u0001\u00b3\n\u00c5\u0081\u0016\u00f1*\b\u00da3\u00afM\u00e6\u0012v\u00ab\u0081\u007f\u00ce\u0081oC\u00bb\u00e43\u0088\u00a6h\u0086lA\t\u00d6*~\u00f0\u00dc\u0089-\t\u0093\u0097\n\u00a0\u00c7\u0099".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 70;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "Z\u00d0\u00a5z\u00aa'#/\u00b5\u00da\u0090\u00f6\u008e|\u00a3\bL\u00bfR\u00ee\u00e0\u00e9\u00bc%2\u00fc\u00ea\u0015I0\u0005\u00e7^\u00bee\u00ff\u009c\u0012\u00d4\u000e\u00aa\u00e0d&p\u00deoL.\u008c\u0015\u00edCg$\u00b1*\u00d9\u00c7\u000f_\u00a0o\u0005\u00c1l\u00e6\u0084R5f\u009f\u00cf\u009a\u00f0\u00dd\u00bb\u008b\\\u00bf\u00a3\u00ef\u00c1~R7\u009dQ\u009d\u0087\"\u00d5\u00e3";
                        var4_3 = "Z\u00d0\u00a5z\u00aa'#/\u00b5\u00da\u0090\u00f6\u008e|\u00a3\bL\u00bfR\u00ee\u00e0\u00e9\u00bc%2\u00fc\u00ea\u0015I0\u0005\u00e7^\u00bee\u00ff\u009c\u0012\u00d4\u000e\u00aa\u00e0d&p\u00deoL.\u008c\u0015\u00edCg$\u00b1*\u00d9\u00c7\u000f_\u00a0o\u0005\u00c1l\u00e6\u0084R5f\u009f\u00cf\u009a\u00f0\u00dd\u00bb\u008b\\\u00bf\u00a3\u00ef\u00c1~R7\u009dQ\u009d\u0087\"\u00d5\u00e3".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 38;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 95;
                                break;
                            }
                            case 1: {
                                v15 = 98;
                                break;
                            }
                            case 2: {
                                v15 = 24;
                                break;
                            }
                            case 3: {
                                v15 = 78;
                                break;
                            }
                            case 4: {
                                v15 = 107;
                                break;
                            }
                            case 5: {
                                v15 = 80;
                                break;
                            }
                            default: {
                                v15 = 46;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x2BDA) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 162;
                    case 1 -> 202;
                    case 2 -> 30;
                    case 3 -> 196;
                    case 4 -> 184;
                    case 5 -> 63;
                    case 6 -> 49;
                    case 7 -> 82;
                    case 8 -> 39;
                    case 9 -> 153;
                    case 10 -> 55;
                    case 11 -> 32;
                    case 12 -> 64;
                    case 13 -> 94;
                    case 14 -> 69;
                    case 15 -> 133;
                    case 16 -> 102;
                    case 17 -> 167;
                    case 18 -> 207;
                    case 19 -> 251;
                    case 20 -> 51;
                    case 21 -> 247;
                    case 22 -> 219;
                    case 23 -> 45;
                    case 24 -> 209;
                    case 25 -> 191;
                    case 26 -> 97;
                    case 27 -> 60;
                    case 28 -> 14;
                    case 29 -> 227;
                    case 30 -> 125;
                    case 31 -> 110;
                    case 32 -> 86;
                    case 33 -> 246;
                    case 34 -> 169;
                    case 35 -> 193;
                    case 36 -> 3;
                    case 37 -> 19;
                    case 38 -> 223;
                    case 39 -> 225;
                    case 40 -> 181;
                    case 41 -> 166;
                    case 42 -> 23;
                    case 43 -> 65;
                    case 44 -> 66;
                    case 45 -> 56;
                    case 46 -> 61;
                    case 47 -> 245;
                    case 48 -> 221;
                    case 49 -> 108;
                    case 50 -> 48;
                    case 51 -> 146;
                    case 52 -> 1;
                    case 53 -> 187;
                    case 54 -> 18;
                    case 55 -> 213;
                    case 56 -> 120;
                    case 57 -> 73;
                    case 58 -> 22;
                    case 59 -> 217;
                    case 60 -> 57;
                    case 61 -> 165;
                    case 62 -> 54;
                    case 63 -> 15;
                    case 64 -> 132;
                    case 65 -> 212;
                    case 66 -> 101;
                    case 67 -> 70;
                    case 68 -> 78;
                    case 69 -> 152;
                    case 70 -> 179;
                    case 71 -> 186;
                    case 72 -> 233;
                    case 73 -> 105;
                    case 74 -> 4;
                    case 75 -> 59;
                    case 76 -> 211;
                    case 77 -> 172;
                    case 78 -> 192;
                    case 79 -> 16;
                    case 80 -> 42;
                    case 81 -> 35;
                    case 82 -> 160;
                    case 83 -> 185;
                    case 84 -> 106;
                    case 85 -> 98;
                    case 86 -> 93;
                    case 87 -> 222;
                    case 88 -> 9;
                    case 89 -> 198;
                    case 90 -> 121;
                    case 91 -> 12;
                    case 92 -> 36;
                    case 93 -> 171;
                    case 94 -> 99;
                    case 95 -> 100;
                    case 96 -> 253;
                    case 97 -> 130;
                    case 98 -> 116;
                    case 99 -> 244;
                    case 100 -> 24;
                    case 101 -> 27;
                    case 102 -> 127;
                    case 103 -> 144;
                    case 104 -> 83;
                    case 105 -> 33;
                    case 106 -> 195;
                    case 107 -> 114;
                    case 108 -> 178;
                    case 109 -> 122;
                    case 110 -> 13;
                    case 111 -> 8;
                    case 112 -> 113;
                    case 113 -> 142;
                    case 114 -> 26;
                    case 115 -> 131;
                    case 116 -> 104;
                    case 117 -> 87;
                    case 118 -> 2;
                    case 119 -> 90;
                    case 120 -> 44;
                    case 121 -> 107;
                    case 122 -> 124;
                    case 123 -> 139;
                    case 124 -> 31;
                    case 125 -> 141;
                    case 126 -> 118;
                    case 127 -> 226;
                    case 128 -> 155;
                    case 129 -> 189;
                    case 130 -> 203;
                    case 131 -> 119;
                    case 132 -> 0;
                    case 133 -> 242;
                    case 134 -> 232;
                    case 135 -> 126;
                    case 136 -> 134;
                    case 137 -> 190;
                    case 138 -> 243;
                    case 139 -> 58;
                    case 140 -> 159;
                    case 141 -> 240;
                    case 142 -> 206;
                    case 143 -> 149;
                    case 144 -> 154;
                    case 145 -> 164;
                    case 146 -> 123;
                    case 147 -> 47;
                    case 148 -> 150;
                    case 149 -> 200;
                    case 150 -> 228;
                    case 151 -> 43;
                    case 152 -> 85;
                    case 153 -> 197;
                    case 154 -> 252;
                    case 155 -> 218;
                    case 156 -> 117;
                    case 157 -> 147;
                    case 158 -> 254;
                    case 159 -> 151;
                    case 160 -> 248;
                    case 161 -> 74;
                    case 162 -> 77;
                    case 163 -> 161;
                    case 164 -> 194;
                    case 165 -> 68;
                    case 166 -> 28;
                    case 167 -> 163;
                    case 168 -> 177;
                    case 169 -> 79;
                    case 170 -> 96;
                    case 171 -> 210;
                    case 172 -> 176;
                    case 173 -> 34;
                    case 174 -> 241;
                    case 175 -> 7;
                    case 176 -> 234;
                    case 177 -> 236;
                    case 178 -> 188;
                    case 179 -> 88;
                    case 180 -> 183;
                    case 181 -> 230;
                    case 182 -> 250;
                    case 183 -> 75;
                    case 184 -> 175;
                    case 185 -> 204;
                    case 186 -> 81;
                    case 187 -> 229;
                    case 188 -> 143;
                    case 189 -> 111;
                    case 190 -> 158;
                    case 191 -> 235;
                    case 192 -> 115;
                    case 193 -> 140;
                    case 194 -> 37;
                    case 195 -> 136;
                    case 196 -> 17;
                    case 197 -> 6;
                    case 198 -> 168;
                    case 199 -> 174;
                    case 200 -> 180;
                    case 201 -> 231;
                    case 202 -> 145;
                    case 203 -> 103;
                    case 204 -> 220;
                    case 205 -> 128;
                    case 206 -> 71;
                    case 207 -> 224;
                    case 208 -> 215;
                    case 209 -> 38;
                    case 210 -> 10;
                    case 211 -> 148;
                    case 212 -> 201;
                    case 213 -> 20;
                    case 214 -> 249;
                    case 215 -> 46;
                    case 216 -> 216;
                    case 217 -> 21;
                    case 218 -> 62;
                    case 219 -> 91;
                    case 220 -> 72;
                    case 221 -> 5;
                    case 222 -> 52;
                    case 223 -> 205;
                    case 224 -> 135;
                    case 225 -> 29;
                    case 226 -> 112;
                    case 227 -> 84;
                    case 228 -> 237;
                    case 229 -> 50;
                    case 230 -> 182;
                    case 231 -> 41;
                    case 232 -> 138;
                    case 233 -> 76;
                    case 234 -> 137;
                    case 235 -> 25;
                    case 236 -> 109;
                    case 237 -> 238;
                    case 238 -> 214;
                    case 239 -> 199;
                    case 240 -> 80;
                    case 241 -> 67;
                    case 242 -> 170;
                    case 243 -> 92;
                    case 244 -> 239;
                    case 245 -> 129;
                    case 246 -> 40;
                    case 247 -> 89;
                    case 248 -> 95;
                    case 249 -> 156;
                    case 250 -> 255;
                    case 251 -> 11;
                    case 252 -> 173;
                    case 253 -> 53;
                    case 254 -> 208;
                    default -> 157;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 70508688386517L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(1789760850 - (char)-5053, 1789629780 + (char)-2293, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 42789776789491L;
                    int[] nArray = SshAgentIpcService.l();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(982369650 - 13898, 982369650 - 15005, (int)l2));
                    int[] nArray2 = nArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (nArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 37701310888228L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00da\u00bd\u0018\u00d7G\u0003n\u00b2\u00d8";
                var4_3 = "\u00da\u00bd\u0018\u00d7G\u0003n\u00b2\u00d8".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 40;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 80;
                                break;
                            }
                            case 1: {
                                v11 = 44;
                                break;
                            }
                            case 2: {
                                v11 = 76;
                                break;
                            }
                            case 3: {
                                v11 = 45;
                                break;
                            }
                            case 4: {
                                v11 = 93;
                                break;
                            }
                            case 5: {
                                v11 = 31;
                                break;
                            }
                            default: {
                                v11 = 103;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF80DA) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 106;
                    case 1 -> 100;
                    case 2 -> 23;
                    case 3 -> 41;
                    case 4 -> 216;
                    case 5 -> 136;
                    case 6 -> 101;
                    case 7 -> 166;
                    case 8 -> 237;
                    case 9 -> 206;
                    case 10 -> 50;
                    case 11 -> 79;
                    case 12 -> 167;
                    case 13 -> 25;
                    case 14 -> 90;
                    case 15 -> 88;
                    case 16 -> 155;
                    case 17 -> 194;
                    case 18 -> 74;
                    case 19 -> 165;
                    case 20 -> 44;
                    case 21 -> 0;
                    case 22 -> 193;
                    case 23 -> 76;
                    case 24 -> 94;
                    case 25 -> 207;
                    case 26 -> 143;
                    case 27 -> 254;
                    case 28 -> 134;
                    case 29 -> 139;
                    case 30 -> 133;
                    case 31 -> 68;
                    case 32 -> 239;
                    case 33 -> 205;
                    case 34 -> 243;
                    case 35 -> 4;
                    case 36 -> 202;
                    case 37 -> 40;
                    case 38 -> 111;
                    case 39 -> 77;
                    case 40 -> 18;
                    case 41 -> 178;
                    case 42 -> 247;
                    case 43 -> 125;
                    case 44 -> 62;
                    case 45 -> 245;
                    case 46 -> 140;
                    case 47 -> 17;
                    case 48 -> 255;
                    case 49 -> 72;
                    case 50 -> 73;
                    case 51 -> 187;
                    case 52 -> 204;
                    case 53 -> 95;
                    case 54 -> 57;
                    case 55 -> 233;
                    case 56 -> 149;
                    case 57 -> 1;
                    case 58 -> 220;
                    case 59 -> 176;
                    case 60 -> 180;
                    case 61 -> 201;
                    case 62 -> 19;
                    case 63 -> 183;
                    case 64 -> 61;
                    case 65 -> 49;
                    case 66 -> 200;
                    case 67 -> 157;
                    case 68 -> 186;
                    case 69 -> 2;
                    case 70 -> 26;
                    case 71 -> 70;
                    case 72 -> 224;
                    case 73 -> 215;
                    case 74 -> 31;
                    case 75 -> 82;
                    case 76 -> 45;
                    case 77 -> 185;
                    case 78 -> 246;
                    case 79 -> 113;
                    case 80 -> 83;
                    case 81 -> 181;
                    case 82 -> 242;
                    case 83 -> 235;
                    case 84 -> 66;
                    case 85 -> 151;
                    case 86 -> 174;
                    case 87 -> 16;
                    case 88 -> 189;
                    case 89 -> 251;
                    case 90 -> 229;
                    case 91 -> 236;
                    case 92 -> 30;
                    case 93 -> 53;
                    case 94 -> 13;
                    case 95 -> 32;
                    case 96 -> 210;
                    case 97 -> 250;
                    case 98 -> 28;
                    case 99 -> 67;
                    case 100 -> 38;
                    case 101 -> 184;
                    case 102 -> 110;
                    case 103 -> 65;
                    case 104 -> 9;
                    case 105 -> 78;
                    case 106 -> 104;
                    case 107 -> 119;
                    case 108 -> 164;
                    case 109 -> 137;
                    case 110 -> 190;
                    case 111 -> 153;
                    case 112 -> 51;
                    case 113 -> 96;
                    case 114 -> 152;
                    case 115 -> 92;
                    case 116 -> 109;
                    case 117 -> 10;
                    case 118 -> 222;
                    case 119 -> 11;
                    case 120 -> 168;
                    case 121 -> 132;
                    case 122 -> 188;
                    case 123 -> 123;
                    case 124 -> 117;
                    case 125 -> 46;
                    case 126 -> 55;
                    case 127 -> 85;
                    case 128 -> 63;
                    case 129 -> 87;
                    case 130 -> 221;
                    case 131 -> 118;
                    case 132 -> 227;
                    case 133 -> 248;
                    case 134 -> 126;
                    case 135 -> 234;
                    case 136 -> 84;
                    case 137 -> 121;
                    case 138 -> 86;
                    case 139 -> 71;
                    case 140 -> 169;
                    case 141 -> 148;
                    case 142 -> 253;
                    case 143 -> 135;
                    case 144 -> 241;
                    case 145 -> 214;
                    case 146 -> 144;
                    case 147 -> 211;
                    case 148 -> 172;
                    case 149 -> 5;
                    case 150 -> 99;
                    case 151 -> 249;
                    case 152 -> 142;
                    case 153 -> 105;
                    case 154 -> 52;
                    case 155 -> 69;
                    case 156 -> 191;
                    case 157 -> 103;
                    case 158 -> 238;
                    case 159 -> 98;
                    case 160 -> 43;
                    case 161 -> 58;
                    case 162 -> 199;
                    case 163 -> 162;
                    case 164 -> 21;
                    case 165 -> 145;
                    case 166 -> 129;
                    case 167 -> 131;
                    case 168 -> 8;
                    case 169 -> 218;
                    case 170 -> 14;
                    case 171 -> 6;
                    case 172 -> 36;
                    case 173 -> 81;
                    case 174 -> 182;
                    case 175 -> 252;
                    case 176 -> 203;
                    case 177 -> 244;
                    case 178 -> 158;
                    case 179 -> 208;
                    case 180 -> 198;
                    case 181 -> 47;
                    case 182 -> 35;
                    case 183 -> 161;
                    case 184 -> 37;
                    case 185 -> 120;
                    case 186 -> 170;
                    case 187 -> 33;
                    case 188 -> 75;
                    case 189 -> 130;
                    case 190 -> 217;
                    case 191 -> 195;
                    case 192 -> 219;
                    case 193 -> 177;
                    case 194 -> 114;
                    case 195 -> 115;
                    case 196 -> 213;
                    case 197 -> 196;
                    case 198 -> 59;
                    case 199 -> 163;
                    case 200 -> 91;
                    case 201 -> 154;
                    case 202 -> 56;
                    case 203 -> 150;
                    case 204 -> 173;
                    case 205 -> 3;
                    case 206 -> 175;
                    case 207 -> 231;
                    case 208 -> 22;
                    case 209 -> 171;
                    case 210 -> 146;
                    case 211 -> 42;
                    case 212 -> 197;
                    case 213 -> 228;
                    case 214 -> 160;
                    case 215 -> 124;
                    case 216 -> 97;
                    case 217 -> 108;
                    case 218 -> 12;
                    case 219 -> 230;
                    case 220 -> 179;
                    case 221 -> 226;
                    case 222 -> 212;
                    case 223 -> 138;
                    case 224 -> 34;
                    case 225 -> 15;
                    case 226 -> 112;
                    case 227 -> 232;
                    case 228 -> 223;
                    case 229 -> 122;
                    case 230 -> 240;
                    case 231 -> 192;
                    case 232 -> 209;
                    case 233 -> 7;
                    case 234 -> 20;
                    case 235 -> 29;
                    case 236 -> 107;
                    case 237 -> 48;
                    case 238 -> 156;
                    case 239 -> 116;
                    case 240 -> 147;
                    case 241 -> 27;
                    case 242 -> 64;
                    case 243 -> 93;
                    case 244 -> 225;
                    case 245 -> 102;
                    case 246 -> 39;
                    case 247 -> 89;
                    case 248 -> 24;
                    case 249 -> 141;
                    case 250 -> 54;
                    case 251 -> 159;
                    case 252 -> 80;
                    case 253 -> 128;
                    case 254 -> 127;
                    default -> 60;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

