/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.update.FilePathChange;
import com.intellij.openapi.vcs.update.FilesCollector;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronouslyKt;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.update.Wrapper;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\b\u001a\u00020\t2\u000b\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0007J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0016\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007J\u0016\u0010\u0014\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u0007J\u0016\u0010\u0016\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u0007J\u0016\u0010\u0017\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u001e\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u0002J\u0016\u0010\u001b\u001a\u00020\t2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001dH\u0002J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010\u0013H\u0002J\u0016\u0010 \u001a\u00020\t2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0007J\u0016\u0010$\u001a\u00020\t2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\u0012H\u0007J\u001e\u0010%\u001a\u00020\t2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020&0\u00122\b\b\u0002\u0010'\u001a\u00020\u001aJ*\u0010%\u001a\u00020\t\"\u0004\b\u0000\u0010(2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H(0\u00122\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0*H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/openapi/vcs/update/RefreshVFsSynchronously;", "", "<init>", "()V", "TRACE_LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "TIME_LOG", "trace", "", "message", "", "Lorg/jetbrains/annotations/NonNls;", "updateAllChanged", "updatedFiles", "Lcom/intellij/openapi/vcs/update/UpdatedFiles;", "refreshFiles", "files", "", "Ljava/io/File;", "refreshVirtualFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "refreshVirtualFilesRecursive", "refreshDeletedFiles", "markDirtyAndRefresh", "isRecursive", "", "runWithProgressText", "task", "Lkotlin/Function0;", "findValidParent", "file", "updateChangesForRollback", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "updateChanges", "refresh", "Lcom/intellij/openapi/vcs/update/FilePathChange;", "isRollback", "T", "wrapper", "Lcom/intellij/openapi/vcs/update/Wrapper;", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nRefreshVFsSynchronously.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefreshVFsSynchronously.kt\ncom/intellij/openapi/vcs/update/RefreshVFsSynchronously\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Timing.kt\nkotlin/system/TimingKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,190:1\n1619#2:191\n1863#2:192\n1864#2:194\n1620#2:195\n1619#2:196\n1863#2:197\n1864#2:199\n1620#2:200\n1863#2,2:206\n1#3:193\n1#3:198\n29#4,3:201\n183#5,2:204\n37#6:208\n36#6,3:209\n*S KotlinDebug\n*F\n+ 1 RefreshVFsSynchronously.kt\ncom/intellij/openapi/vcs/update/RefreshVFsSynchronously\n*L\n51#1:191\n51#1:192\n51#1:194\n51#1:195\n78#1:196\n78#1:197\n78#1:199\n78#1:200\n131#1:206,2\n51#1:193\n78#1:198\n83#1:201,3\n117#1:204,2\n85#1:208\n85#1:209,3\n*E\n"})
public final class RefreshVFsSynchronously {
    @NotNull
    public static final RefreshVFsSynchronously INSTANCE = new RefreshVFsSynchronously();
    @NotNull
    private static final Logger TRACE_LOG;
    @NotNull
    private static final Logger TIME_LOG;

    private RefreshVFsSynchronously() {
    }

    @JvmStatic
    public static final void trace(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (TRACE_LOG.isDebugEnabled()) {
            TRACE_LOG.debug("RefreshVFsSynchronously: " + message);
        }
    }

    @JvmStatic
    public static final void updateAllChanged(@NotNull UpdatedFiles updatedFiles) {
        Intrinsics.checkNotNullParameter((Object)updatedFiles, (String)"updatedFiles");
        FilesCollector collector = new FilesCollector();
        UpdateFilesHelper.iterateFileGroupFilesDeletedOnServerFirst(updatedFiles, collector);
        INSTANCE.refreshDeletedFiles((Collection<? extends File>)collector.getDeletedFiles());
        RefreshVFsSynchronously.refreshFiles((Collection<? extends File>)collector.getFiles());
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void refreshFiles(@NotNull Collection<? extends File> files) {
        void var3_2;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        if (files.isEmpty()) {
            return;
        }
        if (TRACE_LOG.isDebugEnabled()) {
            TRACE_LOG.debug("RefreshVFsSynchronously#refreshFiles: " + files, new Throwable());
        }
        Iterable iterable = files;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            File it = (File)element$iv;
            boolean bl2 = false;
            if (INSTANCE.findValidParent(it) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        Set toRefresh = (Set)var3_2;
        INSTANCE.markDirtyAndRefresh(false, toRefresh);
    }

    @JvmStatic
    public static final void refreshVirtualFiles(@NotNull Collection<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        if (files.isEmpty()) {
            return;
        }
        if (TRACE_LOG.isDebugEnabled()) {
            TRACE_LOG.debug("RefreshVFsSynchronously#refreshVirtualFiles: " + files, new Throwable());
        }
        INSTANCE.markDirtyAndRefresh(false, files);
    }

    @JvmStatic
    public static final void refreshVirtualFilesRecursive(@NotNull Collection<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        if (files.isEmpty()) {
            return;
        }
        if (TRACE_LOG.isDebugEnabled()) {
            TRACE_LOG.debug("RefreshVFsSynchronously#refreshVirtualFilesRecursive: " + files, new Throwable());
        }
        INSTANCE.markDirtyAndRefresh(true, files);
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshDeletedFiles(Collection<? extends File> files) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        if (files.isEmpty()) {
            return;
        }
        if (TRACE_LOG.isDebugEnabled()) {
            TRACE_LOG.debug("RefreshVFsSynchronously#refreshDeletedFiles: " + files, new Throwable());
        }
        Iterable iterable = files;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            File it = (File)element$iv;
            boolean bl2 = false;
            if (INSTANCE.findValidParent(it.getParentFile()) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        Set toRefresh = (Set)destination$iv;
        this.markDirtyAndRefresh(true, toRefresh);
    }

    private final void markDirtyAndRefresh(boolean isRecursive, Collection<? extends VirtualFile> files) {
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        INSTANCE.runWithProgressText((Function0<Unit>)((Function0)() -> RefreshVFsSynchronously.markDirtyAndRefresh$lambda$3$lambda$2(isRecursive, files)));
        long time = System.currentTimeMillis() - start$iv;
        if (TIME_LOG.isDebugEnabled()) {
            TIME_LOG.debug("VFS refresh took " + time + "ms, " + files.size() + " files, isRecursive=" + isRecursive);
        }
    }

    private final void runWithProgressText(Function0<Unit> task2) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator == null) {
            task2.invoke();
            return;
        }
        String oldText = indicator.getText();
        CharSequence charSequence = oldText;
        if (charSequence == null || charSequence.length() == 0) {
            indicator.setText(IdeCoreBundle.message((String)"file.synchronize.progress", (Object[])new Object[0]));
            task2.invoke();
            indicator.setText(oldText);
        } else {
            String oldText2 = indicator.getText2();
            indicator.setText2(IdeCoreBundle.message((String)"file.synchronize.progress", (Object[])new Object[0]));
            task2.invoke();
            indicator.setText2(oldText2);
        }
    }

    private final VirtualFile findValidParent(File file) {
        Object v0;
        block1: {
            Sequence $this$firstOrNull$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)file, RefreshVFsSynchronously::findValidParent$lambda$4), RefreshVFsSynchronously::findValidParent$lambda$5);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                if (!it.isValid()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @JvmStatic
    public static final void updateChangesForRollback(@NotNull List<? extends Change> changes) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        INSTANCE.refresh((Collection)changes, RefreshVFsSynchronouslyKt.access$getREVERSED_CHANGE_WRAPPER$p());
    }

    @JvmStatic
    public static final void updateChanges(@NotNull Collection<? extends Change> changes) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        INSTANCE.refresh(changes, RefreshVFsSynchronouslyKt.access$getCHANGE_WRAPPER$p());
    }

    public final void refresh(@NotNull Collection<? extends FilePathChange> changes, boolean isRollback) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        this.refresh(changes, isRollback ? RefreshVFsSynchronouslyKt.access$getREVERSED_FILE_PATH_CHANGE_WRAPPER$p() : RefreshVFsSynchronouslyKt.access$getFILE_PATH_CHANGE_WRAPPER$p());
    }

    public static /* synthetic */ void refresh$default(RefreshVFsSynchronously refreshVFsSynchronously, Collection collection, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        refreshVFsSynchronously.refresh(collection, bl);
    }

    private final <T> void refresh(Collection<? extends T> changes, Wrapper<T> wrapper) {
        Set files = new LinkedHashSet();
        Set deletedFiles = new LinkedHashSet();
        Iterable $this$forEach$iv = changes;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            FilePath it;
            Object element$iv;
            Object change = element$iv = iterator.next();
            boolean bl = false;
            FilePath beforePath = wrapper.getBeforePath(change);
            FilePath afterPath = wrapper.getAfterPath(change);
            if (beforePath != null) {
                boolean bl2 = false;
                ((Collection)(wrapper.isBeforePathDeleted(change) ? deletedFiles : files)).add(it.getIOFile());
            }
            if (afterPath == null) continue;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)it, (Object)beforePath)) continue;
            ((Collection)files).add(it.getIOFile());
        }
        RefreshVFsSynchronously.refreshFiles(files);
        this.refreshDeletedFiles(deletedFiles);
    }

    private static final Unit markDirtyAndRefresh$lambda$3$lambda$2(boolean $isRecursive, Collection $files) {
        Collection $this$toTypedArray$iv = $files;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        VirtualFile[] virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)$isRecursive, (boolean)false, (VirtualFile[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        return Unit.INSTANCE;
    }

    private static final File findValidParent$lambda$4(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParentFile();
    }

    private static final VirtualFile findValidParent$lambda$5(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LocalFileSystem.getInstance().findFileByIoFile(it);
    }

    static {
        Logger logger = Logger.getInstance((String)"#trace.RefreshVFsSynchronously");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        TRACE_LOG = logger;
        Logger logger2 = Logger.getInstance((String)"#time.RefreshVFsSynchronously");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        TIME_LOG = logger2;
    }
}

