/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCResultSetMetaDataImpl;

public class PostgreResultSetMetaDataImpl
extends JDBCResultSetMetaDataImpl {
    public PostgreResultSetMetaDataImpl(JDBCResultSet resultSet) throws SQLException {
        super(resultSet);
    }

    public String getCatalogName(int column) throws SQLException {
        return this.resultSet.getSession().getExecutionContext().getOwnerInstance().getName();
    }

    public String getSchemaName(int column) throws SQLException {
        String schemaName;
        try {
            schemaName = (String)this.original.getClass().getMethod("getBaseSchemaName", Integer.TYPE).invoke((Object)this.original, column);
        }
        catch (InvocationTargetException e) {
            throw new SQLException("Error getting schema name", e.getTargetException());
        }
        catch (Exception e) {
            throw new SQLException("Error getting schema name", e);
        }
        return JDBCUtils.normalizeIdentifier((String)schemaName);
    }

    public String getTableName(int column) throws SQLException {
        String tableName;
        try {
            tableName = (String)this.original.getClass().getMethod("getBaseTableName", Integer.TYPE).invoke((Object)this.original, column);
        }
        catch (InvocationTargetException e) {
            throw new SQLException("Error getting table name", e.getTargetException());
        }
        catch (Exception e) {
            throw new SQLException("Error getting table name", e);
        }
        return JDBCUtils.normalizeIdentifier((String)tableName);
    }
}

