/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.reader.TempFileNameScheme;
import org.dita.dost.reader.AbstractReader;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FilterUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class DitaValReader
implements AbstractReader {
    private static final QName REV = QName.valueOf("rev");
    private Set<QName> filterAttributes;
    private Set<QName> flagAttributes;
    protected DITAOTLogger logger;
    protected Job job;
    private final Map<FilterUtils.FilterKey, FilterUtils.Action> filterMap = new HashMap<FilterUtils.FilterKey, FilterUtils.Action>();
    private String foregroundConflictColor;
    private String backgroundConflictColor;
    private TempFileNameScheme tempFileNameScheme;
    private final List<URI> imageList = new ArrayList<URI>(256);
    private URI ditaVal = null;
    private Map<QName, Map<String, Set<Element>>> bindingMap;
    private final List<URI> relFlagImageList = new ArrayList<URI>(256);

    public DitaValReader() {
        this.filterAttributes = Stream.of(Configuration.configuration.getOrDefault("filter-attributes", "").trim().split("\\s*,\\s*")).map(QName::valueOf).collect(Collectors.toSet());
        this.flagAttributes = Stream.of(Configuration.configuration.getOrDefault("flag-attributes", "").trim().split("\\s*,\\s*")).map(QName::valueOf).collect(Collectors.toSet());
    }

    @VisibleForTesting
    DitaValReader(Set<QName> filterAttributes, Set<QName> flagAttributes) {
        this();
        this.filterAttributes = Sets.union(this.filterAttributes, filterAttributes);
        this.flagAttributes = Sets.union(this.flagAttributes, flagAttributes);
    }

    @Override
    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    @Override
    public void setJob(Job job) {
        this.job = job;
        if (job.getInputDir() != null) {
            this.tempFileNameScheme = job.getTempFileNameScheme();
        }
    }

    public void setSubjectScheme(Map<QName, Map<String, Set<Element>>> bindingMap) {
        this.bindingMap = bindingMap;
    }

    @Override
    @Deprecated
    public void read(File input) {
        assert (input.isAbsolute());
        this.read(input.toURI());
    }

    public void read(URI input) {
        Document doc;
        assert (input.isAbsolute());
        this.ditaVal = input;
        try {
            doc = this.job.getStore().getDocument(input);
        }
        catch (IOException e) {
            this.logger.error("Failed to read DITAVAL file: " + e.getMessage(), e);
            return;
        }
        this.readDocument(doc);
        if (this.bindingMap != null && !this.bindingMap.isEmpty()) {
            HashMap<FilterUtils.FilterKey, FilterUtils.Action> buf = new HashMap<FilterUtils.FilterKey, FilterUtils.Action>(this.filterMap);
            for (Map.Entry e : buf.entrySet()) {
                this.refineAction((FilterUtils.Action)e.getValue(), (FilterUtils.FilterKey)e.getKey());
            }
        }
    }

    private void readDocument(Document doc) {
        Element root = doc.getDocumentElement();
        List<Object> props = XMLUtils.toList(root.getElementsByTagName("prop"));
        for (Object prop : props) {
            this.readProp((Element)prop);
        }
        List<Element> revprops = XMLUtils.toList(root.getElementsByTagName("revprop"));
        for (Element revprop : revprops) {
            this.readProp(revprop);
        }
        List<Element> styleConflicts = XMLUtils.toList(root.getElementsByTagName("style-conflict"));
        for (Element styleConflict : styleConflicts) {
            this.readStyleConflict(styleConflict);
        }
    }

    public void readProp(Element elem) {
        String attAction;
        FilterUtils.Action action = switch (attAction = elem.getAttribute("action")) {
            case "include" -> FilterUtils.Action.INCLUDE;
            case "exclude" -> FilterUtils.Action.EXCLUDE;
            case "passthrough" -> FilterUtils.Action.PASSTHROUGH;
            case "flag" -> this.readFlag(elem);
            default -> throw new IllegalArgumentException(MessageUtils.getMessage("DOTJ077F", attAction).setLocation(elem).toString());
        };
        if (action != null) {
            QName attName;
            if (elem.getTagName().equals("revprop")) {
                attName = REV;
            } else {
                String attValue = XMLUtils.getValue(elem, "att");
                if (attValue != null) {
                    if (attValue.contains(":")) {
                        String[] parts = attValue.split(":");
                        String uri = parts[0].equals("xml") ? "http://www.w3.org/XML/1998/namespace" : elem.lookupNamespaceURI(parts[0]);
                        attName = new QName(uri, parts[1], parts[0]);
                    } else {
                        attName = QName.valueOf(attValue);
                    }
                } else {
                    attName = null;
                }
                if (attName != null && attName.equals(REV) && !this.filterAttributes.isEmpty() && !this.filterAttributes.contains(REV)) {
                    this.logger.warn(MessageUtils.getMessage("DOTJ074W", new String[0]).setLocation(elem).toString());
                    return;
                }
            }
            String attValue = XMLUtils.getValue(elem, "val");
            FilterUtils.FilterKey key = attName != null ? new FilterUtils.FilterKey(attName, attValue) : FilterUtils.DEFAULT;
            this.insertAction(action, key);
        }
    }

    private FilterUtils.Flag readFlag(Element elem) {
        String style = XMLUtils.getValue(elem, "style");
        String outputClass = XMLUtils.getValue(elem, "add-outputclass");
        if (outputClass == null && (outputClass = XMLUtils.getValue(elem, "outputclass")) != null) {
            this.logger.warn(MessageUtils.getMessage("DOTA014W", "outputclass", "add-outputclass").setLocation(elem).toString());
        }
        return new FilterUtils.Flag(elem.getLocalName(), XMLUtils.getValue(elem, "color"), XMLUtils.getValue(elem, "backcolor"), style != null ? style.trim().split("\\s+") : null, XMLUtils.getValue(elem, "changebar"), this.readFlagImage(elem, "startflag"), this.readFlagImage(elem, "endflag"), outputClass);
    }

    private FilterUtils.Flag.FlagImage readFlagImage(Element elem, String name) {
        NodeList children = elem.getElementsByTagName(name);
        if (children.getLength() != 0) {
            Element img = (Element)children.item(0);
            URI absolute = null;
            if (!img.getAttribute("imageref").isEmpty()) {
                URI relative;
                absolute = URLUtils.toURI(img.getAttribute("imageref"));
                if (absolute.isAbsolute()) {
                    relative = URLUtils.getRelativePath(this.ditaVal, absolute);
                } else if (!img.getAttributeNS("http://dita-ot.sourceforge.net", "imagerefuri").isEmpty()) {
                    relative = absolute = URI.create(img.getAttributeNS("http://dita-ot.sourceforge.net", "imagerefuri"));
                } else {
                    relative = absolute;
                    absolute = this.ditaVal.resolve(absolute);
                }
                this.imageList.add(absolute);
                this.relFlagImageList.add(relative);
                if (this.tempFileNameScheme != null && this.job.getFileInfo(absolute) == null) {
                    URI dstTemp = this.tempFileNameScheme.generateTempFileName(absolute);
                    Job.FileInfo.Builder fi = new Job.FileInfo.Builder().src(absolute).uri(dstTemp).format("flag");
                    this.job.add(fi.build());
                }
            }
            String altText = null;
            NodeList alts = img.getElementsByTagName("alt-text");
            if (alts.getLength() != 0) {
                altText = XMLUtils.getText(alts.item(0));
            }
            if (absolute != null || altText != null) {
                return new FilterUtils.Flag.FlagImage(absolute, altText);
            }
        }
        return null;
    }

    private void readStyleConflict(Element elem) {
        this.foregroundConflictColor = XMLUtils.getValue(elem, "foreground-conflict-color");
        this.backgroundConflictColor = XMLUtils.getValue(elem, "background-conflict-color");
    }

    private void refineAction(FilterUtils.Action action, FilterUtils.FilterKey key) {
        Map<String, Set<Element>> schemeMap;
        if (key.value() != null && this.bindingMap != null && !this.bindingMap.isEmpty() && (schemeMap = this.bindingMap.get(key.attribute())) != null && !schemeMap.isEmpty()) {
            for (Set<Element> submap : schemeMap.values()) {
                for (Element e : submap) {
                    Element subRoot = this.searchForKey(e, key.value());
                    if (subRoot == null) continue;
                    this.insertAction(subRoot, key.attribute(), action);
                }
            }
        }
    }

    private void insertAction(Element subTree, QName attName, FilterUtils.Action action) {
        if (subTree == null || action == null) {
            return;
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        NodeList children = subTree.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            queue.offer((Element)children.item(i));
        }
        while (!queue.isEmpty()) {
            FilterUtils.FilterKey k;
            String key;
            Element node = (Element)queue.poll();
            children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                queue.offer((Element)children.item(i));
            }
            if (!Constants.SUBJECTSCHEME_SUBJECTDEF.matches(node) || (key = node.getAttribute("keys")) == null || key.trim().isEmpty() || this.filterMap.containsKey(k = new FilterUtils.FilterKey(attName, key))) continue;
            this.filterMap.put(k, action);
        }
    }

    private Element searchForKey(Element root, String keyValue) {
        if (root == null || keyValue == null) {
            return null;
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        queue.add(root);
        while (!queue.isEmpty()) {
            String key;
            Element node = (Element)queue.removeFirst();
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                queue.add((Element)children.item(i));
            }
            if (!Constants.SUBJECTSCHEME_SUBJECTDEF.matches(node) || !keyValue.equals(key = node.getAttribute("keys"))) continue;
            return node;
        }
        return null;
    }

    private void insertAction(FilterUtils.Action action, FilterUtils.FilterKey key) {
        if (this.filterMap.get(key) == null) {
            this.filterMap.put(key, action);
        } else {
            this.logger.info(MessageUtils.getMessage("DOTJ007I", key.toString()).toString());
        }
    }

    public List<URI> getImageList() {
        return this.imageList;
    }

    public Map<FilterUtils.FilterKey, FilterUtils.Action> getFilterMap() {
        return Collections.unmodifiableMap(this.filterMap);
    }

    public void filterReset() {
        this.filterMap.clear();
    }

    public List<URI> getRelFlagImageList() {
        return this.relFlagImageList;
    }

    public String getForegroundConflictColor() {
        return this.foregroundConflictColor;
    }

    public String getBackgroundConflictColor() {
        return this.backgroundConflictColor;
    }
}

