/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module.reader;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.AbstractPipelineModuleImpl;
import org.dita.dost.module.reader.DTDForwardHandler;
import org.dita.dost.module.reader.TempFileNameScheme;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.reader.DitaValReader;
import org.dita.dost.reader.GenListModuleReader;
import org.dita.dost.reader.GrammarPoolManager;
import org.dita.dost.reader.KeydefFilter;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FilterUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.DitaWriterFilter;
import org.dita.dost.writer.TopicFragmentFilter;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractReaderModule
extends AbstractPipelineModuleImpl {
    Predicate<String> formatFilter;
    private final Map<URI, Collection<Job.FileInfo>> fileinfos = new ConcurrentHashMap<URI, Collection<Job.FileInfo>>();
    final Set<URI> fullTopicSet = ConcurrentHashMap.newKeySet();
    final Set<URI> fullMapSet = ConcurrentHashMap.newKeySet();
    private final Set<URI> hrefTopicSet = ConcurrentHashMap.newKeySet();
    final Set<URI> conrefSet = ConcurrentHashMap.newKeySet();
    private final Set<URI> coderefSet = ConcurrentHashMap.newKeySet();
    final Set<GenListModuleReader.Reference> formatSet = ConcurrentHashMap.newKeySet();
    private final Set<URI> flagImageSet = ConcurrentHashMap.newKeySet();
    final SetMultimap<String, URI> htmlSet = MultimapBuilder.SetMultimapBuilder.hashKeys().hashSetValues().build();
    final Set<URI> hrefTargetSet = ConcurrentHashMap.newKeySet();
    Set<URI> conrefTargetSet = ConcurrentHashMap.newKeySet();
    final Set<URI> nonConrefCopytoTargetSet = ConcurrentHashMap.newKeySet();
    private final Set<URI> coderefTargetSet = ConcurrentHashMap.newKeySet();
    private final Set<URI> relFlagImagesSet = ConcurrentHashMap.newKeySet();
    @VisibleForTesting
    final NavigableMap<URI, GenListModuleReader.Reference> waitList = new ConcurrentSkipListMap<URI, GenListModuleReader.Reference>();
    final Set<URI> doneList = ConcurrentHashMap.newKeySet();
    final Set<URI> failureList = ConcurrentHashMap.newKeySet();
    final Set<URI> outDitaFilesSet = ConcurrentHashMap.newKeySet();
    final Set<URI> conrefpushSet = ConcurrentHashMap.newKeySet();
    final Set<URI> keyrefSet = ConcurrentHashMap.newKeySet();
    final Set<URI> resourceOnlySet = ConcurrentHashMap.newKeySet();
    private URI baseInputDir;
    GenListModuleReader listFilter;
    KeydefFilter keydefFilter;
    boolean validate = true;
    ContentHandler nullHandler;
    private TempFileNameScheme tempFileNameScheme;
    URI rootFile;
    List<URI> resources;
    private final Set<URI> schemeSet = ConcurrentHashMap.newKeySet();
    private final Map<URI, Set<URI>> schemeDictionary = new HashMap<URI, Set<URI>>();
    private final Map<URI, URI> copyTo = new ConcurrentHashMap<URI, URI>();
    Configuration.Mode processingMode;
    boolean genDebugInfo;
    private boolean gramcache = true;
    private boolean profilingEnabled;
    String transtype;
    private File ditavalFile;
    FilterUtils filterUtils;
    File outputFile;
    private XMLReader reader;
    URI currentFile;
    DitaWriterFilter ditaWriterFilter;
    TopicFragmentFilter topicFragmentFilter;
    final Set<URI> additionalResourcesSet = ConcurrentHashMap.newKeySet();

    public abstract void readStartFile() throws DITAOTException;

    String getFormatFromPath(URI file) {
        String ext = org.dita.dost.util.FileUtils.getExtension(file.getPath());
        if (Configuration.parserMap.containsKey(ext)) {
            return ext;
        }
        if (Objects.equals(ext, "ditamap")) {
            return "ditamap";
        }
        return null;
    }

    void readResourceFiles() throws DITAOTException {
        if (!this.resources.isEmpty()) {
            for (URI resource : this.resources) {
                this.additionalResourcesSet.add(resource);
                this.addToWaitList(new GenListModuleReader.Reference(resource));
            }
            this.processWaitList();
            this.additionalResourcesSet.addAll(this.hrefTargetSet);
            this.additionalResourcesSet.addAll(this.conrefTargetSet);
            this.additionalResourcesSet.addAll(this.nonConrefCopytoTargetSet);
            this.additionalResourcesSet.addAll(this.outDitaFilesSet);
            this.additionalResourcesSet.addAll(this.conrefpushSet);
            this.additionalResourcesSet.addAll(this.keyrefSet);
            this.additionalResourcesSet.addAll(this.resourceOnlySet);
            this.additionalResourcesSet.addAll(this.fullTopicSet);
            this.additionalResourcesSet.addAll(this.fullMapSet);
            this.additionalResourcesSet.addAll(this.conrefSet);
            this.resourceOnlySet.clear();
        }
    }

    void initFilters() {
        this.tempFileNameScheme.setBaseDir(this.job.getInputDir());
        this.listFilter = new GenListModuleReader();
        this.listFilter.setLogger(this.logger);
        this.listFilter.setPrimaryDitamap(this.rootFile);
        this.listFilter.setJob(this.job);
        this.listFilter.setFormatFilter(this.formatFilter);
        if (this.profilingEnabled) {
            this.filterUtils = this.parseFilterFile();
        }
        this.keydefFilter = new KeydefFilter();
        this.keydefFilter.setLogger(this.logger);
        this.keydefFilter.setCurrentFile(this.rootFile);
        this.keydefFilter.setJob(this.job);
        this.nullHandler = new DefaultHandler();
        this.ditaWriterFilter = new DitaWriterFilter();
        this.ditaWriterFilter.setTempFileNameScheme(this.tempFileNameScheme);
        this.ditaWriterFilter.setLogger(this.logger);
        this.ditaWriterFilter.setJob(this.job);
        this.ditaWriterFilter.setEntityResolver(this.reader.getEntityResolver());
        this.topicFragmentFilter = new TopicFragmentFilter("conref", "conrefend");
    }

    void initXMLReader(boolean validate) throws DITAOTException {
        try {
            this.reader = XMLUtils.getXMLReader();
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            if (validate) {
                this.reader.setFeature("http://xml.org/sax/features/validation", true);
                try {
                    this.reader.setFeature("http://apache.org/xml/features/validation/schema", true);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
            }
            if (this.gramcache) {
                XMLGrammarPool grammarPool = GrammarPoolManager.getGrammarPool();
                try {
                    this.reader.setProperty("http://apache.org/xml/properties/internal/grammar-pool", grammarPool);
                    this.logger.debug("Using Xerces grammar pool for DTD and schema caching.");
                }
                catch (NoClassDefFoundError e) {
                    this.logger.warn("Xerces not available, not using grammar caching");
                }
                catch (SAXNotRecognizedException | SAXNotSupportedException e) {
                    this.logger.warn("Failed to set Xerces grammar pool for parser: " + e.getMessage());
                }
            }
            this.reader.setEntityResolver((EntityResolver)this.xmlUtils.getCatalogResolver());
        }
        catch (SAXException e) {
            throw new DITAOTException(e);
        }
    }

    void parseInputParameters(AbstractPipelineInput input) {
        this.validate = Boolean.parseBoolean(input.getAttribute("validate"));
        this.transtype = input.getAttribute("transtype");
        this.gramcache = "yes".equalsIgnoreCase(input.getAttribute("gramcache"));
        this.processingMode = Optional.ofNullable(input.getAttribute("processing-mode")).map(String::toUpperCase).map(Configuration.Mode::valueOf).orElse(Configuration.Mode.LAX);
        this.genDebugInfo = Boolean.parseBoolean(input.getAttribute("generate-debug-attributes"));
        this.job.setGeneratecopyouter(input.getAttribute("generatecopyouter"));
        this.job.setOutterControl(input.getAttribute("outercontrol"));
        this.job.setOnlyTopicInMap(Boolean.parseBoolean(input.getAttribute("onlytopicinmap")));
        this.job.setCrawl(Optional.ofNullable(input.getAttribute("crawl")).orElse("topic"));
        File path = URLUtils.toFile(input.getAttribute("outputdir"));
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Output directory " + String.valueOf(path) + " must be absolute");
        }
        this.job.setOutputDir(path);
        File basedir = URLUtils.toFile(input.getAttribute("basedir"));
        URI ditaInputDir = URLUtils.toURI(input.getAttribute("inputdir"));
        if (ditaInputDir != null) {
            this.baseInputDir = ditaInputDir.isAbsolute() ? ditaInputDir : (ditaInputDir.getPath() != null && ditaInputDir.getPath().startsWith("/") ? URLUtils.setScheme(ditaInputDir, "file") : basedir.toURI().resolve(ditaInputDir));
            assert (this.baseInputDir.isAbsolute());
        }
        this.resources = input.getAttribute("resources") != null ? Stream.of(input.getAttribute("resources").split(File.pathSeparator)).map(resource -> new File((String)resource).toURI()).collect(Collectors.toList()) : Collections.emptyList();
        URI ditaInput = URLUtils.toURI(input.getAttribute("inputmap"));
        URI uRI = ditaInput = ditaInput != null ? ditaInput : this.job.getInputFile();
        this.rootFile = ditaInput.isAbsolute() ? ditaInput : (ditaInput.getPath() != null && ditaInput.getPath().startsWith("/") ? URLUtils.setScheme(ditaInput, "file") : Objects.requireNonNullElseGet(this.baseInputDir, () -> basedir.toURI()).resolve(ditaInput));
        this.job.setInputFile(this.rootFile);
        if (this.baseInputDir == null) {
            this.baseInputDir = this.rootFile.resolve(".");
        }
        this.job.setInputDir(this.baseInputDir);
        this.profilingEnabled = Optional.ofNullable(input.getAttribute("profiling.enable")).map(Boolean::parseBoolean).orElse(true);
        if (this.profilingEnabled) {
            this.ditavalFile = Optional.of(new File(this.job.tempDir, "ditaot.generated.ditaval")).filter(File::exists).orElse(null);
        }
    }

    void processWaitList() throws DITAOTException {
        Map.Entry<URI, GenListModuleReader.Reference> entry = this.waitList.pollFirstEntry();
        while (entry != null) {
            this.readFile(entry.getValue(), null);
            entry = this.waitList.pollFirstEntry();
        }
    }

    abstract List<XMLFilter> getProcessingPipe(URI var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readFile(GenListModuleReader.Reference ref, URI parseFile) throws DITAOTException {
        URI src;
        this.currentFile = ref.filename.normalize();
        assert (this.currentFile.isAbsolute());
        URI uRI = src = parseFile != null ? parseFile : this.currentFile;
        assert (src.isAbsolute());
        URI rel = this.tempFileNameScheme.generateTempFileName(this.currentFile);
        this.outputFile = new File(this.job.tempDirURI.resolve(rel));
        File outputDir = this.outputFile.getParentFile();
        if (!outputDir.exists()) {
            try {
                Files.createDirectories(outputDir.toPath(), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                this.logger.error("Failed to create output directory " + outputDir.getAbsolutePath());
                return;
            }
        }
        this.logger.info("Processing " + String.valueOf(this.currentFile) + " to " + String.valueOf(this.outputFile.toURI()));
        String[] params = new String[]{this.currentFile.toString()};
        Job.FileInfo fi = this.job.getFileInfo(this.currentFile);
        if (fi == null) {
            String extension = org.dita.dost.util.FileUtils.getExtension(this.currentFile.getPath());
            Job.FileInfo stub = new Job.FileInfo.Builder().src(this.currentFile).uri(rel).result(this.currentFile).isInput(this.currentFile.equals(this.rootFile)).format(GenListModuleReader.isFormatDita(extension) ? extension : null).build();
            this.job.add(stub);
        }
        try {
            DITAOTXMLErrorHandler errorHandler = new DITAOTXMLErrorHandler(src.toString(), this.logger, this.processingMode);
            XMLReader parser = XMLUtils.getXmlReader(ref.format, this.processingMode).orElse(this.reader);
            parser.setErrorHandler(errorHandler);
            XMLReader xmlSource = parser;
            for (XMLFilter f : this.getProcessingPipe(this.currentFile)) {
                f.setParent(xmlSource);
                f.setEntityResolver((EntityResolver)this.xmlUtils.getCatalogResolver());
                f.setErrorHandler(errorHandler);
                xmlSource = f;
            }
            try {
                DTDForwardHandler lexicalHandler = new DTDForwardHandler(xmlSource);
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
                parser.setFeature("http://xml.org/sax/features/lexical-handler", true);
            }
            catch (SAXNotRecognizedException lexicalHandler) {
                // empty catch block
            }
            ContentHandler serializer = this.job.getStore().getContentHandler(this.outputFile.toURI());
            xmlSource.setContentHandler(serializer);
            xmlSource.parse(src.toString());
            if (this.listFilter.isValidInput()) {
                this.processParseResult(this.currentFile);
                this.categorizeCurrentFile(ref);
            } else if (!this.currentFile.equals(this.rootFile)) {
                this.logger.error(MessageUtils.getMessage("DOTJ021E", params).toString());
                this.failureList.add(this.currentFile);
            }
        }
        catch (GenListModuleReader.EarlyExitException e) {
            this.failureList.add(this.currentFile);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (SAXParseException sax) {
            Exception inner = sax.getException();
            if (inner != null && inner instanceof DITAOTException) {
                throw (DITAOTException)inner;
            }
            if (this.currentFile.equals(this.rootFile)) {
                throw new DITAOTException(MessageUtils.getMessage("DOTJ012F", params).toString() + ": " + sax.getMessage(), sax);
            }
            if (this.processingMode == Configuration.Mode.STRICT) {
                throw new DITAOTException(MessageUtils.getMessage("DOTJ013E", params).toString() + ": " + sax.getMessage(), sax);
            }
            this.logger.error(MessageUtils.getMessage("DOTJ013E", params).toString() + ": " + sax.getMessage(), sax);
            this.failureList.add(this.currentFile);
        }
        catch (FileNotFoundException e) {
            if (!URLUtils.exists(this.currentFile)) {
                if (this.currentFile.equals(this.rootFile)) {
                    throw new DITAOTException(MessageUtils.getMessage("DOTA069F", params).toString(), e);
                }
                if (this.processingMode == Configuration.Mode.STRICT) {
                    throw new DITAOTException(MessageUtils.getMessage("DOTX008E", params).toString(), e);
                }
                this.logger.error(MessageUtils.getMessage("DOTX008E", params).toString());
            } else {
                if (this.currentFile.equals(this.rootFile)) {
                    throw new DITAOTException(MessageUtils.getMessage("DOTJ078F", params).toString() + " Cannot load file: " + e.getMessage(), e);
                }
                if (this.processingMode == Configuration.Mode.STRICT) {
                    throw new DITAOTException(MessageUtils.getMessage("DOTJ079E", params).toString() + " Cannot load file: " + e.getMessage(), e);
                }
                this.logger.error(MessageUtils.getMessage("DOTJ079E", params).toString() + " Cannot load file: " + e.getMessage());
            }
            this.failureList.add(this.currentFile);
        }
        catch (Exception e) {
            if (this.currentFile.equals(this.rootFile)) {
                throw new DITAOTException(MessageUtils.getMessage("DOTJ012F", params).toString() + ": " + e.getMessage(), e);
            }
            if (this.processingMode == Configuration.Mode.STRICT) {
                throw new DITAOTException(MessageUtils.getMessage("DOTJ013E", params).toString() + ": " + e.getMessage(), e);
            }
            this.logger.error(MessageUtils.getMessage("DOTJ013E", params).toString() + ": " + e.getMessage(), e);
            this.failureList.add(this.currentFile);
        }
        finally {
            if (this.failureList.contains(this.currentFile)) {
                FileUtils.deleteQuietly((File)this.outputFile);
            }
        }
        if (!this.listFilter.isValidInput() && this.currentFile.equals(this.rootFile)) {
            if (this.validate) {
                throw new DITAOTException(MessageUtils.getMessage("DOTJ022F", params).toString());
            }
            throw new DITAOTException(MessageUtils.getMessage("DOTJ034F", params).toString());
        }
        this.doneList.add(this.currentFile);
        this.listFilter.reset();
        this.keydefFilter.reset();
    }

    void processParseResult(URI currentFile) {
        LinkedHashSet<GenListModuleReader.Reference> nonCopytoResult = new LinkedHashSet<GenListModuleReader.Reference>(128);
        nonCopytoResult.addAll(this.listFilter.getNonConrefCopytoTargets());
        for (URI uRI : this.listFilter.getConrefTargets()) {
            nonCopytoResult.add(new GenListModuleReader.Reference(URLUtils.stripFragment(uRI), this.getFormatFromPath(URLUtils.stripFragment(uRI))));
        }
        for (URI uRI : this.listFilter.getCopytoMap().values()) {
            nonCopytoResult.add(new GenListModuleReader.Reference(URLUtils.stripFragment(uRI)));
        }
        for (URI uRI : this.listFilter.getIgnoredCopytoSourceSet()) {
            nonCopytoResult.add(new GenListModuleReader.Reference(URLUtils.stripFragment(uRI)));
        }
        for (URI uRI : this.listFilter.getCoderefTargetSet()) {
            nonCopytoResult.add(new GenListModuleReader.Reference(URLUtils.stripFragment(uRI)));
        }
        for (GenListModuleReader.Reference reference : nonCopytoResult) {
            this.categorizeReferenceFile(reference);
        }
        for (Map.Entry entry : this.listFilter.getCopytoMap().entrySet()) {
            URI source = (URI)entry.getValue();
            URI target = (URI)entry.getKey();
            this.copyTo.put(target, source);
        }
        this.schemeSet.addAll(this.listFilter.getSchemeRefSet());
        this.hrefTargetSet.addAll(this.listFilter.getHrefTargets());
        this.conrefTargetSet.addAll(this.listFilter.getConrefTargets());
        Set nonConrefCopytoTargets = this.listFilter.getNonConrefCopytoTargets().stream().map(r -> r.filename).collect(Collectors.toSet());
        this.nonConrefCopytoTargetSet.addAll(nonConrefCopytoTargets);
        this.coderefTargetSet.addAll(this.listFilter.getCoderefTargets());
        this.outDitaFilesSet.addAll(this.listFilter.getOutDitaFilesSet());
        Set<URI> set = this.listFilter.getSchemeSet();
        if (set != null && !set.isEmpty()) {
            Set<URI> children = this.schemeDictionary.get(currentFile);
            if (children == null) {
                children = new HashSet<URI>();
            }
            children.addAll(set);
            this.schemeDictionary.put(currentFile, children);
            Set<URI> hrfSet = this.listFilter.getHrefTargets();
            for (URI filename : hrfSet) {
                children = this.schemeDictionary.get(filename);
                if (children == null) {
                    children = new HashSet<URI>();
                }
                children.addAll(set);
                this.schemeDictionary.put(filename, children);
            }
        }
    }

    void categorizeCurrentFile(GenListModuleReader.Reference ref) {
        URI currentFile = ref.filename;
        if (this.listFilter.hasConaction()) {
            this.conrefpushSet.add(currentFile);
        }
        if (this.listFilter.hasConRef()) {
            this.conrefSet.add(currentFile);
        }
        if (this.listFilter.hasKeyRef()) {
            this.keyrefSet.add(currentFile);
        }
        if (this.listFilter.hasCodeRef()) {
            this.coderefSet.add(currentFile);
        }
        if (this.listFilter.isDitaTopic()) {
            assert (currentFile.getFragment() == null);
            URI f = currentFile.normalize();
            if (!GenListModuleReader.isFormatDita(ref.format)) {
                if (!this.fileinfos.containsKey(f)) {
                    Job.FileInfo i = new Job.FileInfo.Builder().uri(this.tempFileNameScheme.generateTempFileName(currentFile)).src(currentFile).format(ref.format).build();
                    this.fileinfos.put(i.src, Collections.singletonList(i));
                }
            } else {
                Job.FileInfo fi = this.job.getFileInfo(f);
                if (fi != null) {
                    Job.FileInfo i = new Job.FileInfo.Builder(fi).format("dita").build();
                    this.job.add(i);
                }
            }
            this.fullTopicSet.add(currentFile);
            this.hrefTargetSet.add(currentFile);
            if (this.listFilter.hasHref()) {
                this.hrefTopicSet.add(currentFile);
            }
        } else if (this.listFilter.isDitaMap()) {
            Job.FileInfo fi = this.job.getFileInfo(currentFile);
            if (fi != null && !Objects.equals(fi.format, "ditamap")) {
                Job.FileInfo i = new Job.FileInfo.Builder(fi).format("ditamap").build();
                this.job.add(i);
            }
            this.fullMapSet.add(currentFile);
        }
    }

    abstract void categorizeReferenceFile(GenListModuleReader.Reference var1);

    void addToWaitList(GenListModuleReader.Reference ref) {
        URI file = ref.filename;
        assert (file.isAbsolute() && file.getFragment() == null);
        if (this.doneList.contains(file) || this.waitList.containsKey(ref.filename) || file.equals(this.currentFile)) {
            return;
        }
        this.waitList.put(ref.filename, ref);
    }

    private FilterUtils parseFilterFile() {
        FilterUtils filterUtils;
        if (this.ditavalFile != null) {
            DitaValReader ditaValReader = new DitaValReader();
            ditaValReader.setLogger(this.logger);
            ditaValReader.setJob(this.job);
            ditaValReader.read(this.ditavalFile.toURI());
            this.flagImageSet.addAll(ditaValReader.getImageList());
            this.relFlagImagesSet.addAll(ditaValReader.getRelFlagImageList());
            filterUtils = new FilterUtils(Configuration.printTranstype.contains(this.transtype), ditaValReader.getFilterMap(), ditaValReader.getForegroundConflictColor(), ditaValReader.getBackgroundConflictColor());
        } else {
            filterUtils = new FilterUtils(Configuration.printTranstype.contains(this.transtype));
        }
        filterUtils.setLogger(this.logger);
        return filterUtils;
    }

    void handleConref() {
        HashSet<URI> pureConrefTargets = new HashSet<URI>();
        for (URI target : this.conrefTargetSet) {
            if (this.nonConrefCopytoTargetSet.contains(target)) continue;
            pureConrefTargets.add(target);
        }
        pureConrefTargets.remove(this.rootFile);
        this.conrefTargetSet = pureConrefTargets;
        this.fullTopicSet.removeAll(pureConrefTargets);
        this.resourceOnlySet.addAll(pureConrefTargets);
    }

    void outputResult() throws DITAOTException {
        this.tempFileNameScheme.setBaseDir(this.baseInputDir);
        URI rootTemp = this.tempFileNameScheme.generateTempFileName(this.rootFile);
        File relativeRootFile = URLUtils.toFile(rootTemp);
        this.job.setInputMap(rootTemp);
        this.job.setProperty("user.input.file.listfile", "usr.input.file.list");
        File inputfile = new File(this.job.tempDir, "usr.input.file.list");
        this.writeListFile(inputfile, relativeRootFile.toString());
        this.job.setProperty("tempdirToinputmapdir.relative.value", StringUtils.escapeRegExp(this.getPrefix(relativeRootFile)));
        HashSet<URI> res = new HashSet<URI>(this.listFilter.getResourceOnlySet());
        res.removeAll(this.listFilter.getNormalProcessingRoleSet());
        this.resourceOnlySet.addAll(res);
        for (URI uRI : this.outDitaFilesSet) {
            this.createOrUpdateFileInfo(uRI, fi -> {
                fi.isOutDita = true;
            });
        }
        for (URI uRI : this.fullTopicSet) {
            this.createOrUpdateFileInfo(uRI, fi -> {
                if (GenListModuleReader.isFormatDita(fi.format)) {
                    fi.format = "dita";
                }
            });
        }
        for (URI uRI : this.fullMapSet) {
            this.createOrUpdateFileInfo(uRI, fi -> {
                if (fi.format == null) {
                    fi.format = "ditamap";
                }
            });
        }
        for (URI uRI : this.hrefTopicSet) {
            this.createOrUpdateFileInfo(uRI, fi -> {
                fi.hasLink = true;
            });
        }
        for (URI uRI : this.conrefSet) {
            this.createOrUpdateFileInfo(uRI, fi -> {
                fi.hasConref = true;
            });
        }
        for (GenListModuleReader.Reference reference : this.formatSet) {
            this.createOrUpdateFileInfo(reference.filename, fi -> {
                fi.format = file.format;
            });
        }
        for (URI uRI : this.flagImageSet) {
            this.createOrUpdateFileInfo(uRI, fi -> {
                fi.isFlagImage = true;
                fi.format = "image";
            });
        }
        for (String string : this.htmlSet.keySet()) {
            for (URI file : this.htmlSet.get((Object)string)) {
                this.createOrUpdateFileInfo(file, fi -> {
                    fi.format = format;
                });
            }
        }
        for (URI uRI : this.hrefTargetSet) {
            this.createOrUpdateFileInfo(uRI, fi -> {
                fi.isTarget = true;
            });
        }
        for (URI uRI : this.schemeSet) {
            this.createOrUpdateFileInfo(uRI, fi -> {
                fi.isSubjectScheme = true;
            });
        }
        for (URI uRI : this.coderefTargetSet) {
            this.createOrUpdateFileInfo(uRI, fi -> {
                fi.isSubtarget = true;
                if (fi.format == null) {
                    fi.format = Constants.PR_D_CODEREF.localName;
                }
            });
        }
        for (URI uRI : this.conrefpushSet) {
            this.createOrUpdateFileInfo(uRI, fi -> {
                fi.isConrefPush = true;
            });
        }
        for (URI uRI : this.keyrefSet) {
            this.createOrUpdateFileInfo(uRI, fi -> {
                fi.hasKeyref = true;
            });
        }
        for (URI uRI : this.coderefSet) {
            this.createOrUpdateFileInfo(uRI, fi -> {
                fi.hasCoderef = true;
            });
        }
        for (URI uRI : this.resourceOnlySet) {
            this.createOrUpdateFileInfo(uRI, fi -> {
                fi.isResourceOnly = true;
            });
        }
        for (URI uRI : this.resources) {
            this.createOrUpdateFileInfo(uRI, fi -> {
                fi.isInputResource = true;
            });
        }
        this.addFlagImagesSetToProperties(this.job, this.relFlagImagesSet);
        Map<URI, URI> filteredCopyTo = this.filterConflictingCopyTo(this.copyTo, this.fileinfos.values());
        this.fileinfos.values().stream().flatMap(Collection::stream).filter(fs -> !this.failureList.contains(fs.src)).forEach(fs -> {
            URI src = (URI)filteredCopyTo.get(fs.src);
            if (src != null) {
                Job.FileInfo corr = new Job.FileInfo.Builder((Job.FileInfo)fs).src(src).build();
                this.job.add(corr);
            } else {
                this.job.add((Job.FileInfo)fs);
            }
        });
        for (URI target : filteredCopyTo.keySet()) {
            URI tmp = this.tempFileNameScheme.generateTempFileName(target);
            URI src = filteredCopyTo.get(target);
            Job.FileInfo fi2 = new Job.FileInfo.Builder().result(target).uri(tmp).build();
            if (!this.formatFilter.test(fi2.format) && fi2.format != null && !fi2.format.equals("dita")) continue;
            this.job.add(fi2);
        }
        for (URI f : this.additionalResourcesSet) {
            Job.FileInfo fi3 = this.job.getFileInfo(f);
            if (fi3.isResourceOnly) continue;
            fi3.isInputResource = true;
        }
        Job.FileInfo fileInfo = this.job.getFileInfo(this.rootFile);
        if (fileInfo == null) {
            throw new RuntimeException("Unable to set input file to job configuration");
        }
        this.job.add(new Job.FileInfo.Builder(fileInfo).isInput(true).build());
    }

    private Map<URI, URI> filterConflictingCopyTo(Map<URI, URI> copyTo, Collection<Collection<Job.FileInfo>> fileInfos) {
        Set fileinfoTargets = fileInfos.stream().flatMap(Collection::stream).filter(fi -> fi.src.equals(fi.result)).map(fi -> fi.result).collect(Collectors.toSet());
        return copyTo.entrySet().stream().filter(e -> !fileinfoTargets.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void writeListFile(File inputfile, String relativeRootFile) {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.job.getStore().getOutputStream(inputfile.toURI())));){
            bufferedWriter.write(relativeRootFile);
            ((Writer)bufferedWriter).flush();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    private String getPrefix(File relativeRootFile) {
        File p = relativeRootFile.getParentFile();
        Object res = p != null ? p.toString() + File.separator : "";
        return res;
    }

    private void createOrUpdateFileInfo(URI file, Consumer<Job.FileInfo> consumer) {
        for (Job.FileInfo fi : this.getOrCreateFileInfo(this.fileinfos, file)) {
            consumer.accept(fi);
        }
    }

    private Collection<Job.FileInfo> getOrCreateFileInfo(Map<URI, Collection<Job.FileInfo>> fileInfos, URI file) {
        assert (file.getFragment() == null);
        URI f = file.normalize();
        if (fileInfos.containsKey(f)) {
            return fileInfos.get(f);
        }
        Collection prevs = this.job.getFileInfo(fi -> Objects.equals(fi.src, f)).stream().map(prev -> {
            Job.FileInfo.Builder b = new Job.FileInfo.Builder((Job.FileInfo)prev);
            if (prev.src == null) {
                b = b.src(f);
            }
            if (prev.uri == null) {
                b = b.uri(this.tempFileNameScheme.generateTempFileName(f));
            }
            return b.build();
        }).collect(Collectors.toList());
        if (!prevs.isEmpty()) {
            fileInfos.put(f, prevs);
            return prevs;
        }
        List<Job.FileInfo> fis = Collections.singletonList(new Job.FileInfo.Builder().src(f).uri(this.tempFileNameScheme.generateTempFileName(f)).build());
        fileInfos.put(f, fis);
        return fis;
    }

    private void addFlagImagesSetToProperties(Job prop, Set<URI> set) {
        LinkedHashSet<URI> newSet = new LinkedHashSet<URI>(128);
        for (URI file : set) {
            if (file.isAbsolute()) {
                newSet.add(file.normalize());
                continue;
            }
            newSet.add(file.normalize());
        }
        String fileKey = "relflagimagelist".substring(0, "relflagimagelist".lastIndexOf("list")) + "file";
        prop.setProperty(fileKey, "relflagimagelist".substring(0, "relflagimagelist".lastIndexOf("list")) + ".list");
        File list = this.job.tempDir.toPath().resolve(prop.getProperty(fileKey)).toFile();
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.job.getStore().getOutputStream(list.toURI())));){
            for (URI aNewSet : newSet) {
                bufferedWriter.write(aNewSet.getPath());
                ((Writer)bufferedWriter).write(10);
            }
            ((Writer)bufferedWriter).flush();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
        }
        prop.setProperty("relflagimagelist", newSet.stream().map(URI::toString).collect(Collectors.joining(",")));
    }

    void init() throws DITAOTException {
        try {
            String cls = Optional.ofNullable(this.job.getProperty("temp-file-name-scheme")).orElse(Configuration.configuration.get("temp-file-name-scheme"));
            this.tempFileNameScheme = (TempFileNameScheme)Class.forName(cls).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.tempFileNameScheme.setBaseDir(this.job.getInputDir());
        this.initXMLReader(this.validate);
        this.initFilters();
    }
}

