<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/sensors/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/sensors/metadata.yaml"
sidebar_label: "Linux Sensors"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Hardware Devices and Sensors"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Linux Sensors


<img src="https://netdata.cloud/img/microchip.svg" width="150"/>


Plugin: go.d.plugin
Module: sensors

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector gathers real-time system sensor statistics using the [sysfs](https://www.kernel.org/doc/Documentation/hwmon/sysfs-interface) interface.

Supported sensors:

- Temperature
- Voltage
- Fan
- Current
- Power
- Energy
- Humidity
- Intrusion




This collector is only supported on the following platforms:

- Linux

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

Automatically discovers and exposes all available sensors on the system through the [sysfs](https://www.kernel.org/doc/Documentation/hwmon/sysfs-interface) interface.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per sensor

These metrics refer to the system sensor.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| chip | The path to the sensor's chip device, excluding the /sys/devices prefix. This provides a unique identifier for the physical hardware component. |
| chip_id | A unique identifier for the sensor's chip, formatted as `chipName-busType-hash`. |
| sensor | The name of the specific sensor within the chip device. This provides a direct identifier for the individual measurement point. |
| label | A label provided by the kernel driver to indicate the intended use or purpose of the sensor. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| sensors.chip_sensor_temperature | input | Celsius |
| sensors.chip_sensor_temperature_alarm | clear, triggered | status |
| sensors.chip_sensor_voltage | input | Volts |
| sensors.chip_sensor_voltage_average | average | Volts |
| sensors.chip_sensor_voltage_alarm | clear, triggered | status |
| sensors.chip_sensor_fan | input | RPM |
| sensors.chip_sensor_fan_alarm | clear, triggered | status |
| sensors.chip_sensor_current | input | Amperes |
| sensors.chip_sensor_current_average | average | Amperes |
| sensors.chip_sensor_current_alarm | clear, triggered | status |
| sensors.chip_sensor_power | input | Watts |
| sensors.chip_sensor_power_average | average | Watts |
| sensors.chip_sensor_power_alarm | clear, triggered | status |
| sensors.chip_sensor_energy | input | Joules |
| sensors.chip_sensor_humidity | input | percent |
| sensors.chip_sensor_intrusion_alarm | clear, triggered | status |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/sensors.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name1
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/sensors.conf
```
#### Options

The following options can be defined globally: update_every.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 10 | no |
| relabel | A list used to update existing sensor labels or add labels to sensors that don't have them. | [] | no |
| relabel[].chip | [Pattern](https://github.com/netdata/netdata/blob/master/src/libnetdata/simple_pattern/README.md#simple-patterns) to match the `chip_id` label value. |  | no |
| relabel[].sensors | A list of sensors to be relabeled for the specified chip. | [] | no |
| relabel[].sensors[].name | The exact sensor name (e.g., `'temp1'`, `'in1'`, `'voltage1'`). |  | no |
| relabel[].sensors[].label | The new label value for the sensor. |  | no |

</details>

#### Examples

##### Custom update_every

Allows you to override the default data collection interval.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: sensors
    update_every: 5  # Collect sensors statistics every 5 seconds

```
</details>

##### Renaming labels

Allows you to override/add labels.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: sensors
    relabel:
      - chip: as99127f-*
        sensors:
          - name: temp1
            label: Mobo Temp
          - name: temp2
            label: CPU0 Temp

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `sensors` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m sensors
  ```

### Getting Logs

If you're encountering problems with the `sensors` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep sensors
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep sensors /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep sensors
```


