/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.items.events;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.events.ItemEvent;
import org.openhab.core.types.Command;

@NonNullByDefault
public class ItemCommandEvent
extends ItemEvent {
    public static final String TYPE = ItemCommandEvent.class.getSimpleName();
    private final Command command;

    protected ItemCommandEvent(String topic, String payload, String itemName, Command command, @Nullable String source) {
        super(topic, payload, itemName, source);
        this.command = command;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public Command getItemCommand() {
        return this.command;
    }

    public String toString() {
        String result = String.format("Item '%s' received command %s", this.itemName, this.command);
        String source = this.getSource();
        if (source != null) {
            result = String.format("%s (source: %s)", result, source);
        }
        return result;
    }
}

