/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.media.internal;

import java.math.BigDecimal;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.handler.BaseActionModuleHandler;
import org.openhab.core.library.types.PercentType;
import org.openhab.core.voice.VoiceManager;

@NonNullByDefault
public class SayActionHandler
extends BaseActionModuleHandler {
    public static final String TYPE_ID = "media.SayAction";
    public static final String PARAM_TEXT = "text";
    public static final String PARAM_SINK = "sink";
    public static final String PARAM_VOLUME = "volume";
    private final VoiceManager voiceManager;
    private final String text;
    private final @Nullable String sink;
    private final @Nullable PercentType volume;

    public SayActionHandler(Action module, VoiceManager voiceManager) {
        super(module);
        PercentType percentType;
        this.voiceManager = voiceManager;
        this.text = module.getConfiguration().get(PARAM_TEXT).toString();
        Object sinkParam = module.getConfiguration().get(PARAM_SINK);
        this.sink = sinkParam != null ? sinkParam.toString() : null;
        Object volumeParam = module.getConfiguration().get(PARAM_VOLUME);
        if (volumeParam instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)volumeParam;
            percentType = new PercentType(bd);
        } else {
            percentType = null;
        }
        this.volume = percentType;
    }

    public @Nullable Map<String, @Nullable Object> execute(Map<String, Object> context) {
        this.voiceManager.say(this.text, null, this.sink, this.volume);
        return null;
    }
}

