/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnsqueryresult;

import org.minidns.dnsmessage.DnsMessage;

public abstract class DnsQueryResult {
    public final QueryMethod queryMethod;
    public final DnsMessage query;
    public final DnsMessage response;

    protected DnsQueryResult(QueryMethod queryMethod, DnsMessage query, DnsMessage response) {
        assert (queryMethod != null);
        assert (query != null);
        assert (response != null);
        this.queryMethod = queryMethod;
        this.query = query;
        this.response = response;
    }

    public String toString() {
        return this.response.toString();
    }

    public boolean wasSuccessful() {
        return this.response.responseCode == DnsMessage.RESPONSE_CODE.NO_ERROR;
    }

    public static enum QueryMethod {
        udp,
        tcp,
        asyncUdp,
        asyncTcp,
        cachedDirect,
        cachedSynthesized,
        testWorld;

    }
}

